/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.xml;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.mapping.xml.MappingDocument;
import com.metamatrix.query.mapping.xml.MappingNode;
import com.metamatrix.query.mapping.xml.MappingNodeLogger;
import com.metamatrix.query.mapping.xml.MappingRecursiveElement;
import com.metamatrix.query.mapping.xml.MappingSourceNode;
import com.metamatrix.query.mapping.xml.MappingVisitor;
import com.metamatrix.query.mapping.xml.Navigator;
import com.metamatrix.query.mapping.xml.ResultSetInfo;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.CommandPlanner;
import com.metamatrix.query.optimizer.CommandTreeNode;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.xml.CriteriaPlanner;
import com.metamatrix.query.optimizer.xml.HandleNillableVisitor;
import com.metamatrix.query.optimizer.xml.MarkExcludeVisitor;
import com.metamatrix.query.optimizer.xml.NameInSourceResolverVisitor;
import com.metamatrix.query.optimizer.xml.SourceNodeGenaratorVisitor;
import com.metamatrix.query.optimizer.xml.SourceNodePlannerVisitor;
import com.metamatrix.query.optimizer.xml.ValidateMappedCriteriaVisitor;
import com.metamatrix.query.optimizer.xml.XMLPlanToProcessVisitor;
import com.metamatrix.query.optimizer.xml.XMLPlannerEnvironment;
import com.metamatrix.query.optimizer.xml.XMLQueryPlanner;
import com.metamatrix.query.optimizer.xml.XMLStagaingQueryPlanner;
import com.metamatrix.query.processor.ProcessorPlan;
import com.metamatrix.query.processor.xml.Program;
import com.metamatrix.query.processor.xml.XMLPlan;
import com.metamatrix.query.processor.xml.XMLProcessorEnvironment;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.OrderBy;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.lang.Select;
import com.metamatrix.query.sql.symbol.AllSymbol;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.SelectSymbol;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.visitor.ElementCollectorVisitor;
import com.metamatrix.query.sql.visitor.GroupCollectorVisitor;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public final class XMLPlanner
implements CommandPlanner {
    public void generateCanonical(CommandTreeNode rootNode, QueryMetadataInterface metadata, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, MetaMatrixComponentException {
    }

    public ProcessorPlan optimize(CommandTreeNode node, IDGenerator idGenerator, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        String xmlFormResults;
        XMLPlannerEnvironment env = new XMLPlannerEnvironment(metadata);
        if (node.getParent() != null && node.getParent().getCommandType() == 5 && (xmlFormResults = (String)node.getParent().getProperty(XMLPlannerEnvironment.XML_FORM_RESULTS_PROPERTY)) != null) {
            env.xmlFormResults = xmlFormResults;
        }
        return XMLPlanner.preparePlan(node.getCommand(), metadata, analysisRecord, env, idGenerator, capFinder, context);
    }

    static XMLPlan preparePlan(Command command, QueryMetadataInterface metadata, AnalysisRecord analysisRecord, XMLPlannerEnvironment planEnv, IDGenerator idGenerator, CapabilitiesFinder capFinder, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        Query xmlQuery = (Query)command;
        boolean debug = analysisRecord.recordDebug();
        if (debug) {
            analysisRecord.println("============================================================================");
            analysisRecord.println("XML COMMAND: " + xmlQuery);
        }
        Collection groups = GroupCollectorVisitor.getGroups((LanguageObject)xmlQuery, (boolean)true);
        GroupSymbol group = (GroupSymbol)groups.iterator().next();
        MappingDocument doc = (MappingDocument)metadata.getMappingNode(group.getMetadataID());
        planEnv.mappingDoc = doc = (MappingDocument)doc.clone();
        planEnv.documentGroup = group;
        planEnv.xmlCommand = (Query)command;
        planEnv.analysisRecord = analysisRecord;
        planEnv.capFinder = capFinder;
        planEnv.idGenerator = idGenerator;
        planEnv.context = context;
        LogManager.logTrace((String)"XML_QUERY_PLANNER", (Object[])new Object[]{"Mapping document tree", new MappingNodeLogger((MappingNode)planEnv.mappingDoc)});
        if (debug) {
            XMLPlanner.debugDocumentInfo("Start", planEnv);
        }
        XMLPlanner.prePlan(planEnv, debug);
        Program programPlan = XMLPlanToProcessVisitor.planProgram((MappingDocument)planEnv.mappingDoc, (XMLPlannerEnvironment)planEnv);
        XMLProcessorEnvironment env = planEnv.createProcessorEnvironment(programPlan);
        env.setChildPlans(XMLPlanner.getChildPlans(doc));
        XMLPlan plan = new XMLPlan(env);
        if (debug) {
            analysisRecord.println("");
            analysisRecord.println(plan.toString());
            analysisRecord.println("============================================================================");
        }
        return plan;
    }

    private static Collection getChildPlans(MappingDocument doc) throws QueryMetadataException, MetaMatrixComponentException {
        final ArrayList childPlans = new ArrayList();
        MappingVisitor real = new MappingVisitor(){

            public void visit(MappingSourceNode element) {
                childPlans.add(element.getResultSetInfo().getPlan());
            }
        };
        try {
            Navigator visitor = new Navigator(true, real);
            doc.acceptVisitor((MappingVisitor)visitor);
        }
        catch (MetaMatrixRuntimeException e) {
            if (e.getCause() instanceof QueryMetadataException) {
                throw (QueryMetadataException)e.getCause();
            }
            if (e.getCause() instanceof MetaMatrixComponentException) {
                throw (MetaMatrixComponentException)e.getCause();
            }
            throw e;
        }
        return childPlans;
    }

    private static void debugDocumentInfo(String msgTag, XMLPlannerEnvironment planEnv) {
        planEnv.analysisRecord.println("\n" + msgTag + ":============================================================================");
        planEnv.analysisRecord.println("MAPPING DOCUMENT:\n" + MappingNode.toStringNodeTree((MappingNode)planEnv.mappingDoc));
    }

    private static void prePlan(XMLPlannerEnvironment planEnv, boolean debug) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        planEnv.mappingDoc = SourceNodeGenaratorVisitor.extractSourceNodes((MappingDocument)planEnv.mappingDoc);
        if (debug) {
            XMLPlanner.debugDocumentInfo("After Source Node Generation", planEnv);
        }
        SourceNodePlannerVisitor.raiseInputSet(planEnv.mappingDoc, planEnv);
        XMLPlanner.placeOrderBys(planEnv.xmlCommand.getOrderBy(), planEnv);
        Criteria crit = planEnv.xmlCommand.getCriteria();
        CriteriaPlanner.placeUserCriteria((Criteria)crit, (XMLPlannerEnvironment)planEnv);
        XMLQueryPlanner.prePlanQueries(planEnv.mappingDoc, planEnv);
        if (debug) {
            XMLPlanner.debugDocumentInfo("After Pre Plan Queries", planEnv);
        }
        XMLPlanner.preMarkExcluded(planEnv.xmlCommand, planEnv.mappingDoc);
        if (debug) {
            XMLPlanner.debugDocumentInfo("After Mark Exclude", planEnv);
        }
        XMLPlanner.removeExcluded((MappingNode)planEnv.mappingDoc);
        if (debug) {
            XMLPlanner.debugDocumentInfo("After Exclude", planEnv);
        }
        XMLStagaingQueryPlanner.stageQueries(planEnv.mappingDoc, planEnv);
        XMLQueryPlanner.optimizeQueries(planEnv.mappingDoc, planEnv);
        planEnv.mappingDoc = HandleNillableVisitor.execute((MappingDocument)planEnv.mappingDoc);
        NameInSourceResolverVisitor.resolveElements((MappingDocument)planEnv.mappingDoc, (XMLPlannerEnvironment)planEnv);
        ValidateMappedCriteriaVisitor.validateAndCollectCriteriaElements((MappingDocument)planEnv.mappingDoc, (XMLPlannerEnvironment)planEnv);
    }

    static void removeExcluded(MappingNode node) {
        Iterator i = node.getChildren().iterator();
        while (i.hasNext()) {
            MappingNode child = (MappingNode)i.next();
            if (!(node instanceof MappingRecursiveElement) && child.isExcluded()) {
                i.remove();
                continue;
            }
            XMLPlanner.removeExcluded(child);
        }
    }

    static MappingDocument preMarkExcluded(Query xmlCommand, MappingDocument doc) {
        Select select = xmlCommand.getSelect();
        SelectSymbol firstSymbol = select.getSymbol(0);
        if (firstSymbol instanceof AllSymbol) {
            return doc;
        }
        Collection validElements = ElementCollectorVisitor.getElements((LanguageObject)select, (boolean)true);
        HashSet<String> elements = new HashSet<String>(validElements.size());
        Iterator i = validElements.iterator();
        while (i.hasNext()) {
            ElementSymbol element = (ElementSymbol)i.next();
            String elementName = element.getFullyQualifiedName();
            elements.add(elementName.toUpperCase());
        }
        return MarkExcludeVisitor.markExcludedNodes((MappingDocument)doc, elements);
    }

    private static void placeOrderBys(OrderBy orderBy, XMLPlannerEnvironment planEnv) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        if (orderBy == null) {
            return;
        }
        List elements = orderBy.getVariables();
        List types = orderBy.getTypes();
        for (int i = 0; i < elements.size(); ++i) {
            ElementSymbol elemSymbol = (ElementSymbol)elements.get(i);
            String nodeName = planEnv.getGlobalMetadata().getFullName(elemSymbol.getMetadataID()).toUpperCase();
            MappingNode elementNode = MappingNode.findNode((MappingNode)planEnv.mappingDoc, (String)nodeName);
            if (elementNode.getNameInSource() == null) {
                Object[] params = new Object[]{elementNode, orderBy};
                String msg = QueryExecPlugin.Util.getString("XMLPlanner.The_XML_document_element_{0}_is_not_mapped_to_data_and_cannot_be_used_in_the_ORDER_BY_clause__{1}_1", params);
                throw new QueryPlannerException(msg);
            }
            MappingSourceNode sourceNode = elementNode.getSourceNode();
            ResultSetInfo rs = sourceNode.getResultSetInfo();
            OrderBy by = rs.getOrderBy();
            if (by == null) {
                by = new OrderBy();
            }
            ElementSymbol mappedSymbol = (ElementSymbol)sourceNode.getSymbolMap().get(new ElementSymbol(elementNode.getNameInSource()));
            by.addVariable((SingleElementSymbol)((ElementSymbol)mappedSymbol.clone()), ((Boolean)types.get(i)).booleanValue());
            rs.setOrderBy(by);
        }
    }
}

