/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.relational.PlanHints;
import com.metamatrix.query.optimizer.relational.plantree.JoinStrategyType;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.NodeFactory;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.DependentSetCriteria;
import com.metamatrix.query.sql.lang.From;
import com.metamatrix.query.sql.lang.FromClause;
import com.metamatrix.query.sql.lang.GroupBy;
import com.metamatrix.query.sql.lang.JoinPredicate;
import com.metamatrix.query.sql.lang.JoinType;
import com.metamatrix.query.sql.lang.Limit;
import com.metamatrix.query.sql.lang.Option;
import com.metamatrix.query.sql.lang.OrderBy;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.lang.QueryCommand;
import com.metamatrix.query.sql.lang.Select;
import com.metamatrix.query.sql.lang.SetQuery;
import com.metamatrix.query.sql.lang.StoredProcedure;
import com.metamatrix.query.sql.lang.SubqueryFromClause;
import com.metamatrix.query.sql.lang.UnaryFromClause;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.visitor.AggregateSymbolCollectorVisitor;
import com.metamatrix.query.sql.visitor.ElementCollectorVisitor;
import com.metamatrix.query.sql.visitor.GroupCollectorVisitor;
import com.metamatrix.query.sql.visitor.GroupsUsedByElementsVisitor;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;

public final class GenerateCanonical {
    public static PlanNode generatePlan(Command command, PlanHints hints, QueryMetadataInterface metadata) throws QueryPlannerException {
        if (command.getType() == 1) {
            return GenerateCanonical.createQueryPlan(command, hints, metadata);
        }
        if (command.getType() == 2 || command.getType() == 3 || command.getType() == 4 || command.getType() == 11 || command.getType() == 12) {
            hints.isUpdate = true;
            return GenerateCanonical.createUpdatePlan(command, hints);
        }
        if (command.getType() == 6) {
            return GenerateCanonical.createStoredProcedurePlan(command, hints);
        }
        throw new QueryPlannerException(QueryExecPlugin.Util.getString("ERR.015.004.0005", (Object)command.getClass().getName()));
    }

    private GenerateCanonical() {
    }

    static PlanNode createUpdatePlan(Command command, PlanHints hints) throws QueryPlannerException {
        PlanNode projectNode = NodeFactory.getNewNode((int)11);
        Collection groups = GroupCollectorVisitor.getGroups((LanguageObject)command, (boolean)false);
        projectNode.addGroups(groups);
        List cols = command.getProjectedSymbols();
        projectNode.setProperty((Object)NodeConstants.Info.TOP_COLS, (Object)cols);
        projectNode.setProperty((Object)NodeConstants.Info.PROJECT_COLS, (Object)cols);
        PlanNode sourceNode = NodeFactory.getNewNode((int)19);
        sourceNode.setProperty((Object)NodeConstants.Info.ATOMIC_REQUEST, (Object)command);
        sourceNode.setProperty((Object)NodeConstants.Info.VIRTUAL_COMMAND, (Object)command);
        List subCommands = command.getSubCommands();
        if (subCommands.size() == 1) {
            sourceNode.setProperty((Object)NodeConstants.Info.NESTED_COMMAND, subCommands.iterator().next());
        }
        sourceNode.addGroups(groups);
        NodeEditor.attachLast((PlanNode)projectNode, (PlanNode)sourceNode);
        return projectNode;
    }

    static PlanNode createStoredProcedurePlan(Command command, PlanHints hints) throws QueryPlannerException {
        StoredProcedure storedProc = (StoredProcedure)command;
        PlanNode projectNode = NodeFactory.getNewNode((int)11);
        List cols = storedProc.getProjectedSymbols();
        projectNode.setProperty((Object)NodeConstants.Info.TOP_COLS, (Object)cols);
        projectNode.setProperty((Object)NodeConstants.Info.PROJECT_COLS, (Object)cols);
        PlanNode sourceNode = NodeFactory.getNewNode((int)19);
        sourceNode.setProperty((Object)NodeConstants.Info.VIRTUAL_COMMAND, (Object)storedProc);
        if (storedProc.getSubCommand() != null) {
            sourceNode.setProperty((Object)NodeConstants.Info.NESTED_COMMAND, (Object)storedProc.getSubCommand());
        }
        hints.hasRelationalProc |= storedProc.isProcedureRelational();
        sourceNode.addGroup(storedProc.getGroup());
        NodeEditor.attachLast((PlanNode)projectNode, (PlanNode)sourceNode);
        return projectNode;
    }

    static PlanNode createQueryPlan(Command command, PlanHints hints, QueryMetadataInterface metadata) throws QueryPlannerException {
        QueryCommand qcommand = (QueryCommand)command;
        Option option = qcommand.getOption();
        if (option != null) {
            hints.addMakeDepGroups(option.getDependentGroups());
            hints.addMakeNotDepGroups(option.getNotDependentGroups());
        }
        PlanNode node = null;
        node = command instanceof Query ? GenerateCanonical.createQueryPlan((Query)command, hints, metadata) : GenerateCanonical.createQueryPlan((SetQuery)command, hints, metadata);
        List projectCols = command.getProjectedSymbols();
        ArrayList<Object> topCols = new ArrayList<Object>(projectCols.size());
        Iterator projectIter = projectCols.iterator();
        while (projectIter.hasNext()) {
            SingleElementSymbol symbol = (SingleElementSymbol)projectIter.next();
            topCols.add(symbol.clone());
        }
        node.setProperty((Object)NodeConstants.Info.TOP_COLS, topCols);
        return node;
    }

    private static PlanNode createQueryPlan(SetQuery query, PlanHints hints, QueryMetadataInterface metadata) throws QueryPlannerException {
        hints.hasUnion = true;
        Iterator queryIter = query.getQueries().iterator();
        Iterator flagIter = query.getUseAllFlags().iterator();
        PlanNode plan = null;
        while (queryIter.hasNext()) {
            QueryCommand command = (QueryCommand)queryIter.next();
            Boolean useAll = (Boolean)flagIter.next();
            if (plan == null) {
                plan = GenerateCanonical.createQueryPlan((Command)command, hints, metadata);
                continue;
            }
            PlanNode leftChild = plan;
            PlanNode rightChild = GenerateCanonical.createQueryPlan((Command)command, hints, metadata);
            plan = NodeFactory.getNewNode((int)29);
            plan.setProperty((Object)NodeConstants.Info.SET_OPERATION, (Object)new Integer(query.getOperation()));
            plan.setProperty((Object)NodeConstants.Info.USE_ALL, (Object)useAll);
            plan.addLastChild(leftChild);
            plan.addLastChild(rightChild);
            leftChild.setParent(plan);
            rightChild.setParent(plan);
            plan.addGroups((Collection)leftChild.getGroups());
            plan.addGroups((Collection)rightChild.getGroups());
        }
        if (query.getOrderBy() != null) {
            plan = GenerateCanonical.attachSorting(plan, query.getOrderBy());
            hints.hasSort = true;
        }
        if (query.getLimit() != null) {
            plan = GenerateCanonical.attachTupleLimit(plan, query.getLimit(), hints);
        }
        return plan;
    }

    private static PlanNode createQueryPlan(Query query, PlanHints hints, QueryMetadataInterface metadata) throws QueryPlannerException {
        PlanNode plan = null;
        if (query.getFrom() != null) {
            FromClause fromClause = GenerateCanonical.mergeClauseTrees(query.getFrom());
            PlanNode dummyRoot = new PlanNode();
            hints.hasOptionalJoin = GenerateCanonical.buildTree(fromClause, dummyRoot);
            plan = dummyRoot.getFirstChild();
            boolean bl = hints.hasJoin = plan.getType() == 7;
            if (query.getCriteria() != null) {
                plan = GenerateCanonical.attachCriteria(plan, query.getCriteria());
                hints.hasCriteria = true;
            }
            Iterator i = plan.getGroups().iterator();
            while (i.hasNext()) {
                GroupSymbol group = (GroupSymbol)i.next();
                try {
                    if (metadata.isVirtualGroup(group.getMetadataID())) continue;
                    Object modelID = metadata.getModelID(group.getMetadataID());
                    boolean bl2 = hints.needsWhereAllValidation = !metadata.modelSupports(modelID, 3);
                    if (!hints.needsWhereAllValidation) continue;
                    break;
                }
                catch (MetaMatrixComponentException e) {
                    throw new QueryPlannerException((Throwable)e, e.getMessage());
                }
                catch (QueryMetadataException e) {
                    throw new QueryPlannerException((Throwable)e, e.getMessage());
                }
            }
            if (query.getGroupBy() != null || GenerateCanonical.containsAggregates(query.getSelect())) {
                plan = GenerateCanonical.attachGrouping(plan, query, hints);
            }
            if (query.getHaving() != null) {
                plan = GenerateCanonical.attachCriteria(plan, query.getHaving());
                plan.setProperty((Object)NodeConstants.Info.IS_HAVING, (Object)Boolean.TRUE);
                hints.hasCriteria = true;
            }
        }
        plan = GenerateCanonical.attachProject(plan, query.getSelect());
        if (query.getSelect().isDistinct()) {
            plan = GenerateCanonical.attachDupRemoval(plan);
        }
        if (query.getOrderBy() != null) {
            plan = GenerateCanonical.attachSorting(plan, query.getOrderBy());
            hints.hasSort = true;
        }
        if (query.getLimit() != null) {
            plan = GenerateCanonical.attachTupleLimit(plan, query.getLimit(), hints);
        }
        if (query.getInto() != null) {
            PlanNode originalProject = plan;
            while (originalProject.getType() != 11) {
                originalProject = originalProject.getFirstChild();
            }
            originalProject.setProperty((Object)NodeConstants.Info.TOP_COLS, originalProject.getProperty((Object)NodeConstants.Info.PROJECT_COLS));
            List groups = null;
            PlanNode sourceNode = NodeFactory.getNewNode((int)19);
            List cols = query.getSelect().getProjectedSymbols();
            HashMap<SingleElementSymbol, SingleElementSymbol> symbolMap = new HashMap<SingleElementSymbol, SingleElementSymbol>();
            for (int i = 0; i < cols.size(); ++i) {
                SingleElementSymbol symbol = (SingleElementSymbol)cols.get(i);
                symbolMap.put(symbol, symbol);
            }
            sourceNode.setProperty((Object)NodeConstants.Info.SYMBOL_MAP, symbolMap);
            NodeEditor.attachLast((PlanNode)sourceNode, (PlanNode)plan);
            plan = sourceNode;
            if (query.getFrom() != null) {
                groups = query.getFrom().getGroups();
                sourceNode.addGroups((Collection)groups);
            }
            PlanNode projectNode = NodeFactory.getNewNode((int)11);
            List selectCols = query.getProjectedSymbols();
            projectNode.setProperty((Object)NodeConstants.Info.TOP_COLS, (Object)selectCols);
            projectNode.setProperty((Object)NodeConstants.Info.PROJECT_COLS, (Object)selectCols);
            projectNode.setProperty((Object)NodeConstants.Info.INTO_GROUP, (Object)query.getInto().getGroup());
            if (groups != null) {
                projectNode.addGroups((Collection)groups);
            }
            NodeEditor.attachLast((PlanNode)projectNode, (PlanNode)plan);
            plan = projectNode;
        }
        return plan;
    }

    private static FromClause mergeClauseTrees(From from) {
        List clauses = from.getClauses();
        while (clauses.size() > 1) {
            FromClause first = (FromClause)from.getClauses().remove(0);
            FromClause second = (FromClause)from.getClauses().remove(0);
            JoinPredicate jp = new JoinPredicate(first, second, JoinType.JOIN_CROSS);
            clauses.add(0, jp);
        }
        return (FromClause)clauses.get(0);
    }

    static boolean buildTree(FromClause clause, PlanNode parent) throws QueryPlannerException {
        boolean result = false;
        PlanNode node = null;
        if (clause instanceof UnaryFromClause) {
            UnaryFromClause ufc = (UnaryFromClause)clause;
            GroupSymbol group = ufc.getGroup();
            Command nestedCommand = ufc.getExpandedCommand();
            node = NodeFactory.getNewNode((int)19);
            node.addGroup(group);
            node.setProperty((Object)NodeConstants.Info.NESTED_COMMAND, (Object)nestedCommand);
            parent.addLastChild(node);
            node.setParent(parent);
        } else if (clause instanceof JoinPredicate) {
            JoinPredicate jp = (JoinPredicate)clause;
            node = NodeFactory.getNewNode((int)7);
            node.setProperty((Object)NodeConstants.Info.JOIN_TYPE, (Object)jp.getJoinType());
            node.setProperty((Object)NodeConstants.Info.JOIN_STRATEGY, (Object)JoinStrategyType.NESTED_LOOP);
            node.setProperty((Object)NodeConstants.Info.JOIN_CRITERIA, (Object)jp.getJoinCriteria());
            parent.addLastChild(node);
            node.setParent(parent);
            FromClause[] clauses = new FromClause[]{jp.getLeftClause(), jp.getRightClause()};
            for (int i = 0; i < 2; ++i) {
                result |= GenerateCanonical.buildTree(clauses[i], node);
                Iterator iter = node.getChildren().iterator();
                while (iter.hasNext()) {
                    PlanNode child = (PlanNode)iter.next();
                    node.addGroups((Collection)child.getGroups());
                }
            }
        } else if (clause instanceof SubqueryFromClause) {
            SubqueryFromClause sfc = (SubqueryFromClause)clause;
            GroupSymbol group = sfc.getGroupSymbol();
            Command nestedCommand = sfc.getCommand();
            node = NodeFactory.getNewNode((int)19);
            node.addGroup(group);
            node.setProperty((Object)NodeConstants.Info.NESTED_COMMAND, (Object)nestedCommand);
            parent.addLastChild(node);
            node.setParent(parent);
        }
        if (clause.isOptional()) {
            node.setProperty((Object)NodeConstants.Info.IS_OPTIONAL, (Object)Boolean.TRUE);
            result = true;
        }
        if (clause.isMakeDep()) {
            node.setProperty((Object)NodeConstants.Info.MAKE_DEP, (Object)Boolean.TRUE);
        } else if (clause.isMakeNotDep()) {
            node.setProperty((Object)NodeConstants.Info.MAKE_NOT_DEP, (Object)Boolean.TRUE);
        }
        return result;
    }

    private static PlanNode attachCriteria(PlanNode plan, Criteria criteria) throws QueryPlannerException {
        PlanNode critNode = GenerateCanonical.createSelectNode(criteria);
        NodeEditor.attachLast((PlanNode)critNode, (PlanNode)plan);
        return critNode;
    }

    public static PlanNode createSelectNode(Criteria criteria) {
        PlanNode critNode = NodeFactory.getNewNode((int)13);
        critNode.setProperty((Object)NodeConstants.Info.SELECT_CRITERIA, (Object)criteria);
        critNode.addGroups(GroupsUsedByElementsVisitor.getGroups((LanguageObject)criteria));
        if (criteria instanceof DependentSetCriteria) {
            critNode.setProperty((Object)NodeConstants.Info.IS_DEPENDENT_SET, (Object)Boolean.TRUE);
        }
        return critNode;
    }

    private static boolean containsAggregates(Select select) {
        return AggregateSymbolCollectorVisitor.getAggregates((LanguageObject)select, (boolean)true).size() > 0;
    }

    private static PlanNode attachGrouping(PlanNode plan, Query query, PlanHints hints) {
        PlanNode groupNode = NodeFactory.getNewNode((int)23);
        GroupBy groupBy = query.getGroupBy();
        if (groupBy != null) {
            groupNode.setProperty((Object)NodeConstants.Info.GROUP_COLS, (Object)groupBy.getSymbols());
            groupNode.addGroups(GenerateCanonical.getGroupsUsedByElements(groupBy.getSymbols()));
        } else {
            groupNode.addGroups((Collection)plan.getGroups());
        }
        NodeEditor.attachLast((PlanNode)groupNode, (PlanNode)plan);
        hints.hasAggregates = true;
        return groupNode;
    }

    private static Collection getGroupsUsedByElements(List symbols) {
        HashSet elements = new HashSet();
        Iterator iter = symbols.iterator();
        while (iter.hasNext()) {
            LanguageObject obj = (LanguageObject)iter.next();
            ElementCollectorVisitor.getElements((LanguageObject)obj, elements);
        }
        HashSet<GroupSymbol> groups = new HashSet<GroupSymbol>();
        iter = elements.iterator();
        while (iter.hasNext()) {
            ElementSymbol obj = (ElementSymbol)iter.next();
            groups.add(obj.getGroupSymbol());
        }
        return groups;
    }

    private static PlanNode attachSorting(PlanNode plan, OrderBy orderBy) {
        PlanNode sortNode = NodeFactory.getNewNode((int)17);
        List orderElements = orderBy.getVariables();
        sortNode.setProperty((Object)NodeConstants.Info.SORT_ORDER, (Object)orderElements);
        sortNode.setProperty((Object)NodeConstants.Info.ORDER_TYPES, (Object)orderBy.getTypes());
        sortNode.addGroups(GroupsUsedByElementsVisitor.getGroups((LanguageObject)orderBy));
        NodeEditor.attachLast((PlanNode)sortNode, (PlanNode)plan);
        return sortNode;
    }

    private static PlanNode attachTupleLimit(PlanNode plan, Limit limit, PlanHints hints) {
        hints.hasLimit = true;
        PlanNode limitNode = NodeFactory.getNewNode((int)41);
        boolean attach = false;
        if (limit.getOffset() != null) {
            limitNode.setProperty((Object)NodeConstants.Info.OFFSET_TUPLE_COUNT, (Object)limit.getOffset());
            attach = true;
        }
        if (limit.getRowLimit() != null) {
            limitNode.setProperty((Object)NodeConstants.Info.MAX_TUPLE_LIMIT, (Object)limit.getRowLimit());
            attach = true;
        }
        if (attach) {
            NodeEditor.attachLast((PlanNode)limitNode, (PlanNode)plan);
            plan = limitNode;
        }
        return plan;
    }

    private static PlanNode attachDupRemoval(PlanNode plan) {
        PlanNode dupNode = NodeFactory.getNewNode((int)5);
        NodeEditor.attachLast((PlanNode)dupNode, (PlanNode)plan);
        return dupNode;
    }

    private static PlanNode attachProject(PlanNode plan, Select select) {
        PlanNode projectNode = NodeFactory.getNewNode((int)11);
        projectNode.setProperty((Object)NodeConstants.Info.PROJECT_COLS, (Object)select.getProjectedSymbols());
        projectNode.addGroups(GroupsUsedByElementsVisitor.getGroups((LanguageObject)select));
        NodeEditor.attachLast((PlanNode)projectNode, (PlanNode)plan);
        return projectNode;
    }
}

