/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.dqp.internal.cache;

import com.metamatrix.common.util.Intervals;
import com.metamatrix.core.MetaMatrixRuntimeException;
import com.metamatrix.dqp.DQPPlugin;
import com.metamatrix.dqp.internal.cache.CursorReceiverWindowBuffer;
import com.metamatrix.dqp.internal.cache.ResultSetCacheUtil;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.sql.lang.Command;
import java.util.List;
import java.util.Map;

public class CacheResults {
    private List[] results;
    private List elements;
    private AnalysisRecord analysisRecord;
    private Command command;
    private Map paramValues;
    private boolean isFinal;
    private int firstRow;
    private long size = -1L;
    private int finalRow = -1;
    private CursorReceiverWindowBuffer tempResults;
    private Object requestID;

    public CacheResults(List[] results, int firstRow, boolean isFinal) {
        this(results, null, firstRow, isFinal);
    }

    public CacheResults(List[] results, List elements, int firstRow, boolean isFinal) {
        this.results = results;
        this.firstRow = firstRow;
        this.isFinal = isFinal;
        this.elements = elements;
    }

    public CacheResults(Map paramValues, boolean isFinal) {
        this.paramValues = paramValues;
        this.isFinal = isFinal;
    }

    public int getFirstRow() {
        return this.firstRow;
    }

    public boolean isFinal() {
        return this.isFinal;
    }

    public List[] getResults() {
        return this.results;
    }

    public List getElements() {
        return this.elements;
    }

    public Command getCommand() {
        return this.command;
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    public long getSize() {
        return this.size;
    }

    public void setSize(long size) {
        this.size = size;
    }

    public AnalysisRecord getAnalysisRecord() {
        return this.analysisRecord;
    }

    public void setAnalysisRecord(AnalysisRecord analysisRecord) {
        this.analysisRecord = analysisRecord;
    }

    public int getFinalRow() {
        return this.finalRow;
    }

    public void setFinalRow(int finalRow) {
        this.finalRow = finalRow;
    }

    public Map getParamValues() {
        return this.paramValues;
    }

    public void setParamValues(Map paramValues) {
        if (this.paramValues == null) {
            this.paramValues = paramValues;
        } else if (paramValues != null) {
            this.paramValues.putAll(paramValues);
        }
    }

    boolean addResults(CacheResults cacheResults, Object requestID) {
        int firstRow = cacheResults.getFirstRow() - 1;
        boolean isFinal = cacheResults.isFinal();
        List[] results = cacheResults.getResults();
        this.size += cacheResults.size;
        if (this.requestID == null) {
            if (firstRow != 0) {
                return false;
            }
            if (isFinal) {
                this.results = results;
                this.command = cacheResults.getCommand();
                this.analysisRecord = cacheResults.getAnalysisRecord();
                this.firstRow = 1;
                this.isFinal = true;
                this.finalRow = this.results.length;
                return true;
            }
            this.requestID = requestID;
            this.tempResults = new CursorReceiverWindowBuffer();
        }
        if (!requestID.equals(this.requestID)) {
            return true;
        }
        if (results != null && results.length > 0) {
            this.tempResults.add(new int[]{firstRow, firstRow + results.length - 1}, results);
        }
        if (isFinal) {
            if (!this.tempResults.getContents().isContiguous()) {
                throw new MetaMatrixRuntimeException(DQPPlugin.Util.getString("ResultSetCache.1"));
            }
            this.results = this.tempResults.getAllRows();
            this.command = cacheResults.getCommand();
            this.analysisRecord = cacheResults.getAnalysisRecord();
            this.paramValues = cacheResults.getParamValues();
            this.firstRow = 1;
            this.isFinal = true;
            this.finalRow = this.results.length;
            this.tempResults = null;
            this.requestID = null;
        }
        return true;
    }

    long getCurrentSize() {
        if (this.tempResults == null) {
            return 0L;
        }
        Intervals intervals = this.tempResults.getContents();
        int[] bound = intervals.getBoundingInterval();
        int totalRows = bound[1] - bound[0] + 1;
        return ResultSetCacheUtil.getResultsSize((Object[])new Object[]{this.tempResults.getRow(0)}, (boolean)true) * (long)totalRows;
    }

    boolean hasAllResults() {
        return this.isFinal;
    }
}

