/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.vdb.internal.edit;

import com.metamatrix.common.xml.XMLReaderWriter;
import com.metamatrix.common.xml.XMLReaderWriterImpl;
import com.metamatrix.core.MetaMatrixCoreException;
import com.metamatrix.core.event.IChangeListener;
import com.metamatrix.core.event.IChangeNotifier;
import com.metamatrix.core.id.IDGenerator;
import com.metamatrix.core.id.InvalidIDException;
import com.metamatrix.core.id.ObjectID;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.core.util.DateUtil;
import com.metamatrix.core.util.EnhancedStringTokenizer;
import com.metamatrix.core.util.FileUtils;
import com.metamatrix.core.util.ObjectConverterUtil;
import com.metamatrix.core.util.StringUtil;
import com.metamatrix.core.util.TempDirectory;
import com.metamatrix.core.util.UriUtil;
import com.metamatrix.internal.core.xml.vdb.VdbHeader;
import com.metamatrix.internal.core.xml.vdb.VdbHeaderReader;
import com.metamatrix.metamodels.core.CoreFactory;
import com.metamatrix.metamodels.core.ModelAnnotation;
import com.metamatrix.metamodels.core.ModelType;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.internal.core.resource.EResourceImpl;
import com.metamatrix.vdb.edit.VdbContext;
import com.metamatrix.vdb.edit.VdbEditPlugin;
import com.metamatrix.vdb.edit.loader.VDBReader;
import com.metamatrix.vdb.edit.manifest.ManifestFactory;
import com.metamatrix.vdb.edit.manifest.ModelReference;
import com.metamatrix.vdb.edit.manifest.NonModelReference;
import com.metamatrix.vdb.edit.manifest.Severity;
import com.metamatrix.vdb.edit.manifest.VirtualDatabase;
import com.metamatrix.vdb.edit.manifest.impl.ManifestPackageImpl;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyVetoException;
import java.beans.VetoableChangeListener;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.StringWriter;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import java.util.Random;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import org.eclipse.core.internal.runtime.ListenerList;
import org.eclipse.core.runtime.IPath;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.NullProgressMonitor;
import org.eclipse.core.runtime.Path;
import org.eclipse.emf.common.util.EList;
import org.eclipse.emf.common.util.URI;
import org.eclipse.emf.ecore.resource.Resource;
import org.jdom.Attribute;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.Namespace;
import org.jdom.output.Format;
import org.jdom.output.XMLOutputter;

public class VdbContextImpl
implements VdbContext {
    private static final String PRODUCER_NAME = "MetaMatrix";
    private static final String PRODUCER_VERSION = "5.0";
    private static final Random RANDOM = new Random(System.currentTimeMillis());
    private static final String XSD_IMPORT_TAG_NAME = "import";
    private static final String XSD_INCLUDE_TAG_NAME = "include";
    private static final String XSD_SCHEMA_DIRECTIVE_LOCATION_ATTRIBUTE_NAME = "schemaLocation";
    private static final String XML_FORMAT_INDENT = "    ";
    private static final String URL_ROOT_FOR_VDB = "http://vdb.metamatrix.com";
    private static final String URL_SUFFIX_FOR_VDB = "?vdbToken=true";
    private File vdbFile;
    private TempDirectory tempDirectory;
    private Resource manifestResource;
    private Map options;
    private VirtualDatabase virtualDatabase;
    private final ListenerList changeListeners;
    private final ListenerList vetoListeners;
    private Properties executionProperties;

    public VdbContextImpl(File theVdbFile, File vdbWorkingFolder) {
        ArgCheck.isNotNull((Object)theVdbFile);
        ArgCheck.isNotNull((Object)vdbWorkingFolder);
        if (!(vdbWorkingFolder.exists() && vdbWorkingFolder.isDirectory() && vdbWorkingFolder.canWrite())) {
            String msg = VdbEditPlugin.Util.getString("VdbContextImpl.Working_folder_must_be_existing_folder", (Object)vdbWorkingFolder);
            throw new IllegalArgumentException(msg);
        }
        this.vdbFile = theVdbFile;
        this.tempDirectory = this.createTempDirectory(vdbWorkingFolder);
        this.options = new HashMap();
        this.changeListeners = new ListenerList();
        this.vetoListeners = new ListenerList();
    }

    public TempDirectory getTempDirectory() {
        return this.tempDirectory;
    }

    public File getVdbFile() {
        return this.vdbFile;
    }

    public Severity getSeverity() {
        if (this.isOpen()) {
            return this.getVirtualDatabase().getSeverity();
        }
        VdbHeader header = null;
        try {
            header = this.peekAtContents();
        }
        catch (IOException e) {
            VdbEditPlugin.Util.log(4, (Throwable)e, e.getLocalizedMessage());
        }
        if (header != null) {
            return Severity.get((String)header.getSeverity());
        }
        return Severity.OK_LITERAL;
    }

    public String getDescription() {
        if (this.isOpen()) {
            return this.getVirtualDatabase().getDescription();
        }
        VdbHeader header = null;
        try {
            header = this.peekAtContents();
        }
        catch (IOException e) {
            VdbEditPlugin.Util.log(4, (Throwable)e, e.getLocalizedMessage());
        }
        if (header != null) {
            return header.getDescription();
        }
        return null;
    }

    public boolean isReadOnly() {
        return this.getVdbFile().exists() && !this.getVdbFile().canWrite();
    }

    public boolean isEmpty() {
        return !this.getVdbFile().exists() || this.getVdbFile().exists() && this.getVdbFile().length() == 0L;
    }

    public VdbHeader peekAtContents() throws IOException {
        if (this.getVdbFile().exists() && this.getVdbFile().canRead()) {
            try {
                return VdbHeaderReader.readHeader((File)this.getVdbFile());
            }
            catch (MetaMatrixCoreException e) {
                throw new IOException(e.getLocalizedMessage());
            }
        }
        return null;
    }

    public boolean isOpen() {
        return this.getManifestResource() != null;
    }

    public synchronized void open(IProgressMonitor theMonitor) throws IOException {
        this.open(theMonitor, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void open(IProgressMonitor theMonitor, boolean notify) throws IOException {
        if (this.isOpen()) {
            return;
        }
        IProgressMonitor monitor = theMonitor == null ? new NullProgressMonitor() : theMonitor;
        ZipFile vdbArchive = null;
        try {
            if (this.getVdbFile().exists() && this.getVdbFile().length() > 0L) {
                vdbArchive = new ZipFile(this.getVdbFile());
            }
            Resource manifest = this.createManifestResource(URI.createURI((String)"MetaMatrix-VdbManifestModel.xmi"));
            if (vdbArchive == null) {
                this.manifestResource = manifest;
                return;
            }
            TempDirectory tempDir = this.getTempDirectory();
            VdbHeader header = this.peekAtContents();
            int totalFileCount = header != null ? header.getModelInfos().length + header.getNonModelInfos().length + 1 : 1;
            String taskName = VdbEditPlugin.Util.getString("VdbContextImpl.Opening", (Object)this.getVdbFile().getName());
            monitor.beginTask(taskName, totalFileCount);
            int amountWorked = 0;
            this.loadManifestResource(manifest, vdbArchive);
            this.manifestResource = manifest;
            monitor.worked(amountWorked++);
            ArrayList<String> problems = new ArrayList<String>();
            EList modelRefs = this.getVirtualDatabase().getModels();
            Iterator i = modelRefs.iterator();
            while (i.hasNext()) {
                ModelReference modelRef = (ModelReference)i.next();
                try {
                    File f = this.writeArchiveEntryToTempDirectory(modelRef.getModelLocation(), vdbArchive, tempDir);
                    if (modelRef.getChecksum() == 0L && f != null && f.exists()) {
                        modelRef.setChecksum(this.getCheckSum(f));
                    }
                    monitor.worked(amountWorked++);
                }
                catch (Exception e) {
                    problems.add(e.getLocalizedMessage());
                }
            }
            EList nonModelRefs = this.getVirtualDatabase().getNonModels();
            Iterator i2 = nonModelRefs.iterator();
            while (i2.hasNext()) {
                NonModelReference nonModelRef = (NonModelReference)i2.next();
                try {
                    File f = this.writeArchiveEntryToTempDirectory(nonModelRef.getPath(), vdbArchive, tempDir);
                    if (nonModelRef.getChecksum() == 0L && f != null && f.exists()) {
                        nonModelRef.setChecksum(this.getCheckSum(f));
                    }
                    monitor.worked(amountWorked++);
                }
                catch (Exception e) {
                    problems.add(e.getLocalizedMessage());
                }
            }
            if (!problems.isEmpty()) {
                StringBuffer sb = new StringBuffer(2000);
                Iterator i3 = problems.iterator();
                while (i3.hasNext()) {
                    sb.append((String)i3.next());
                    if (!i3.hasNext()) continue;
                    sb.append(StringUtil.Constants.NEW_LINE);
                }
                throw new IOException(sb.toString());
            }
        }
        finally {
            if (vdbArchive != null) {
                vdbArchive.close();
            }
        }
        if (notify) {
            this.fireStateChanged();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public VirtualDatabase getVirtualDatabase() {
        this.assertContextIsOpen();
        if (this.virtualDatabase == null && this.manifestResource != null) {
            ModelAnnotation model = null;
            VirtualDatabase vdb = null;
            Iterator i = this.manifestResource.getContents().iterator();
            while (i.hasNext()) {
                Object obj = i.next();
                if (obj instanceof ModelAnnotation) {
                    model = (ModelAnnotation)obj;
                    continue;
                }
                if (!(obj instanceof VirtualDatabase)) continue;
                vdb = (VirtualDatabase)obj;
            }
            if (model == null) {
                boolean requiredStart = ModelerCore.startTxn((boolean)false, (boolean)false, (String)"Adapter Property Source", (Object)this);
                boolean succeeded = false;
                try {
                    model = CoreFactory.eINSTANCE.createModelAnnotation();
                    model.setPrimaryMetamodelUri("http://www.metamatrix.com/metamodels/VirtualDatabase");
                    model.setModelType(ModelType.VDB_ARCHIVE_LITERAL);
                    model.setProducerName(PRODUCER_NAME);
                    model.setProducerVersion(PRODUCER_VERSION);
                    this.manifestResource.getContents().add((Object)model);
                    succeeded = true;
                }
                finally {
                    if (requiredStart) {
                        if (succeeded) {
                            ModelerCore.commitTxn();
                        } else {
                            ModelerCore.rollbackTxn();
                        }
                    }
                }
            }
            if (vdb == null) {
                vdb = ManifestFactory.eINSTANCE.createVirtualDatabase();
                vdb.setName(URI.createFileURI((String)this.getVdbFile().getAbsolutePath()).trimFileExtension().lastSegment());
                vdb.setProducerName(PRODUCER_NAME);
                vdb.setProducerVersion(PRODUCER_VERSION);
                Date currentDate = DateUtil.getCurrentDate();
                vdb.setTimeLastChangedAsDate(currentDate);
                vdb.setTimeLastProducedAsDate(currentDate);
                this.manifestResource.getContents().add((Object)vdb);
            }
            this.virtualDatabase = vdb;
        }
        return this.virtualDatabase;
    }

    public void setVirtualDatabase(VirtualDatabase vdb) {
        this.virtualDatabase = vdb;
    }

    public ModelReference getModelReference(String pathInArchive) {
        ArgCheck.isNotNull((Object)pathInArchive);
        ArgCheck.isNotZeroLength((String)pathInArchive);
        this.assertContextIsOpen();
        IPath pathToMatch = this.createNormalizedPath(pathInArchive);
        Iterator i = this.getVirtualDatabase().getModels().iterator();
        while (i.hasNext()) {
            ModelReference ref = (ModelReference)i.next();
            IPath refPath = this.createNormalizedPath(ref.getModelLocation());
            if (!pathToMatch.equals(refPath)) continue;
            return ref;
        }
        IPath upperPathToMatch = this.createNormalizedPath(pathInArchive.toUpperCase());
        Iterator i2 = this.getVirtualDatabase().getModels().iterator();
        while (i2.hasNext()) {
            ModelReference ref = (ModelReference)i2.next();
            IPath upperRefPath = this.createNormalizedPath(ref.getModelLocation().toUpperCase());
            if (!upperPathToMatch.equals(upperRefPath)) continue;
            return ref;
        }
        return null;
    }

    public ModelReference getModelReference(File tempDirFile) {
        ArgCheck.isNotNull((Object)tempDirFile);
        File tempDirFolder = new File(this.getTempDirectory().getPath());
        String pathInTempDir = this.getPathRelativeToFolder(tempDirFolder, tempDirFile);
        if (pathInTempDir != null) {
            return this.getModelReference(pathInTempDir);
        }
        VdbEditPlugin.Util.log(4, VdbEditPlugin.Util.getString("VdbContextImpl.Error_getting_model_reference", (Object)tempDirFile));
        return null;
    }

    public ModelReference getModelReference(ObjectID uuid) {
        ArgCheck.isNotNull((Object)uuid);
        this.assertContextIsOpen();
        Iterator i = this.getVirtualDatabase().getModels().iterator();
        while (i.hasNext()) {
            ModelReference ref = (ModelReference)i.next();
            String uuidString = ref.getUuid();
            try {
                ObjectID refUuid;
                if (StringUtil.isEmpty(uuidString) || !uuid.equals(refUuid = IDGenerator.getInstance().stringToObject(uuidString, "mmuuid"))) continue;
                return ref;
            }
            catch (InvalidIDException e) {
                VdbEditPlugin.Util.log((Throwable)e);
            }
        }
        return null;
    }

    public NonModelReference getNonModelReference(String pathInArchive) {
        ArgCheck.isNotNull((Object)pathInArchive);
        ArgCheck.isNotZeroLength((String)pathInArchive);
        this.assertContextIsOpen();
        IPath pathToMatch = this.createNormalizedPath(pathInArchive);
        Iterator i = this.getVirtualDatabase().getNonModels().iterator();
        while (i.hasNext()) {
            NonModelReference ref = (NonModelReference)i.next();
            IPath refPath = this.createNormalizedPath(ref.getPath());
            if (!pathToMatch.equals(refPath)) continue;
            return ref;
        }
        IPath upperPathToMatch = this.createNormalizedPath(pathInArchive.toUpperCase());
        Iterator i2 = this.getVirtualDatabase().getNonModels().iterator();
        while (i2.hasNext()) {
            NonModelReference ref = (NonModelReference)i2.next();
            IPath upperRefPath = this.createNormalizedPath(ref.getPath().toUpperCase());
            if (!upperPathToMatch.equals(upperRefPath)) continue;
            return ref;
        }
        return null;
    }

    public NonModelReference getNonModelReference(File tempDirFile) {
        ArgCheck.isNotNull((Object)tempDirFile);
        File tempDirFolder = new File(this.getTempDirectory().getPath());
        String pathInTempDir = this.getPathRelativeToFolder(tempDirFolder, tempDirFile);
        return this.getNonModelReference(pathInTempDir);
    }

    public InputStream getInputStream(ModelReference modelRef) throws IOException {
        ArgCheck.isNotNull((Object)modelRef);
        this.assertContextIsOpen();
        File model = this.getTempDirectoryFile(this.getTempDirectory(), modelRef.getModelLocation());
        if (model.exists()) {
            return ObjectConverterUtil.convertToInputStream((File)model);
        }
        return null;
    }

    public InputStream getInputStream(NonModelReference nonModelRef) throws IOException {
        ArgCheck.isNotNull((Object)nonModelRef);
        this.assertContextIsOpen();
        File model = this.getTempDirectoryFile(this.getTempDirectory(), nonModelRef.getPath());
        if (model.exists()) {
            return ObjectConverterUtil.convertToInputStream((File)model);
        }
        return null;
    }

    public synchronized void close(IProgressMonitor theMonitor) throws IOException {
        this.close(theMonitor, true, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void close(IProgressMonitor theMonitor, boolean notify, boolean vetoable) throws IOException {
        if (this.isOpen() && (!vetoable || this.fireVetoableChange("closing", "opened", "closed"))) {
            IProgressMonitor monitor = theMonitor == null ? new NullProgressMonitor() : theMonitor;
            String taskName = VdbEditPlugin.Util.getString("VdbContextImpl.Closing", (Object)this.getVdbFile().getName());
            monitor.beginTask(taskName, 2);
            int amountWorked = 0;
            try {
                if (this.options != null) {
                    this.options.clear();
                }
                if (this.manifestResource != null) {
                    this.manifestResource.unload();
                }
                monitor.worked(amountWorked++);
                if (this.tempDirectory != null) {
                    File tempDirectoryFolder = new File(this.tempDirectory.getPath());
                    FileUtils.removeChildrenRecursively((File)tempDirectoryFolder);
                }
                monitor.worked(amountWorked++);
                Object var9_8 = null;
                this.virtualDatabase = null;
                this.manifestResource = null;
                if (notify) {
                    this.fireStateChanged();
                }
            }
            catch (Throwable throwable) {
                Object var9_9 = null;
                this.virtualDatabase = null;
                this.manifestResource = null;
                if (notify) {
                    this.fireStateChanged();
                }
                throw throwable;
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized void dispose() {
        try {
            block10: {
                try {
                    int i;
                    Object[] listeners;
                    this.close(null, false, false);
                    if (this.options != null) {
                        this.options.clear();
                    }
                    if (this.manifestResource != null) {
                        this.manifestResource.unload();
                    }
                    if (this.changeListeners != null) {
                        listeners = this.changeListeners.getListeners();
                        for (i = 0; i < listeners.length; ++i) {
                            this.changeListeners.remove(listeners[i]);
                        }
                    }
                    if (this.vetoListeners != null) {
                        listeners = this.vetoListeners.getListeners();
                        for (i = 0; i < listeners.length; ++i) {
                            this.vetoListeners.remove(listeners[i]);
                        }
                    }
                    if (this.tempDirectory == null) break block10;
                    this.tempDirectory.remove();
                }
                catch (Exception e) {
                    String msg = VdbEditPlugin.Util.getString("VdbContextImpl.Error_disposing_of_vdbContext");
                    VdbEditPlugin.Util.log(4, (Throwable)e, msg);
                    Object var4_6 = null;
                    this.options = null;
                    this.virtualDatabase = null;
                    this.manifestResource = null;
                    this.tempDirectory = null;
                    this.vdbFile = null;
                }
            }
            Object var4_5 = null;
            this.options = null;
            this.virtualDatabase = null;
            this.manifestResource = null;
            this.tempDirectory = null;
            this.vdbFile = null;
        }
        catch (Throwable throwable) {
            Object var4_7 = null;
            this.options = null;
            this.virtualDatabase = null;
            this.manifestResource = null;
            this.tempDirectory = null;
            this.vdbFile = null;
            throw throwable;
        }
    }

    public void addVetoableChangeListener(VetoableChangeListener theListener) {
        if (theListener != null) {
            this.vetoListeners.add((Object)theListener);
        }
    }

    public void removeVetoableChangeListener(VetoableChangeListener theListener) {
        this.vetoListeners.remove((Object)theListener);
    }

    public void addChangeListener(IChangeListener theListener) {
        if (theListener != null) {
            this.changeListeners.add((Object)theListener);
        }
    }

    public void removeChangeListener(IChangeListener theListener) {
        this.changeListeners.remove((Object)theListener);
    }

    public Properties getExecutionProperties() {
        if (this.executionProperties == null) {
            try {
                this.executionProperties = VDBReader.loadVDBDefn(this, false).getExecutionProperties();
            }
            catch (Exception e) {
                String msg = VdbEditPlugin.Util.getString("VdbContextImpl.Error_loading_VDB");
                VdbEditPlugin.Util.log(4, (Throwable)e, msg);
            }
        }
        return this.executionProperties;
    }

    protected void assertContextIsOpen() {
        if (!this.isOpen()) {
            String msg = VdbEditPlugin.Util.getString("VdbContextImpl.Context_must_be_open_before_calling");
            throw new IllegalStateException(msg);
        }
    }

    protected void fireStateChanged() {
        Object[] listeners = this.changeListeners.getListeners();
        for (int i = 0; i < listeners.length; ++i) {
            ((IChangeListener)listeners[i]).stateChanged((IChangeNotifier)this);
        }
    }

    protected boolean fireVetoableChange(String key, Object oldValue, Object newValue) {
        try {
            Object[] listeners = this.vetoListeners.getListeners();
            PropertyChangeEvent evt = null;
            for (int i = 0; i < listeners.length; ++i) {
                if (evt == null) {
                    evt = new PropertyChangeEvent(this, key, oldValue, newValue);
                }
                ((VetoableChangeListener)listeners[i]).vetoableChange(evt);
            }
            return true;
        }
        catch (PropertyVetoException ex) {
            return false;
        }
    }

    protected Map getLoadOptions() {
        if (!this.options.containsKey("DISABLE_NOTIFY")) {
            this.options.put("DISABLE_NOTIFY", Boolean.TRUE);
        }
        if (!this.options.containsKey("PROCESS_DANGLING_HREF")) {
            this.options.put("PROCESS_DANGLING_HREF", "THROW");
        }
        return this.options;
    }

    protected File getVdbWorkingFolder() {
        TempDirectory tempDir = this.getTempDirectory();
        return new File(tempDir.getPath()).getParentFile();
    }

    protected Resource getManifestResource() {
        return this.manifestResource;
    }

    protected Resource createManifestResource(URI uri) {
        return new EResourceImpl(uri);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void loadManifestResource(Resource manifest, ZipFile archiveFile) throws IOException {
        block8: {
            ArgCheck.isNotNull((Object)manifest);
            if (archiveFile == null) {
                return;
            }
            InputStream istream = null;
            try {
                istream = this.getArchiveEntryStream("MetaMatrix-VdbManifestModel.xmi", archiveFile);
                if (istream == null) break block8;
                try {
                    manifest.load(istream, this.getLoadOptions());
                    Object var5_4 = null;
                }
                catch (Throwable throwable) {
                    Object var5_5 = null;
                    try {
                        istream.close();
                    }
                    catch (IOException e) {
                        VdbEditPlugin.Util.log(4, (Throwable)e, e.getLocalizedMessage());
                    }
                    throw throwable;
                }
                try {
                    istream.close();
                }
                catch (IOException e) {
                    VdbEditPlugin.Util.log(4, (Throwable)e, e.getLocalizedMessage());
                }
            }
            catch (Exception e) {
                manifest.getContents().clear();
                VdbEditPlugin.Util.log(4, (Throwable)e, e.getLocalizedMessage());
                throw new IOException(e.getLocalizedMessage());
            }
        }
    }

    protected IPath createNormalizedPath(String pathInArchive) {
        ArgCheck.isNotNull((Object)pathInArchive);
        ArgCheck.isNotZeroLength((String)pathInArchive);
        Path path = new Path(pathInArchive);
        return path.segmentCount() == 1 ? path.removeTrailingSeparator().makeRelative() : path.makeAbsolute();
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected File writeArchiveEntryToTempDirectory(String pathInArchive, ZipFile archiveFile, TempDirectory tempDir) throws IOException {
        InputStream istream;
        File result;
        block10: {
            ArgCheck.isNotNull((Object)pathInArchive);
            ArgCheck.isNotZeroLength((String)pathInArchive);
            ArgCheck.isNotNull((Object)archiveFile);
            ArgCheck.isNotNull((Object)tempDir);
            result = null;
            istream = null;
            istream = this.getArchiveEntryStream(pathInArchive, archiveFile);
            if (istream == null) break block10;
            if (pathInArchive.endsWith(".xsd")) {
                istream = this.decodeXsdStream(istream, pathInArchive, tempDir);
            } else if (!pathInArchive.endsWith(".xmi")) {
                istream = this.decodeXmiStream(istream, pathInArchive, tempDir);
            }
            result = this.writeToTempDirectory(istream, pathInArchive, tempDir);
        }
        Object var10_6 = null;
        if (istream == null) return result;
        try {
            istream.close();
            return result;
        }
        catch (IOException e) {
            VdbEditPlugin.Util.log(4, (Throwable)e, e.getLocalizedMessage());
        }
        return result;
        {
            catch (Exception e) {
                Object[] params = new Object[]{pathInArchive, e.getLocalizedMessage()};
                String msg = VdbEditPlugin.Util.getString("VdbContextImpl.Error_streaming_entry", params);
                VdbEditPlugin.Util.log(4, (Throwable)e, msg);
                throw new IOException(msg);
            }
        }
        catch (Throwable throwable) {
            Object var10_7 = null;
            if (istream == null) throw throwable;
            try {
                istream.close();
                throw throwable;
            }
            catch (IOException e) {
                VdbEditPlugin.Util.log(4, (Throwable)e, e.getLocalizedMessage());
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream decodeXsdStream(InputStream istream, String pathInArchive, TempDirectory tempDir) throws IOException {
        ArgCheck.isNotNull((Object)istream);
        if (!pathInArchive.endsWith(".xsd")) {
            return istream;
        }
        Document doc = null;
        InputStream result = null;
        if (istream != null) {
            try {
                doc = this.buildDocument(istream);
                this.decodeXsdSchemaDirectivePaths(doc, pathInArchive, new File(tempDir.getPath()));
                result = ObjectConverterUtil.convertToInputStream((String)this.writeToString(doc, XML_FORMAT_INDENT, true));
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                try {
                    istream.close();
                }
                catch (IOException e) {
                    VdbEditPlugin.Util.log(4, (Throwable)e, e.getLocalizedMessage());
                }
                throw throwable;
            }
            try {
                istream.close();
            }
            catch (IOException e) {
                VdbEditPlugin.Util.log(4, (Throwable)e, e.getLocalizedMessage());
            }
        }
        return result;
    }

    protected InputStream decodeXmiStream(InputStream istream, String pathInArchive, TempDirectory tempDir) throws IOException {
        ArgCheck.isNotNull((Object)istream);
        if (!pathInArchive.endsWith(".xmi")) {
            return istream;
        }
        return istream;
    }

    protected InputStream getArchiveEntryStream(String pathInArchive, ZipFile archiveFile) throws IOException {
        ArgCheck.isNotNull((Object)pathInArchive);
        ArgCheck.isNotZeroLength((String)pathInArchive);
        ArgCheck.isNotNull((Object)archiveFile);
        ZipEntry zipEntry = archiveFile.getEntry(pathInArchive);
        InputStream istream = null;
        if (zipEntry != null && (istream = archiveFile.getInputStream(zipEntry)) == null) {
            Object[] params = new Object[]{pathInArchive, this.getVdbFile()};
            String msg = VdbEditPlugin.Util.getString("VdbContextImpl.Error_obtaining_input_stream", params);
            throw new IOException(msg);
        }
        return istream;
    }

    /*
     * Loose catch block
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    protected File copyTempDirectoryEntryForSave(String pathInTempDir, TempDirectory sourceDir, TempDirectory targetDir) throws IOException {
        InputStream istream;
        File result;
        block10: {
            ArgCheck.isNotNull((Object)pathInTempDir);
            ArgCheck.isNotZeroLength((String)pathInTempDir);
            ArgCheck.isNotNull((Object)sourceDir);
            ArgCheck.isNotNull((Object)targetDir);
            result = null;
            istream = null;
            File sourceFile = this.getTempDirectoryFile(sourceDir, pathInTempDir);
            istream = ObjectConverterUtil.convertToInputStream((File)sourceFile);
            if (istream == null) break block10;
            if (pathInTempDir.endsWith(".xsd")) {
                istream = this.encodeXsdStream(istream, pathInTempDir, sourceDir);
            } else if (!pathInTempDir.endsWith(".xmi")) {
                istream = this.encodeXmiStream(istream, pathInTempDir, sourceDir);
            }
            result = this.writeToTempDirectory(istream, pathInTempDir, targetDir);
        }
        Object var10_8 = null;
        if (istream == null) return result;
        try {
            istream.close();
            return result;
        }
        catch (IOException e) {
            VdbEditPlugin.Util.log(4, (Throwable)e, e.getLocalizedMessage());
        }
        return result;
        {
            catch (Exception e) {
                Object[] params = new Object[]{pathInTempDir, e.getLocalizedMessage()};
                String msg = VdbEditPlugin.Util.getString("VdbContextImpl.Error_streaming_entry", params);
                VdbEditPlugin.Util.log(4, (Throwable)e, msg);
                throw new IOException(msg);
            }
        }
        catch (Throwable throwable) {
            Object var10_9 = null;
            if (istream == null) throw throwable;
            try {
                istream.close();
                throw throwable;
            }
            catch (IOException e) {
                VdbEditPlugin.Util.log(4, (Throwable)e, e.getLocalizedMessage());
            }
            throw throwable;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected InputStream encodeXsdStream(InputStream istream, String pathInTempDir, TempDirectory tempDir) throws IOException {
        ArgCheck.isNotNull((Object)istream);
        if (!pathInTempDir.endsWith(".xsd")) {
            return istream;
        }
        Document doc = null;
        InputStream result = null;
        if (istream != null) {
            try {
                doc = this.buildDocument(istream);
                this.encodeXsdSchemaDirectivePaths(doc, pathInTempDir, new File(tempDir.getPath()));
                result = ObjectConverterUtil.convertToInputStream((String)this.writeToString(doc, XML_FORMAT_INDENT, true));
                Object var7_6 = null;
            }
            catch (Throwable throwable) {
                Object var7_7 = null;
                try {
                    istream.close();
                }
                catch (IOException e) {
                    VdbEditPlugin.Util.log(4, (Throwable)e, e.getLocalizedMessage());
                }
                throw throwable;
            }
            try {
                istream.close();
            }
            catch (IOException e) {
                VdbEditPlugin.Util.log(4, (Throwable)e, e.getLocalizedMessage());
            }
        }
        return result;
    }

    protected InputStream encodeXmiStream(InputStream istream, String pathInTempDir, TempDirectory tempDir) throws IOException {
        ArgCheck.isNotNull((Object)istream);
        if (!pathInTempDir.endsWith(".xmi")) {
            return istream;
        }
        return istream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected File writeToTempDirectory(InputStream istream, String pathInTempDir, TempDirectory tempDir) throws IOException {
        ArgCheck.isNotNull((Object)istream);
        FileOutputStream fos = null;
        OutputStream bos = null;
        File tempDirFile = null;
        try {
            int bytesRead;
            tempDirFile = this.getTempDirectoryFile(tempDir, pathInTempDir);
            if (tempDirFile.exists()) {
                tempDirFile.delete();
            }
            fos = new FileOutputStream(tempDirFile);
            bos = new BufferedOutputStream(fos);
            byte[] buff = new byte[2048];
            while (-1 != (bytesRead = istream.read(buff, 0, buff.length))) {
                bos.write(buff, 0, bytesRead);
            }
            bos.flush();
            Object var10_9 = null;
        }
        catch (Throwable throwable) {
            Object var10_10 = null;
            try {
                istream.close();
            }
            catch (IOException e) {
                VdbEditPlugin.Util.log(4, (Throwable)e, e.getMessage());
            }
            if (bos != null) {
                try {
                    bos.close();
                }
                catch (IOException e) {
                    VdbEditPlugin.Util.log(4, (Throwable)e, e.getLocalizedMessage());
                }
            }
            if (fos != null) {
                try {
                    ((OutputStream)fos).close();
                }
                catch (IOException e) {
                    VdbEditPlugin.Util.log(4, (Throwable)e, e.getLocalizedMessage());
                }
            }
            throw throwable;
        }
        try {
            istream.close();
        }
        catch (IOException e) {
            VdbEditPlugin.Util.log(4, (Throwable)e, e.getMessage());
        }
        if (bos != null) {
            try {
                bos.close();
            }
            catch (IOException e) {
                VdbEditPlugin.Util.log(4, (Throwable)e, e.getLocalizedMessage());
            }
        }
        if (fos != null) {
            try {
                ((OutputStream)fos).close();
            }
            catch (IOException e) {
                VdbEditPlugin.Util.log(4, (Throwable)e, e.getLocalizedMessage());
            }
        }
        return tempDirFile;
    }

    protected File getTempDirectoryFile(TempDirectory tempDir, String pathInTempDir) {
        Path pathToFile;
        ArgCheck.isNotNull((Object)tempDir);
        ArgCheck.isNotNull((Object)pathInTempDir);
        ArgCheck.isNotZeroLength((String)pathInTempDir);
        Path tempDirPath = new Path(tempDir.getPath());
        String tempDirName = tempDirPath.lastSegment();
        String tempFileName = pathInTempDir;
        int tempDirNameIndex = tempFileName.indexOf(tempDirName);
        if (tempDirNameIndex != -1 && (tempDirNameIndex += tempDirName.length()) < tempFileName.length()) {
            tempFileName = tempFileName.substring(tempDirNameIndex);
        }
        if ((pathToFile = new Path(tempFileName)).segmentCount() > 1) {
            File baseFile = tempDirPath.toFile();
            String[] segments = pathToFile.segments();
            for (int i = 0; i != segments.length - 1; ++i) {
                String folderName = segments[i];
                File folder = new File(baseFile, folderName);
                if (!folder.exists()) {
                    folder.mkdir();
                }
                baseFile = folder;
            }
        }
        IPath tempDirFilePath = tempDirPath.append((IPath)new Path(tempFileName));
        return tempDirFilePath.toFile();
    }

    protected synchronized TempDirectory createTempDirectory(File vdbWorkingFolder) {
        ArgCheck.isNotNull((Object)vdbWorkingFolder);
        if (!vdbWorkingFolder.exists()) {
            vdbWorkingFolder.mkdirs();
        }
        String absolutePath = vdbWorkingFolder.getAbsolutePath();
        TempDirectory tempDir = new TempDirectory(absolutePath, System.currentTimeMillis(), RANDOM.nextLong());
        File tempDirectory = new File(tempDir.getPath());
        while (tempDirectory.exists()) {
            try {
                Thread.sleep(10L);
            }
            catch (InterruptedException ignored) {
                // empty catch block
            }
            tempDir = new TempDirectory(absolutePath, System.currentTimeMillis(), RANDOM.nextLong());
            tempDirectory = new File(tempDir.getPath());
        }
        tempDirectory.mkdir();
        return tempDir;
    }

    /*
     * Loose catch block
     */
    protected Document buildDocument(InputStream istream) throws IOException {
        Document doc;
        block7: {
            ArgCheck.isNotNull((Object)istream);
            doc = null;
            doc = this.getXMLReaderWriter().readDocument(istream);
            Object var5_3 = null;
            try {
                istream.close();
            }
            catch (IOException e) {
                VdbEditPlugin.Util.log(4, (Throwable)e, e.getLocalizedMessage());
            }
            break block7;
            {
                catch (Exception e) {
                    VdbEditPlugin.Util.log(4, (Throwable)e, e.getLocalizedMessage());
                    throw new IOException(e.getLocalizedMessage());
                }
            }
            catch (Throwable throwable) {
                Object var5_4 = null;
                try {
                    istream.close();
                }
                catch (IOException e) {
                    VdbEditPlugin.Util.log(4, (Throwable)e, e.getLocalizedMessage());
                }
                throw throwable;
            }
        }
        return doc;
    }

    protected XMLReaderWriter getXMLReaderWriter() {
        return new XMLReaderWriterImpl();
    }

    protected void encodeXsdSchemaDirectivePaths(Document doc, String pathInArchive, File targetDirectory) {
        ArgCheck.isNotNull((Object)doc);
        ArgCheck.isNotNull((Object)pathInArchive);
        ArgCheck.isNotZeroLength((String)pathInArchive);
        ArgCheck.isNotNull((Object)targetDirectory);
        File targetFile = new File(targetDirectory, pathInArchive);
        ArrayList directives = new ArrayList();
        Namespace xsNS = Namespace.getNamespace((String)"xsd", (String)"http://www.w3.org/2001/XMLSchema");
        directives.addAll(doc.getRootElement().getChildren(XSD_IMPORT_TAG_NAME, xsNS));
        directives.addAll(doc.getRootElement().getChildren(XSD_INCLUDE_TAG_NAME, xsNS));
        Iterator i = directives.iterator();
        while (i.hasNext()) {
            Element elm = (Element)i.next();
            Iterator j = elm.getAttributes().iterator();
            while (j.hasNext()) {
                String updatedPath;
                String relativePath;
                Attribute a = (Attribute)j.next();
                if (!XSD_SCHEMA_DIRECTIVE_LOCATION_ATTRIBUTE_NAME.equals(a.getName())) continue;
                URI baseUri = URI.createFileURI((String)targetFile.getAbsolutePath());
                URI locationUri = URI.createURI((String)a.getValue());
                if (baseUri.isHierarchical() && !baseUri.isRelative() && locationUri.isRelative()) {
                    locationUri = locationUri.resolve(baseUri);
                }
                if (locationUri.isFile()) {
                    relativePath = this.getPathRelativeToFolder(targetDirectory, new File(locationUri.toFileString()));
                    updatedPath = this.encodePathForUrl((IPath)new Path(relativePath)).toString();
                    a.setValue(URL_ROOT_FOR_VDB + updatedPath + URL_SUFFIX_FOR_VDB);
                    continue;
                }
                if (!"http://www.metamatrix.com/metamodels/SimpleDatatypes-instance".equals(locationUri.toString())) continue;
                relativePath = "builtInDataTypes.xsd";
                updatedPath = this.encodePathForUrl((IPath)new Path(relativePath)).toString();
                a.setValue(URL_ROOT_FOR_VDB + updatedPath + URL_SUFFIX_FOR_VDB);
            }
        }
    }

    protected void decodeXsdSchemaDirectivePaths(Document doc, String pathInArchive, File targetDirectory) {
        ArgCheck.isNotNull((Object)doc);
        ArgCheck.isNotNull((Object)pathInArchive);
        ArgCheck.isNotZeroLength((String)pathInArchive);
        ArgCheck.isNotNull((Object)targetDirectory);
        File targetFile = new File(targetDirectory, pathInArchive);
        URI baseUri = URI.createFileURI((String)targetFile.getAbsolutePath());
        ArrayList directives = new ArrayList();
        Namespace xsNS = Namespace.getNamespace((String)"xsd", (String)"http://www.w3.org/2001/XMLSchema");
        directives.addAll(doc.getRootElement().getChildren(XSD_IMPORT_TAG_NAME, xsNS));
        directives.addAll(doc.getRootElement().getChildren(XSD_INCLUDE_TAG_NAME, xsNS));
        Iterator i = directives.iterator();
        while (i.hasNext()) {
            Element elm = (Element)i.next();
            Iterator j = elm.getAttributes().iterator();
            while (j.hasNext()) {
                URI deresolvedURI;
                boolean deresolve;
                String location;
                Attribute a = (Attribute)j.next();
                if (!XSD_SCHEMA_DIRECTIVE_LOCATION_ATTRIBUTE_NAME.equals(a.getName()) || (location = a.getValue()) == null || !location.startsWith(URL_ROOT_FOR_VDB) || !location.endsWith(URL_SUFFIX_FOR_VDB)) continue;
                int endIndex = location.lastIndexOf(URL_SUFFIX_FOR_VDB);
                int beginIndex = URL_ROOT_FOR_VDB.length();
                if (endIndex <= 0 || beginIndex >= endIndex) continue;
                location = location.substring(beginIndex, endIndex);
                if ((location = this.decodePathForUrl((IPath)new Path(location)).toString()).endsWith("builtInDataTypes.xsd")) {
                    a.setValue("http://www.metamatrix.com/metamodels/SimpleDatatypes-instance");
                    continue;
                }
                File importFile = new File(targetDirectory, location);
                URI importUri = URI.createFileURI((String)importFile.getAbsolutePath());
                boolean bl = deresolve = baseUri != null && !baseUri.isRelative() && baseUri.isHierarchical();
                if (deresolve && !importUri.isRelative() && (deresolvedURI = importUri.deresolve(baseUri, true, true, false)).hasRelativePath()) {
                    importUri = deresolvedURI;
                }
                a.setValue(URI.decode((String)importUri.toString()));
            }
        }
    }

    protected IPath encodePathForUrl(IPath pathToResourceInVdb) {
        String[] pathSegments = pathToResourceInVdb.segments();
        Path pathWithEncoding = Path.ROOT;
        for (int i = 0; i < pathSegments.length; ++i) {
            String segment = pathSegments[i];
            StringBuffer encodedSegment = new StringBuffer();
            String tokenDelimSet = ".?_";
            EnhancedStringTokenizer segmentTokens = new EnhancedStringTokenizer(segment, ".?_");
            while (segmentTokens.hasMoreTokens()) {
                String token = segmentTokens.nextToken();
                String delims = segmentTokens.nextDelimiters();
                String encodedSegmentToken = UriUtil.escape((String)token);
                encodedSegment.append(encodedSegmentToken);
                if (delims == null) continue;
                encodedSegment.append(delims);
            }
            pathWithEncoding = pathWithEncoding.append(encodedSegment.toString());
        }
        return pathWithEncoding;
    }

    protected IPath decodePathForUrl(IPath pathToResourceInVdb) {
        String[] pathSegments = pathToResourceInVdb.segments();
        Path pathWithEncoding = Path.ROOT;
        for (int i = 0; i < pathSegments.length; ++i) {
            String segment = pathSegments[i];
            StringBuffer decodedSegment = new StringBuffer();
            String tokenDelimSet = ".?_";
            EnhancedStringTokenizer segmentTokens = new EnhancedStringTokenizer(segment, ".?_");
            while (segmentTokens.hasMoreTokens()) {
                String token = segmentTokens.nextToken();
                String delims = segmentTokens.nextDelimiters();
                String decodedSegmentToken = UriUtil.unescape((String)token);
                decodedSegment.append(decodedSegmentToken);
                if (delims == null) continue;
                decodedSegment.append(delims);
            }
            pathWithEncoding = pathWithEncoding.append(decodedSegment.toString());
        }
        return pathWithEncoding;
    }

    protected String writeToString(Document doc, String indent, boolean newlines) throws IOException {
        ArgCheck.isNotNull((Object)doc);
        Format format = Format.getPrettyFormat();
        format.setIndent(indent);
        if (newlines) {
            format.setLineSeparator("\n");
        } else {
            format.setLineSeparator("");
        }
        XMLOutputter outputter = new XMLOutputter(format);
        StringWriter writer = new StringWriter();
        outputter.output(doc, (Writer)writer);
        return writer.getBuffer().toString();
    }

    protected String getPathRelativeToFolder(File parentFolder, File f) {
        ArgCheck.isNotNull((Object)parentFolder);
        ArgCheck.isNotNull((Object)f);
        String relativePath = null;
        try {
            String folderPath = parentFolder.getCanonicalPath();
            String filePath = f.getCanonicalPath();
            if (filePath.startsWith(folderPath)) {
                relativePath = filePath.substring(folderPath.length());
            }
        }
        catch (IOException e) {
            VdbEditPlugin.Util.log(4, (Throwable)e, e.getLocalizedMessage());
        }
        return relativePath;
    }

    protected long getCheckSum(File f) {
        ArgCheck.isNotNull((Object)f);
        try {
            return FileUtils.getCheckSum((File)f);
        }
        catch (Exception e) {
            String msg = VdbEditPlugin.Util.getString("VdbContextImpl.Error_computing_checksum", (Object)f);
            VdbEditPlugin.Util.log(4, (Throwable)e, msg);
            return 0L;
        }
    }

    static {
        ManifestPackageImpl.init();
    }
}

