/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.processor.relational;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.ExpressionEvaluationException;
import com.metamatrix.api.exception.query.QueryValidatorException;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.common.buffer.TupleBatch;
import com.metamatrix.common.buffer.TupleSource;
import com.metamatrix.query.eval.LookupEvaluator;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.processor.relational.RelationalNode;
import com.metamatrix.query.processor.relational.RelationalNodeUtil;
import com.metamatrix.query.processor.relational.SetCriteriaUtil;
import com.metamatrix.query.rewriter.QueryRewriter;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.Query;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.visitor.EvaluateExpressionVisitor;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class AccessNode
extends RelationalNode {
    private Command command;
    private String modelName;
    private boolean shouldEvaluate = false;
    private Map elementMap;
    private TupleSource tupleSource;
    private boolean sourceOpened = false;
    private boolean needProject = false;
    private boolean needProcessing = true;
    private boolean isUpdate = false;
    protected List dependentAccessTupleStores;
    protected int maxSetSize;
    private int execCount;

    public AccessNode(int nodeID) {
        super(nodeID);
    }

    public void reset() {
        super.reset();
        this.tupleSource = null;
        this.sourceOpened = false;
        this.needProject = false;
        this.needProcessing = true;
        this.isUpdate = false;
    }

    public void setCommand(Command command) {
        this.command = command;
    }

    public Command getCommand() {
        return this.command;
    }

    public void setModelName(String name) {
        this.modelName = name;
    }

    public String getModelName() {
        return this.modelName;
    }

    public void setShouldEvaluateExpressions(boolean shouldEvaluate) {
        this.shouldEvaluate = shouldEvaluate;
    }

    public void setTupleSource(TupleSource tupleSource, int nodeID) {
        this.tupleSource = tupleSource;
    }

    public void setMaxSetSize(int maxSetSize) {
        this.maxSetSize = maxSetSize;
    }

    protected void needsNoProcessing() {
        this.needProcessing = false;
    }

    public void open() throws MetaMatrixComponentException {
        if (!this.needProcessing) {
            return;
        }
        Command atomicCommand = this.command;
        if (this.shouldEvaluate) {
            atomicCommand = (Command)this.command.clone();
            try {
                EvaluateExpressionVisitor.replaceExpressions((LanguageObject)atomicCommand, true, true, (LookupEvaluator)this.getDataManager(), this.getContext());
            }
            catch (ExpressionEvaluationException e) {
                throw new MetaMatrixComponentException((Throwable)e, "ERR.015.006.0024", QueryExecPlugin.Util.getString("ERR.015.006.0024"));
            }
            try {
                QueryRewriter.rewrite(atomicCommand, null, null, this.getContext());
            }
            catch (QueryValidatorException e) {
                throw new MetaMatrixComponentException((Throwable)e, QueryExecPlugin.Util.getString("AccessNode.rewrite_failed", (Object)atomicCommand));
            }
        }
        this.isUpdate = RelationalNodeUtil.isUpdate((Command)atomicCommand);
        this.needProcessing = RelationalNodeUtil.shouldExecute((Command)atomicCommand, (boolean)true);
        if (this.dependentAccessTupleStores != null && (atomicCommand = SetCriteriaUtil.addSetCriteriaToCommand((Query)((Query)atomicCommand), (List)this.dependentAccessTupleStores, (int)this.maxSetSize)) == null) {
            this.needProcessing = false;
        }
        if (this.needProcessing) {
            this.getDataManager().registerRequest(this.getContext().getProcessorID(), atomicCommand, this.modelName, this.getID(), this.execCount++);
        }
    }

    public TupleBatch nextBatchDirect() throws BlockedException, MetaMatrixComponentException {
        if (!this.needProcessing) {
            if (this.isUpdate) {
                ArrayList<Integer> tuple = new ArrayList<Integer>(1);
                tuple.add(new Integer(0));
                this.addBatchRow(tuple);
            }
            this.terminateBatches();
            return this.pullBatch();
        }
        if (this.tupleSource == null) {
            throw BlockedException.INSTANCE;
        }
        if (!this.sourceOpened) {
            this.tupleSource.openSource();
            this.sourceOpened = true;
            List sourceElements = this.tupleSource.getSchema();
            this.elementMap = this.createLookupMap(sourceElements);
            List actualElements = this.getElements();
            if (sourceElements.size() != actualElements.size()) {
                this.needProject = true;
            } else {
                Iterator srcIter = sourceElements.iterator();
                Iterator actualIter = actualElements.iterator();
                while (srcIter.hasNext()) {
                    SingleElementSymbol srcElement = (SingleElementSymbol)srcIter.next();
                    SingleElementSymbol actualElement = (SingleElementSymbol)actualIter.next();
                    if (srcElement.getShortName().equalsIgnoreCase(actualElement.getShortName())) continue;
                    this.needProject = true;
                    break;
                }
            }
        }
        boolean batchDone = false;
        while (!batchDone) {
            List tuple = this.tupleSource.nextTuple();
            if (tuple == null) {
                this.tupleSource.closeSource();
                this.tupleSource = null;
                batchDone = true;
                if (this.dependentAccessTupleStores != null && !SetCriteriaUtil.isEmpty((List)this.dependentAccessTupleStores)) {
                    Query atomicCommand = SetCriteriaUtil.addSetCriteriaToCommand((Query)((Query)this.command), (List)this.dependentAccessTupleStores, (int)this.maxSetSize);
                    if (atomicCommand != null) {
                        this.getDataManager().registerRequest(this.getContext().getProcessorID(), (Command)atomicCommand, this.modelName, this.getID(), this.execCount++);
                        this.sourceOpened = false;
                        continue;
                    }
                    this.terminateBatches();
                    continue;
                }
                this.terminateBatches();
                continue;
            }
            if (this.needProject) {
                tuple = this.projectTuple(this.elementMap, tuple, this.getElements());
            }
            this.addBatchRow(tuple);
            batchDone = this.isBatchFull();
        }
        return this.pullBatch();
    }

    public void close() throws MetaMatrixComponentException {
        if (this.tupleSource != null) {
            this.tupleSource.closeSource();
            this.tupleSource = null;
        }
    }

    protected void getNodeString(StringBuffer str) {
        super.getNodeString(str);
        str.append(this.command);
    }

    public Object clone() {
        AccessNode clonedNode = new AccessNode(super.getID());
        this.copy(this, clonedNode);
        return clonedNode;
    }

    protected void copy(AccessNode source, AccessNode target) {
        super.copy((RelationalNode)source, (RelationalNode)target);
        target.modelName = source.modelName;
        target.shouldEvaluate = source.shouldEvaluate;
        target.command = (Command)source.command.clone();
        target.execCount = source.execCount;
        target.maxSetSize = source.maxSetSize;
    }

    public Map getDescriptionProperties() {
        Map props = super.getDescriptionProperties();
        props.put("type", "Access");
        props.put("sql", this.command.toString());
        props.put("modelName", this.modelName);
        return props;
    }

    protected int getExecCount() {
        return this.execCount;
    }
}

