/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.RuleAssignOutputElements;
import com.metamatrix.query.optimizer.relational.rules.RuleConstants;
import com.metamatrix.query.optimizer.relational.rules.RuleRemoveOptionalJoins;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.visitor.GroupsUsedByElementsVisitor;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

/*
 * Exception performing whole class analysis ignored.
 */
public class RuleRemoveOptionalJoins
implements OptimizerRule {
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        OutputColumnsChangeFlag flag = new OutputColumnsChangeFlag();
        this.removeOptionalJoinNodes(plan, metadata, capFinder, flag);
        if (OutputColumnsChangeFlag.access$000((OutputColumnsChangeFlag)flag)) {
            rules.push(RuleConstants.ASSIGN_OUTPUT_ELEMENTS);
        }
        return plan;
    }

    private boolean removeOptionalJoinNodes(PlanNode node, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, OutputColumnsChangeFlag flag) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        boolean oneOptionalNodeRemoved = false;
        if (node.getType() == 7) {
            if (Boolean.TRUE.equals(node.getProperty(NodeConstants.Info.IS_RIGHT_OPTIONAL))) {
                oneOptionalNodeRemoved = this.removeOptionalJoinNode(node, node.getLastChild(), metadata, capFinder, flag);
            }
            if (!oneOptionalNodeRemoved && Boolean.TRUE.equals(node.getProperty(NodeConstants.Info.IS_LEFT_OPTIONAL))) {
                oneOptionalNodeRemoved = this.removeOptionalJoinNode(node, node.getFirstChild(), metadata, capFinder, flag);
            }
        }
        if (oneOptionalNodeRemoved) {
            return true;
        }
        boolean hasOptionalNodeRemoved = false;
        boolean oneOptionalNodeRemovedFromChild = false;
        block0: do {
            oneOptionalNodeRemovedFromChild = false;
            Iterator iter = node.getChildren().iterator();
            while (iter.hasNext()) {
                if (!this.removeOptionalJoinNodes((PlanNode)iter.next(), metadata, capFinder, flag)) continue;
                oneOptionalNodeRemovedFromChild = true;
                hasOptionalNodeRemoved = true;
                continue block0;
            }
        } while (oneOptionalNodeRemovedFromChild);
        return hasOptionalNodeRemoved;
    }

    private boolean removeOptionalJoinNode(PlanNode node, PlanNode optionalNode, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, OutputColumnsChangeFlag flag) throws QueryPlannerException, QueryMetadataException, MetaMatrixComponentException {
        List cols = (List)node.getProperty(NodeConstants.Info.OUTPUT_COLS);
        Set groups = optionalNode.getGroups();
        boolean shouldRemoveNode = true;
        Iterator colsIter = cols.iterator();
        while (colsIter.hasNext()) {
            LanguageObject element = (LanguageObject)colsIter.next();
            Collection outputGroups = GroupsUsedByElementsVisitor.getGroups((LanguageObject)element);
            outputGroups.retainAll(groups);
            if (outputGroups.size() <= 0) continue;
            shouldRemoveNode = false;
            break;
        }
        if (shouldRemoveNode) {
            PlanNode parentNode = node.getParent();
            PlanNode siblingNode = NodeEditor.getSibling(optionalNode);
            List newCols = (List)node.getProperty(NodeConstants.Info.OUTPUT_COLS);
            List oldCols = (List)siblingNode.getProperty(NodeConstants.Info.OUTPUT_COLS);
            if (siblingNode.getType() == 19) {
                int[] newIndexes = new int[newCols.size()];
                ArrayList<String> newShortNames = new ArrayList<String>(newCols.size());
                Iterator<Object> iter = newCols.iterator();
                int i = 0;
                while (iter.hasNext()) {
                    SingleElementSymbol newCol = (SingleElementSymbol)iter.next();
                    newIndexes[i] = oldCols.indexOf(newCol);
                    newShortNames.add(newCol.getShortName());
                    ++i;
                }
                for (PlanNode projectNode = RuleAssignOutputElements.findFirstProject(siblingNode); projectNode != siblingNode; projectNode = projectNode.getParent()) {
                    this.filterListWithIndexes(projectNode, NodeConstants.Info.OUTPUT_COLS, newIndexes);
                    this.filterListWithIndexes(projectNode, NodeConstants.Info.PROJECT_COLS, newIndexes);
                    this.filterListWithNames(projectNode, NodeConstants.Info.TOP_COLS, newShortNames);
                }
                Map symbolMap = (Map)siblingNode.getProperty(NodeConstants.Info.SYMBOL_MAP);
                iter = new HashSet(symbolMap.keySet()).iterator();
                while (iter.hasNext()) {
                    Object symbol = iter.next();
                    if (newCols.contains(symbol)) continue;
                    symbolMap.remove(symbol);
                }
            }
            siblingNode.setProperty(NodeConstants.Info.OUTPUT_COLS, newCols);
            node.removeChild(optionalNode);
            NodeEditor.removeChildNode(parentNode, node);
            siblingNode.setProperty(NodeConstants.Info.IS_OPTIONAL, node.getProperty(NodeConstants.Info.IS_OPTIONAL));
            siblingNode.removeProperty(NodeConstants.Info.DEPENDENT_JOIN_DATA);
            parentNode.getGroups().removeAll(optionalNode.getGroups());
            if (newCols.size() < oldCols.size()) {
                OutputColumnsChangeFlag.access$002((OutputColumnsChangeFlag)flag, (boolean)true);
            }
        }
        return shouldRemoveNode;
    }

    private void filterListWithNames(PlanNode node, Integer nodeProperty, List newShortNames) {
        List list = (List)node.getProperty(nodeProperty);
        if (list == null) {
            return;
        }
        ArrayList<SingleElementSymbol> filteredList = new ArrayList<SingleElementSymbol>(newShortNames.size());
        Iterator iter = newShortNames.iterator();
        block0: while (iter.hasNext()) {
            String name = (String)iter.next();
            Iterator iter2 = list.iterator();
            while (iter2.hasNext()) {
                SingleElementSymbol symbol = (SingleElementSymbol)iter2.next();
                if (!name.equalsIgnoreCase(symbol.getShortName())) continue;
                filteredList.add(symbol);
                continue block0;
            }
        }
        node.setProperty(nodeProperty, filteredList);
    }

    private void filterListWithIndexes(PlanNode node, Integer nodeProperty, int[] newIndexes) {
        List list = (List)node.getProperty(nodeProperty);
        if (list == null) {
            return;
        }
        ArrayList filteredList = new ArrayList(newIndexes.length);
        for (int i = 0; i < newIndexes.length; ++i) {
            filteredList.add(list.get(newIndexes[i]));
        }
        node.setProperty(nodeProperty, filteredList);
    }

    public String toString() {
        return "RuleRemoveOptionalJoins";
    }
}

