/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.core.util.Assertion;
import com.metamatrix.query.function.FunctionDescriptor;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.FrameUtil;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.From;
import com.metamatrix.query.sql.lang.FromClause;
import com.metamatrix.query.sql.lang.IsNullCriteria;
import com.metamatrix.query.sql.lang.JoinPredicate;
import com.metamatrix.query.sql.lang.JoinType;
import com.metamatrix.query.sql.navigator.DeepPreOrderNavigator;
import com.metamatrix.query.sql.symbol.Function;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.visitor.GroupCollectorVisitor;
import com.metamatrix.query.sql.visitor.GroupsUsedByElementsVisitor;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.Set;

public class JoinUtil {
    private JoinUtil() {
    }

    static boolean doesJoinPreventCriteriaOptimization(PlanNode joinNode, PlanNode critNode) {
        return JoinUtil.getJoinTypePreventingCriteriaOptimization(joinNode, critNode) != null;
    }

    static final JoinType optimizeJoinType(PlanNode critNode, PlanNode joinNode) {
        Criteria crit;
        if (critNode.getGroups().isEmpty() || !joinNode.getGroups().containsAll(critNode.getGroups()) || critNode.hasCollectionProperty(NodeConstants.Info.CORRELATED_REFERENCES)) {
            return null;
        }
        JoinType joinType = (JoinType)joinNode.getProperty(NodeConstants.Info.JOIN_TYPE);
        if (joinType == null || !joinType.isOuter()) {
            return null;
        }
        Set innerGroups = null;
        if (joinType == JoinType.JOIN_LEFT_OUTER || joinType == JoinType.JOIN_RIGHT_OUTER) {
            PlanNode root = JoinUtil.getInnerSideJoinNodes(joinNode)[0];
            innerGroups = FrameUtil.findJoinSourceNode(root, root.getGroups()).getGroups();
        }
        if (NullDependentVisitor.isNullDependent(crit = (Criteria)critNode.getProperty(NodeConstants.Info.SELECT_CRITERIA), innerGroups)) {
            return null;
        }
        PlanNode left = joinNode.getFirstChild();
        left = FrameUtil.findJoinSourceNode(left, left.getGroups());
        PlanNode right = joinNode.getLastChild();
        right = FrameUtil.findJoinSourceNode(right, right.getGroups());
        if (left == null || right == null) {
            return null;
        }
        JoinType result = JoinType.JOIN_INNER;
        if (joinType == JoinType.JOIN_LEFT_OUTER) {
            if (left.getGroups().containsAll(critNode.getGroups())) {
                return null;
            }
        } else if (joinType == JoinType.JOIN_RIGHT_OUTER) {
            if (right.getGroups().containsAll(critNode.getGroups())) {
                return null;
            }
        } else if (left.getGroups().containsAll(critNode.getGroups())) {
            result = JoinType.JOIN_LEFT_OUTER;
        } else if (right.getGroups().containsAll(critNode.getGroups())) {
            JoinUtil.swapJoinChildren(joinNode);
            result = JoinType.JOIN_LEFT_OUTER;
        }
        joinNode.setProperty(NodeConstants.Info.JOIN_TYPE, result);
        return result;
    }

    static JoinType getJoinTypePreventingCriteriaOptimization(PlanNode joinNode, PlanNode critNode) {
        Set groups = critNode.getGroups();
        if (groups.size() == 0) {
            if ((critNode = FrameUtil.findOriginatingNode(critNode, groups)) == null) {
                return null;
            }
            groups = critNode.getGroups();
        }
        if (joinNode.getProperty(NodeConstants.Info.JOIN_TYPE) != null) {
            return JoinUtil.getJoinTypePreventingOptimization(joinNode, (Collection)groups);
        }
        From from = (From)joinNode.getProperty(NodeConstants.Info.FROM_CLAUSE);
        return JoinUtil.getJoinTypePreventingOptimization(from, (Collection)groups);
    }

    private static JoinType getJoinTypePreventingOptimization(PlanNode joinNode, Collection groups) {
        Iterator groupIter = groups.iterator();
        JoinType joinType = (JoinType)joinNode.getProperty(NodeConstants.Info.JOIN_TYPE);
        if (!joinType.isOuter()) {
            return null;
        }
        if (joinType.equals((Object)JoinType.JOIN_FULL_OUTER)) {
            return joinType;
        }
        Set innerGroups = JoinUtil.getInnerSideJoinNodes(joinNode)[0].getGroups();
        while (groupIter.hasNext()) {
            GroupSymbol group = (GroupSymbol)groupIter.next();
            if (!innerGroups.contains(group)) continue;
            return joinType;
        }
        return null;
    }

    private static JoinType getJoinTypePreventingOptimization(From from, Collection groups) {
        Iterator clauses = from.getClauses().iterator();
        while (clauses.hasNext()) {
            Iterator groupIter = groups.iterator();
            FromClause clause = (FromClause)clauses.next();
            while (groupIter.hasNext()) {
                GroupSymbol groupSymbol = (GroupSymbol)groupIter.next();
                JoinPredicate result = JoinUtil.getJoinPredicatePreventingOptimization(clause, groupSymbol);
                if (result == null) continue;
                return result.getJoinType();
            }
        }
        return null;
    }

    private static JoinPredicate getJoinPredicatePreventingOptimization(FromClause clause, GroupSymbol groupSymbol) {
        if (clause instanceof JoinPredicate) {
            JoinPredicate result;
            JoinPredicate predicate = (JoinPredicate)clause;
            JoinType jtype = predicate.getJoinType();
            if (jtype.isOuter()) {
                if (jtype.equals((Object)JoinType.JOIN_LEFT_OUTER)) {
                    if (GroupCollectorVisitor.getGroups((LanguageObject)predicate.getRightClause(), (boolean)true).contains(groupSymbol)) {
                        return predicate;
                    }
                } else if (jtype.equals((Object)JoinType.JOIN_RIGHT_OUTER)) {
                    if (GroupCollectorVisitor.getGroups((LanguageObject)predicate.getLeftClause(), (boolean)true).contains(groupSymbol)) {
                        return predicate;
                    }
                } else {
                    return predicate;
                }
            }
            if ((result = JoinUtil.getJoinPredicatePreventingOptimization(predicate.getLeftClause(), groupSymbol)) != null) {
                return result;
            }
            result = JoinUtil.getJoinPredicatePreventingOptimization(predicate.getRightClause(), groupSymbol);
            if (result != null) {
                return result;
            }
        }
        return null;
    }

    static PlanNode[] getInnerSideJoinNodes(PlanNode joinNode) {
        Assertion.assertTrue((joinNode.getType() == 7 ? 1 : 0) != 0);
        JoinType jt = (JoinType)joinNode.getProperty(NodeConstants.Info.JOIN_TYPE);
        if (jt == JoinType.JOIN_INNER || jt == JoinType.JOIN_CROSS) {
            return new PlanNode[]{joinNode.getFirstChild(), joinNode.getLastChild()};
        }
        if (jt == JoinType.JOIN_RIGHT_OUTER) {
            return new PlanNode[]{joinNode.getFirstChild()};
        }
        if (jt == JoinType.JOIN_LEFT_OUTER) {
            return new PlanNode[]{joinNode.getLastChild()};
        }
        return new PlanNode[0];
    }

    static void swapJoinChildren(PlanNode joinNode) {
        PlanNode leftChild = joinNode.getFirstChild();
        joinNode.removeChild(leftChild);
        joinNode.addLastChild(leftChild);
        List leftExpressions = (List)joinNode.getProperty(NodeConstants.Info.LEFT_EXPRESSIONS);
        List rightExpressions = (List)joinNode.getProperty(NodeConstants.Info.RIGHT_EXPRESSIONS);
        joinNode.setProperty(NodeConstants.Info.LEFT_EXPRESSIONS, rightExpressions);
        joinNode.setProperty(NodeConstants.Info.RIGHT_EXPRESSIONS, leftExpressions);
        JoinType jt = (JoinType)joinNode.getProperty(NodeConstants.Info.JOIN_TYPE);
        joinNode.setProperty(NodeConstants.Info.JOIN_TYPE, jt.getReverseType());
    }

    public static class NullDependentVisitor
    extends LanguageVisitor {
        private boolean nullDependent = false;
        private Collection innerGroups;

        public NullDependentVisitor(Collection innerGroups) {
            this.innerGroups = innerGroups;
        }

        public void visit(IsNullCriteria obj) {
            this.checkInnerGroups((LanguageObject)obj);
        }

        public void visit(Function obj) {
            FunctionDescriptor descriptor = obj.getFunctionDescriptor();
            if (descriptor.isNullDependent()) {
                this.checkInnerGroups((LanguageObject)obj);
            }
        }

        private void checkInnerGroups(LanguageObject obj) {
            if (this.innerGroups != null) {
                Collection groups = GroupsUsedByElementsVisitor.getGroups((LanguageObject)obj);
                Iterator i = groups.iterator();
                while (i.hasNext()) {
                    if (!this.innerGroups.contains(i.next())) continue;
                    this.setNullDependent();
                    break;
                }
            } else {
                this.setNullDependent();
            }
        }

        private void setNullDependent() {
            this.nullDependent = true;
            this.setAbort(true);
        }

        public static boolean isNullDependent(Criteria crit, Collection innerGroups) {
            NullDependentVisitor visitor = new NullDependentVisitor(innerGroups);
            DeepPreOrderNavigator.doVisit((LanguageObject)crit, (LanguageVisitor)visitor);
            return visitor.nullDependent;
        }
    }
}

