/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.plantree;

import com.metamatrix.query.execution.QueryExecPlugin;

public final class NodeConstants {
    private NodeConstants() {
    }

    public static final String getNodeTypeString(int type) {
        switch (type) {
            case 3: {
                return "Access";
            }
            case 5: {
                return "DupRemoval";
            }
            case 7: {
                return "Join";
            }
            case 11: {
                return "Project";
            }
            case 13: {
                return "Select";
            }
            case 17: {
                return "Sort";
            }
            case 19: {
                return "Source";
            }
            case 23: {
                return "Group";
            }
            case 29: {
                return "SetOperation";
            }
            case 31: {
                return "Null";
            }
            case 37: {
                return "TupleOffset";
            }
            case 41: {
                return "TupleLimit";
            }
        }
        return "Unknown: " + type;
    }

    public static final int getNodeTypeInt(String type) {
        if (type.equals("Access")) {
            return 3;
        }
        if (type.equals("DupRemoval")) {
            return 5;
        }
        if (type.equals("Join")) {
            return 7;
        }
        if (type.equals("Project")) {
            return 11;
        }
        if (type.equals("Select")) {
            return 13;
        }
        if (type.equals("Sort")) {
            return 17;
        }
        if (type.equals("Source")) {
            return 19;
        }
        if (type.equals("Group")) {
            return 23;
        }
        if (type.equals("SetOperation")) {
            return 29;
        }
        if (type.equals("Null")) {
            return 31;
        }
        if (type.equals("TupleOffset")) {
            return 37;
        }
        if (type.equals("TupleLimit")) {
            return 41;
        }
        throw new IllegalArgumentException(QueryExecPlugin.Util.getString("ERR.015.004.0011", (Object)type));
    }

    public static final class Info {
        public static final Integer ATOMIC_REQUEST = new Integer(0);
        public static final Integer MODEL_ID = new Integer(1);
        public static final Integer ACCESS_PATTERNS = new Integer(2);
        public static final Integer ACCESS_PATTERN_USED = new Integer(3);
        public static final Integer DEPENDENT_JOIN_DATA = new Integer(4);
        public static final Integer EXPRESSIONS_CREATED = new Integer(5);
        public static final Integer INDEPENDENT_ELEMENT = new Integer(6);
        public static final Integer DEPENDENT_ELEMENT = new Integer(7);
        public static final Integer ALLOWS_NO_CRITERIA = new Integer(8);
        public static final Integer IS_STRONG = new Integer(9);
        public static final Integer SET_OPERATION = new Integer(10);
        public static final Integer USE_ALL = new Integer(11);
        public static final Integer FROM_CLAUSE = new Integer(20);
        public static final Integer JOIN_CRITERIA = new Integer(21);
        public static final Integer JOIN_TYPE = new Integer(22);
        public static final Integer INTERNAL_JOIN = new Integer(23);
        public static final Integer JOIN_STRATEGY = new Integer(28);
        public static final Integer IS_OPTIONAL = new Integer(220);
        public static final Integer IS_LEFT_OPTIONAL = new Integer(221);
        public static final Integer IS_RIGHT_OPTIONAL = new Integer(222);
        public static final Integer LEFT_EXPRESSIONS = new Integer(24);
        public static final Integer RIGHT_EXPRESSIONS = new Integer(25);
        public static final Integer SORT_IN_LEFT_ACCESS = new Integer(26);
        public static final Integer SORT_IN_RIGHT_ACCESS = new Integer(27);
        public static final Integer PROJECT_COLS = new Integer(30);
        public static final Integer INTO_GROUP = new Integer(32);
        public static final Integer ACCESS_RAISED = new Integer(33);
        public static final Integer SELECT_CRITERIA = new Integer(40);
        public static final Integer IS_HAVING = new Integer(41);
        public static final Integer IS_PHANTOM = new Integer(42);
        public static final Integer COPIED = new Integer(45);
        public static final Integer PUSHED = new Integer(46);
        public static final Integer DEPENDENT_VALUE_SOURCE = new Integer(47);
        public static final Integer DEPENDENT_SET_CRITS = new Integer(48);
        public static final Integer ORDER_TYPES = new Integer(50);
        public static final Integer SORT_ORDER = new Integer(51);
        public static final Integer SYMBOL_MAP = new Integer(60);
        public static final Integer VIRTUAL_COMMAND = new Integer(61);
        public static final Integer MAKE_DEP = new Integer(62);
        public static final Integer PROCESSOR_PLAN = new Integer(63);
        public static final Integer NESTED_COMMAND = new Integer(64);
        public static final Integer MAKE_NOT_DEP = new Integer(65);
        public static final Integer INLINE_VIEW = new Integer(66);
        public static final Integer GROUP_COLS = new Integer(80);
        public static final Integer AGGREGATES = new Integer(81);
        public static final Integer OUTPUT_COLS = new Integer(90);
        public static final Integer TOP_COLS = new Integer(91);
        public static final Integer SUBQUERY_PLANS = new Integer(101);
        public static final Integer SUBQUERY_VALUE_PROVIDERS = new Integer(102);
        public static final Integer CORRELATED_REFERENCES = new Integer(103);
        public static final Integer EST_CARDINALITY = new Integer(100);
        public static final Integer EST_SET_SIZE = new Integer(110);
        public static final Integer EST_DEP_CARDINALITY = new Integer(111);
        public static final Integer EST_DEP_JOIN_COST = new Integer(112);
        public static final Integer EST_JOIN_COST = new Integer(113);
        public static final Integer MAX_TUPLE_LIMIT = new Integer(120);
        public static final Integer OFFSET_TUPLE_COUNT = new Integer(121);

        private Info() {
        }
    }

    public static final class Types {
        public static final int NO_TYPE = 2;
        public static final int ACCESS = 3;
        public static final int DUP_REMOVE = 5;
        public static final int JOIN = 7;
        public static final int PROJECT = 11;
        public static final int SELECT = 13;
        public static final int SORT = 17;
        public static final int SOURCE = 19;
        public static final int GROUP = 23;
        public static final int SET_OP = 29;
        public static final int NULL = 31;
        public static final int TUPLE_OFFSET = 37;
        public static final int TUPLE_LIMIT = 41;

        private Types() {
        }
    }
}

