/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.CommandTreeNode;
import com.metamatrix.query.optimizer.CommandTreeProcessor;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.SubqueryFromClause;
import com.metamatrix.query.sql.proc.Block;
import com.metamatrix.query.sql.proc.CommandStatement;
import com.metamatrix.query.sql.proc.CreateUpdateProcedureCommand;
import com.metamatrix.query.sql.proc.Statement;
import com.metamatrix.query.sql.visitor.SubqueryFromClauseCollectorVisitor;
import java.util.Iterator;
import java.util.List;

public class RemoveWrapperProcedureProcessor
implements CommandTreeProcessor {
    public CommandTreeNode process(CommandTreeNode node, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        return this.processRecursive(node, metadata);
    }

    private CommandTreeNode processRecursive(CommandTreeNode node, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        List children = node.getChildren();
        for (int i = 0; i < children.size(); ++i) {
            CommandTreeNode child = (CommandTreeNode)children.get(i);
            CommandTreeNode replacement = this.processRecursive(child, metadata);
            if (replacement == child) continue;
            children.set(i, replacement);
        }
        if (this.isSimpleProc(node)) {
            this.correctParentReferences(node);
            return node.getFirstChild().getFirstChild();
        }
        return node;
    }

    private void correctParentReferences(CommandTreeNode node) {
        CommandTreeNode parent = node.getParent();
        if (parent != null && parent.getCommandType() == 2) {
            PlanNode relNode = (PlanNode)parent.getCanonicalPlan();
            Command oldCommand = node.getCommand();
            Command newCommand = node.getFirstChild().getFirstChild().getCommand();
            List srcNodes = NodeEditor.findAllNodes(relNode, 19);
            Iterator iter = srcNodes.iterator();
            while (iter.hasNext()) {
                PlanNode srcNode = (PlanNode)iter.next();
                if (srcNode.getProperty(NodeConstants.Info.NESTED_COMMAND) != oldCommand) continue;
                srcNode.setProperty(NodeConstants.Info.NESTED_COMMAND, newCommand);
            }
        }
    }

    public boolean isSimpleProc(CommandTreeNode node) {
        return node.getChildCount() == 1 && this.isRelational(node) && (!this.embedded(node) || this.inlineView(node)) && this.isSingleCommandProc((PlanNode)node.getCanonicalPlan());
    }

    public boolean isRelational(CommandTreeNode node) {
        return node.getCommandType() == 2;
    }

    public boolean embedded(CommandTreeNode node) {
        return node.getCommand().isEmbedded();
    }

    public boolean inlineView(CommandTreeNode node) {
        CommandTreeNode parent = node.getParent();
        List clauses = SubqueryFromClauseCollectorVisitor.getClauses((LanguageObject)parent.getCommand());
        if (clauses.size() == 0) {
            return false;
        }
        Iterator iter = clauses.iterator();
        while (iter.hasNext()) {
            SubqueryFromClause clause = (SubqueryFromClause)iter.next();
            if (clause.getCommand() != node.getCommand()) continue;
            return true;
        }
        return false;
    }

    private boolean isSingleCommandProc(PlanNode node) {
        if (node.getType() != 11) {
            return false;
        }
        if (node.getChildCount() != 1) {
            return false;
        }
        PlanNode srcNode = node.getFirstChild();
        if (srcNode.getType() != 19) {
            return false;
        }
        Command virtualProcCommand = (Command)srcNode.getProperty(NodeConstants.Info.NESTED_COMMAND);
        if (!(virtualProcCommand instanceof CreateUpdateProcedureCommand)) {
            return false;
        }
        CreateUpdateProcedureCommand procCommand = (CreateUpdateProcedureCommand)virtualProcCommand;
        Block block = procCommand.getBlock();
        List statements = block.getStatements();
        if (statements.size() != 1) {
            return false;
        }
        Statement stmt = (Statement)statements.get(0);
        if (stmt instanceof CommandStatement) {
            return ((CommandStatement)stmt).getCommand().getType() != 10;
        }
        return false;
    }
}

