/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.metadata.TempMetadataAdapter;
import com.metamatrix.query.metadata.TempMetadataStore;
import com.metamatrix.query.optimizer.CommandTreeNode;
import com.metamatrix.query.optimizer.CommandTreeProcessor;
import com.metamatrix.query.optimizer.relational.PlanHints;
import com.metamatrix.query.optimizer.relational.RelationalCommandConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.lang.SubqueryContainer;
import com.metamatrix.query.sql.symbol.AggregateSymbol;
import com.metamatrix.query.sql.symbol.AliasSymbol;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.ExpressionSymbol;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.symbol.SingleElementSymbol;
import com.metamatrix.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Map;

public class MergeTreeNodeProcessor
implements CommandTreeProcessor {
    public CommandTreeNode process(CommandTreeNode node, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        MergeTreeNodeProcessor.processRecursive(node, metadata);
        return node;
    }

    private static void processRecursive(CommandTreeNode node, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        Iterator children = node.getChildren().iterator();
        while (children.hasNext()) {
            CommandTreeNode child = (CommandTreeNode)children.next();
            MergeTreeNodeProcessor.processRecursive(child, metadata);
        }
        QueryMetadataInterface fullMetadata = metadata;
        Map commandMetadata = node.getCommand().getTemporaryMetadata();
        if (commandMetadata != null && commandMetadata.size() > 0) {
            fullMetadata = new TempMetadataAdapter(metadata, new TempMetadataStore(commandMetadata));
        }
        ArrayList oldChildren = new ArrayList(node.getChildren());
        int childCount = oldChildren.size();
        for (int childIndex = 0; childIndex < childCount; ++childIndex) {
            CommandTreeNode child = (CommandTreeNode)oldChildren.get(childIndex);
            MergeTreeNodeProcessor.checkNode(node, child, childIndex, fullMetadata);
        }
    }

    private static void checkNode(CommandTreeNode parent, CommandTreeNode child, int childIndex, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        if (parent.getCommandType() == 2 && child.getCommandType() == 2) {
            Command childCommand = child.getCommand();
            Command parentCommand = parent.getCommand();
            Iterator i = ValueIteratorProviderCollectorVisitor.getValueIteratorProviders((LanguageObject)parentCommand).iterator();
            while (i.hasNext()) {
                SubqueryContainer crit = (SubqueryContainer)i.next();
                if (crit.getCommand() != childCommand) continue;
                return;
            }
            MergeTreeNodeProcessor.removeChildNode(parent, child);
            MergeTreeNodeProcessor.mergeRelationalPlans(parent, child, metadata);
            MergeTreeNodeProcessor.mergeTempMetadata(childCommand, parentCommand);
        }
    }

    private static void mergeTempMetadata(Command childCommand, Command parentCommand) {
        Map childTempMetadata = childCommand.getTemporaryMetadata();
        if (childTempMetadata != null && !childTempMetadata.isEmpty()) {
            Map parentTempMetadata = parentCommand.getTemporaryMetadata();
            if (parentTempMetadata == null) {
                parentCommand.setTemporaryMetadata(new HashMap(childTempMetadata));
            } else {
                parentTempMetadata.putAll(childTempMetadata);
            }
        }
    }

    private static void mergeRelationalPlans(CommandTreeNode parent, CommandTreeNode child, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        PlanNode parentPlan = (PlanNode)parent.getCanonicalPlan();
        Iterator sourceNodes = NodeEditor.findAllNodes(parentPlan, 19).iterator();
        while (sourceNodes.hasNext()) {
            GroupSymbol sourceGroup;
            Command command;
            PlanNode sourceNode = (PlanNode)sourceNodes.next();
            if (sourceNode.getChildCount() > 0 || (command = (Command)sourceNode.getProperty(NodeConstants.Info.NESTED_COMMAND)) == null || command.getType() == 7 || !metadata.isVirtualGroup((sourceGroup = (GroupSymbol)sourceNode.getGroups().iterator().next()).getMetadataID())) continue;
            PlanNode childPlan = (PlanNode)child.getCanonicalPlan();
            NodeEditor.attachFirst(sourceNode, childPlan);
            List projectCols = child.getCommand().getProjectedSymbols();
            sourceNode.setProperty(NodeConstants.Info.SYMBOL_MAP, MergeTreeNodeProcessor.createSymbolMap(sourceNode, childPlan, projectCols));
            MergeTreeNodeProcessor.combineHints(parent, child);
            break;
        }
    }

    private static void combineHints(CommandTreeNode parent, CommandTreeNode child) {
        PlanHints parentHints = (PlanHints)parent.getProperty(RelationalCommandConstants.HINTS);
        PlanHints childHints = (PlanHints)child.getProperty(RelationalCommandConstants.HINTS);
        if (childHints.hasCriteria) {
            parentHints.hasCriteria = true;
        }
        if (childHints.hasJoin) {
            parentHints.hasJoin = true;
        }
        if (childHints.hasSort) {
            parentHints.hasSort = true;
        }
        if (childHints.hasVirtualGroups) {
            parentHints.hasVirtualGroups = true;
        }
        if (childHints.isUpdate) {
            parentHints.isUpdate = true;
        }
        if (childHints.isUpdate) {
            parentHints.isUpdate = true;
        }
        if (childHints.hasUnion) {
            parentHints.hasUnion = true;
        }
        if (childHints.hasAggregates) {
            parentHints.hasAggregates = true;
        }
        if (childHints.makeDepGroups != null && childHints.makeDepGroups.size() > 0) {
            if (parentHints.makeDepGroups == null) {
                parentHints.makeDepGroups = childHints.makeDepGroups;
            } else {
                parentHints.makeDepGroups.addAll(childHints.makeDepGroups);
            }
        }
        if (childHints.makeNotDepGroups != null && childHints.makeNotDepGroups.size() > 0) {
            if (parentHints.makeNotDepGroups == null) {
                parentHints.makeNotDepGroups = childHints.makeNotDepGroups;
            } else {
                parentHints.makeNotDepGroups.addAll(childHints.makeNotDepGroups);
            }
        }
        if (childHints.hasOptionalNodes) {
            parentHints.hasOptionalNodes = true;
        }
        if (childHints.needsWhereAllValidation) {
            parentHints.needsWhereAllValidation = true;
        }
    }

    static final Map createSymbolMap(PlanNode sourceNode, PlanNode planTop, List projectCols) {
        Iterator groupIter = sourceNode.getGroups().iterator();
        GroupSymbol virtualGroup = (GroupSymbol)groupIter.next();
        String virtualGroupName = virtualGroup.getName();
        HashMap<ElementSymbol, Object> symbolMap = new HashMap<ElementSymbol, Object>();
        Iterator elementIter = projectCols.iterator();
        while (elementIter.hasNext()) {
            SingleElementSymbol symbol = (SingleElementSymbol)elementIter.next();
            String name = symbol.getName();
            int index = name.lastIndexOf(".");
            if (index >= 0) {
                name = name.substring(index + 1);
            }
            String virtualElementName = virtualGroupName + "." + name;
            ElementSymbol virtualElement = new ElementSymbol(virtualElementName);
            virtualElement.setGroupSymbol(virtualGroup);
            virtualElement.setType(symbol.getType());
            if (symbol instanceof AliasSymbol) {
                symbol = ((AliasSymbol)symbol).getSymbol();
            }
            if (symbol instanceof ExpressionSymbol && !(symbol instanceof AggregateSymbol)) {
                symbolMap.put(virtualElement, ((ExpressionSymbol)symbol).getExpression());
                continue;
            }
            symbolMap.put(virtualElement, symbol);
        }
        return symbolMap;
    }

    private static final void removeChildNode(CommandTreeNode parent, CommandTreeNode child) {
        Assertion.isNotNull((Object)parent);
        Assertion.isNotNull((Object)child);
        LinkedList newChildren = new LinkedList(parent.getChildren());
        List orphans = child.getChildren();
        ListIterator<CommandTreeNode> childIter = newChildren.listIterator();
        while (childIter.hasNext()) {
            CommandTreeNode possibleChild = (CommandTreeNode)childIter.next();
            if (possibleChild != child) continue;
            childIter.remove();
            child.setParent(null);
            Iterator orphanIter = orphans.iterator();
            while (orphanIter.hasNext()) {
                CommandTreeNode orphan = (CommandTreeNode)orphanIter.next();
                childIter.add(orphan);
            }
        }
        Iterator removeIter = new LinkedList(parent.getChildren()).iterator();
        while (removeIter.hasNext()) {
            CommandTreeNode removeNode = (CommandTreeNode)removeIter.next();
            parent.removeChild(removeNode);
        }
        parent.addChildren(newChildren);
        Iterator iter = newChildren.iterator();
        while (iter.hasNext()) {
            CommandTreeNode newChild = (CommandTreeNode)iter.next();
            newChild.setParent(parent);
        }
        removeIter = new LinkedList(child.getChildren()).iterator();
        while (removeIter.hasNext()) {
            child.removeChild((CommandTreeNode)removeIter.next());
        }
    }
}

