/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.function;

import com.metamatrix.core.util.Assertion;
import com.metamatrix.core.util.HashCodeUtil;
import com.metamatrix.query.function.FunctionDescriptor;
import java.io.Serializable;
import java.lang.reflect.Method;

class FunctionDescriptorImpl
implements FunctionDescriptor,
Serializable {
    private String name;
    private int pushdown;
    private Class[] types;
    private Class returnType;
    private int hash;
    private boolean requiresContext;
    private boolean nullDependent;
    private transient Method invocationMethod;

    FunctionDescriptorImpl(String name, int pushdown, Class[] types, Class returnType, Method invocationMethod, boolean requiresContext, boolean nullDependent) {
        Assertion.isNotNull((Object)name);
        Assertion.isNotNull((Object)types);
        Assertion.isNotNull((Object)returnType);
        this.name = name;
        this.pushdown = pushdown;
        this.types = types;
        this.returnType = returnType;
        this.invocationMethod = invocationMethod;
        this.requiresContext = requiresContext;
        this.nullDependent = nullDependent;
        this.hash = HashCodeUtil.hashCode((int)0, (Object)name);
        for (int i = 0; i < types.length; ++i) {
            this.hash = HashCodeUtil.hashCode((int)this.hash, (Object)types[i]);
        }
    }

    public String getName() {
        return this.name;
    }

    public int getPushdown() {
        return this.pushdown;
    }

    void setPushdown(int pushdown) {
        this.pushdown = pushdown;
    }

    public Class[] getTypes() {
        return this.types;
    }

    public Class getReturnType() {
        return this.returnType;
    }

    Method getInvocationMethod() {
        return this.invocationMethod;
    }

    public boolean requiresContext() {
        return this.requiresContext;
    }

    public int hashCode() {
        return this.hash;
    }

    public boolean equals(Object obj) {
        Class[] otherTypes;
        if (obj == this) {
            return true;
        }
        if (obj == null || !(obj instanceof FunctionDescriptor)) {
            return false;
        }
        FunctionDescriptor other = (FunctionDescriptor)obj;
        if (!this.getName().equals(other.getName())) {
            return false;
        }
        Class[] thisTypes = this.getTypes();
        if (thisTypes.length != (otherTypes = other.getTypes()).length) {
            return false;
        }
        for (int i = 0; i < thisTypes.length; ++i) {
            if (thisTypes[i].equals(otherTypes[i])) continue;
            return false;
        }
        return this.nullDependent == other.isNullDependent();
    }

    public String toString() {
        StringBuffer str = new StringBuffer(this.name);
        str.append("(");
        for (int i = 0; i < this.types.length; ++i) {
            if (this.types[i] != null) {
                str.append(this.types[i].getName());
            } else {
                str.append("null");
            }
            if (i >= this.types.length - 1) continue;
            str.append(", ");
        }
        str.append(") : ");
        if (this.returnType == null) {
            str.append("null");
        } else {
            str.append(this.returnType.getName());
        }
        return str.toString();
    }

    public boolean isNullDependent() {
        return this.nullDependent;
    }
}

