/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.modeler.core.refactor;

import com.metamatrix.core.util.StringUtil;
import com.metamatrix.metamodels.core.ModelType;
import com.metamatrix.metamodels.transformation.SqlTransformation;
import com.metamatrix.metamodels.transformation.SqlTransformationMappingRoot;
import com.metamatrix.metamodels.transformation.TransformationMappingRoot;
import com.metamatrix.modeler.core.ModelEditor;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.TransactionRunnable;
import com.metamatrix.modeler.core.container.Container;
import com.metamatrix.modeler.core.metamodel.aspect.AspectManager;
import com.metamatrix.modeler.core.metamodel.aspect.ImportsAspect;
import com.metamatrix.modeler.core.refactor.ModelResourceCollectorVisitor;
import com.metamatrix.modeler.core.refactor.OrganizeImportCommand;
import com.metamatrix.modeler.core.refactor.OrganizeImportHandler;
import com.metamatrix.modeler.core.refactor.RefactorCommand;
import com.metamatrix.modeler.core.refactor.ResourceRefactorCommand;
import com.metamatrix.modeler.core.refactor.ResourceStatusList;
import com.metamatrix.modeler.core.refactor.SqlStringConverter;
import com.metamatrix.modeler.core.workspace.ModelResource;
import com.metamatrix.modeler.core.workspace.ModelWorkspaceException;
import com.metamatrix.modeler.core.workspace.ResourceFilter;
import com.metamatrix.modeler.internal.core.index.IndexUtil;
import com.metamatrix.modeler.internal.core.resource.EmfResource;
import com.metamatrix.modeler.internal.core.workspace.ModelResourceFilter;
import com.metamatrix.modeler.internal.core.workspace.ModelResourceImpl;
import com.metamatrix.modeler.internal.core.workspace.ModelUtil;
import com.metamatrix.modeler.internal.core.workspace.WorkspaceResourceFinderUtil;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import org.eclipse.core.resources.IContainer;
import org.eclipse.core.resources.IFile;
import org.eclipse.core.resources.IResource;
import org.eclipse.core.resources.IResourceVisitor;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IProgressMonitor;
import org.eclipse.core.runtime.IStatus;
import org.eclipse.core.runtime.MultiStatus;
import org.eclipse.core.runtime.Status;
import org.eclipse.emf.common.notify.Notification;
import org.eclipse.emf.ecore.EObject;
import org.eclipse.emf.ecore.InternalEObject;
import org.eclipse.emf.ecore.impl.ENotificationImpl;
import org.eclipse.emf.ecore.resource.Resource;
import org.eclipse.xsd.XSDAnnotation;
import org.eclipse.xsd.XSDNamedComponent;
import org.eclipse.xsd.XSDSchema;
import org.eclipse.xsd.XSDSchemaDirective;
import org.eclipse.xsd.util.XSDResourceImpl;

public abstract class ResourceRefactorCommand
implements RefactorCommand {
    private static final ModelResourceFilter RESOURCE_FILTER = new ModelResourceFilter();
    public static final int ERROR_MISSING_RESOURCE = 1100;
    public static final int WARNING_REBUILD_IMPORTS = 1101;
    public static final int ERROR_REBUILD_IMPORTS = 1102;
    public static final int REBUILD_IMPORTS_COMPLETE = 1103;
    public static final int ERROR_BUILD_INDEXES = 1104;
    public static final int BUILD_INDEXES_COMPLETE = 1105;
    public static final int ERROR_RENAMING_VDB = 1106;
    private static final boolean UNDO_REQUEST = true;
    private static final boolean NOT_UNDO_REQUEST = false;
    public static final String PID = "com.metamatrix.modeler.core";
    protected static final IStatus[] EMPTY_ISTATUS = new IStatus[0];
    private String nameAfterRename;
    private String label;
    private IResource resource;
    private IResource modifiedResource;
    private Collection dependentResources;
    private Collection dependencies;
    private List problems = new ArrayList();
    private OrganizeImportHandler handler;

    public ResourceRefactorCommand(String label) {
        this.label = label;
        this.dependencies = Collections.EMPTY_LIST;
        this.dependentResources = Collections.EMPTY_LIST;
    }

    public void setResource(IResource resource) {
        this.resource = resource;
    }

    protected void setModifiedResource(IResource resource) {
        this.modifiedResource = resource;
    }

    protected IResource getResource() {
        return this.resource;
    }

    protected IResource getModifiedResource() {
        return this.modifiedResource;
    }

    public void setImportHandler(OrganizeImportHandler handler) {
        this.handler = handler;
    }

    public void setLabel(String label) {
        this.label = label;
    }

    public void setNewName(String name) {
        this.nameAfterRename = name;
    }

    public String getNewName() {
        return this.nameAfterRename;
    }

    public final IStatus canExecute() {
        if (this.resource == null) {
            String msg = ModelerCore.Util.getString("ResourceRefactorCommand.No_resource_has_been_selected");
            return new Status(4, PID, 1100, msg, null);
        }
        if (ModelUtil.isIResourceReadOnly((IResource)this.resource)) {
            String msg = ModelerCore.Util.getString("ResourceRefactorCommand.Selection_is_read_only");
            return new Status(4, PID, 1002, msg, null);
        }
        IStatus result = this.getCanExecuteStatus();
        if (result != null) {
            return result;
        }
        String msg = ModelerCore.Util.getString("ResourceRefactorCommand.Ready_to_execute");
        return new Status(0, PID, 1000, msg, null);
    }

    protected abstract IStatus getCanExecuteStatus();

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public final IStatus execute(IProgressMonitor monitor) {
        this.problems.clear();
        try {
            Status status;
            Status result;
            String msg = ModelerCore.Util.getString("ResourceRefactorCommand.Execution_complete");
            Status okayStatus = result = new Status(0, PID, 1001, msg, null);
            if (result != null && result.getSeverity() == 4) {
                Status status2 = result;
                return status2;
            }
            int severity = this.checkDependentResources(false);
            if (severity < 4) {
                result = this.modifyResource(this.getResource(), monitor);
                if (result == null || result.getSeverity() < 4) {
                    Map refactoredPaths = this.getMovedResourcePathMap(false);
                    result = this.refactorDependentResources(monitor, refactoredPaths);
                }
            } else {
                String msg2 = ModelerCore.Util.getString("ResourceRefactorCommand.Dependent_resource_error");
                Status status3 = new Status(severity, PID, 1002, msg2, null);
                return status3;
            }
            if (result.isOK()) {
                status = okayStatus;
                return status;
            }
            status = result;
            return status;
        }
        finally {
            if (monitor != null) {
                monitor.done();
            }
        }
    }

    protected abstract IStatus modifyResource(IResource var1, IProgressMonitor var2);

    protected int checkDependentResources(boolean isUndo) {
        Collection searchResults = this.dependentResources(isUndo);
        ResourceStatusList statusList = new ResourceStatusList(searchResults);
        this.dependentResources = statusList.getResourceList();
        searchResults = this.dependencyResources(isUndo);
        statusList = new ResourceStatusList(searchResults, 0);
        this.dependencies = statusList.getImportedResourceList();
        this.problems.addAll(statusList.getProblems());
        return statusList.getHighestSeverity();
    }

    private Collection dependentResources(boolean isUndo) {
        IResource res = this.resource;
        if (isUndo) {
            res = this.modifiedResource;
        }
        Collection dependentResource = ResourceRefactorCommand.dependentResources(res);
        return this.checkForDuplicate(dependentResource);
    }

    private static Collection dependentResources(IResource res) {
        List dependentResources = new ArrayList();
        try {
            if (res instanceof IContainer) {
                if (res.exists()) {
                    IContainer folder = (IContainer)res;
                    IResource[] resources = folder.members();
                    dependentResources = new LinkedList();
                    for (int idx = 0; idx < resources.length; ++idx) {
                        dependentResources.addAll(ResourceRefactorCommand.dependentResources(resources[idx]));
                    }
                }
            } else {
                WorkspaceResourceFinderUtil.getResourcesThatUseRecursive(res, (ResourceFilter)RESOURCE_FILTER, dependentResources);
            }
        }
        catch (CoreException ce) {
            ModelerCore.Util.log((Throwable)ce);
            dependentResources = Collections.EMPTY_LIST;
        }
        return dependentResources;
    }

    private Collection dependencyResources(boolean isUndo) {
        IResource res = this.resource;
        if (isUndo) {
            res = this.modifiedResource;
        }
        return ResourceRefactorCommand.dependencyResources(res);
    }

    private static Collection dependencyResources(IResource res) {
        LinkedList dependencyResource = Collections.EMPTY_LIST;
        try {
            if (res instanceof IContainer) {
                IContainer folder = (IContainer)res;
                IResource[] resources = folder.members();
                dependencyResource = new LinkedList();
                for (int idx = 0; idx < resources.length; ++idx) {
                    dependencyResource.addAll(ResourceRefactorCommand.dependencyResources(resources[idx]));
                }
            } else {
                dependencyResource = Arrays.asList(WorkspaceResourceFinderUtil.getDependentResources(res));
            }
        }
        catch (CoreException ce) {
            ModelerCore.Util.log((Throwable)ce);
            dependencyResource = Collections.EMPTY_LIST;
        }
        return dependencyResource;
    }

    private Collection checkForDuplicate(Collection dependentResource) {
        if (dependentResource.size() <= 1) {
            return dependentResource;
        }
        HashSet<IResource> uniqueSet = new HashSet<IResource>();
        Iterator iter = dependentResource.iterator();
        while (iter.hasNext()) {
            IResource nextResource = (IResource)iter.next();
            uniqueSet.add(nextResource);
        }
        return new ArrayList(uniqueSet);
    }

    protected Collection getModifiedDependentResources() {
        return ResourceRefactorCommand.dependentResources(this.getModifiedResource());
    }

    protected IStatus refactorDependentResources(IProgressMonitor monitor, Map refactoredPaths) {
        ArrayList<Status> errorList;
        block14: {
            errorList = new ArrayList<Status>();
            int severity = 0;
            ModelEditor editor = ModelerCore.getModelEditor();
            if (this.shouldRebuildImports()) {
                Iterator iter = this.dependentResources.iterator();
                while (iter.hasNext()) {
                    String msg;
                    IFile modelFile = (IFile)iter.next();
                    try {
                        ModelResource modelResource = editor.findModelResource(modelFile);
                        if (modelResource != null) {
                            if (modelResource.getResource() == null || !modelResource.getResource().exists() || modelResource.isReadOnly()) continue;
                            this.rebuildImports(modelResource, monitor, refactoredPaths);
                            this.regenerateUserSql(modelResource, monitor, refactoredPaths);
                            modelResource.save(null, false);
                            Resource resrc = modelResource.getEmfResource();
                            if (!(resrc instanceof EmfResource)) continue;
                            List xformations = ((EmfResource)resrc).getModelContents().getTransformations();
                            Iterator rootIter = xformations.iterator();
                            while (rootIter.hasNext()) {
                                TransformationMappingRoot root = (TransformationMappingRoot)rootIter.next();
                                ENotificationImpl notification = new ENotificationImpl((InternalEObject)root, 1, 9, refactoredPaths.keySet(), refactoredPaths.values());
                                root.eNotify((Notification)notification);
                            }
                            continue;
                        }
                        if (severity < 2) {
                            severity = 2;
                        }
                        msg = ModelerCore.Util.getString("ResourceRefactorCommand.Model_resource_not_in_ws", (Object)modelFile.getName());
                        errorList.add(new Status(2, PID, 1101, msg, null));
                    }
                    catch (ModelWorkspaceException e) {
                        severity = 4;
                        msg = ModelerCore.Util.getString("ResourceRefactorCommand.Exception_finding_model_resource", (Object)modelFile.getName());
                        errorList.add(new Status(4, PID, 1102, msg, (Throwable)e));
                    }
                }
            }
            this.validateDependentResources();
            HashMap<String, String> map = new HashMap<String, String>();
            Iterator iter = this.dependencies.iterator();
            while (iter.hasNext()) {
                IFile file = (IFile)iter.next();
                String path = file.getFullPath().toString();
                map.put(path, path);
            }
            if (!map.isEmpty()) {
                try {
                    Resource oldEmfResrc;
                    XSDSchema xsdSchema;
                    ModelResource model = this.resource instanceof IFile ? editor.findModelResource((IFile)this.resource) : null;
                    if (model == null || !model.isXsd() || (xsdSchema = ((XSDResourceImpl)(oldEmfResrc = model.getEmfResource())).getSchema()) == null) break block14;
                    Iterator oldIter = xsdSchema.getContents().iterator();
                    model = editor.findModelResource((IFile)this.modifiedResource);
                    Resource emfResrc = model.getEmfResource();
                    Iterator iter2 = ((XSDResourceImpl)emfResrc).getSchema().getContents().iterator();
                    while (oldIter.hasNext()) {
                        EObject oldEObj = (EObject)oldIter.next();
                        EObject eObj = (EObject)iter2.next();
                        if (oldEObj instanceof XSDAnnotation) continue;
                        if (!(oldEObj instanceof XSDNamedComponent)) {
                            Container cntr;
                            Resource refResource;
                            ImportsAspect importsAspect = AspectManager.getModelImportsAspect((EObject)oldEObj);
                            if (importsAspect == null || !(oldEObj instanceof XSDSchemaDirective) || (refResource = (cntr = ModelerCore.getContainer((Resource)emfResrc)).getResourceFinder().findByImport((XSDSchemaDirective)oldEObj, true)) == null) continue;
                            importsAspect.setModelLocation(eObj, refResource.getURI());
                            emfResrc.setModified(true);
                            continue;
                        }
                        break;
                    }
                }
                catch (ModelWorkspaceException err) {
                    severity = 4;
                    String msg = ModelerCore.Util.getString("ResourceRefactorCommand.Exception_finding_model_resource", (Object)this.resource.getName());
                    errorList.add(new Status(4, PID, 1102, msg, (Throwable)err));
                }
            }
        }
        String msg = ModelerCore.Util.getString("ResourceRefactorCommand.Execution_complete");
        MultiStatus multiStatus = new MultiStatus(PID, 1103, errorList.toArray(EMPTY_ISTATUS), msg, null);
        if (!multiStatus.isOK()) {
            msg = ModelerCore.Util.getString("ResourceRefactorCommand.Dependent_resource_error");
            multiStatus = new MultiStatus(PID, 1102, errorList.toArray(EMPTY_ISTATUS), msg, null);
        }
        return multiStatus;
    }

    protected void validateDependentResources() {
        if (!this.dependentResources.isEmpty()) {
            1 runnable = new /* Unavailable Anonymous Inner Class!! */;
            try {
                ModelerCore.getModelEditor().executeAsTransaction((TransactionRunnable)runnable, "Updating ModelIndexes", false, false, (Object)this);
            }
            catch (CoreException err) {
                ModelerCore.Util.log((Throwable)err);
            }
        }
    }

    protected IStatus rebuildImports(ModelResource modelResource, IProgressMonitor monitor, Map refactoredPaths) throws ModelWorkspaceException {
        OrganizeImportCommand importCommand = new OrganizeImportCommand();
        importCommand.setResource(modelResource.getEmfResource());
        importCommand.setRefactoredPaths(refactoredPaths);
        importCommand.setHandler(this.handler);
        IStatus status = importCommand.canExecute();
        if (status.isOK()) {
            status = importCommand.execute(monitor);
        }
        return status;
    }

    protected IStatus regenerateUserSql(ModelResource modelResource, IProgressMonitor monitor, Map refactoredPaths) throws ModelWorkspaceException {
        Resource r = modelResource.getEmfResource();
        if (r instanceof EmfResource && ((EmfResource)r).getModelType() == ModelType.VIRTUAL_LITERAL) {
            if (!r.isLoaded()) {
                Map options = r.getResourceSet() != null ? r.getResourceSet().getLoadOptions() : Collections.EMPTY_MAP;
                try {
                    r.load(options);
                }
                catch (IOException e) {
                    ModelerCore.Util.log(4, (Throwable)e, e.getLocalizedMessage());
                    return new Status(4, PID, 0, e.getLocalizedMessage(), (Throwable)e);
                }
            }
            List transformations = ((EmfResource)r).getModelContents().getTransformations();
            Iterator i = transformations.iterator();
            while (i.hasNext()) {
                EObject eObj = (EObject)i.next();
                if (!(eObj instanceof SqlTransformationMappingRoot)) continue;
                SqlTransformationMappingRoot mappingRoot = (SqlTransformationMappingRoot)eObj;
                SqlTransformation helper = (SqlTransformation)mappingRoot.getHelper();
                SqlTransformation nested = null;
                if (helper != null) {
                    Iterator j = helper.getNested().iterator();
                    while (j.hasNext()) {
                        eObj = (EObject)j.next();
                        if (!(eObj instanceof SqlTransformation)) continue;
                        nested = (SqlTransformation)eObj;
                    }
                }
                if (nested == null) continue;
                try {
                    ArrayList eResources = new ArrayList(ModelerCore.getModelContainer().getResources());
                    String uuidFormSql = helper.getSelectSql();
                    String convertedSql = null;
                    if (!StringUtil.isEmpty(uuidFormSql)) {
                        convertedSql = SqlStringConverter.convertUUIDsToFullNames((String)uuidFormSql, eResources);
                        nested.setSelectSql(convertedSql);
                    }
                    if (!StringUtil.isEmpty(uuidFormSql = helper.getInsertSql())) {
                        convertedSql = SqlStringConverter.convertUUIDsToFullNames((String)uuidFormSql, eResources);
                        nested.setInsertSql(convertedSql);
                    }
                    if (!StringUtil.isEmpty(uuidFormSql = helper.getUpdateSql())) {
                        convertedSql = SqlStringConverter.convertUUIDsToFullNames((String)uuidFormSql, eResources);
                        nested.setUpdateSql(convertedSql);
                    }
                    if (StringUtil.isEmpty(uuidFormSql = helper.getDeleteSql())) continue;
                    convertedSql = SqlStringConverter.convertUUIDsToFullNames((String)uuidFormSql, eResources);
                    nested.setDeleteSql(convertedSql);
                }
                catch (CoreException e) {
                    ModelerCore.Util.log(4, (Throwable)e, e.getLocalizedMessage());
                    return new Status(4, PID, 0, e.getLocalizedMessage(), (Throwable)e);
                }
            }
        }
        String msg = ModelerCore.Util.getString("ResourceRefactorCommand.user_sql_string_regenerated_successfully");
        return new Status(0, PID, 0, msg, null);
    }

    public boolean canUndo() {
        return !this.anyResourceReadOnly();
    }

    public boolean canRedo() {
        return !this.anyResourceReadOnly();
    }

    public Collection getResult() {
        return Collections.EMPTY_LIST;
    }

    public Collection getAffectedObjects() {
        return Collections.EMPTY_LIST;
    }

    public String getLabel() {
        return this.label;
    }

    public String getDescription() {
        return this.label;
    }

    public Collection getPostExecuteMessages() {
        return this.problems;
    }

    public final IStatus redo(IProgressMonitor monitor) {
        this.problems.clear();
        int severity = this.checkDependentResources(false);
        if (severity >= 4) {
            String msg2 = ModelerCore.Util.getString("ResourceRefactorCommand.Dependent_resource_error");
            return new Status(severity, PID, 1002, msg2, null);
        }
        this.redoResourceModification(monitor);
        Map refactoredPaths = this.getMovedResourcePathMap(false);
        return this.refactorDependentResources(monitor, refactoredPaths);
    }

    protected abstract IStatus redoResourceModification(IProgressMonitor var1);

    public final IStatus undo(IProgressMonitor monitor) {
        this.problems.clear();
        int severity = this.checkDependentResources(true);
        if (severity >= 4) {
            String msg2 = ModelerCore.Util.getString("ResourceRefactorCommand.Dependent_resource_error");
            return new Status(severity, PID, 1002, msg2, null);
        }
        this.undoResourceModification(monitor);
        Map refactoredPaths = this.getMovedResourcePathMap(true);
        return this.refactorDependentResources(monitor, refactoredPaths);
    }

    protected abstract IStatus undoResourceModification(IProgressMonitor var1);

    protected void addProblem(IStatus problem) {
        this.problems.add(problem);
    }

    protected void unloadModelResources(IResource resource) throws CoreException {
        ModelResourceCollectorVisitor visitor = new ModelResourceCollectorVisitor();
        resource.accept((IResourceVisitor)visitor);
        Iterator iter = visitor.getModelResources().iterator();
        while (iter.hasNext()) {
            ModelResource mResource = (ModelResource)iter.next();
            mResource.unload();
            mResource.close();
            if (!(mResource instanceof ModelResourceImpl)) continue;
            ((ModelResourceImpl)mResource).removeEmfResource();
        }
        iter = visitor.getResources().iterator();
        while (iter.hasNext()) {
            String searchIndexFileName;
            File searchIndexFile;
            IResource tmpResource = (IResource)iter.next();
            if (!ModelUtil.isModelFile((IResource)tmpResource) || tmpResource.getLocation() == null) continue;
            String runtimeIndexFileName = IndexUtil.getRuntimeIndexFileName((IResource)tmpResource);
            File runtimeIndexFile = new File(IndexUtil.INDEX_PATH, runtimeIndexFileName);
            if (!runtimeIndexFile.delete()) {
                runtimeIndexFile.deleteOnExit();
            }
            if ((searchIndexFile = new File(IndexUtil.INDEX_PATH, searchIndexFileName = IndexUtil.getSearchIndexFileName((IResource)tmpResource))).delete()) continue;
            searchIndexFile.deleteOnExit();
        }
    }

    protected IStatus buildIndexes(IProgressMonitor monitor, Collection iResources) {
        try {
            2 runnable = new /* Unavailable Anonymous Inner Class!! */;
            ModelerCore.getModelEditor().executeAsTransaction((TransactionRunnable)runnable, "Updating ModelIndexes", false, false, (Object)this);
        }
        catch (Exception e) {
            String msg = ModelerCore.Util.getString("ResourceRefactorCommand.Exception_building_indexes");
            return new Status(4, PID, 1102, msg, (Throwable)e);
        }
        String msg = ModelerCore.Util.getString("ResourceRefactorCommand.Building_indexes_complete");
        return new Status(0, PID, 1105, msg, null);
    }

    protected IStatus buildIndexes(IProgressMonitor monitor, IResource iResource) {
        ArrayList<IResource> iResources = new ArrayList<IResource>(1);
        iResources.add(iResource);
        return this.buildIndexes(monitor, iResources);
    }

    protected boolean anyResourceReadOnly() {
        return !this.getReadOnlyDependentResources().isEmpty();
    }

    public List getReadOnlyDependentResources() {
        IResource res = this.getModifiedResource();
        if (res == null) {
            res = this.getResource();
        }
        return ResourceRefactorCommand.getReadOnlyDependentResources(res);
    }

    protected static List getReadOnlyDependentResources(IResource res) {
        ArrayList<Object> rv = new ArrayList<Object>();
        ModelResource mr = null;
        try {
            mr = ModelUtil.getModel((Object)res);
        }
        catch (Exception err) {
            ModelerCore.Util.log(4, (Throwable)err, err.getMessage());
        }
        if (mr != null && mr.isReadOnly()) {
            rv.add(mr);
        }
        Iterator iter = ResourceRefactorCommand.dependentResources(res).iterator();
        while (iter.hasNext()) {
            IResource dres = (IResource)iter.next();
            try {
                mr = ModelUtil.getModel((Object)dres);
                if (mr == null || !mr.isReadOnly()) continue;
                rv.add(dres);
            }
            catch (ModelWorkspaceException err) {
                ModelerCore.Util.log(4, (Throwable)err, err.getMessage());
            }
        }
        return rv;
    }

    protected abstract Map getMovedResourcePathMap(boolean var1);

    protected boolean shouldRebuildImports() {
        return true;
    }

    public Collection getDependentResources() {
        return this.dependentResources;
    }

    static /* synthetic */ Collection access$000(ResourceRefactorCommand x0) {
        return x0.dependentResources;
    }
}

