/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.installer.transformation.etl.jdbc.apiimpl;

import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.common.config.JDBCConnectionPoolHelper;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationID;
import com.metamatrix.common.config.api.ResourceDescriptor;
import com.metamatrix.installer.log.LogWriter;
import java.sql.Connection;
import java.sql.DatabaseMetaData;
import java.sql.SQLException;
import java.util.HashMap;
import java.util.Map;
import java.util.Properties;

public class JDBCConnectionMgr {
    private static JDBCConnectionMgr mgr = null;
    private static Map descriptors = new HashMap();

    private JDBCConnectionMgr() {
    }

    public static final Connection getConnection(Properties connectionProperties, String userName, LogWriter logwriter) throws MetaMatrixException {
        Connection conn = JDBCConnectionMgr.getInstance().createConnection(connectionProperties, userName, logwriter);
        return conn;
    }

    protected static synchronized JDBCConnectionMgr getInstance() {
        if (mgr == null) {
            mgr = new JDBCConnectionMgr();
        }
        return mgr;
    }

    private Connection createConnection(Properties connProps, String userName, LogWriter logwriter) throws MetaMatrixException {
        Connection con;
        block7: {
            String key = this.getKey(connProps);
            con = null;
            try {
                boolean createConnection = false;
                ResourceDescriptor rd = null;
                if (descriptors.containsKey(key)) {
                    rd = (ResourceDescriptor)descriptors.get(key);
                } else {
                    createConnection = true;
                    connProps.setProperty("pooling.resource.extend.maximum.pool.size.mode", "true");
                    connProps.setProperty("pooling.resource.extend.maximum.pool.size.percent", "5.00");
                    connProps.setProperty("metamatrix.common.pooling.resource.name", key);
                    rd = JDBCConnectionPoolHelper.createDescriptor((ConfigurationID)Configuration.NEXT_STARTUP_ID, (String)key, (Properties)connProps);
                    descriptors.put(key, rd);
                }
                con = JDBCConnectionPoolHelper.getConnection((ResourceDescriptor)rd, (String)userName);
                if (con == null || con.isClosed()) {
                    throw new MetaMatrixException("Problem creating connection for " + userName);
                }
                if (!createConnection) break block7;
                try {
                    DatabaseMetaData metadata = con.getMetaData();
                    logwriter.logInfo("\n***** CONNECTION INFO *******");
                    logwriter.logInfo("url " + metadata.getURL());
                    logwriter.logInfo("driver " + metadata.getDriverName());
                    logwriter.logInfo("user " + metadata.getUserName());
                    logwriter.logInfo("****************************************\n");
                }
                catch (SQLException sqle) {
                    logwriter.logError("Unable to obtain the database metadata for " + key);
                    throw new MetaMatrixException((Throwable)sqle, "Unable to obtain the database metadata for " + key);
                }
            }
            catch (SQLException sqle) {
                throw new MetaMatrixException((Throwable)sqle, "Unable to connect to " + key);
            }
        }
        return con;
    }

    private String getKey(Properties props) {
        String db = props.getProperty("metamatrix.common.pooling.jdbc.Database");
        String protocol = props.getProperty("metamatrix.common.pooling.jdbc.Protocol");
        String url = null;
        url = db.startsWith("jdbc") ? db : "jdbc:" + (protocol == null ? "" : protocol) + ":" + db;
        String username = props.getProperty("metamatrix.common.pooling.jdbc.User");
        String key = url + " - " + username;
        return key;
    }
}

