/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.installer.transformation.etl.apiimpl;

import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.installer.log.LogWriter;
import com.metamatrix.installer.transformation.api.TargetObject;
import com.metamatrix.installer.transformation.apiimpl.BasicTask;
import com.metamatrix.installer.transformation.etl.api.Destination;
import com.metamatrix.installer.transformation.etl.api.ETLAction;
import com.metamatrix.installer.transformation.etl.api.Source;
import com.metamatrix.installer.transformation.etl.jdbc.api.Connector;
import java.util.Properties;

public abstract class TransformBaseTask
extends BasicTask {
    public static final String IS_DBTYPE = "is.dbtype";
    private static final String ORACLE = "oracle";
    private static final String DB2 = "db2";
    private static final String MSSQL = "mssql";
    private static final String SYBASE = "sybase";
    private Connector sourceConn;
    private Connector destConn;
    private Source s;
    private Destination d;

    public void init(String name, Properties props, LogWriter logwriter) throws MetaMatrixException {
        super.init(name, props, logwriter);
    }

    protected void validateTarget(TargetObject target) throws MetaMatrixException {
        super.validateTarget(target);
        if (!(target instanceof ETLAction)) {
            throw new MetaMatrixException("TransformBaseTask: Target " + target + " object is not instance of ETLAction");
        }
        ETLAction a = (ETLAction)target;
        this.s = a.getSource();
        this.d = a.getDestination();
        if (this.s != null && this.getSourceConnector() != null) {
            this.getSourceConnector().setTargetObject((TargetObject)this.s);
            this.getSourceConnector().setup(this.s.getConnectionProperties());
        }
        if (this.d != null && this.getTargetConnector() != null) {
            this.getTargetConnector().setTargetObject((TargetObject)this.d);
            this.getTargetConnector().setup(this.d.getConnectionProperties());
        }
    }

    protected String okToPerform() {
        String result = super.okToPerform();
        if (result != null) {
            return result;
        }
        Properties props = this.getProperties();
        String dbtype = props.getProperty(IS_DBTYPE);
        if (dbtype != null && dbtype.length() > 0) {
            if (this.destConn != null) {
                if (dbtype.equalsIgnoreCase(ORACLE) && (this.destConn.isOracle8i() || this.destConn.isOracle9i())) {
                    return null;
                }
                if (dbtype.equalsIgnoreCase(DB2) && this.destConn.isDB2()) {
                    return null;
                }
                if (dbtype.equalsIgnoreCase(MSSQL) && this.destConn.isMSSQL()) {
                    return null;
                }
                if (dbtype.equalsIgnoreCase(SYBASE) && this.destConn.getPlatform().isSybase()) {
                    return null;
                }
                return "Database type " + dbtype + " is not the current target";
            }
            return "Database type cannot be established as " + dbtype;
        }
        return null;
    }

    public Source getSource() {
        return this.s;
    }

    public Destination getDestination() {
        return this.d;
    }

    public Connector getSourceConnector() {
        return this.sourceConn;
    }

    public void setSourceConnector(Connector sourceConn) {
        if (sourceConn == null) {
            this.logInfo("Task " + this.getName() + " will have no source connector");
        }
        this.sourceConn = sourceConn;
    }

    public Connector getTargetConnector() {
        return this.destConn;
    }

    public void setTargetConnector(Connector destConn) {
        if (destConn == null) {
            this.logInfo("Task " + this.getName() + " will have no destination connector");
        }
        this.destConn = destConn;
    }

    public void reset() throws MetaMatrixException {
        super.reset();
        if (this.sourceConn != null) {
            this.sourceConn.reset();
        }
        if (this.destConn != null) {
            this.destConn.reset();
        }
    }

    public void cleanup() throws MetaMatrixException {
        this.logInfo("Performing Task " + this.getName() + " cleanup...");
        super.cleanup();
        try {
            if (this.sourceConn != null) {
                this.sourceConn.cleanup();
            }
        }
        catch (Exception e) {
            // empty catch block
        }
        try {
            if (this.destConn != null) {
                this.destConn.cleanup();
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.sourceConn = null;
        this.destConn = null;
    }

    protected void performRead() throws MetaMatrixException {
        this.getSourceConnector().read();
    }
}

