/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.data.pool;

import EDU.oswego.cs.dl.util.concurrent.FIFOSemaphore;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.data.DataPlugin;
import com.metamatrix.data.api.SecurityContext;
import com.metamatrix.data.exception.ConnectorException;
import com.metamatrix.data.monitor.AliveStatus;
import com.metamatrix.data.monitor.ConnectionStatus;
import com.metamatrix.data.pool.ConnectionPoolException;
import com.metamatrix.data.pool.ConnectorIdentity;
import com.metamatrix.data.pool.SourceConnection;
import com.metamatrix.data.pool.SourceConnectionFactory;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.IdentityHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Properties;

public class ConnectionPool {
    public static final String MAX_CONNECTIONS = "com.metamatrix.data.pool.max_connections";
    public static final String MAX_CONNECTIONS_FOR_EACH_ID = "com.metamatrix.data.pool.max_connections_for_each_id";
    public static final String LIVE_AND_UNUSED_TIME = "com.metamatrix.data.pool.live_and_unused_time";
    public static final String WAIT_FOR_SOURCE_TIME = "com.metamatrix.data.pool.wait_for_source_time";
    public static final String CLEANING_INTERVAL = "com.metamatrix.data.pool.cleaning_interval";
    public static final String ENABLE_SHRINKING = "com.metamatrix.data.pool.enable_shrinking";
    private static final String CTX_CONNECTOR = "CONNECTOR";
    private int maxConnections = 5;
    private int maxConnectionsForEachID = 5;
    private int liveAndUnusedTime = 60;
    private int waitForSourceTime = 120000;
    private int cleaningInterval = 60;
    private boolean enableShrinking = true;
    private int testConnectInterval;
    private SourceConnectionFactory connectionFactory;
    private Map idConnections = new HashMap();
    private Map reverseIdConnections = new IdentityHashMap();
    private CleanUpThread cleaningThread;
    private Object lock = new Object();
    private FIFOSemaphore poolSemaphore;
    private volatile int totalConnectionCount;
    private volatile boolean shuttingDownPool;
    protected volatile boolean lastConnectionAttemptFailed = false;
    private volatile Exception lastConnectionAttemptException = null;
    private volatile Date lastConnectionAttemptDate = null;
    private volatile long lastTestConnectTime;

    public ConnectionPool(SourceConnectionFactory connectionFactory) {
        this.connectionFactory = connectionFactory;
        this.lastTestConnectTime = System.currentTimeMillis();
    }

    public void initialize(Properties poolProperties) throws ConnectionPoolException {
        ArgCheck.isNotNull((Object)poolProperties);
        String property = null;
        String value = null;
        try {
            property = MAX_CONNECTIONS;
            value = poolProperties.getProperty(property);
            if (value != null) {
                this.maxConnections = Integer.parseInt(value);
            }
            this.poolSemaphore = new FIFOSemaphore((long)this.maxConnections);
            property = MAX_CONNECTIONS_FOR_EACH_ID;
            value = poolProperties.getProperty(property);
            if (value != null) {
                this.maxConnectionsForEachID = Integer.parseInt(value);
            }
            if ((value = poolProperties.getProperty(property = LIVE_AND_UNUSED_TIME)) != null) {
                this.liveAndUnusedTime = Integer.parseInt(value);
            }
            if ((value = poolProperties.getProperty(property = WAIT_FOR_SOURCE_TIME)) != null) {
                this.waitForSourceTime = Integer.parseInt(value);
            }
            if ((value = poolProperties.getProperty(property = CLEANING_INTERVAL)) != null) {
                this.cleaningInterval = Integer.parseInt(value);
            }
            if (!this.shuttingDownPool) {
                this.cleaningThread = new CleanUpThread(this.cleaningInterval * 1000);
                this.cleaningThread.setDaemon(true);
                this.cleaningThread.start();
            }
            if ((value = poolProperties.getProperty(property = ENABLE_SHRINKING)) != null) {
                this.enableShrinking = Boolean.valueOf(value);
            }
            value = poolProperties.getProperty("SourceConnectionTestInterval", "600");
            this.testConnectInterval = Integer.parseInt(value) * 1000;
            LogManager.logInfo(CTX_CONNECTOR, DataPlugin.Util.getString("ConnectionPool.Connection_pool_created_1"));
        }
        catch (NumberFormatException nfe) {
            throw new ConnectionPoolException(DataPlugin.Util.getString("ConnectionPool.The_value__6", (Object)value, (Object)new Integer(MAX_CONNECTIONS)));
        }
    }

    private long timeRemaining(long startTime) {
        return startTime + (long)this.waitForSourceTime - System.currentTimeMillis();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public SourceConnection obtain(SecurityContext securityContext) throws ConnectionPoolException {
        ConnectionsForId connectionsForId;
        boolean success;
        boolean idLockHeld;
        boolean poolLockHeld;
        ConnectionsForId connLists;
        block26: {
            SourceConnection sourceConnection;
            block24: {
                block25: {
                    if (this.shuttingDownPool) {
                        throw new ConnectionPoolException(DataPlugin.Util.getString("ConnectionPool.No_connection_pool_available._8"));
                    }
                    long startTime = System.currentTimeMillis();
                    ConnectorIdentity id = null;
                    try {
                        id = this.connectionFactory.createIdentity(securityContext);
                    }
                    catch (ConnectorException e1) {
                        throw new ConnectionPoolException((Throwable)e1);
                    }
                    LogManager.logTrace(CTX_CONNECTOR, new Object[]{"Obtaining connection for id", id});
                    connLists = null;
                    Object object = this.lock;
                    synchronized (object) {
                        connLists = (ConnectionsForId)this.idConnections.get(id);
                        if (connLists == null) {
                            connLists = new ConnectionsForId();
                            if (this.maxConnectionsForEachID < this.maxConnections) {
                                connLists.idSemaphore = new FIFOSemaphore((long)this.maxConnectionsForEachID);
                            }
                            this.idConnections.put(id, connLists);
                        }
                    }
                    poolLockHeld = false;
                    idLockHeld = false;
                    success = false;
                    try {
                        try {
                            if (!poolLockHeld && !this.poolSemaphore.attempt(this.timeRemaining(startTime))) {
                                throw new ConnectionPoolException(DataPlugin.Util.getString("ConnectionPool.ExceededWait", (Object)id, (Object)new Integer(this.waitForSourceTime)));
                            }
                            poolLockHeld = true;
                            if (connLists.idSemaphore != null && !idLockHeld && !connLists.idSemaphore.attempt(this.timeRemaining(startTime))) {
                                throw new ConnectionPoolException(DataPlugin.Util.getString("ConnectionPool.ExceededConnections", (Object)id, (Object)new Integer(this.maxConnectionsForEachID)));
                            }
                            idLockHeld = true;
                            do {
                                ConnectionsForId connectionsForId2 = connLists;
                                synchronized (connectionsForId2) {
                                    if (connLists.unused.isEmpty()) {
                                        break;
                                    }
                                    ConnectionWrapper conn = (ConnectionWrapper)connLists.unused.removeFirst();
                                    if (conn.originalConnection.isAlive()) {
                                        LogManager.logTrace(CTX_CONNECTOR, new Object[]{"Existing connection leased for", id});
                                        connLists.used.addLast(conn.originalConnection);
                                        success = true;
                                        sourceConnection = conn.originalConnection;
                                        // MONITOREXIT @DISABLED, blocks:[2, 3, 23, 8, 13] lbl45 : MonitorExitStatement: MONITOREXIT : var9_10
                                        Object var15_16 = null;
                                        if (success) return sourceConnection;
                                        if (!idLockHeld || connLists.idSemaphore == null) break block24;
                                        break block25;
                                    }
                                    this.closeSourceConnection(conn.originalConnection, id);
                                }
                            } while (this.timeRemaining(startTime) > 0L);
                            SourceConnection connection = this.createConnection(id);
                            int idSize = 0;
                            connectionsForId = connLists;
                            synchronized (connectionsForId) {
                                connLists.used.addLast(connection);
                                idSize = connLists.used.size() + connLists.unused.size();
                            }
                            this.updateStateWithNewConnection(id, connection, idSize);
                            success = true;
                            connectionsForId = connection;
                            break block26;
                        }
                        catch (InterruptedException err) {
                            throw new ConnectionPoolException((Throwable)err);
                        }
                    }
                    catch (Throwable throwable) {
                        Object var15_18 = null;
                        if (success) throw throwable;
                        if (idLockHeld && connLists.idSemaphore != null) {
                            connLists.idSemaphore.release();
                        }
                        if (!poolLockHeld) throw throwable;
                        this.poolSemaphore.release();
                        throw throwable;
                    }
                }
                connLists.idSemaphore.release();
            }
            if (!poolLockHeld) return sourceConnection;
            this.poolSemaphore.release();
            return sourceConnection;
        }
        Object var15_17 = null;
        if (success) return connectionsForId;
        if (idLockHeld && connLists.idSemaphore != null) {
            connLists.idSemaphore.release();
        }
        if (!poolLockHeld) return connectionsForId;
        this.poolSemaphore.release();
        return connectionsForId;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateStateWithNewConnection(ConnectorIdentity id, SourceConnection connection, int idSize) {
        ArrayList ids = null;
        Object object = this.lock;
        synchronized (object) {
            this.reverseIdConnections.put(connection, id);
            ++this.totalConnectionCount;
            if (this.totalConnectionCount > this.maxConnections) {
                ids = new ArrayList(this.idConnections.values());
            }
            if (this.totalConnectionCount == this.maxConnections) {
                LogManager.logWarning(CTX_CONNECTOR, DataPlugin.Util.getString("ConnectionPool.Max_conn_reached"));
            } else if (idSize == this.maxConnectionsForEachID) {
                LogManager.logWarning(CTX_CONNECTOR, DataPlugin.Util.getString("ConnectionPool.Max_conn_per_id_reached"));
            }
        }
        if (ids != null) {
            Iterator i = ids.iterator();
            while (i.hasNext() && this.totalConnectionCount > this.maxConnections) {
                ConnectionsForId connsForId;
                ConnectionsForId connectionsForId = connsForId = (ConnectionsForId)i.next();
                synchronized (connectionsForId) {
                    if (connsForId.unused.isEmpty()) {
                        continue;
                    }
                    ConnectionWrapper conn = (ConnectionWrapper)connsForId.unused.removeFirst();
                    this.closeSourceConnection(conn.originalConnection, id);
                    break;
                }
            }
        }
    }

    private SourceConnection createConnection(ConnectorIdentity id) throws ConnectionPoolException {
        SourceConnection connection;
        try {
            connection = this.connectionFactory.createConnection(id);
            LogManager.logTrace(CTX_CONNECTOR, new Object[]{"Connection pool created a connection for", id});
        }
        catch (ConnectorException e) {
            this.lastConnectionAttemptFailed = true;
            this.lastConnectionAttemptException = e;
            this.lastConnectionAttemptDate = new Date();
            throw new ConnectionPoolException((Throwable)e);
        }
        this.lastConnectionAttemptFailed = false;
        return connection;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void release(SourceConnection connection, boolean forceClose) {
        ConnectionsForId connLists = null;
        ConnectorIdentity id = null;
        Object object = this.lock;
        synchronized (object) {
            id = (ConnectorIdentity)this.reverseIdConnections.get(connection);
            connLists = (ConnectionsForId)this.idConnections.get(id);
        }
        if (connLists == null) {
            return;
        }
        object = connLists;
        synchronized (object) {
            if (connLists.used.remove(connection)) {
                LogManager.logTrace(CTX_CONNECTOR, new Object[]{"ConnectionPool(release) connection released:", id});
                if (forceClose || this.shuttingDownPool) {
                    this.closeSourceConnection(connection, id);
                } else {
                    connLists.unused.addLast(new ConnectionWrapper(connection));
                }
                if (connLists.idSemaphore != null) {
                    connLists.idSemaphore.release();
                }
                this.poolSemaphore.release();
            }
        }
    }

    public void release(SourceConnection connection) {
        this.release(connection, false);
    }

    public void error(SourceConnection connection) {
        this.release(connection, true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ConnectionStatus getStatus() {
        LinkedList values = null;
        Object object = this.lock;
        synchronized (object) {
            values = new LinkedList(this.idConnections.values());
        }
        AliveStatus poolStatus = this.checkStatusOfUsedConnections(values);
        if (poolStatus.equals((Object)AliveStatus.UNKNOWN)) {
            poolStatus = this.checkStatusOfUnusedConnections(values);
        }
        if (poolStatus.equals((Object)AliveStatus.UNKNOWN)) {
            poolStatus = this.testGetConnection();
        }
        if (poolStatus.equals((Object)AliveStatus.UNKNOWN) && this.lastConnectionAttemptFailed) {
            poolStatus = AliveStatus.DEAD;
        }
        if (poolStatus.equals((Object)AliveStatus.DEAD) && !this.connectionFactory.isSingleIdentity()) {
            poolStatus = AliveStatus.UNKNOWN;
        }
        return new ConnectionStatus(poolStatus, this.getTotalConnectionCount(), this.lastConnectionAttemptException, this.lastConnectionAttemptDate);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AliveStatus checkStatusOfUsedConnections(Collection connectionInfos) {
        Iterator i = connectionInfos.iterator();
        while (i.hasNext()) {
            ConnectionsForId connLists;
            ConnectionsForId connectionsForId = connLists = (ConnectionsForId)i.next();
            synchronized (connectionsForId) {
                if (connLists.used.size() > 0) {
                    return AliveStatus.ALIVE;
                }
            }
        }
        return AliveStatus.UNKNOWN;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private AliveStatus checkStatusOfUnusedConnections(Collection connectionInfos) {
        Iterator i = connectionInfos.iterator();
        while (i.hasNext()) {
            ConnectionsForId connLists;
            ConnectionsForId connectionsForId = connLists = (ConnectionsForId)i.next();
            synchronized (connectionsForId) {
                Iterator unusedConnItr = connLists.unused.iterator();
                while (unusedConnItr.hasNext()) {
                    SourceConnection theConn = ((ConnectionWrapper)unusedConnItr.next()).originalConnection;
                    if (theConn.isAlive()) {
                        return AliveStatus.ALIVE;
                    }
                    if (!theConn.isFailed()) continue;
                    return AliveStatus.DEAD;
                }
            }
        }
        return AliveStatus.UNKNOWN;
    }

    private AliveStatus testGetConnection() {
        long time;
        if (this.connectionFactory.isSingleIdentity() && (time = System.currentTimeMillis()) - this.lastTestConnectTime > (long)this.testConnectInterval) {
            this.lastTestConnectTime = time;
            try {
                SourceConnection connection = this.obtain(null);
                boolean alive = connection.isAlive();
                this.release(connection);
                return alive ? AliveStatus.ALIVE : AliveStatus.DEAD;
            }
            catch (ConnectionPoolException e) {
                return AliveStatus.DEAD;
            }
        }
        return AliveStatus.UNKNOWN;
    }

    public void shutDown() {
        if (LogManager.isMessageToBeRecorded(CTX_CONNECTOR, 6)) {
            LogManager.logTrace(CTX_CONNECTOR, DataPlugin.Util.getString("ConnectionPool.Shut_down"));
        }
        this.shuttingDownPool = true;
        if (this.cleaningThread != null) {
            this.cleaningThread.stopCleanup();
            this.cleaningThread.interrupt();
        }
        this.cleanUp(true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void cleanUp(boolean forceClose) {
        HashMap values = null;
        Object object = this.lock;
        synchronized (object) {
            values = new HashMap(this.idConnections);
        }
        Iterator i = values.entrySet().iterator();
        while (i.hasNext()) {
            ConnectionsForId connLists;
            Map.Entry entry = i.next();
            ConnectionsForId connectionsForId = connLists = (ConnectionsForId)entry.getValue();
            synchronized (connectionsForId) {
                Iterator unusedIter = connLists.unused.iterator();
                while (unusedIter.hasNext()) {
                    ConnectionWrapper unusedConnection = (ConnectionWrapper)unusedIter.next();
                    if (!forceClose && (!this.enableShrinking || unusedConnection.getIdelTime() < this.liveAndUnusedTime) && unusedConnection.originalConnection.isAlive()) continue;
                    unusedIter.remove();
                    this.closeSourceConnection(unusedConnection.originalConnection, (ConnectorIdentity)entry.getKey());
                }
            }
        }
    }

    protected SourceConnectionFactory getConnectionFactory() {
        return this.connectionFactory;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void closeSourceConnection(SourceConnection connection, ConnectorIdentity id) {
        Object object = this.lock;
        synchronized (object) {
            --this.totalConnectionCount;
            this.reverseIdConnections.remove(connection);
        }
        try {
            connection.closeSource();
            if (LogManager.isMessageToBeRecorded(CTX_CONNECTOR, 6)) {
                LogManager.logTrace(CTX_CONNECTOR, DataPlugin.Util.getString("ConnectionPool.Removed_conn", (Object)id));
            }
        }
        catch (Exception e) {
            LogManager.logError(CTX_CONNECTOR, DataPlugin.Util.getString("ConnectionPool.Failed_close_a_connection__2", (Object)id));
        }
    }

    final List getUsedConnections(SourceConnection connection) {
        ConnectorIdentity id = (ConnectorIdentity)this.reverseIdConnections.get(connection);
        ConnectionsForId connLists = (ConnectionsForId)this.idConnections.get(id);
        return connLists.used;
    }

    final List getUnusedConnections(SourceConnection connection) {
        ConnectorIdentity id = (ConnectorIdentity)this.reverseIdConnections.get(connection);
        ConnectionsForId connLists = (ConnectionsForId)this.idConnections.get(id);
        if (connLists != null) {
            ArrayList<SourceConnection> result = new ArrayList<SourceConnection>();
            for (int i = 0; i < connLists.unused.size(); ++i) {
                result.add(((ConnectionWrapper)connLists.unused.get(i)).originalConnection);
            }
            return result;
        }
        return Collections.EMPTY_LIST;
    }

    int getTotalConnectionCount() {
        return this.totalConnectionCount;
    }

    class CleanUpThread
    extends Thread {
        private long sleepTime;
        private boolean continueChecks = true;

        CleanUpThread(long sleepTime) {
            super("CleanUpThread");
            this.sleepTime = sleepTime;
        }

        public void stopCleanup() {
            this.continueChecks = false;
        }

        public void run() {
            while (this.continueChecks) {
                try {
                    CleanUpThread.sleep(this.sleepTime);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
                ConnectionPool.this.cleanUp(false);
            }
        }
    }

    static class ConnectionWrapper {
        private SourceConnection originalConnection;
        private long timeReturnedToPool;

        ConnectionWrapper(SourceConnection originalConn) {
            this.originalConnection = originalConn;
            this.timeReturnedToPool = System.currentTimeMillis();
        }

        int getIdelTime() {
            return (int)(System.currentTimeMillis() - this.timeReturnedToPool) / 1000;
        }
    }

    protected static class Default {
        static final int DEFAULT_MAX_CONNECTION = 5;
        static final int DEFAULT_MAX_CONNECTIONS_FOR_EACH_ID = 5;
        static final int DEFAULT_LIVE_AND_UNUSED_TIME = 60;
        static final int DEFAULT_WAIT_FOR_SOURCE_TIME = 120000;
        static final int DEFAULT_CLEANING_INTERVAL = 60;
        static final boolean DEFAULT_ENABLE_SHRINKING = true;

        private Default() {
        }
    }

    private static class ConnectionsForId {
        LinkedList used = new LinkedList();
        LinkedList unused = new LinkedList();
        FIFOSemaphore idSemaphore;

        private ConnectionsForId() {
        }
    }
}

