/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.processor.xml;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.processor.xml.DocumentInProgress;
import com.metamatrix.query.processor.xml.ProcessorEnvironment;
import com.metamatrix.query.processor.xml.ProcessorInstruction;
import java.util.HashMap;
import java.util.Map;
import org.xml.sax.SAXException;

public class MoveDocInstruction
extends ProcessorInstruction {
    public static final int UP = 0;
    public static final int DOWN = 1;
    private int direction;

    public MoveDocInstruction(int direction) {
        this.direction = direction;
    }

    public void process(ProcessorEnvironment env) throws BlockedException, MetaMatrixComponentException {
        DocumentInProgress doc = env.getDocumentInProgress();
        switch (this.direction) {
            case 0: {
                LogManager.logTrace((String)"XML_PLAN", (String)"UP in document");
                try {
                    doc.moveToParent();
                    break;
                }
                catch (SAXException err) {
                    throw new MetaMatrixComponentException((Throwable)err, "Failed to move UP in document");
                }
            }
            case 1: {
                LogManager.logTrace((String)"XML_PLAN", (String)"LAST child in document");
                doc.moveToLastChild();
                break;
            }
            default: {
                Assertion.failed((String)QueryExecPlugin.Util.getString("ERR.015.006.0051", this.direction));
            }
        }
        env.incrementCurrentProgramCounter();
    }

    public String toString() {
        if (this.direction == 0) {
            return "UP";
        }
        return "LAST";
    }

    public Map getDescriptionProperties() {
        HashMap<String, String> props = new HashMap<String, String>();
        if (this.direction == 0) {
            props.put("type", "UP IN DOCUMENT");
        } else {
            props.put("type", "NEXT IN DOCUMENT");
        }
        return props;
    }
}

