/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.processor;

import com.metamatrix.api.exception.ComponentCommunicationException;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixException;
import com.metamatrix.common.buffer.BlockedException;
import com.metamatrix.common.buffer.BufferManager;
import com.metamatrix.common.buffer.TupleBatch;
import com.metamatrix.common.buffer.TupleSource;
import com.metamatrix.common.buffer.TupleSourceID;
import com.metamatrix.query.execution.QueryExecPlugin;
import com.metamatrix.query.processor.ProcessorDataManager;
import com.metamatrix.query.processor.ProcessorPlan;
import com.metamatrix.query.util.CommandContext;
import java.rmi.RemoteException;
import java.util.List;

public class QueryProcessor {
    private CommandContext context;
    private ProcessorDataManager dataMgr;
    private BufferManager bufferMgr;
    private ProcessorPlan processPlan;
    private boolean initialized = false;
    private MetaMatrixException dataError;
    private boolean requestCancelled = false;
    private static final int DEFAULT_WAIT = 50;
    private boolean processorClosed = false;

    public QueryProcessor(ProcessorPlan plan, CommandContext context, BufferManager bufferMgr, ProcessorDataManager dataMgr) {
        this.context = context;
        this.dataMgr = dataMgr;
        this.bufferMgr = bufferMgr;
        this.processPlan = plan;
        this.dataMgr.registerProcessor(context.getProcessorID(), this);
        this.processPlan.initialize(context, this.dataMgr, bufferMgr);
    }

    public Object getProcessID() {
        return this.context.getProcessorID();
    }

    public TupleSourceID getResultsID() {
        return this.context.getTupleSourceID();
    }

    public ProcessorPlan getProcessorPlan() {
        return this.processPlan;
    }

    private void initialize() throws MetaMatrixComponentException {
        if (!this.initialized) {
            this.processPlan.open();
            this.initialized = true;
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void process() throws MetaMatrixComponentException, MetaMatrixException {
        try {
            while (true) {
                try {
                    this.initialize();
                }
                catch (BlockedException be) {
                    try {
                        Thread.sleep(50L);
                        continue;
                    }
                    catch (InterruptedException err) {
                        continue;
                    }
                }
                break;
            }
        }
        catch (MetaMatrixComponentException e) {
            this.closeProcessing();
            throw e;
        }
        catch (MetaMatrixException e) {
            this.closeProcessing();
            throw e;
        }
        while (true) {
            this.checkState();
            try {
                TupleBatch batch = this.processPlan.nextBatch();
                this.flushBatch(batch);
                if (!batch.getTerminationFlag()) continue;
            }
            catch (BlockedException e) {
                try {
                    Thread.sleep(50L);
                }
                catch (InterruptedException interruptedException) {}
                continue;
            }
            break;
        }
        this.closeProcessing();
        this.checkState();
    }

    public void processNoTimeSlice() throws MetaMatrixComponentException, MetaMatrixException {
        try {
            TupleBatch batch;
            this.initialize();
            do {
                this.checkState();
                batch = this.processPlan.nextBatch();
                this.flushBatch(batch);
            } while (!batch.getTerminationFlag());
        }
        catch (BlockedException e) {
            throw e;
        }
        catch (MetaMatrixComponentException e) {
            this.closeProcessing();
            throw e;
        }
        catch (MetaMatrixException e) {
            this.closeProcessing();
            throw e;
        }
        this.closeProcessing();
        this.checkState();
    }

    public boolean process(long time, boolean clientNeedsBatch) throws BlockedException, MetaMatrixComponentException, MetaMatrixException {
        boolean done = false;
        try {
            this.initialize();
            long end = System.currentTimeMillis() + time;
            while (System.currentTimeMillis() < end) {
                this.checkState();
                TupleBatch batch = this.processPlan.nextBatch();
                this.flushBatch(batch);
                if (batch.getTerminationFlag()) {
                    done = true;
                } else if (!clientNeedsBatch || batch == null || batch.getRowCount() <= 0) continue;
                break;
            }
        }
        catch (BlockedException e) {
            throw e;
        }
        catch (MetaMatrixComponentException e) {
            this.closeProcessing();
            throw e;
        }
        catch (MetaMatrixException e) {
            this.closeProcessing();
            throw e;
        }
        this.checkState();
        if (done) {
            this.closeProcessing();
            this.checkState();
            return true;
        }
        return false;
    }

    private void flushBatch(TupleBatch batch) {
        if (batch != null && batch.getRowCount() > 0) {
            try {
                this.bufferMgr.addTupleBatch(this.context.getTupleSourceID(), batch);
            }
            catch (MetaMatrixException e) {
                this.errorOccurred(e);
            }
            catch (RemoteException e) {
                this.errorOccurred((MetaMatrixException)new ComponentCommunicationException((Throwable)e, "ERR.015.006.0004", QueryExecPlugin.Util.getString("ERR.015.006.0004")));
            }
        }
    }

    private void closeProcessor() {
        if (!this.processorClosed) {
            this.dataMgr.unregisterProcessor(this.context.getProcessorID());
            try {
                this.processPlan.close();
            }
            catch (MetaMatrixException e) {
                this.errorOccurred(e);
            }
            this.processorClosed = true;
        }
    }

    private void closeProcessing() {
        this.closeProcessor();
        if (this.bufferMgr != null) {
            try {
                this.bufferMgr.setStatus(this.context.getTupleSourceID(), 2);
            }
            catch (MetaMatrixException e) {
                this.errorOccurred(e);
            }
            catch (RemoteException e) {
                this.errorOccurred((MetaMatrixException)new ComponentCommunicationException((Throwable)e, "ERR.015.006.0004", QueryExecPlugin.Util.getString("ERR.015.006.0004")));
            }
        }
    }

    public void connectTupleSource(TupleSource source, int nodeID) {
        this.processPlan.connectTupleSource(source, nodeID);
    }

    public void errorOccurred(MetaMatrixException e) {
        this.dataError = e;
    }

    private void checkState() throws MetaMatrixException {
        if (this.requestCancelled) {
            this.dataError = new MetaMatrixComponentException(QueryExecPlugin.Util.getString("QueryProcessor.request_cancelled", this.getProcessID()));
        }
        if (this.dataError != null) {
            try {
                this.processPlan.close();
            }
            catch (MetaMatrixException metaMatrixException) {
                // empty catch block
            }
            throw this.dataError;
        }
    }

    public List getAndClearWarnings() {
        return this.processPlan.getAndClearWarnings();
    }

    public CommandContext getContext() {
        return this.context;
    }

    public void requestCancelled() {
        this.requestCancelled = true;
        this.closeProcessor();
    }
}

