/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryMetadataException;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.sql.lang.Command;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.util.CommandContext;
import java.util.Iterator;
import java.util.List;

public final class RuleRemoveUpdateSource
implements OptimizerRule {
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryMetadataException, MetaMatrixComponentException {
        List sourceNodes = NodeEditor.findAllNodes(plan, 19);
        Iterator iter = sourceNodes.iterator();
        while (iter.hasNext()) {
            PlanNode sourceNode = (PlanNode)iter.next();
            if (!this.requiresUpdateMap(sourceNode, metadata)) continue;
            NodeEditor.cutFirst(sourceNode);
        }
        return plan;
    }

    boolean requiresUpdateMap(PlanNode sourceNode, QueryMetadataInterface metadata) throws QueryMetadataException, MetaMatrixComponentException {
        int type;
        Command command;
        GroupSymbol group = (GroupSymbol)sourceNode.getGroups().iterator().next();
        return metadata.isVirtualGroup(group.getMetadataID()) && (command = (Command)sourceNode.getProperty((Object)NodeConstants.Info.ATOMIC_REQUEST)) != null && ((type = command.getType()) == 2 || type == 3 || type == 4);
    }

    public String toString() {
        return "RemoveUpdateSource";
    }
}

