/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.query.optimizer.relational.rules;

import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.query.QueryPlannerException;
import com.metamatrix.core.util.Assertion;
import com.metamatrix.query.analysis.AnalysisRecord;
import com.metamatrix.query.metadata.QueryMetadataInterface;
import com.metamatrix.query.optimizer.capabilities.CapabilitiesFinder;
import com.metamatrix.query.optimizer.relational.OptimizerRule;
import com.metamatrix.query.optimizer.relational.RuleStack;
import com.metamatrix.query.optimizer.relational.plantree.NodeConstants;
import com.metamatrix.query.optimizer.relational.plantree.NodeEditor;
import com.metamatrix.query.optimizer.relational.plantree.NodeFactory;
import com.metamatrix.query.optimizer.relational.plantree.PlanNode;
import com.metamatrix.query.optimizer.relational.rules.RuleConstants;
import com.metamatrix.query.sql.LanguageObject;
import com.metamatrix.query.sql.LanguageVisitor;
import com.metamatrix.query.sql.lang.CompareCriteria;
import com.metamatrix.query.sql.lang.Criteria;
import com.metamatrix.query.sql.lang.JoinType;
import com.metamatrix.query.sql.navigator.DeepSpParameterPreOrderNavigator;
import com.metamatrix.query.sql.symbol.ElementSymbol;
import com.metamatrix.query.sql.symbol.Expression;
import com.metamatrix.query.sql.symbol.GroupSymbol;
import com.metamatrix.query.sql.visitor.ElementCollectorVisitor;
import com.metamatrix.query.sql.visitor.StaticSymbolMappingVisitor;
import com.metamatrix.query.sql.visitor.ValueIteratorProviderCollectorVisitor;
import com.metamatrix.query.util.CommandContext;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Set;

public final class RuleCopyCriteria
implements OptimizerRule {
    public PlanNode execute(PlanNode plan, QueryMetadataInterface metadata, CapabilitiesFinder capFinder, RuleStack rules, AnalysisRecord analysisRecord, CommandContext context) throws QueryPlannerException, MetaMatrixComponentException {
        ArrayList critNodes = new ArrayList();
        this.findSingleGroupCriteria(plan, critNodes);
        if (critNodes.size() == 0) {
            return plan;
        }
        boolean madeChange = false;
        Iterator nodeIter = critNodes.iterator();
        while (nodeIter.hasNext()) {
            PlanNode critNode = (PlanNode)nodeIter.next();
            boolean changed = this.tryToCopy(critNode, metadata);
            if (!changed) continue;
            madeChange = true;
        }
        if (madeChange) {
            rules.push(RuleConstants.PUSH_SELECT_CRITERIA);
        }
        return plan;
    }

    void findSingleGroupCriteria(PlanNode root, List foundNodes) throws QueryPlannerException, MetaMatrixComponentException {
        if (root.getType() == 13 && root.getGroups().size() == 1) {
            Boolean isHaving = (Boolean)root.getProperty((Object)NodeConstants.Info.IS_HAVING);
            if (!(isHaving != null && !isHaving.equals(Boolean.FALSE) || this.hasBeenCopied(root) || this.hasSubquery(root))) {
                foundNodes.add(root);
            }
            root.setProperty((Object)NodeConstants.Info.COPIED, (Object)Boolean.TRUE);
        }
        if (root.getChildCount() > 0) {
            List children = root.getChildren();
            Iterator iter = children.iterator();
            while (iter.hasNext()) {
                PlanNode child = (PlanNode)iter.next();
                this.findSingleGroupCriteria(child, foundNodes);
            }
        }
    }

    boolean hasSubquery(PlanNode critNode) {
        Criteria crit = (Criteria)critNode.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
        Collection subCrits = ValueIteratorProviderCollectorVisitor.getValueIteratorProviders((LanguageObject)crit);
        return subCrits.size() > 0;
    }

    boolean hasBeenCopied(PlanNode critNode) {
        Boolean copied = (Boolean)critNode.getProperty((Object)NodeConstants.Info.COPIED);
        if (copied == null) {
            return false;
        }
        return copied;
    }

    boolean tryToCopy(PlanNode critNode, QueryMetadataInterface metadata) {
        Criteria crit = (Criteria)critNode.getProperty((Object)NodeConstants.Info.SELECT_CRITERIA);
        if (crit == null) {
            return false;
        }
        Set srcElements = (Set)ElementCollectorVisitor.getElements((LanguageObject)crit, (boolean)true);
        GroupSymbol srcGroup = (GroupSymbol)critNode.getGroups().iterator().next();
        ArrayList joinNodes = new ArrayList();
        ArrayList tgtMaps = new ArrayList();
        this.findJoinNodes(critNode.getParent(), srcElements, srcGroup, joinNodes, tgtMaps);
        if (joinNodes.size() > 0) {
            boolean changedTree = false;
            for (int i = 0; i < joinNodes.size(); ++i) {
                PlanNode newCritNode = NodeFactory.getNewNode((int)13);
                Criteria tgtCrit = (Criteria)crit.clone();
                Map tgtMap = (Map)tgtMaps.get(i);
                StaticSymbolMappingVisitor visitor = new StaticSymbolMappingVisitor(tgtMap);
                DeepSpParameterPreOrderNavigator.doVisit((LanguageObject)tgtCrit, (LanguageVisitor)visitor);
                newCritNode.setProperty((Object)NodeConstants.Info.SELECT_CRITERIA, (Object)tgtCrit);
                Collection elements = ElementCollectorVisitor.getElements((LanguageObject)tgtCrit, (boolean)true);
                Iterator elementIter = elements.iterator();
                while (elementIter.hasNext()) {
                    ElementSymbol element = (ElementSymbol)elementIter.next();
                    newCritNode.addGroup(element.getGroupSymbol());
                }
                PlanNode joinNode = (PlanNode)joinNodes.get(i);
                JoinType joinType = (JoinType)joinNode.getProperty((Object)NodeConstants.Info.JOIN_TYPE);
                if (RuleCopyCriteria.isInnerSideOfOuterJoin(joinType, joinNode, (GroupSymbol)newCritNode.getGroups().iterator().next()) || !this.placeCriteriaNode(joinNode, newCritNode)) continue;
                changedTree = true;
            }
            return changedTree;
        }
        return false;
    }

    private static boolean isInnerSideOfOuterJoin(JoinType joinType, PlanNode joinNode, GroupSymbol critGroup) {
        boolean isInner = false;
        if (joinType.equals((Object)JoinType.JOIN_LEFT_OUTER)) {
            Assertion.assertTrue((joinNode.getChildCount() == 2 ? 1 : 0) != 0, (String)"");
            PlanNode rightChild = joinNode.getLastChild();
            if (rightChild.getGroups().contains(critGroup)) {
                isInner = true;
            }
        } else if (joinType.equals((Object)JoinType.JOIN_RIGHT_OUTER)) {
            Assertion.assertTrue((joinNode.getChildCount() == 2 ? 1 : 0) != 0, (String)"");
            PlanNode leftChild = joinNode.getFirstChild();
            if (leftChild.getGroups().contains(critGroup)) {
                isInner = true;
            }
        }
        return isInner;
    }

    boolean placeCriteriaNode(PlanNode joinNode, PlanNode criteriaNode) {
        Set groups = criteriaNode.getGroups();
        if (groups.size() == 1) {
            GroupSymbol tgtGroup = (GroupSymbol)groups.iterator().next();
            Iterator childIter = joinNode.getChildren().iterator();
            while (childIter.hasNext()) {
                PlanNode childNode = (PlanNode)childIter.next();
                if (this.findSourceNode(childNode, tgtGroup) == null) continue;
                NodeEditor.insertNode(joinNode, childNode, criteriaNode);
                return true;
            }
            return false;
        }
        return false;
    }

    void findJoinNodes(PlanNode node, Set srcElements, GroupSymbol srcGroup, List joinNodes, List tgtMaps) {
        if (node == null) {
            return;
        }
        int nodeType = node.getType();
        if (nodeType == 7) {
            List joinCrits = (List)node.getProperty((Object)NodeConstants.Info.JOIN_CRITERIA);
            if (joinCrits != null && joinCrits.size() > 0) {
                HashMap<ElementSymbol, Expression> srcToTgt = null;
                boolean matchedAll = true;
                Iterator srcIter = srcElements.iterator();
                while (srcIter.hasNext()) {
                    ElementSymbol srcElement = (ElementSymbol)srcIter.next();
                    boolean matchedElement = false;
                    Iterator critIter = joinCrits.iterator();
                    while (critIter.hasNext()) {
                        CompareCriteria jcrit;
                        Criteria theCrit = (Criteria)critIter.next();
                        if (!(theCrit instanceof CompareCriteria) || (jcrit = (CompareCriteria)theCrit).getOperator() != 1) continue;
                        if (jcrit.getLeftExpression().equals(srcElement) && jcrit.getRightExpression() instanceof ElementSymbol) {
                            if (srcToTgt == null) {
                                srcToTgt = new HashMap<ElementSymbol, Expression>();
                            }
                            srcToTgt.put(srcElement, jcrit.getRightExpression());
                            matchedElement = true;
                            break;
                        }
                        if (!jcrit.getRightExpression().equals(srcElement) || !(jcrit.getLeftExpression() instanceof ElementSymbol)) continue;
                        if (srcToTgt == null) {
                            srcToTgt = new HashMap();
                        }
                        srcToTgt.put(srcElement, jcrit.getLeftExpression());
                        matchedElement = true;
                        break;
                    }
                    if (matchedElement) continue;
                    matchedAll = false;
                    break;
                }
                if (matchedAll) {
                    joinNodes.add(node);
                    tgtMaps.add(srcToTgt);
                }
            }
        } else if (nodeType == 19 || nodeType == 29 || nodeType == 23 || nodeType == 11) {
            return;
        }
        this.findJoinNodes(node.getParent(), srcElements, srcGroup, joinNodes, tgtMaps);
    }

    PlanNode findSourceNode(PlanNode root, GroupSymbol group) {
        if (root.getType() == 19) {
            if (root.getGroups().contains(group)) {
                return root;
            }
            return null;
        }
        List children = root.getChildren();
        Iterator childIter = children.iterator();
        while (childIter.hasNext()) {
            PlanNode child = (PlanNode)childIter.next();
            PlanNode found = this.findSourceNode(child, group);
            if (found == null) continue;
            return found;
        }
        return null;
    }

    public String toString() {
        return "CopyCriteria";
    }
}

