/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.metamodels.relational.util;

import com.metamatrix.core.util.ArgCheck;
import com.metamatrix.metamodels.relational.RelationalPlugin;
import com.metamatrix.metamodels.relational.SearchabilityType;
import com.metamatrix.metamodels.relational.util.RelationalTypeMapping;
import com.metamatrix.modeler.core.ModelerCore;
import com.metamatrix.modeler.core.ModelerCoreException;
import com.metamatrix.modeler.core.ModelerCoreRuntimeException;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlAspect;
import com.metamatrix.modeler.core.metamodel.aspect.sql.SqlDatatypeAspect;
import com.metamatrix.modeler.core.types.DatatypeManager;
import java.util.HashMap;
import java.util.Map;
import org.eclipse.emf.ecore.EObject;

public class RelationalTypeMappingImpl
implements RelationalTypeMapping {
    private static RelationalTypeMapping instance;
    private final Map jdbcToBuiltInType = new HashMap();
    private final Map builtInTypeToJdbc = new HashMap();
    private final Map jdbcIntToJdbcName = new HashMap();
    private final Map datatypeToJdbcName = new HashMap();
    private final DatatypeManager datatypeManager;
    private boolean initialized;

    public static RelationalTypeMapping getInstance() {
        if (instance == null) {
            instance = new RelationalTypeMappingImpl();
        }
        return instance;
    }

    protected static DatatypeManager getStandardDatatypeManager() {
        try {
            return ModelerCore.getWorkspaceDatatypeManager();
        }
        catch (ModelerCoreRuntimeException e) {
            RelationalPlugin.Util.log((Throwable)e);
            return null;
        }
    }

    public RelationalTypeMappingImpl() {
        this(RelationalTypeMappingImpl.getStandardDatatypeManager());
    }

    public RelationalTypeMappingImpl(DatatypeManager datatypeManager) {
        this.datatypeManager = datatypeManager;
        if (this.datatypeManager == null) {
            String msg = RelationalPlugin.Util.getString("RelationalTypeMapping.No_DatatypeManager");
            RelationalPlugin.Util.log(4, msg);
        }
    }

    protected void initialize() {
        if (this.initialized) {
            return;
        }
        this.initialized = true;
        if (this.datatypeManager == null) {
            return;
        }
        this.register(-5, "BIGINT", this.internalFindDatatype("biginteger"));
        this.register(-2, "BINARY", this.internalFindDatatype("object"));
        this.register(-7, "BIT", this.internalFindDatatype("short"));
        this.register(2004, "BLOB", this.internalFindDatatype("blob"));
        this.register(1, "CHAR", this.internalFindDatatype("char"));
        this.register(2005, "CLOB", this.internalFindDatatype("clob"));
        this.register(91, "DATE", this.internalFindDatatype("date"));
        this.register(3, "DECIMAL", this.internalFindDatatype("double"));
        this.register(8, "DOUBLE", this.internalFindDatatype("double"));
        this.register(2, "NUMERIC", this.internalFindDatatype("integer"));
        this.register(4, "INTEGER", this.internalFindDatatype("int"));
        this.register(6, "FLOAT", this.internalFindDatatype("float"));
        this.register(-4, "LONGVARBINARY", this.internalFindDatatype("object"));
        this.register(-1, "LONGVARCHAR", this.internalFindDatatype("string"));
        this.register(-754888, "NCHAR", this.internalFindDatatype("string"));
        this.register(-754888, "NTEXT", this.internalFindDatatype("object"));
        this.register(2, "NUMERIC", this.internalFindDatatype("long"));
        this.register(2, "NUMERIC", this.internalFindDatatype("bigdecimal"));
        this.register(1111, "OTHER", this.internalFindDatatype("object"));
        this.register(7, "REAL", this.internalFindDatatype("double"));
        this.register(2006, "REF", this.internalFindDatatype("object"));
        this.register(5, "SMALLINT", this.internalFindDatatype("short"));
        this.register(2002, "STRUCT", this.internalFindDatatype("object"));
        this.register(92, "TIME", this.internalFindDatatype("time"));
        this.register(93, "TIMESTAMP", this.internalFindDatatype("timestamp"));
        this.register(-6, "TINYINT", this.internalFindDatatype("short"));
        this.register(-3, "VARBINARY", this.internalFindDatatype("object"));
        this.register(12, "VARCHAR", this.internalFindDatatype("string"));
    }

    protected EObject internalFindDatatype(String identifier) {
        try {
            return this.datatypeManager.getBuiltInDatatype(identifier);
        }
        catch (ModelerCoreException e) {
            RelationalPlugin.Util.log((Throwable)e);
            return null;
        }
    }

    protected EObject findDatatype(String identifier) throws ModelerCoreException {
        EObject result = this.datatypeManager.getBuiltInDatatype(identifier);
        if (result == null) {
            result = this.datatypeManager.findDatatype(identifier);
        }
        return result;
    }

    public void register(int jdbcTypeInt, String jdbcTypeName, EObject datatype) {
        this.initialize();
        ArgCheck.isNotNull((Object)jdbcTypeName);
        ArgCheck.isNotNull((Object)datatype);
        String identifier = this.getIdentifier(datatype);
        this.register(jdbcTypeInt, jdbcTypeName, identifier);
    }

    public void register(int jdbcTypeInt, String jdbcTypeName, String datatypeUri) {
        this.initialize();
        ArgCheck.isNotNull((Object)jdbcTypeName);
        ArgCheck.isNotNull((Object)datatypeUri);
        String jdbcUpperTypeName = jdbcTypeName.toUpperCase();
        this.jdbcToBuiltInType.put(jdbcUpperTypeName, datatypeUri);
        this.builtInTypeToJdbc.put(datatypeUri, jdbcUpperTypeName);
        if (jdbcTypeInt != -754888) {
            this.jdbcIntToJdbcName.put(new Integer(jdbcTypeInt), jdbcUpperTypeName);
        }
    }

    protected String getIdentifier(EObject datatype) {
        ArgCheck.isNotNull((Object)datatype);
        SqlAspect sqlAspect = (SqlAspect)ModelerCore.getMetamodels().getMetamodelAspect(datatype, "sqlAspect");
        if (sqlAspect == null) {
            return this.datatypeManager.getName(datatype);
        }
        if (sqlAspect instanceof SqlDatatypeAspect) {
            SqlDatatypeAspect datatypeAspect = (SqlDatatypeAspect)sqlAspect;
            String id = datatypeAspect.getDatatypeID(datatype);
            return id;
        }
        Object id = sqlAspect.getObjectID(datatype);
        if (id != null) {
            return id.toString();
        }
        return null;
    }

    public EObject getDatatype(String jdbcTypeName) throws ModelerCoreException {
        String identifier;
        this.initialize();
        EObject result = null;
        if (jdbcTypeName != null && (identifier = (String)this.jdbcToBuiltInType.get(jdbcTypeName.toUpperCase())) != null) {
            result = this.findDatatype(identifier);
        }
        if (result == null) {
            result = this.findDatatype("object");
        }
        return result;
    }

    public EObject getDatatype(int jdbcType) throws ModelerCoreException {
        this.initialize();
        String jdbcTypeName = (String)this.jdbcIntToJdbcName.get(new Integer(jdbcType));
        EObject result = null;
        if (jdbcTypeName != null) {
            result = this.getDatatype(jdbcTypeName);
        }
        return result;
    }

    public String getJdbcTypeName(EObject type) throws ModelerCoreException {
        ArgCheck.isNotNull((Object)type);
        this.initialize();
        String name = (String)this.datatypeToJdbcName.get(type);
        if (name == null) {
            String id;
            EObject theType = type;
            while (name == null && theType != null && ((name = (String)this.builtInTypeToJdbc.get(id = this.getIdentifier(theType))) != null || this.datatypeManager == null || (theType = this.datatypeManager.getBaseType(theType)) != null)) {
            }
            if (name == null) {
                EObject objType = this.findDatatype("object");
                ArgCheck.isNotNull((Object)objType);
                String id2 = this.getIdentifier(objType);
                ArgCheck.isNotNull((Object)id2);
                name = (String)this.builtInTypeToJdbc.get(id2);
            }
            ArgCheck.isNotNull((Object)name);
            this.datatypeToJdbcName.put(type, name);
        }
        return name;
    }

    public SearchabilityType getSearchabilityType(EObject datatype) {
        if (datatype == null) {
            return SearchabilityType.UNSEARCHABLE_LITERAL;
        }
        this.initialize();
        EObject dt = datatype;
        while (dt != null && !this.datatypeManager.isBuiltInDatatype(dt)) {
            EObject baseType = this.datatypeManager.getBaseType(dt);
            dt = this.datatypeManager.isSimpleDatatype(baseType) ? baseType : null;
        }
        String typeName = this.datatypeManager.getName(dt);
        if ("string".equals(typeName)) {
            return SearchabilityType.SEARCHABLE_LITERAL;
        }
        if ("char".equals(typeName)) {
            return SearchabilityType.SEARCHABLE_LITERAL;
        }
        if ("clob".equals(typeName)) {
            return SearchabilityType.LIKE_ONLY_LITERAL;
        }
        if ("blob".equals(typeName)) {
            return SearchabilityType.UNSEARCHABLE_LITERAL;
        }
        if ("object".equals(typeName)) {
            return SearchabilityType.UNSEARCHABLE_LITERAL;
        }
        return SearchabilityType.ALL_EXCEPT_LIKE_LITERAL;
    }
}

