/*
 * Decompiled with CFR 0.152.
 */
package com.metamatrix.admin.server;

import com.metamatrix.admin.AdminPlugin;
import com.metamatrix.admin.api.exception.AdminComponentException;
import com.metamatrix.admin.api.exception.AdminException;
import com.metamatrix.admin.api.exception.AdminProcessingException;
import com.metamatrix.admin.api.objects.AdminObject;
import com.metamatrix.admin.api.objects.AdminOptions;
import com.metamatrix.admin.api.objects.AdminStatus;
import com.metamatrix.admin.api.objects.Host;
import com.metamatrix.admin.api.objects.LogConfiguration;
import com.metamatrix.admin.api.objects.ProcessObject;
import com.metamatrix.admin.api.objects.ScriptsContainer;
import com.metamatrix.admin.api.objects.VDB;
import com.metamatrix.admin.api.server.ServerConfigAdmin;
import com.metamatrix.admin.objects.MMAdminObject;
import com.metamatrix.admin.objects.MMAdminStatus;
import com.metamatrix.admin.objects.MMConnectorBinding;
import com.metamatrix.admin.objects.MMLogConfiguration;
import com.metamatrix.admin.objects.MMScriptsContainer;
import com.metamatrix.admin.server.AbstractAdminImpl;
import com.metamatrix.admin.server.AdminServerPlugin;
import com.metamatrix.admin.server.ServerAdminImpl;
import com.metamatrix.api.exception.MetaMatrixComponentException;
import com.metamatrix.api.exception.MetaMatrixProcessingException;
import com.metamatrix.api.exception.security.AuthorizationException;
import com.metamatrix.api.exception.security.InvalidSessionException;
import com.metamatrix.common.actions.ModificationActionQueue;
import com.metamatrix.common.actions.ModificationException;
import com.metamatrix.common.config.api.ComponentDefnID;
import com.metamatrix.common.config.api.ComponentObject;
import com.metamatrix.common.config.api.ComponentType;
import com.metamatrix.common.config.api.Configuration;
import com.metamatrix.common.config.api.ConfigurationModelContainer;
import com.metamatrix.common.config.api.ConfigurationObjectEditor;
import com.metamatrix.common.config.api.ConnectorArchive;
import com.metamatrix.common.config.api.ConnectorBinding;
import com.metamatrix.common.config.api.ConnectorBindingType;
import com.metamatrix.common.config.api.ExtensionModule;
import com.metamatrix.common.config.api.HostID;
import com.metamatrix.common.config.api.ServiceComponentDefn;
import com.metamatrix.common.config.api.ServiceComponentDefnID;
import com.metamatrix.common.config.api.VMComponentDefn;
import com.metamatrix.common.config.api.exceptions.ConfigurationException;
import com.metamatrix.common.config.model.BasicConfigurationObjectEditor;
import com.metamatrix.common.config.model.BasicConnectorArchive;
import com.metamatrix.common.config.model.BasicDeployedComponent;
import com.metamatrix.common.config.model.BasicExtensionModule;
import com.metamatrix.common.config.model.ConfigurationModelContainerAdapter;
import com.metamatrix.common.config.util.ConfigObjectsNotResolvableException;
import com.metamatrix.common.config.util.InvalidConfigurationElementException;
import com.metamatrix.common.config.xml.XMLConfigurationImportExportUtility;
import com.metamatrix.common.extensionmodule.ExtensionModuleDescriptor;
import com.metamatrix.common.log.LogManager;
import com.metamatrix.common.net.SocketHelper;
import com.metamatrix.common.util.LogContextsUtil;
import com.metamatrix.common.util.PropertiesUtils;
import com.metamatrix.common.util.crypto.CryptoException;
import com.metamatrix.common.util.crypto.CryptoUtil;
import com.metamatrix.common.vdb.api.ModelInfo;
import com.metamatrix.common.vdb.api.VDBDefn;
import com.metamatrix.core.util.ObjectConverterUtil;
import com.metamatrix.metabase.repository.api.IRepository;
import com.metamatrix.metabase.repository.api.RepositoryResultWithContentsStruct;
import com.metamatrix.metadata.runtime.RuntimeMetadataCatalog;
import com.metamatrix.metadata.runtime.api.Model;
import com.metamatrix.metadata.runtime.api.VirtualDatabase;
import com.metamatrix.metadata.runtime.api.VirtualDatabaseID;
import com.metamatrix.metadata.runtime.vdb.defn.VDBDefnExport;
import com.metamatrix.metadata.runtime.vdb.defn.VDBDefnImport;
import com.metamatrix.platform.service.api.exception.ServiceException;
import com.metamatrix.server.admin.apiimpl.MaterializationLoadScriptsImpl;
import com.metamatrix.server.admin.apiimpl.RuntimeMetadataHelper;
import com.metamatrix.vdb.edit.loader.VDBReader;
import com.metamatrix.vdb.edit.loader.VDBWriter;
import java.io.BufferedOutputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Properties;
import java.util.Set;

public class ServerConfigAdminImpl
extends AbstractAdminImpl
implements ServerConfigAdmin {
    private static final String CONNECTION_PROPERTY_DRIVER = "Driver";
    private static final String CONNECTION_PROPERTY_PASSWORD = "Password";
    private static final String CONNECTION_PROPERTY_USER = "User";
    private static final String CONNECTION_PROPERTY_URL = "URL";
    private static String METAMATRIXPROCESS_PSC = "MMProcessPSC";
    private static String PLATFORM_STANDARD_PSC = "PlatformStandard";
    private static String QUERY_ENGINE_PSC = "QueryEngine";

    public ServerConfigAdminImpl(ServerAdminImpl parent) {
        super(parent);
    }

    public com.metamatrix.admin.api.objects.ConnectorBinding addConnectorBinding(String connectorBindingName, String connectorTypeIdentifier, Properties properties, AdminOptions options) throws AdminException {
        com.metamatrix.admin.api.objects.ConnectorBinding newBinding = null;
        if (connectorBindingName == null) {
            this.throwProcessingException("ServerConfigAdminImpl.Name_can_not_be_null");
        }
        if (connectorTypeIdentifier == null) {
            this.throwProcessingException("ServerConfigAdminImpl.Connector_Type_can_not_be_null");
        }
        if (properties == null) {
            this.throwProcessingException("ServerConfigAdminImpl.Properties_can_not_be_null");
        }
        Collection existingBindings = this.parent.getConnectorBindings("*" + AdminObject.DELIMITER + connectorBindingName);
        ArrayList<String> newBindingNames = new ArrayList<String>(1);
        newBindingNames.add(connectorBindingName);
        Collection updateBindingNames = this.getBindingNamesToUpdate(existingBindings, newBindingNames, options);
        if (updateBindingNames.size() > 0 && updateBindingNames.iterator().next().equals(connectorBindingName)) {
            AdminStatus status = this.checkDecryption(properties, connectorBindingName, connectorTypeIdentifier);
            if (status.getCode() == -101 && !options.containsOption(8)) {
                LogManager.logError((String)"ADMIN", (String)status.getMessage());
                throw new AdminProcessingException(status.getCode(), status.getMessage());
            }
            ConnectorBinding binding = null;
            try {
                binding = this.getConfigurationServiceProxy().createConnectorBinding(connectorBindingName, connectorTypeIdentifier, METAMATRIXPROCESS_PSC, this.getUserName(), properties);
                if (binding == null) {
                    this.throwProcessingException("ServerConfigAdminImpl.Connector_Binding_was_null", new Object[]{connectorBindingName});
                }
            }
            catch (ConfigurationException configException) {
                ServerConfigAdminImpl.logAndConvertSystemException((Exception)((Object)configException));
            }
            catch (ServiceException err) {
                ServerConfigAdminImpl.logAndConvertSystemException((Exception)((Object)err));
            }
            Collection newBindings = this.parent.getConnectorBindings("*" + AdminObject.DELIMITER + connectorBindingName);
            newBinding = (com.metamatrix.admin.api.objects.ConnectorBinding)newBindings.iterator().next();
        } else if (existingBindings != null && existingBindings.size() > 0) {
            newBinding = (com.metamatrix.admin.api.objects.ConnectorBinding)existingBindings.iterator().next();
        }
        return newBinding;
    }

    public com.metamatrix.admin.api.objects.ConnectorBinding addConnectorBinding(String connectorBindingName, char[] xmlFile, AdminOptions options) throws AdminException {
        com.metamatrix.admin.api.objects.ConnectorBinding newBinding = null;
        if (connectorBindingName == null) {
            this.throwProcessingException("ServerConfigAdminImpl.Connector_Binding_can_not_be_null");
        }
        if (xmlFile == null) {
            this.throwProcessingException("ServerConfigAdminImpl.CDK_File_Name_can_not_be_null");
        }
        Collection existingBindings = this.parent.getConnectorBindings("*" + AdminObject.DELIMITER + connectorBindingName);
        ArrayList<String> newBindingNames = new ArrayList<String>(1);
        newBindingNames.add(connectorBindingName);
        Collection updateBindingNames = this.getBindingNamesToUpdate(existingBindings, newBindingNames, options);
        if (updateBindingNames.size() > 0 && updateBindingNames.iterator().next().equals(connectorBindingName)) {
            InputStream is = ObjectConverterUtil.convertToInputStream((char[])xmlFile);
            XMLConfigurationImportExportUtility ciu = new XMLConfigurationImportExportUtility();
            ConnectorBinding binding = null;
            try {
                binding = ciu.importConnectorBinding(is, (ConfigurationObjectEditor)new BasicConfigurationObjectEditor(false), connectorBindingName);
                is.close();
            }
            catch (ConfigObjectsNotResolvableException err1) {
                ServerConfigAdminImpl.logAndConvertSystemException((Exception)((Object)err1));
            }
            catch (InvalidConfigurationElementException err1) {
                ServerConfigAdminImpl.logAndConvertSystemException((Exception)((Object)err1));
            }
            catch (IOException err1) {
                ServerConfigAdminImpl.logAndConvertSystemException(err1);
            }
            AdminStatus status = this.checkDecryption(binding);
            if (status.getCode() == -101 && !options.containsOption(8)) {
                LogManager.logError((String)"ADMIN", (String)status.getMessage());
                throw new AdminProcessingException(status.getCode(), status.getMessage());
            }
            try {
                is = ObjectConverterUtil.convertToInputStream((char[])xmlFile);
                binding = this.getConfigurationServiceProxy().importConnectorBinding(is, connectorBindingName, METAMATRIXPROCESS_PSC, this.getUserName());
                if (binding == null) {
                    this.throwProcessingException("ServerConfigAdminImpl.Connector_Type_was_null", new Object[]{connectorBindingName});
                }
            }
            catch (ConfigurationException configException) {
                ServerConfigAdminImpl.logAndConvertSystemException((Exception)((Object)configException));
            }
            catch (ServiceException err) {
                ServerConfigAdminImpl.logAndConvertSystemException((Exception)((Object)err));
            }
            Collection newBindings = this.parent.getConnectorBindings("*" + AdminObject.DELIMITER + connectorBindingName);
            newBinding = (com.metamatrix.admin.api.objects.ConnectorBinding)newBindings.iterator().next();
        } else if (existingBindings != null && existingBindings.size() > 0) {
            newBinding = (com.metamatrix.admin.api.objects.ConnectorBinding)existingBindings.iterator().next();
        }
        return newBinding;
    }

    public void addConnectorType(String name, char[] cdkFile) throws AdminException {
        ComponentType connectorType = null;
        if (name == null) {
            this.throwProcessingException("ServerConfigAdminImpl.Connector_Type_can_not_be_null");
        }
        if (cdkFile == null) {
            this.throwProcessingException("ServerConfigAdminImpl.CDK_File_Name_can_not_be_null");
        }
        try {
            InputStream is = ObjectConverterUtil.convertToInputStream((char[])cdkFile);
            connectorType = this.getConfigurationServiceProxy().importConnectorType(is, name, this.getUserName());
            if (connectorType == null) {
                this.throwProcessingException("ServerConfigAdminImpl.Connector_Type_was_null", new Object[]{name});
            }
        }
        catch (ConfigurationException configException) {
            ServerConfigAdminImpl.logAndConvertSystemException((Exception)((Object)configException));
        }
        catch (ServiceException err) {
            ServerConfigAdminImpl.logAndConvertSystemException((Exception)((Object)err));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void addConnectorArchive(byte[] contents, AdminOptions options) throws AdminException {
        if (options == null) {
            options = new AdminOptions(2);
        }
        if (contents == null || contents.length == 0) {
            this.throwProcessingException("ServerConfigAdminImpl.CDK_File_Name_can_not_be_null");
        }
        XMLConfigurationImportExportUtility util = new XMLConfigurationImportExportUtility();
        InputStream in = ObjectConverterUtil.convertToInputStream((byte[])contents);
        try {
            HashSet previouslyAddedModules = new HashSet();
            HashSet<ConnectorBindingType> typesToAdd = new HashSet<ConnectorBindingType>();
            ConnectorArchive archive = util.importConnectorArchive(in, (ConfigurationObjectEditor)new BasicConfigurationObjectEditor());
            ConnectorBindingType[] connectorTypes = archive.getConnectorTypes();
            for (int typeIndex = 0; typeIndex < connectorTypes.length; ++typeIndex) {
                String connectorName = connectorTypes[typeIndex].getName();
                ConnectorBindingType type = (ConnectorBindingType)this.getComponentType(connectorName);
                if (type != null && options.containsOption(4)) {
                    this.throwProcessingException("ServerConfigAdminImpl.Connector_Type_already_exists", new Object[]{connectorName});
                } else {
                    if (type != null && options.containsOption(2)) continue;
                    if (type != null && options.containsOption(1)) {
                        this.deleteConnectorType(connectorName);
                    }
                }
                type = connectorTypes[typeIndex];
                ExtensionModule[] extModules = archive.getExtensionModules(type);
                this.checkAddingConnectorType(type, extModules, options, previouslyAddedModules);
                typesToAdd.add(type);
            }
            Iterator i = typesToAdd.iterator();
            while (i.hasNext()) {
                ConnectorBindingType type = (ConnectorBindingType)i.next();
                ByteArrayOutputStream baos = new ByteArrayOutputStream(10240);
                util.exportComponentType((OutputStream)baos, (ComponentType)type, this.getPropertiesForExporting());
                this.addConnectorType(type.getName(), ObjectConverterUtil.bytesToChar((byte[])baos.toByteArray(), null));
                baos.close();
            }
            i = previouslyAddedModules.iterator();
            while (i.hasNext()) {
                ExtensionModule extModule = (ExtensionModule)i.next();
                this.addExtensionModule(extModule.getModuleType(), extModule.getFullName(), extModule.getFileContents(), extModule.getDescription());
            }
        }
        catch (Exception e) {
            ServerConfigAdminImpl.logAndConvertSystemException(e);
        }
        finally {
            try {
                in.close();
            }
            catch (Exception e) {}
        }
    }

    void checkAddingConnectorType(ConnectorBindingType type, ExtensionModule[] extModules, AdminOptions options, HashSet ignorableModules) throws MetaMatrixComponentException, MetaMatrixProcessingException, AdminException {
        for (int i = 0; i < extModules.length; ++i) {
            boolean add = true;
            String moduleName = extModules[i].getFullName();
            if (ignorableModules.contains(extModules[i])) continue;
            if (this.getExtensionSourceManager().isSourceInUse(moduleName)) {
                if (options.containsOption(4)) {
                    this.throwProcessingException("ServerConfigAdminImpl.Extension_module_already_exists", new Object[]{moduleName});
                } else if (options.containsOption(2)) {
                    add = false;
                } else if (options.containsOption(1)) {
                    this.deleteExtensionModule(moduleName);
                }
            }
            if (!add) continue;
            ignorableModules.add(extModules[i]);
        }
    }

    public void addExtensionModule(String type, String sourceName, byte[] source, String description) throws AdminException {
        Collection foundModules = this.parent.getExtensionModules(sourceName);
        if (foundModules.size() > 0) {
            this.throwProcessingException("ServerConfigAdminImpl.Extension_Module_duplicate", new Object[]{sourceName});
        }
        try {
            ExtensionModuleDescriptor desc = this.getExtensionSourceManager().addSource(this.getUserName(), type, sourceName, source, description, true);
            if (desc == null) {
                this.throwProcessingException("ServerConfigAdminImpl.Extension_Module_Descriptor_was_null", new Object[]{sourceName});
            }
        }
        catch (Exception e) {
            ServerConfigAdminImpl.logAndConvertSystemException(e);
        }
    }

    public void deleteExtensionModule(String sourceName) throws AdminException {
        try {
            this.getExtensionSourceManager().removeSource(this.getUserName(), sourceName);
        }
        catch (Exception e) {
            ServerConfigAdminImpl.logAndConvertSystemException(e);
        }
    }

    public void addHost(String hostIdentifer, Properties properties) throws AdminException {
        com.metamatrix.common.config.api.Host host = null;
        String hostName = this.getName(hostIdentifer);
        if (hostName == null) {
            this.throwProcessingException("ServerConfigAdminImpl.Host_name_can_not_be_null");
        }
        if (properties == null) {
            this.throwProcessingException("ServerConfigAdminImpl.Properties_can_not_be_null");
        }
        try {
            host = this.getConfigurationServiceProxy().addHost(hostName, this.getUserName(), properties);
            if (host == null) {
                this.throwProcessingException("ServerConfigAdminImpl.Host_was_null", new Object[]{hostName});
            }
        }
        catch (Exception theException) {
            ServerConfigAdminImpl.logAndConvertSystemException(theException);
        }
    }

    public void addProcess(String processIdentifier, Properties properties) throws AdminException {
        String hostName;
        String processName = this.getName(processIdentifier);
        if (processName == null) {
            this.throwProcessingException("ServerConfigAdminImpl.Name_can_not_be_null");
        }
        if ((hostName = this.getParent(processIdentifier)) == null) {
            this.throwProcessingException("ServerConfigAdminImpl.Host_name_can_not_be_null");
        }
        com.metamatrix.common.config.api.Host theHost = this.getHostByName(hostName);
        if (properties == null) {
            this.throwProcessingException("ServerConfigAdminImpl.Properties_can_not_be_null");
        }
        try {
            VMComponentDefn processDefn = null;
            processDefn = this.getConfigurationServiceProxy().addProcess(processName, hostName, this.getUserName(), properties);
            if (processDefn != null) {
                this.getConfigurationServiceProxy().deployPSC(theHost, processDefn, METAMATRIXPROCESS_PSC, this.getUserName());
                this.getConfigurationServiceProxy().deployPSC(theHost, processDefn, PLATFORM_STANDARD_PSC, this.getUserName());
                this.getConfigurationServiceProxy().deployPSC(theHost, processDefn, QUERY_ENGINE_PSC, this.getUserName());
            } else {
                Object[] params = new Object[]{processIdentifier, hostName};
                this.throwProcessingException("ServerConfigAdminImpl.Process_was_null", params);
            }
        }
        catch (Exception theException) {
            ServerConfigAdminImpl.logAndConvertSystemException(theException);
        }
    }

    public VDB addVDB(String name, byte[] vdbFile, AdminOptions options) throws AdminException {
        VDBDefn vdbDefn = null;
        try {
            vdbDefn = VDBReader.loadVDBDefn(name, vdbFile, null);
        }
        catch (Exception err) {
            ServerConfigAdminImpl.logAndConvertSystemException(err);
        }
        return this.addVDB(vdbDefn, options);
    }

    private VDB addVDB(VDBDefn vdbDefn, AdminOptions options) throws AdminException {
        VirtualDatabase newVDB = null;
        ArrayList newBindings = new ArrayList(vdbDefn.getConnectorBindings().values());
        AdminStatus status = this.checkDecryption(newBindings);
        if (status.getCode() == -101 && !options.containsOption(8)) {
            LogManager.logError((String)"ADMIN", (String)status.getMessage());
            throw new AdminProcessingException(status.getCode(), status.getMessage());
        }
        Collection newBindingNames = this.getBindingNames(newBindings);
        Collection existingBindings = this.parent.getConnectorBindingsInVDB(vdbDefn.getName());
        Collection totalBindings = this.getBindingNamesToUpdate(existingBindings, newBindingNames, options);
        this.checkSourceLicense(totalBindings.size());
        boolean updateBindings = options.containsOption(1);
        try {
            newVDB = VDBDefnImport.importVDBDefn((VDBDefn)vdbDefn, (String)this.getUserName(), (boolean)updateBindings);
        }
        catch (Exception err) {
            ServerConfigAdminImpl.logAndConvertSystemException(err);
        }
        if (newVDB == null) {
            this.throwProcessingException("ServerConfigAdminImpl.VDB_created_was_null", new Object[]{vdbDefn.getName()});
        }
        return this.convertToAdminVDB(newVDB);
    }

    public VDB addVDB(String deployedVDBName, String repositoryVersion, String repositoryLocation) throws AdminException {
        RepositoryResultWithContentsStruct struct = null;
        IRepository repository = null;
        VDB vdb = null;
        try {
            repository = this.getDirectoryServiceProxy().getLocalObject();
            repository.ping();
            Boolean isExist = repository.exists(repositoryLocation);
            if (isExist != null && isExist.booleanValue()) {
                struct = repositoryVersion == null || repositoryVersion.equals("LATEST") ? repository.getLatest(repositoryLocation) : repository.getVersion(repositoryLocation, repositoryVersion);
            } else {
                this.throwProcessingException("ServerConfigAdminImpl.Could_not_find_VDB_at_the_specified_path", new Object[]{repositoryLocation});
            }
            if (struct != null) {
                vdb = this.addVDB(deployedVDBName, struct.contents, new AdminOptions(2));
            } else {
                this.throwProcessingException("ServerConfigAdminImpl.Could_not_find_VDB_at_the_specified_path", new Object[]{repositoryLocation});
            }
        }
        catch (Exception theException) {
            ServerConfigAdminImpl.logAndConvertSystemException(theException);
        }
        return vdb;
    }

    public ScriptsContainer generateMaterializationScripts(String vdbName, String vdbVersion, String metamatrixUserName, String metamatrixUserPwd, String materializationUserName, String materializationUserPwd) throws AdminException {
        Object[] params;
        VDBDefn vdbDefn = null;
        try {
            vdbDefn = VDBDefnExport.getVDBDefn((String)vdbName, (String)vdbVersion);
        }
        catch (Exception err) {
            ServerConfigAdminImpl.logAndConvertProcessingException(err);
        }
        ModelInfo materializationModel = vdbDefn.getMatertializationModel();
        List bindings = materializationModel.getConnectorBindingNames();
        ConnectorBinding materializationConnector = null;
        String materializationConnectorName = null;
        if (bindings != null && bindings.size() > 0) {
            materializationConnectorName = (String)bindings.iterator().next();
        } else {
            Object[] params2 = new Object[]{materializationModel.getName()};
            this.throwProcessingException(AdminServerPlugin.Util.getString("ServerConfigAdminImpl.Unable_to_get_binding_name", params2));
        }
        try {
            materializationConnector = this.getConnectorBindingByName(materializationConnectorName);
        }
        catch (Exception err) {
            Object[] params3 = new Object[]{materializationModel.getName()};
            ServerConfigAdminImpl.logAndConvertSystemException(err, AdminServerPlugin.Util.getString("ServerConfigAdminImpl.Unable_to_get_binding_name", params3));
        }
        Properties materializationConnectorProps = materializationConnector.getProperties();
        String materializationURL = materializationConnectorProps.getProperty(CONNECTION_PROPERTY_URL);
        if (materializationUserName == null || materializationUserName.length() == 0 || materializationUserPwd == null || materializationUserPwd.length() == 0) {
            materializationUserName = materializationConnectorProps.getProperty(CONNECTION_PROPERTY_USER);
            materializationUserPwd = materializationConnectorProps.getProperty(CONNECTION_PROPERTY_PASSWORD);
        } else {
            try {
                materializationUserPwd = PropertiesUtils.saveConvert((String)new String(CryptoUtil.stringEncrypt((char[])materializationUserPwd.toCharArray())), (boolean)false);
            }
            catch (CryptoException err) {
                params = new Object[]{materializationUserName};
                ServerConfigAdminImpl.logAndConvertSystemException((Exception)((Object)err), AdminServerPlugin.Util.getString("ServerConfigAdminImpl.Unable_to_encrypt_mat_db_user", params));
            }
        }
        try {
            metamatrixUserPwd = PropertiesUtils.saveConvert((String)new String(CryptoUtil.stringEncrypt((char[])metamatrixUserPwd.toCharArray())), (boolean)false);
        }
        catch (CryptoException err) {
            params = new Object[]{metamatrixUserName};
            ServerConfigAdminImpl.logAndConvertSystemException((Exception)((Object)err), AdminServerPlugin.Util.getString("ServerConfigAdminImpl.Unable_to_encrypt_MM_user", params));
        }
        String materializationDriver = materializationConnectorProps.getProperty(CONNECTION_PROPERTY_DRIVER);
        String mmHost = null;
        String mmPort = null;
        Collection hosts = this.parent.getHosts("*");
        Host aHost = (Host)hosts.iterator().next();
        mmHost = aHost.getName();
        Collection hostProcesses = this.parent.getProcesses(aHost.getIdentifier() + AdminObject.DELIMITER + "*");
        ProcessObject hostProcess = (ProcessObject)hostProcesses.iterator().next();
        mmPort = hostProcess.getPropertyValue("vm.socketPort");
        boolean useSSL = false;
        try {
            useSSL = SocketHelper.isServerSSLEnabled();
        }
        catch (Exception err) {
            ServerConfigAdminImpl.logAndConvertSystemException(err);
        }
        String mmDriver = "com.metamatrix.jdbc.MMDriver";
        MaterializationLoadScriptsImpl binaryScripts = (MaterializationLoadScriptsImpl)RuntimeMetadataHelper.createMaterializedViewLoadPropertiesVersion(materializationModel, materializationURL, materializationDriver, materializationUserName, materializationUserPwd, mmHost, mmPort, mmDriver, useSSL, metamatrixUserName, metamatrixUserPwd, vdbName, vdbVersion);
        MMScriptsContainer scripts = new MMScriptsContainer();
        try {
            scripts.addFile(binaryScripts.getCreateScriptFileName(), binaryScripts.getCreateFileContents());
            scripts.addFile(binaryScripts.getConnectionPropsFileName(), binaryScripts.getConPropsFileContents());
            scripts.addFile(binaryScripts.getTruncateScriptFileName(), binaryScripts.getTruncateFileContents());
            scripts.addFile(binaryScripts.getLoadScriptFileName(), binaryScripts.getLoadFileContents());
            scripts.addFile(binaryScripts.getSwapScriptFileName(), binaryScripts.getSwapFileContents());
        }
        catch (AdminComponentException err) {
            ServerConfigAdminImpl.logAndConvertSystemException((Exception)((Object)err), AdminServerPlugin.Util.getString("ServerConfigAdminImpl.Script_gen_failed"));
        }
        return scripts;
    }

    public void disableHost(String identifier) throws AdminException {
        try {
            Collection hosts = this.getConfigurationServiceProxy().getHosts();
            Iterator iter = hosts.iterator();
            while (iter.hasNext()) {
                com.metamatrix.common.config.api.Host updatedHost;
                com.metamatrix.common.config.api.Host hostObject = (com.metamatrix.common.config.api.Host)iter.next();
                String hostName = hostObject.getName();
                if (!ServerConfigAdminImpl.identifierMatches(identifier, new String[]{hostName}) || (updatedHost = this.updateHost(hostObject, false)) != null) continue;
                this.throwProcessingException("ServerConfigAdminImpl.Host_was_null", new Object[]{hostName});
            }
        }
        catch (Exception theException) {
            ServerConfigAdminImpl.logAndConvertSystemException(theException);
        }
    }

    private com.metamatrix.common.config.api.Host updateHost(com.metamatrix.common.config.api.Host hostObject, boolean enable) throws ConfigurationException, ServiceException, ModificationException {
        Properties theProperties = hostObject.getProperties();
        theProperties.setProperty("host.enabled", Boolean.toString(enable));
        com.metamatrix.common.config.api.Host updatedHost = (com.metamatrix.common.config.api.Host)this.getConfigurationServiceProxy().modify((ComponentObject)hostObject, theProperties, this.getUserName());
        return updatedHost;
    }

    public void disableProcess(String identifier) throws AdminException {
        Collection defns = new ArrayList();
        try {
            defns = this.getConfigurationServiceProxy().getCurrentConfiguration().getVMComponentDefns();
        }
        catch (ConfigurationException err) {
            ServerConfigAdminImpl.logAndConvertSystemException((Exception)((Object)err));
        }
        catch (ServiceException err) {
            ServerConfigAdminImpl.logAndConvertSystemException((Exception)((Object)err));
        }
        try {
            Iterator iter = defns.iterator();
            while (iter.hasNext()) {
                VMComponentDefn updatedProcess;
                VMComponentDefn defn = (VMComponentDefn)iter.next();
                String processName = defn.getName();
                String hostName = defn.getHostID().getName();
                String[] identifierParts = new String[]{hostName, processName};
                if (!ServerConfigAdminImpl.identifierMatches(identifier, identifierParts) || (updatedProcess = this.updateProcess(defn, false)) != null) continue;
                Object[] params = new Object[]{identifier, hostName};
                this.throwProcessingException("ServerConfigAdminImpl.Process_was_null", params);
            }
        }
        catch (Exception theException) {
            ServerConfigAdminImpl.logAndConvertSystemException(theException);
        }
    }

    private VMComponentDefn updateProcess(VMComponentDefn defn, boolean enabled) throws ConfigurationException, ServiceException, ModificationException {
        Properties processProperties = defn.getProperties();
        processProperties.setProperty("vm.enabled", Boolean.toString(enabled));
        VMComponentDefn updatedProcess = null;
        updatedProcess = (VMComponentDefn)this.getConfigurationServiceProxy().modify((ComponentObject)defn, processProperties, this.getUserName());
        return updatedProcess;
    }

    public void enableHost(String identifier) throws AdminException {
        try {
            Collection hosts = this.getConfigurationServiceProxy().getHosts();
            Iterator iter = hosts.iterator();
            while (iter.hasNext()) {
                com.metamatrix.common.config.api.Host updatedHost;
                com.metamatrix.common.config.api.Host hostObject = (com.metamatrix.common.config.api.Host)iter.next();
                String hostName = hostObject.getName();
                if (!ServerConfigAdminImpl.identifierMatches(identifier, new String[]{hostName}) || (updatedHost = this.updateHost(hostObject, true)) != null) continue;
                this.throwProcessingException("ServerConfigAdminImpl.Host_was_null", new Object[]{hostName});
            }
        }
        catch (Exception theException) {
            ServerConfigAdminImpl.logAndConvertSystemException(theException);
        }
    }

    public void enableProcess(String identifier) throws AdminException {
        try {
            Collection defns = this.getConfigurationServiceProxy().getCurrentConfiguration().getVMComponentDefns();
            Iterator iter = defns.iterator();
            while (iter.hasNext()) {
                VMComponentDefn updatedProcess;
                VMComponentDefn defn = (VMComponentDefn)iter.next();
                String processName = defn.getName();
                String hostName = defn.getHostID().getName();
                String[] identifierParts = new String[]{hostName, processName};
                if (!ServerConfigAdminImpl.identifierMatches(identifier, identifierParts) || (updatedProcess = this.updateProcess(defn, true)) != null) continue;
                Object[] params = new Object[]{identifier, hostName};
                this.throwProcessingException("ServerConfigAdminImpl.Process_was_null", params);
            }
        }
        catch (Exception theException) {
            ServerConfigAdminImpl.logAndConvertSystemException(theException);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public char[] exportConfiguration() throws AdminException {
        char[] results;
        block19: {
            IOException err222;
            BufferedOutputStream os;
            ByteArrayOutputStream baos;
            block17: {
                results = null;
                baos = new ByteArrayOutputStream();
                os = new BufferedOutputStream(baos);
                ConfigurationModelContainer container = this.getConfigurationServiceProxy().getConfigurationModel("Next Startup");
                ConfigurationModelContainerAdapter adapter = new ConfigurationModelContainerAdapter();
                adapter.writeConfigurationModel((OutputStream)os, container, this.getUserName());
                results = ObjectConverterUtil.bytesToChar((byte[])baos.toByteArray(), null);
                Object var7_7 = null;
                if (os == null) break block17;
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException err222) {
                    // empty catch block
                }
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException err222) {}
            }
            break block19;
            {
                catch (Exception theException) {
                    IOException err222;
                    ServerConfigAdminImpl.logAndConvertSystemException(theException);
                    Object var7_8 = null;
                    if (os != null) {
                        try {
                            ((OutputStream)os).close();
                        }
                        catch (IOException err222) {
                            // empty catch block
                        }
                    }
                    if (baos != null) {
                        try {
                            baos.close();
                        }
                        catch (IOException err222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                IOException err222;
                Object var7_9 = null;
                if (os != null) {
                    try {
                        ((OutputStream)os).close();
                    }
                    catch (IOException err222) {
                        // empty catch block
                    }
                }
                if (baos != null) {
                    try {
                        baos.close();
                    }
                    catch (IOException err222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void importConfiguration(char[] fileData) throws AdminException {
        InputStream is = null;
        try {
            is = ObjectConverterUtil.convertToInputStream((char[])fileData);
            ConfigurationObjectEditor readEditor = this.getConfigurationServiceProxy().createEditor();
            XMLConfigurationImportExportUtility utility = new XMLConfigurationImportExportUtility();
            Collection objects = utility.importConfigurationObjects(is, readEditor, "Next Startup");
            ConfigurationObjectEditor writeEditor = this.getConfigurationServiceProxy().createEditor();
            writeEditor.delete(Configuration.NEXT_STARTUP_ID);
            writeEditor.createConfiguration(Configuration.NEXT_STARTUP_ID, objects);
            this.getConfigurationServiceProxy().executeTransaction(this.getUserName(), writeEditor.getDestination().getActions());
        }
        catch (Exception e) {
            ServerConfigAdminImpl.logAndConvertSystemException(e);
        }
        finally {
            try {
                is.close();
            }
            catch (Exception exception) {}
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public char[] exportConnectorBinding(String connectorBindingIdentifier) throws AdminException {
        char[] results;
        block27: {
            IOException err2222;
            BufferedOutputStream os;
            ByteArrayOutputStream baos;
            block25: {
                int numSelected;
                XMLConfigurationImportExportUtility util;
                ArrayList<ComponentType> selectedTypes;
                ArrayList<ConnectorBinding> selectedBindings;
                block22: {
                    IOException err2222;
                    Object component;
                    block23: {
                        results = null;
                        selectedBindings = new ArrayList<ConnectorBinding>();
                        selectedTypes = new ArrayList<ComponentType>();
                        baos = new ByteArrayOutputStream();
                        os = new BufferedOutputStream(baos);
                        util = new XMLConfigurationImportExportUtility();
                        Configuration config = this.getConfigurationServiceProxy().getCurrentConfiguration();
                        ConfigurationModelContainer container = this.getConfigurationServiceProxy().getConfigurationModel("Next Startup");
                        Collection components = config.getDeployedComponents();
                        Iterator iter = components.iterator();
                        while (iter.hasNext()) {
                            component = (BasicDeployedComponent)iter.next();
                            String bindingName = component.getName();
                            String[] identifierParts = new String[]{component.getHostID().getName(), component.getVMComponentDefnID().getName(), bindingName};
                            ConnectorBinding binding = config.getConnectorBinding(bindingName);
                            if (binding == null || !ServerConfigAdminImpl.identifierMatches(connectorBindingIdentifier, identifierParts)) continue;
                            selectedBindings.add(binding);
                            ComponentType ct = container.getComponentType(binding.getComponentTypeID().getFullName());
                            selectedTypes.add(ct);
                        }
                        numSelected = selectedBindings.size();
                        if (numSelected != 0) break block22;
                        component = new char[0];
                        Object var18_20 = null;
                        if (os == null) break block23;
                        try {
                            ((OutputStream)os).close();
                        }
                        catch (IOException err2222) {
                            // empty catch block
                        }
                    }
                    if (baos != null) {
                        try {
                            baos.close();
                        }
                        catch (IOException err2222) {
                            // empty catch block
                        }
                    }
                    return component;
                }
                ConnectorBinding[] bindingArray = new ConnectorBinding[numSelected];
                bindingArray = selectedBindings.toArray(bindingArray);
                int numSelected2 = selectedTypes.size();
                ComponentType[] typeArray = new ComponentType[numSelected2];
                typeArray = selectedTypes.toArray(typeArray);
                Properties properties = this.getPropertiesForExporting();
                util.exportConnectorBindings((OutputStream)os, bindingArray, typeArray, properties);
                results = ObjectConverterUtil.bytesToChar((byte[])baos.toByteArray(), null);
                Object var18_21 = null;
                if (os == null) break block25;
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException err2222) {
                    // empty catch block
                }
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException err2222) {}
            }
            break block27;
            {
                catch (Exception theException) {
                    IOException err2222;
                    ServerConfigAdminImpl.logAndConvertSystemException(theException);
                    Object var18_22 = null;
                    if (os != null) {
                        try {
                            ((OutputStream)os).close();
                        }
                        catch (IOException err2222) {
                            // empty catch block
                        }
                    }
                    if (baos != null) {
                        try {
                            baos.close();
                        }
                        catch (IOException err2222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                IOException err2222;
                Object var18_23 = null;
                if (os != null) {
                    try {
                        ((OutputStream)os).close();
                    }
                    catch (IOException err2222) {
                        // empty catch block
                    }
                }
                if (baos != null) {
                    try {
                        baos.close();
                    }
                    catch (IOException err2222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return results;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public char[] exportConnectorType(String connectorTypeIdentifier) throws AdminException {
        char[] results;
        block19: {
            IOException err222;
            BufferedOutputStream os;
            ByteArrayOutputStream baos;
            block17: {
                results = null;
                baos = new ByteArrayOutputStream();
                os = new BufferedOutputStream(baos);
                XMLConfigurationImportExportUtility util = new XMLConfigurationImportExportUtility();
                List selectedTypes = this.getComponentTypes(connectorTypeIdentifier);
                int numSelected = selectedTypes.size();
                ComponentType[] typeArray = new ComponentType[numSelected];
                typeArray = selectedTypes.toArray(typeArray);
                Properties properties = this.getPropertiesForExporting();
                util.exportComponentTypes((OutputStream)os, typeArray, properties);
                results = ObjectConverterUtil.bytesToChar((byte[])baos.toByteArray(), null);
                Object var11_11 = null;
                if (os == null) break block17;
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException err222) {
                    // empty catch block
                }
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException err222) {}
            }
            break block19;
            {
                catch (Exception theException) {
                    IOException err222;
                    ServerConfigAdminImpl.logAndConvertSystemException(theException);
                    Object var11_12 = null;
                    if (os != null) {
                        try {
                            ((OutputStream)os).close();
                        }
                        catch (IOException err222) {
                            // empty catch block
                        }
                    }
                    if (baos != null) {
                        try {
                            baos.close();
                        }
                        catch (IOException err222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                IOException err222;
                Object var11_13 = null;
                if (os != null) {
                    try {
                        ((OutputStream)os).close();
                    }
                    catch (IOException err222) {
                        // empty catch block
                    }
                }
                if (baos != null) {
                    try {
                        baos.close();
                    }
                    catch (IOException err222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return results;
    }

    private List getComponentTypes(String connectorTypeIdentifier) throws ConfigurationException, ServiceException {
        ArrayList<ComponentType> selectedTypes = new ArrayList<ComponentType>();
        Collection types = this.getConfigurationServiceProxy().getAllComponentTypes(false);
        Iterator iter = types.iterator();
        while (iter.hasNext()) {
            ComponentType componentType = (ComponentType)iter.next();
            if (componentType.getComponentTypeCode() != 2) continue;
            String name = componentType.getName();
            String[] identifierParts = new String[]{name};
            if (!ServerConfigAdminImpl.identifierMatches(connectorTypeIdentifier, identifierParts)) continue;
            selectedTypes.add(componentType);
        }
        return selectedTypes;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public byte[] exportConnectorArchive(String connectorTypeIdentifier) throws AdminException {
        BasicConnectorArchive archive = new BasicConnectorArchive();
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        try {
            List selectedTypes = this.getComponentTypes(connectorTypeIdentifier);
            int numSelected = selectedTypes.size();
            if (numSelected == 0) {
                this.throwProcessingException("ServerConfigAdminImpl.Connector_Type_not_found_in_Configuration", new Object[]{connectorTypeIdentifier});
            }
            Iterator i = selectedTypes.iterator();
            while (i.hasNext()) {
                ConnectorBindingType type = (ConnectorBindingType)i.next();
                archive.addConnectorType(type);
                String[] modules = type.getExtensionModules();
                for (int m = 0; m < modules.length; ++m) {
                    String extModuleName = modules[m];
                    try {
                        ExtensionModuleDescriptor emd = this.getExtensionSourceManager().getSourceDescriptor(extModuleName);
                        byte[] source = this.getExtensionSourceManager().getSource(extModuleName);
                        BasicExtensionModule extModule = new BasicExtensionModule(extModuleName, emd.getType(), emd.getDescription(), source);
                        archive.addExtensionModule(type, (ExtensionModule)extModule);
                        continue;
                    }
                    catch (Exception e) {
                        ServerConfigAdminImpl.logAndConvertSystemException(e);
                    }
                }
            }
            XMLConfigurationImportExportUtility util = new XMLConfigurationImportExportUtility();
            util.exportConnectorArchive((OutputStream)baos, (ConnectorArchive)archive, this.getPropertiesForExporting());
            byte[] byArray = baos.toByteArray();
            return byArray;
        }
        catch (Exception e) {
            ServerConfigAdminImpl.logAndConvertSystemException(e);
        }
        finally {
            try {
                baos.close();
            }
            catch (IOException e) {}
        }
        return null;
    }

    public byte[] exportExtensionModule(String identifier) throws AdminException {
        byte[] data = null;
        try {
            List modules = this.getExtensionSourceManager().getSourceDescriptors();
            Iterator iter = modules.iterator();
            while (iter.hasNext()) {
                ExtensionModuleDescriptor descriptor = (ExtensionModuleDescriptor)iter.next();
                String sourceName = descriptor.getName();
                String[] identifierParts = new String[]{sourceName};
                if (!ServerConfigAdminImpl.identifierMatches(identifier, identifierParts)) continue;
                data = this.getExtensionSourceManager().getSource(sourceName);
                break;
            }
        }
        catch (Exception theException) {
            ServerConfigAdminImpl.logAndConvertSystemException(theException);
        }
        return data;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Loose catch block
     */
    public byte[] exportVDB(String name, String version) throws AdminException {
        byte[] results;
        block19: {
            IOException err222;
            BufferedOutputStream os;
            ByteArrayOutputStream baos;
            block17: {
                results = null;
                baos = new ByteArrayOutputStream();
                os = new BufferedOutputStream(baos);
                VDBDefn vdbDefn = VDBDefnExport.getVDBDefn((String)name, (String)version);
                VDBWriter.exportVDBArchive((OutputStream)os, (VDBDefn)vdbDefn, (Properties)new Properties());
                ((OutputStream)os).flush();
                results = baos.toByteArray();
                Object var8_8 = null;
                if (os == null) break block17;
                try {
                    ((OutputStream)os).close();
                }
                catch (IOException err222) {
                    // empty catch block
                }
            }
            if (baos != null) {
                try {
                    baos.close();
                }
                catch (IOException err222) {}
            }
            break block19;
            {
                catch (Exception theException) {
                    IOException err222;
                    ServerConfigAdminImpl.logAndConvertSystemException(theException);
                    Object var8_9 = null;
                    if (os != null) {
                        try {
                            ((OutputStream)os).close();
                        }
                        catch (IOException err222) {
                            // empty catch block
                        }
                    }
                    if (baos != null) {
                        try {
                            baos.close();
                        }
                        catch (IOException err222) {}
                    }
                }
            }
            catch (Throwable throwable) {
                IOException err222;
                Object var8_10 = null;
                if (os != null) {
                    try {
                        ((OutputStream)os).close();
                    }
                    catch (IOException err222) {
                        // empty catch block
                    }
                }
                if (baos != null) {
                    try {
                        baos.close();
                    }
                    catch (IOException err222) {
                        // empty catch block
                    }
                }
                throw throwable;
            }
        }
        return results;
    }

    private Properties getPropertiesForExporting() {
        Properties properties = new Properties();
        properties.put("ApplicationCreatedBy", "ServerAdmin");
        properties.put("ApplicationVersion", "4.3");
        properties.put("UserCreatedBy", this.getUserName());
        return properties;
    }

    public LogConfiguration getLogConfiguration() throws AdminException {
        com.metamatrix.common.log.LogConfiguration logConfig = null;
        try {
            logConfig = this.getConfigurationServiceProxy().getNextStartupConfiguration().getLogConfiguration();
        }
        catch (ConfigurationException err) {
            ServerConfigAdminImpl.logAndConvertSystemException((Exception)((Object)err));
        }
        catch (ServiceException err) {
            ServerConfigAdminImpl.logAndConvertSystemException((Exception)((Object)err));
        }
        MMLogConfiguration result = new MMLogConfiguration();
        if (logConfig != null) {
            result.setLogLevel(logConfig.getMessageLevel());
            result.setDiscardedContexts(logConfig.getDiscardedContexts());
            HashSet contextsSet = new HashSet(LogContextsUtil.ALL_CONTEXTS);
            if (logConfig.getDiscardedContexts() != null) {
                contextsSet.removeAll(logConfig.getDiscardedContexts());
            }
            result.setIncludedContexts(contextsSet);
        }
        return result;
    }

    public void setLogConfiguration(LogConfiguration adminLogConfig) throws AdminException {
        Configuration config = null;
        try {
            config = this.getConfigurationServiceProxy().getNextStartupConfiguration();
        }
        catch (ConfigurationException err) {
            ServerConfigAdminImpl.logAndConvertSystemException((Exception)((Object)err));
        }
        catch (ServiceException err) {
            ServerConfigAdminImpl.logAndConvertSystemException((Exception)((Object)err));
        }
        if (config != null) {
            Set discardedCtx = adminLogConfig.getDiscardedContexts();
            HashSet includedCtx = adminLogConfig.getIncludedContexts();
            if (discardedCtx.contains("CTX_ALL") && includedCtx.contains("CTX_ALL")) {
                return;
            }
            if (discardedCtx.contains("CTX_ALL")) {
                discardedCtx = new HashSet(LogContextsUtil.ALL_CONTEXTS);
                includedCtx = Collections.EMPTY_SET;
            } else if (includedCtx.contains("CTX_ALL")) {
                includedCtx = new HashSet(LogContextsUtil.ALL_CONTEXTS);
                discardedCtx = Collections.EMPTY_SET;
            }
            com.metamatrix.common.log.LogConfiguration logConfig = config.getLogConfiguration();
            logConfig.setMessageLevel(adminLogConfig.getLogLevel());
            logConfig.recordContexts(includedCtx);
            logConfig.discardContexts(discardedCtx);
            LogManager.setLogConfiguration((com.metamatrix.common.log.LogConfiguration)logConfig);
            ConfigurationObjectEditor coe = null;
            try {
                coe = this.getConfigurationServiceProxy().createEditor();
                coe.setLogConfiguration(config, logConfig);
                ModificationActionQueue maq = coe.getDestination();
                List actions = maq.popActions();
                this.getRuntimeStateAdminAPIHelper().setLogConfiguration(this.getMetaMatrixRegistry(), config, logConfig, actions, this.getUserName());
            }
            catch (Exception theException) {
                ServerConfigAdminImpl.logAndConvertSystemException(theException);
            }
        }
    }

    public void setSystemProperty(String propertyName, String propertyValue) throws AdminException {
        if (propertyName == null) {
            throw new IllegalArgumentException(AdminPlugin.Util.getString("ServerConfigAdminImpl.Property_name_can_not_be_null"));
        }
        try {
            this.getConfigurationServiceProxy().setSystemPropertyValue(propertyName, propertyValue, this.getUserName());
        }
        catch (Exception theException) {
            ServerConfigAdminImpl.logAndConvertSystemException(theException);
        }
    }

    public void updateSystemProperties(Properties properties) throws AdminException {
        try {
            this.getConfigurationServiceProxy().updateSystemPropertyValues(properties, this.getUserName());
        }
        catch (Exception theException) {
            ServerConfigAdminImpl.logAndConvertSystemException(theException);
        }
    }

    public void setProperty(String identifier, String className, String propertyName, String propertyValue) throws AdminException {
        Properties properties = new Properties();
        properties.setProperty(propertyName, propertyValue);
        this.updateProperties(identifier, className, properties);
    }

    public void updateProperties(String identifier, String className, Properties properties) throws AdminException {
        Collection adminObjects = this.getAdminObjects(identifier, className);
        if (adminObjects == null || adminObjects.size() == 0) {
            this.throwProcessingException("ServerConfigAdminImpl.No_Objects_Found", new Object[]{identifier, className});
        }
        if (adminObjects.size() > 1) {
            this.throwProcessingException("ServerConfigAdminImpl.Multiple_Objects_Found", new Object[]{identifier, className});
        }
        AdminObject adminObject = (AdminObject)adminObjects.iterator().next();
        int type = MMAdminObject.getObjectType((String)className);
        switch (type) {
            case 19: {
                this.updateSystemProperties(properties);
                break;
            }
            case 8: {
                String hostName = adminObject.getName();
                com.metamatrix.common.config.api.Host host = this.getHostByName(hostName);
                Properties hostProperties = host.getProperties();
                hostProperties.putAll((Map<?, ?>)properties);
                try {
                    com.metamatrix.common.config.api.Host updatedHost = (com.metamatrix.common.config.api.Host)this.getConfigurationServiceProxy().modify((ComponentObject)host, hostProperties, this.getUserName());
                    if (updatedHost != null) break;
                    this.throwProcessingException("ServerConfigAdminImpl.Host_was_null_when_updating_properties", new Object[]{hostName});
                }
                catch (Exception theException) {
                    ServerConfigAdminImpl.logAndConvertSystemException(theException);
                }
                break;
            }
            case 11: {
                ProcessObject process = (ProcessObject)adminObject;
                String processName = adminObject.getName();
                String hostName = process.getHostIdentifier();
                try {
                    VMComponentDefn vmDefn = this.getVMByName(hostName, processName);
                    Properties processProperties = vmDefn.getProperties();
                    processProperties.putAll((Map<?, ?>)properties);
                    VMComponentDefn updatedProcess = (VMComponentDefn)this.getConfigurationServiceProxy().modify((ComponentObject)vmDefn, processProperties, this.getUserName());
                    if (updatedProcess != null) break;
                    this.throwProcessingException("ServerConfigAdminImpl.Process_was_null_when_updating_properties", new Object[]{processName});
                }
                catch (Exception theException) {
                    ServerConfigAdminImpl.logAndConvertSystemException(theException);
                }
                break;
            }
            case 2: {
                String connectorBindingName = adminObject.getName();
                try {
                    ConnectorBinding connectorBinding = this.getConnectorBindingByName(connectorBindingName);
                    Properties bindingProperties = connectorBinding.getProperties();
                    bindingProperties.putAll((Map<?, ?>)properties);
                    ConnectorBinding updatedConnectorBinding = (ConnectorBinding)this.getConfigurationServiceProxy().modify((ComponentObject)connectorBinding, bindingProperties, this.getUserName());
                    if (updatedConnectorBinding != null) break;
                    this.throwProcessingException("ServerConfigAdminImpl.Connector_Binding_was_null_when_updating_properties", new Object[]{connectorBindingName});
                }
                catch (Exception theException) {
                    ServerConfigAdminImpl.logAndConvertSystemException(theException);
                }
                break;
            }
            default: {
                this.throwProcessingException("ServerConfigAdminImpl.Unsupported_Admin_Object", new Object[]{className});
            }
        }
    }

    private ConnectorBinding getConnectorBindingByName(String name) throws ConfigurationException, ServiceException {
        Configuration nextStartupConfig = this.getConfigurationServiceProxy().getNextStartupConfiguration();
        ConnectorBinding cb = nextStartupConfig.getConnectorBinding(name);
        return cb;
    }

    public void assignBindingToModel(String connectorBindingName, String vdbName, String vdbVersion, String modelName) throws AdminException {
        block7: {
            try {
                ConnectorBinding newBinding = this.getConnectorBindingByName(connectorBindingName);
                if (newBinding != null) {
                    Collection colVdbs = RuntimeMetadataCatalog.getVirtualDatabases();
                    if (colVdbs == null) break block7;
                    Iterator iter = colVdbs.iterator();
                    while (iter.hasNext()) {
                        VirtualDatabase vdb = (VirtualDatabase)iter.next();
                        if (!vdb.getName().equals(vdbName) || !vdb.getVirtualDatabaseID().getVersion().equals(vdbVersion)) continue;
                        VirtualDatabaseID vdbId = (VirtualDatabaseID)vdb.getID();
                        Collection models = RuntimeMetadataCatalog.getModels((VirtualDatabaseID)vdbId);
                        if (models != null) {
                            HashMap<String, List> map = new HashMap<String, List>(models.size());
                            Iterator modelIter = models.iterator();
                            while (modelIter.hasNext()) {
                                Model model = (Model)modelIter.next();
                                if (model.getName().equals(modelName)) {
                                    ArrayList<String> bindings = new ArrayList<String>(1);
                                    bindings.add(newBinding.getRoutingUUID());
                                    map.put(model.getName(), bindings);
                                    continue;
                                }
                                map.put(model.getName(), model.getConnectorBindingNames());
                            }
                            this.checkSourceLicense(map.keySet().size());
                            this.setConnectorBindingNames(vdbId, map);
                        }
                        this.setVDBState(vdbId, 3);
                        break block7;
                    }
                    break block7;
                }
                this.throwProcessingException("ServerConfigAdminImpl.Connector_Binding_not_found_in_Configuration");
            }
            catch (Exception theException) {
                ServerConfigAdminImpl.logAndConvertSystemException(theException);
            }
        }
    }

    private void setConnectorBindingNames(VirtualDatabaseID vdbId, Map mapModelsToConnBinds) throws Exception {
        RuntimeMetadataCatalog.setConnectorBindingNames((VirtualDatabaseID)vdbId, (Map)mapModelsToConnBinds, (String)this.getUserName());
    }

    private void setVDBState(VirtualDatabaseID vdbID, int siState) throws Exception {
        RuntimeMetadataCatalog.setVDBStatus((VirtualDatabaseID)vdbID, (short)((short)siState), (String)this.getUserName());
    }

    public void deleteConnectorBinding(String connectorBindingIdentifier) throws AdminException {
        com.metamatrix.admin.api.objects.ConnectorBinding theBinding;
        Collection binding = this.parent.getConnectorBindings(connectorBindingIdentifier);
        if (binding != null && binding.size() > 0 && (theBinding = (com.metamatrix.admin.api.objects.ConnectorBinding)binding.iterator().next()) != null && theBinding.getState() == 1) {
            try {
                this.shutDownConnectorBinding((MMConnectorBinding)theBinding, true);
            }
            catch (Exception err) {
                // empty catch block
            }
        }
        String connectorBindingName = this.getName(connectorBindingIdentifier);
        Configuration nextStartupConfig = null;
        try {
            nextStartupConfig = this.getConfigurationServiceProxy().getNextStartupConfiguration();
        }
        catch (ConfigurationException err) {
            ServerConfigAdminImpl.logAndConvertSystemException((Exception)((Object)err));
        }
        catch (ServiceException err) {
            ServerConfigAdminImpl.logAndConvertSystemException((Exception)((Object)err));
        }
        if (nextStartupConfig == null) {
            return;
        }
        ServiceComponentDefn service = null;
        try {
            service = this.getServiceByName(connectorBindingName);
        }
        catch (InvalidSessionException err) {
            ServerConfigAdminImpl.logAndConvertSystemException((Exception)((Object)err));
        }
        catch (AuthorizationException err) {
            ServerConfigAdminImpl.logAndConvertSystemException((Exception)((Object)err));
        }
        catch (ConfigurationException err) {
            ServerConfigAdminImpl.logAndConvertSystemException((Exception)((Object)err));
        }
        catch (MetaMatrixComponentException err) {
            ServerConfigAdminImpl.logAndConvertSystemException((Exception)((Object)err));
        }
        if (service != null) {
            try {
                this.getConfigurationServiceProxy().delete((ComponentObject)service, false, this.getUserName());
            }
            catch (Exception theException) {
                ServerConfigAdminImpl.logAndConvertSystemException(theException);
            }
        }
        ConnectorBinding cb = nextStartupConfig.getConnectorBinding(connectorBindingName);
        if (cb == null) {
            this.throwProcessingException("ServerConfigAdminImpl.Connector_Binding_not_found_in_Configuration", new Object[]{connectorBindingName});
        } else {
            try {
                this.getConfigurationServiceProxy().delete((ComponentObject)cb, false, this.getUserName());
            }
            catch (Exception theException) {
                ServerConfigAdminImpl.logAndConvertSystemException(theException);
            }
        }
    }

    public void deleteConnectorType(String name) throws AdminException {
        ComponentType ct = this.getComponentType(name);
        if (ct == null) {
            this.throwProcessingException("ServerConfigAdminImpl.Connector_Type_not_found_in_Configuration", new Object[]{name});
        } else {
            try {
                this.getConfigurationServiceProxy().delete(ct, this.getUserName());
            }
            catch (Exception theException) {
                ServerConfigAdminImpl.logAndConvertSystemException(theException);
            }
        }
    }

    private ComponentType getComponentType(String name) throws AdminException {
        Collection types = null;
        try {
            types = this.getConfigurationServiceProxy().getAllComponentTypes(true);
        }
        catch (ConfigurationException err) {
            ServerConfigAdminImpl.logAndConvertSystemException((Exception)((Object)err));
        }
        catch (ServiceException err) {
            ServerConfigAdminImpl.logAndConvertSystemException((Exception)((Object)err));
        }
        ComponentType result = null;
        Iterator compTypes = types.iterator();
        while (compTypes.hasNext()) {
            ComponentType type = (ComponentType)compTypes.next();
            if (!type.getName().equals(name)) continue;
            result = type;
            break;
        }
        return result;
    }

    public void deleteHost(String identifier) throws AdminException {
        String hostName = this.getName(identifier);
        try {
            com.metamatrix.common.config.api.Host host = this.getHostByName(hostName);
            if (host != null) {
                this.getConfigurationServiceProxy().delete((ComponentObject)host, false, this.getUserName());
            }
        }
        catch (Exception theException) {
            ServerConfigAdminImpl.logAndConvertSystemException(theException);
        }
    }

    private com.metamatrix.common.config.api.Host getHostByName(String hostName) throws AdminException {
        com.metamatrix.common.config.api.Host theHost = null;
        try {
            theHost = this.getConfigurationServiceProxy().getHost(new HostID(hostName));
        }
        catch (ConfigurationException err) {
            ServerConfigAdminImpl.logAndConvertSystemException((Exception)((Object)err));
        }
        catch (ServiceException err) {
            ServerConfigAdminImpl.logAndConvertSystemException((Exception)((Object)err));
        }
        if (theHost == null) {
            this.throwProcessingException("ServerConfigAdminImpl.Host_not_found_in_Configuration", new Object[]{hostName});
        }
        return theHost;
    }

    private VMComponentDefn getVMByName(String hostName, String processName) throws ConfigurationException, ServiceException, MetaMatrixProcessingException, AdminException {
        VMComponentDefn result = null;
        Collection defns = this.getConfigurationServiceProxy().getCurrentConfiguration().getVMComponentDefns();
        Iterator iter = defns.iterator();
        while (iter.hasNext()) {
            VMComponentDefn defn = (VMComponentDefn)iter.next();
            if (!defn.getName().equalsIgnoreCase(processName) || !defn.getHostID().getName().equalsIgnoreCase(hostName)) continue;
            result = defn;
            break;
        }
        if (result == null) {
            Object[] params = new Object[]{processName, hostName};
            this.throwProcessingException("ServerConfigAdminImpl.Process_not_found_in_Configuration", params);
        }
        return result;
    }

    public void deleteProcess(String processIdentifier) throws AdminException {
        String processName = this.getName(processIdentifier);
        if (processName == null) {
            throw new AdminProcessingException(AdminPlugin.Util.getString("ServerConfigAdminImpl.Name_can_not_be_null"));
        }
        String hostName = this.getParent(processIdentifier);
        if (hostName == null) {
            throw new AdminProcessingException(AdminPlugin.Util.getString("ServerConfigAdminImpl.Host_name_can_not_be_null"));
        }
        try {
            VMComponentDefn vmDefn = this.getVMByName(hostName, processName);
            if (vmDefn != null) {
                this.getConfigurationServiceProxy().delete((ComponentObject)vmDefn, false, this.getUserName());
            }
        }
        catch (Exception theException) {
            ServerConfigAdminImpl.logAndConvertSystemException(theException);
        }
    }

    protected ServiceComponentDefn getServiceByName(String serviceName) throws ConfigurationException, InvalidSessionException, AuthorizationException, MetaMatrixComponentException {
        ServiceComponentDefnID serviceID = new ServiceComponentDefnID(Configuration.NEXT_STARTUP_ID, serviceName);
        return this.getServiceByID(serviceID);
    }

    protected ServiceComponentDefn getServiceByID(ServiceComponentDefnID serviceID) throws InvalidSessionException, AuthorizationException, ConfigurationException, MetaMatrixComponentException {
        ServiceComponentDefn service = (ServiceComponentDefn)this.getConfigurationServiceProxy().getComponentDefn(Configuration.NEXT_STARTUP_ID, (ComponentDefnID)serviceID);
        return service;
    }

    private AdminStatus checkDecryption(Properties properties, String connectorBindingName, String connectorTypeIdentifier) throws AdminException {
        boolean decryptable = true;
        if (decryptable) {
            return new MMAdminStatus(0, "AdminStatus.CODE_SUCCESS");
        }
        return new MMAdminStatus(-101, "AdminStatus.CODE_DECRYPTION_FAILED", (Object)connectorBindingName);
    }

    private AdminStatus checkDecryption(ConnectorBinding binding) throws AdminException {
        ArrayList<ConnectorBinding> bindings = new ArrayList<ConnectorBinding>();
        bindings.add(binding);
        List decryptables = new ArrayList();
        try {
            decryptables = this.getConfigurationServiceProxy().checkPropertiesDecryptable(bindings);
        }
        catch (ConfigurationException err) {
            ServerConfigAdminImpl.logAndConvertSystemException((Exception)((Object)err));
        }
        catch (ServiceException err) {
            ServerConfigAdminImpl.logAndConvertSystemException((Exception)((Object)err));
        }
        boolean decryptable = (Boolean)decryptables.get(0);
        if (decryptable) {
            return new MMAdminStatus(0, "AdminStatus.CODE_SUCCESS");
        }
        return new MMAdminStatus(-101, "AdminStatus.CODE_DECRYPTION_FAILED", (Object)binding.getName());
    }

    private AdminStatus checkDecryption(List bindings) throws AdminException {
        List decryptables = new ArrayList();
        try {
            decryptables = this.getConfigurationServiceProxy().checkPropertiesDecryptable(bindings);
        }
        catch (ConfigurationException err) {
            ServerConfigAdminImpl.logAndConvertSystemException((Exception)((Object)err));
        }
        catch (ServiceException err) {
            ServerConfigAdminImpl.logAndConvertSystemException((Exception)((Object)err));
        }
        ArrayList<ConnectorBinding> nonDecryptableBindings = new ArrayList<ConnectorBinding>();
        Iterator iter1 = bindings.iterator();
        Iterator iter2 = decryptables.iterator();
        while (iter1.hasNext() && iter2.hasNext()) {
            ConnectorBinding binding = (ConnectorBinding)iter1.next();
            boolean decryptable = (Boolean)iter2.next();
            if (decryptable) continue;
            nonDecryptableBindings.add(binding);
        }
        if (nonDecryptableBindings.size() == 0) {
            return new MMAdminStatus(0, "AdminStatus.CODE_SUCCESS");
        }
        return new MMAdminStatus(-101, "AdminStatus.CODE_DECRYPTION_FAILED", (Object)this.prettyPrintBindingNames(nonDecryptableBindings));
    }

    protected Collection getBindingNamesToUpdate(Collection existingBindings, Collection newBindingNames, AdminOptions options) throws AdminException {
        if (options == null) {
            options = new AdminOptions(2);
        }
        ArrayList addBindings = new ArrayList(newBindingNames.size());
        if (existingBindings == null || existingBindings.size() == 0) {
            addBindings.addAll(newBindingNames);
        } else {
            Collection existingBindingNames = this.getBindingNames(existingBindings);
            ArrayList<String> collidingBindingNames = new ArrayList<String>(existingBindingNames.size());
            ArrayList<String> nonCollidingBindingNames = new ArrayList<String>(existingBindingNames.size());
            Iterator newBindingItr = newBindingNames.iterator();
            while (newBindingItr.hasNext()) {
                String newBindingName = (String)newBindingItr.next();
                if (existingBindingNames.contains(newBindingName)) {
                    collidingBindingNames.add(newBindingName);
                    continue;
                }
                nonCollidingBindingNames.add(newBindingName);
            }
            if (collidingBindingNames.size() > 0) {
                if (options.containsOption(1)) {
                    addBindings.addAll(newBindingNames);
                } else if (options.containsOption(2)) {
                    addBindings.addAll(nonCollidingBindingNames);
                } else if (options.containsOption(4)) {
                    String msg = collidingBindingNames.size() == 1 ? AdminServerPlugin.Util.getString("ServerConfigAdminImpl.binding_exists", collidingBindingNames.toArray()) : AdminServerPlugin.Util.getString("ServerConfigAdminImpl.bindings_exist", collidingBindingNames.toArray());
                    this.throwProcessingException(msg);
                } else {
                    this.throwProcessingException(AdminServerPlugin.Util.getString("ServerConfigAdminImpl.Unknown_admin_options", new Object[]{options.toString()}));
                }
            } else {
                addBindings.addAll(nonCollidingBindingNames);
            }
        }
        return addBindings;
    }

    private Collection getBindingNames(Collection connectorBindings) {
        ArrayList<String> bindingNames = new ArrayList<String>(connectorBindings.size());
        Iterator bindingItr = connectorBindings.iterator();
        while (bindingItr.hasNext()) {
            Object aBindingObj = bindingItr.next();
            String aBindingName = null;
            aBindingName = aBindingObj instanceof ConnectorBinding ? ((ConnectorBinding)aBindingObj).getName() : ((com.metamatrix.admin.api.objects.ConnectorBinding)aBindingObj).getName();
            bindingNames.add(aBindingName);
        }
        return bindingNames;
    }

    private String prettyPrintBindingNames(List bindings) {
        StringBuffer buffer = new StringBuffer();
        Iterator iter = bindings.iterator();
        while (iter.hasNext()) {
            ConnectorBinding binding = (ConnectorBinding)iter.next();
            buffer.append(binding.getName());
            if (!iter.hasNext()) continue;
            buffer.append(", ");
        }
        return buffer.toString();
    }
}

