/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.ws.tools;

import com.sforce.ws.ConnectionException;
import com.sforce.ws.bind.NameMapper;
import com.sforce.ws.bind.TypeMapper;
import com.sforce.ws.template.Template;
import com.sforce.ws.template.TemplateException;
import com.sforce.ws.util.FileUtil;
import com.sforce.ws.wsdl.BindingOperation;
import com.sforce.ws.wsdl.Collection;
import com.sforce.ws.wsdl.ComplexType;
import com.sforce.ws.wsdl.Definitions;
import com.sforce.ws.wsdl.Element;
import com.sforce.ws.wsdl.Message;
import com.sforce.ws.wsdl.Operation;
import com.sforce.ws.wsdl.Part;
import com.sforce.ws.wsdl.SoapHeader;
import com.sforce.ws.wsdl.Types;
import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Iterator;
import javax.xml.namespace.QName;

public class ConnectionGenerator {
    private String packageName;
    private String className;
    private File tempDir;
    private static final String CONNECTION_TEMPLATE = "com/sforce/ws/tools/connection.template";
    private static final String CONNECTOR_TEMPLATE = "com/sforce/ws/tools/connector.template";
    private Definitions definitions;
    private TypeMapper typeMapper;

    public ConnectionGenerator(Definitions definitions, File tempDir, TypeMapper typeMapper, String packagePrefix) {
        this.definitions = definitions;
        this.tempDir = tempDir;
        this.typeMapper = typeMapper;
        this.packageName = NameMapper.getPackageName(definitions.getTargetNamespace(), packagePrefix);
        this.className = (definitions.getApiType() != null ? definitions.getApiType().name() : "Soap") + "Connection";
    }

    public String endpoint() {
        return this.definitions.getService().getPort().getSoapAddress().getLocation();
    }

    public String verifyEndpoint() {
        return this.definitions.getApiType() == null ? null : this.definitions.getApiType().getVerifyEndpoint();
    }

    public String getPackageName() {
        return this.packageName;
    }

    public String getClassName() {
        return this.className;
    }

    public String getPackagePrefix() {
        String prefix = this.typeMapper.getPackagePrefix();
        return prefix == null ? "null" : "\"" + prefix + "\"";
    }

    public String getTargetNamespace() {
        return this.definitions.getTargetNamespace();
    }

    public String sobjectNamespace() {
        return this.definitions.getApiType() == null ? "null" : "\"" + this.definitions.getApiType().getSobjectNamespace() + "\"";
    }

    public String dumpQNames() throws ConnectionException {
        StringBuilder sb = new StringBuilder();
        Iterator<Operation> oit = this.definitions.getPortType().getOperations();
        while (oit.hasNext()) {
            Operation operation = oit.next();
            Part in = operation.getInput().getParts().next();
            this.addQName(sb, in.getElement());
            Part out = operation.getOutput().getParts().next();
            this.addQName(sb, out.getElement());
        }
        Iterator<Part> parts = this.headers();
        while (parts.hasNext()) {
            Part hp = parts.next();
            this.addQName(sb, hp.getElement());
        }
        return sb.toString();
    }

    public String dumpKnownHeaders() throws ConnectionException {
        StringBuilder sb = new StringBuilder();
        Iterator<Part> parts = this.headers();
        while (parts.hasNext()) {
            Part hp = parts.next();
            String varName = this.qname(hp.getElement().getLocalPart());
            sb.append("  knownHeaders.put(");
            sb.append(varName).append(",");
            sb.append(this.headerType(hp)).append(".class");
            sb.append(");").append(FileUtil.EOL);
        }
        return sb.toString();
    }

    private String qname(String str) {
        return str + "_qname";
    }

    public boolean hasSessionHeader() throws ConnectionException {
        Iterator<Part> it = this.headers();
        while (it.hasNext()) {
            Part part = it.next();
            if (!part.getName().equals("SessionHeader")) continue;
            return true;
        }
        return false;
    }

    public Iterator<Part> headersFor(Operation operation) throws ConnectionException {
        BindingOperation bop = this.definitions.getBinding().getOperation(operation.getName());
        ArrayList<Part> parts = new ArrayList<Part>();
        Iterator<SoapHeader> hit = bop.getInput().getHeaders();
        while (hit.hasNext()) {
            SoapHeader sh = hit.next();
            parts.add(this.definitions.getMessage(sh.getMessage()).getPart(sh.getPart()));
        }
        return parts.iterator();
    }

    public Iterator<Part> headers() throws ConnectionException {
        return this.definitions.getBinding().getAllHeaders();
    }

    public String headerType(Part header) throws ConnectionException {
        if (this.isSimpleType(header)) {
            return "java.lang.String";
        }
        ComplexType type = this.getType(header);
        QName qn = new QName(type.getSchema().getTargetNamespace(), type.getName());
        return this.typeMapper.getJavaClassName(qn, this.definitions.getTypes(), false);
    }

    private boolean isSimpleType(Part header) throws ConnectionException {
        Types types = this.definitions.getTypes();
        Element element = types.getElement(header.getElement());
        if (!element.isComplexType()) {
            return true;
        }
        return this.typeMapper.isWellKnownType(element.getType().getNamespaceURI(), element.getType().getLocalPart());
    }

    public String headerName(Part header) {
        return header.getName();
    }

    public String headerElement(Part header) throws ConnectionException {
        return this.qname(header.getElement().getLocalPart());
    }

    private void addQName(StringBuilder sb, QName el) {
        sb.append("    private static final javax.xml.namespace.QName ");
        sb.append(this.qname(el.getLocalPart()));
        sb.append(" = new javax.xml.namespace.QName(\"");
        sb.append(el.getNamespaceURI());
        sb.append("\", \"");
        sb.append(el.getLocalPart());
        sb.append("\");");
        sb.append(FileUtil.EOL);
    }

    public String getResultCall(Operation operation) throws ConnectionException {
        Element el = this.getResponseElement(operation);
        if (el == null) {
            return "";
        }
        return "return __response.get" + NameMapper.getMethodName(el.getName()) + "();";
    }

    public String soapAction(Operation operation) throws ConnectionException {
        BindingOperation bop = this.definitions.getBinding().getOperation(operation.getName());
        String soapAction = bop.getSoapAction();
        return "\"" + soapAction + "\"";
    }

    public String returnType(Operation operation) throws ConnectionException {
        Element el = this.getResponseElement(operation);
        if (el == null) {
            return "void";
        }
        return this.getJavaClassName(el);
    }

    public Element getResponseElement(Operation operation) throws ConnectionException {
        Element result;
        ComplexType ct = this.getType(operation.getOutput());
        Collection sequence = ct.getContent();
        if (sequence == null) {
            return null;
        }
        Iterator<Element> eit = sequence.getElements();
        if (eit.hasNext()) {
            result = eit.next();
            if (eit.hasNext()) {
                throw new IllegalArgumentException("Operation.output got more than one element:" + operation);
            }
        } else {
            result = null;
        }
        return result;
    }

    public String headerArgs(Part header) throws ConnectionException {
        Iterator<Element> eit = this.headerElements(header);
        return this.toArgs(eit);
    }

    public Iterator<Element> headerElements(Part header) throws ConnectionException {
        if (this.isSimpleType(header)) {
            ArrayList list = new ArrayList();
            return list.iterator();
        }
        ComplexType ct = this.getType(header);
        Collection sequence = ct.getContent();
        return sequence.getElements();
    }

    public String getArgs(Operation operation) throws ConnectionException {
        Iterator<Element> eit = this.argElements(operation);
        return this.toArgs(eit);
    }

    private String toArgs(Iterator<Element> eit) {
        StringBuilder sb = new StringBuilder();
        while (eit.hasNext()) {
            Element el = eit.next();
            String clazz = this.getJavaClassName(el);
            sb.append(clazz).append(" ").append(this.argName(el));
            if (!eit.hasNext()) continue;
            sb.append(",");
        }
        return sb.toString();
    }

    public String argSetMethod(Element element) {
        return "set" + NameMapper.getMethodName(element.getName());
    }

    public String argName(Element element) {
        return element.getName();
    }

    public Iterator<Element> argElements(Operation operation) throws ConnectionException {
        ComplexType ct = this.getType(operation.getInput());
        Collection sequence = ct.getContent();
        return sequence == null ? new ArrayList().iterator() : sequence.getElements();
    }

    public String getJavaClassName(Element el) {
        String clazz = this.typeMapper.getJavaClassName(el.getType(), this.definitions.getTypes(), el.isNillable());
        if (el.getMaxOccurs() != 1) {
            clazz = clazz + "[]";
        }
        return clazz;
    }

    public String loginResult() throws ConnectionException {
        QName ln = new QName(this.definitions.getTargetNamespace(), "login");
        Operation op = this.definitions.getPortType().getOperation(ln);
        return this.returnType(op);
    }

    public String responseName(Operation operation) throws ConnectionException {
        return this.qname(operation.getOutput().getParts().next().getElement().getLocalPart());
    }

    public String requestName(Operation operation) throws ConnectionException {
        return this.qname(operation.getInput().getParts().next().getElement().getLocalPart());
    }

    public String responseType(Operation operation) throws ConnectionException {
        ComplexType ct = this.getType(operation.getOutput());
        QName type = new QName(ct.getSchema().getTargetNamespace(), ct.getName());
        return this.typeMapper.getJavaClassName(type, this.definitions.getTypes(), false);
    }

    public String requestType(Operation operation) throws ConnectionException {
        ComplexType ct = this.getType(operation.getInput());
        QName type = new QName(ct.getSchema().getTargetNamespace(), ct.getName());
        return this.typeMapper.getJavaClassName(type, this.definitions.getTypes(), false);
    }

    private ComplexType getType(Message message) throws ConnectionException {
        Iterator<Part> it = message.getParts();
        if (!it.hasNext()) {
            throw new IllegalArgumentException("Input for operation " + message + " does not have a part");
        }
        Part part = it.next();
        if (it.hasNext()) {
            throw new IllegalArgumentException("Found more than one part for operation " + message);
        }
        return this.getType(part);
    }

    private ComplexType getType(Part part) throws ConnectionException {
        Types types = this.definitions.getTypes();
        Element element = types.getElement(part.getElement());
        QName type = element.getType();
        return types.getComplexType(type);
    }

    public Iterator<Operation> getOperations() {
        return this.definitions.getPortType().getOperations();
    }

    public String getOperationName(Operation operation) {
        return operation.getName().getLocalPart();
    }

    public String generateConnector() throws IOException, TemplateException {
        return this.generate(CONNECTOR_TEMPLATE, "Connector");
    }

    public boolean hasLoginCall() {
        return this.definitions.getApiType() != null && this.definitions.getApiType().hasLoginCall();
    }

    public String generateConnection() throws IOException, TemplateException {
        return this.generate(CONNECTION_TEMPLATE, this.className);
    }

    public String generate(String templateFile, String className) throws IOException, TemplateException {
        File dir = FileUtil.mkdirs(this.packageName, this.tempDir);
        Template template = new Template();
        template.setProperty("gen", this);
        File javaFile = new File(dir, className + ".java");
        template.exec(templateFile, javaFile.getAbsolutePath());
        return javaFile.getAbsolutePath();
    }
}

