/*
 * Decompiled with CFR 0.152.
 */
package com.sforce.async;

import com.sforce.ws.parser.XmlOutputStream;
import java.io.IOException;
import java.util.Collections;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;

public final class SObject {
    private static final int MAX_DEPTH = 5;
    private final HashMap<String, String> fields = new HashMap();
    private final HashMap<String, SObject> fkRefs = new HashMap();

    public Set<String> getFieldNames() {
        return Collections.unmodifiableSet(this.fields.keySet());
    }

    public String getField(String name) {
        return this.fields.get(name);
    }

    public void setField(String name, String value) {
        this.fields.put(name, value);
    }

    public void setFieldReference(String name, SObject ref) {
        if (ref == this) {
            throw new IllegalStateException("Foreign Key SObject Reference is pointing to the same SObject");
        }
        this.fkRefs.put(name, ref);
    }

    public void write(XmlOutputStream out) throws IOException {
        this.write(out, 0);
    }

    public void write(XmlOutputStream out, int depth) throws IOException {
        if (depth > 5) {
            throw new IllegalStateException("foreign key reference exceeded the maximum allowed depth of 5");
        }
        out.writeStartTag("http://www.force.com/2009/06/asyncapi/dataload", "sObject");
        for (Map.Entry<String, String> entry : this.fields.entrySet()) {
            String name = entry.getKey();
            String value = entry.getValue();
            out.writeStringElement("http://www.force.com/2009/06/asyncapi/dataload", name, value);
        }
        for (Map.Entry<String, Object> entry : this.fkRefs.entrySet()) {
            String relationshipName = entry.getKey();
            SObject ref = (SObject)entry.getValue();
            out.writeStartTag("http://www.force.com/2009/06/asyncapi/dataload", relationshipName);
            ref.write(out, depth++);
            out.writeEndTag("http://www.force.com/2009/06/asyncapi/dataload", relationshipName);
        }
        out.writeEndTag("http://www.force.com/2009/06/asyncapi/dataload", "sObject");
    }
}

