/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc.db2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import org.teiid.language.Function;
import org.teiid.language.Literal;
import org.teiid.translator.Translator;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.TranslatorProperty;
import org.teiid.translator.jdbc.FunctionModifier;
import org.teiid.translator.jdbc.Version;
import org.teiid.translator.jdbc.db2.BaseDB2ExecutionFactory;

@Translator(name="db2", description="A translator for IBM DB2 Database")
public class DB2ExecutionFactory
extends BaseDB2ExecutionFactory {
    public static final Version EIGHT_0 = Version.getVersion("8.0");
    public static final Version NINE_1 = Version.getVersion("9.1");
    public static final Version FIVE_4 = Version.getVersion("5.4");
    public static final Version SIX_1 = Version.getVersion("6.1");
    private boolean dB2ForI;

    @Override
    public List<String> getSupportedFunctions() {
        ArrayList<String> supportedFunctions = new ArrayList<String>();
        supportedFunctions.addAll(super.getSupportedFunctions());
        supportedFunctions.add("ABS");
        supportedFunctions.add("ACOS");
        supportedFunctions.add("ASIN");
        supportedFunctions.add("ATAN");
        supportedFunctions.add("ATAN2");
        supportedFunctions.add("CEILING");
        supportedFunctions.add("COS");
        supportedFunctions.add("COT");
        supportedFunctions.add("DEGREES");
        supportedFunctions.add("EXP");
        supportedFunctions.add("FLOOR");
        supportedFunctions.add("LOG");
        supportedFunctions.add("LOG10");
        supportedFunctions.add("MOD");
        supportedFunctions.add("POWER");
        supportedFunctions.add("RADIANS");
        supportedFunctions.add("SIGN");
        supportedFunctions.add("SIN");
        supportedFunctions.add("SQRT");
        supportedFunctions.add("TAN");
        supportedFunctions.add("CHAR");
        supportedFunctions.add("CHR");
        supportedFunctions.add("CONCAT");
        supportedFunctions.add("||");
        supportedFunctions.add("LCASE");
        supportedFunctions.add("LENGTH");
        supportedFunctions.add("LEFT");
        supportedFunctions.add("LOCATE");
        supportedFunctions.add("LOWER");
        supportedFunctions.add("LTRIM");
        supportedFunctions.add("RAND");
        supportedFunctions.add("REPLACE");
        supportedFunctions.add("RIGHT");
        supportedFunctions.add("RTRIM");
        supportedFunctions.add("SUBSTRING");
        supportedFunctions.add("trim");
        supportedFunctions.add("UCASE");
        supportedFunctions.add("UPPER");
        supportedFunctions.add("HOUR");
        supportedFunctions.add("MONTH");
        supportedFunctions.add("MONTHNAME");
        supportedFunctions.add("YEAR");
        supportedFunctions.add("DAY");
        supportedFunctions.add("DAYNAME");
        supportedFunctions.add("DAYOFMONTH");
        supportedFunctions.add("DAYOFWEEK");
        supportedFunctions.add("DAYOFYEAR");
        supportedFunctions.add("QUARTER");
        supportedFunctions.add("MINUTE");
        supportedFunctions.add("SECOND");
        supportedFunctions.add("QUARTER");
        supportedFunctions.add("WEEK");
        supportedFunctions.add("CAST");
        supportedFunctions.add("CONVERT");
        supportedFunctions.add("IFNULL");
        supportedFunctions.add("NVL");
        supportedFunctions.add("COALESCE");
        return supportedFunctions;
    }

    public boolean supportsFunctionsInGroupBy() {
        return !this.dB2ForI;
    }

    public boolean supportsAggregatesEnhancedNumeric() {
        return true;
    }

    public boolean supportsCommonTableExpressions() {
        return true;
    }

    public boolean supportsRowLimit() {
        return true;
    }

    public boolean supportsElementaryOlapOperations() {
        return this.getVersion().compareTo(this.isdB2ForI() ? SIX_1 : NINE_1) >= 0;
    }

    @Override
    public void start() throws TranslatorException {
        super.start();
        this.registerFunctionModifier("trim", new FunctionModifier(){

            @Override
            public List<?> translate(Function function) {
                List p = function.getParameters();
                return Arrays.asList("STRIP(", p.get(2), ", ", ((Literal)p.get(0)).getValue(), ", ", p.get(1), ")");
            }
        });
    }

    @TranslatorProperty(display="Is DB2 for i", description="If the server is DB2 for i (formally known as DB2/AS).", advanced=true)
    public boolean isdB2ForI() {
        return this.dB2ForI;
    }

    public void setdB2ForI(boolean dB2ForI) {
        this.dB2ForI = dB2ForI;
    }

    @Override
    protected boolean usesDatabaseVersion() {
        return true;
    }
}

