/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.jdbc;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.LanguageFactory;
import org.teiid.translator.TypeFacility;
import org.teiid.translator.jdbc.AliasModifier;

public class ModFunctionModifier
extends AliasModifier {
    private Set<Class<?>> supportedTypes = new HashSet<Class>(Arrays.asList(TypeFacility.RUNTIME_TYPES.INTEGER, TypeFacility.RUNTIME_TYPES.LONG));
    private LanguageFactory langFactory;

    public ModFunctionModifier(String modFunction, LanguageFactory langFactory) {
        this(modFunction, langFactory, null);
    }

    public ModFunctionModifier(String modFunction, LanguageFactory langFactory, Collection<? extends Class<?>> supportedTypes) {
        super(modFunction);
        this.langFactory = langFactory;
        if (supportedTypes != null) {
            this.supportedTypes.addAll(supportedTypes);
        }
    }

    @Override
    public List<?> translate(Function function) {
        List expressions = function.getParameters();
        Class type = function.getType();
        if (this.supportedTypes.contains(type)) {
            this.modify(function);
            return null;
        }
        Function divide = this.langFactory.createFunction("/", new ArrayList(expressions), type);
        Function abs = this.langFactory.createFunction("abs", Arrays.asList(divide), type);
        Function floor = this.langFactory.createFunction("floor", Arrays.asList(abs), type);
        Function sign = this.langFactory.createFunction("sign", Arrays.asList((Expression)expressions.get(0)), type);
        List<Function> multArgs = Arrays.asList(sign, floor, this.langFactory.createFunction("abs", Arrays.asList((Expression)expressions.get(1)), type));
        Function mult = this.langFactory.createFunction("*", multArgs, type);
        List<Expression> minusArgs = Arrays.asList((Expression)expressions.get(0), mult);
        return Arrays.asList(this.langFactory.createFunction("-", minusArgs, type));
    }
}

