/*
 * Decompiled with CFR 0.152.
 */
package org.core4j.xml;

import java.util.ArrayList;
import java.util.List;
import org.core4j.Enumerable;
import org.core4j.Predicates;
import org.core4j.xml.XAttribute;
import org.core4j.xml.XContainer;
import org.core4j.xml.XName;
import org.core4j.xml.XNameable;
import org.core4j.xml.XNode;
import org.core4j.xml.XText;
import org.core4j.xml.XmlFormat;
import org.core4j.xml.XmlNodeType;
import org.core4j.xml.XmlUtil;

public class XElement
extends XContainer
implements XNameable {
    private XName xname;
    private final List<XAttribute> attributes = new ArrayList<XAttribute>();

    public XElement(String name, Object ... content) {
        this.xname = new XName(null, name);
        for (Object obj : content) {
            this.add(obj);
        }
    }

    @Override
    public void add(Object content) {
        if (content instanceof XAttribute) {
            this.attributes.add((XAttribute)content);
        } else {
            super.add(content);
        }
    }

    @Override
    public XmlNodeType getNodeType() {
        return XmlNodeType.ELEMENT;
    }

    public Enumerable<XAttribute> attributes() {
        return Enumerable.create(this.attributes);
    }

    public XAttribute attribute(String name) {
        return this.attributes().firstOrNull(Predicates.xnameEquals(name));
    }

    @Override
    protected XElement getXElement() {
        return this;
    }

    @Override
    public XName getName() {
        return this.xname;
    }

    @Override
    public String toString() {
        return this.toString(XmlFormat.NOT_INDENTED);
    }

    @Override
    public String toString(XmlFormat format) {
        boolean enableIndent = format.isIndentEnabled();
        String indent = enableIndent ? this.getIndent(format) : "";
        String newline = enableIndent ? "\n" : "";
        String tagName = this.getName().getLocalName();
        StringBuilder sb = new StringBuilder();
        sb.append(indent);
        sb.append('<');
        sb.append(tagName);
        for (XAttribute att : this.attributes) {
            sb.append(' ');
            sb.append(att.getName().getLocalName());
            sb.append("=\"");
            sb.append(XmlUtil.escapeAttributeValue(att.getValue()));
            sb.append('\"');
        }
        List<XNode> nodes = this.nodes().toList();
        if (nodes.size() == 0) {
            sb.append(" />");
        } else {
            sb.append('>');
            boolean onlyText = true;
            for (XNode node : this.nodes()) {
                if (node.getNodeType() == XmlNodeType.TEXT) {
                    sb.append(node.toString(format));
                    continue;
                }
                onlyText = false;
                sb.append(newline);
                sb.append(node.toString(format.incrementLevel()));
            }
            if (!onlyText) {
                sb.append(newline + indent);
            }
            sb.append("</");
            sb.append(tagName);
            sb.append('>');
        }
        return sb.toString();
    }

    public String getValue() {
        XText firstText = this.nodes().ofType(XText.class).firstOrNull();
        return firstText == null ? null : firstText.getValue();
    }
}

