/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.mongodb;

import com.mongodb.MongoClientOptions;
import com.mongodb.MongoCredential;
import com.mongodb.ServerAddress;
import java.net.UnknownHostException;
import java.util.ArrayList;
import java.util.List;
import java.util.StringTokenizer;
import javax.resource.ResourceException;
import javax.resource.spi.InvalidPropertyException;
import org.teiid.core.BundleUtil;
import org.teiid.resource.adapter.mongodb.MongoDBConnectionImpl;
import org.teiid.resource.spi.BasicConnectionFactory;
import org.teiid.resource.spi.BasicManagedConnectionFactory;

public class MongoDBManagedConnectionFactory
extends BasicManagedConnectionFactory {
    private static final long serialVersionUID = -4945630936957298180L;
    public static final BundleUtil UTIL = BundleUtil.getBundleUtil(MongoDBManagedConnectionFactory.class);
    private String remoteServerList = null;
    private String username;
    private String password;
    private String database;

    public BasicConnectionFactory<MongoDBConnectionImpl> createConnectionFactory() throws ResourceException {
        if (this.remoteServerList == null) {
            throw new InvalidPropertyException(UTIL.getString("no_server"));
        }
        if (this.database == null) {
            throw new InvalidPropertyException(UTIL.getString("no_database"));
        }
        final List<ServerAddress> servers = this.getServers();
        final MongoClientOptions options = MongoClientOptions.builder().build();
        return new BasicConnectionFactory<MongoDBConnectionImpl>(){

            public MongoDBConnectionImpl getConnection() throws ResourceException {
                MongoCredential credential = null;
                if (MongoDBManagedConnectionFactory.this.username != null && MongoDBManagedConnectionFactory.this.password != null) {
                    credential = MongoCredential.createMongoCRCredential((String)MongoDBManagedConnectionFactory.this.username, (String)MongoDBManagedConnectionFactory.this.database, (char[])MongoDBManagedConnectionFactory.this.password.toCharArray());
                }
                return new MongoDBConnectionImpl(MongoDBManagedConnectionFactory.this.database, servers, credential, options);
            }
        };
    }

    public String getRemoteServerList() {
        return this.remoteServerList;
    }

    public void setRemoteServerList(String remoteServerList) {
        this.remoteServerList = remoteServerList;
    }

    public String getUsername() {
        return this.username;
    }

    public void setUsername(String username) {
        this.username = username;
    }

    public String getPassword() {
        return this.password;
    }

    public void setPassword(String googlePassword) {
        this.password = googlePassword;
    }

    public String getDatabase() {
        return this.database;
    }

    public void setDatabase(String database) {
        this.database = database;
    }

    protected List<ServerAddress> getServers() throws ResourceException {
        ArrayList<ServerAddress> addresses = new ArrayList<ServerAddress>();
        StringTokenizer st = new StringTokenizer(this.getRemoteServerList(), ";");
        while (st.hasMoreTokens()) {
            String token = st.nextToken();
            int idx = token.indexOf(58);
            if (idx < 0) {
                throw new InvalidPropertyException(UTIL.getString("no_database"));
            }
            try {
                addresses.add(new ServerAddress(token.substring(0, idx), Integer.valueOf(token.substring(idx + 1)).intValue()));
            }
            catch (UnknownHostException e) {
                throw new ResourceException((Throwable)e);
            }
        }
        return addresses;
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + (this.remoteServerList == null ? 0 : this.remoteServerList.hashCode());
        result = 31 * result + (this.database == null ? 0 : this.database.hashCode());
        result = 31 * result + (this.username == null ? 0 : this.username.hashCode());
        result = 31 * result + (this.password == null ? 0 : this.password.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (((Object)((Object)this)).getClass() != obj.getClass()) {
            return false;
        }
        MongoDBManagedConnectionFactory other = (MongoDBManagedConnectionFactory)((Object)obj);
        if (!MongoDBManagedConnectionFactory.checkEquals((Object)this.remoteServerList, (Object)other.remoteServerList)) {
            return false;
        }
        if (!MongoDBManagedConnectionFactory.checkEquals((Object)this.database, (Object)other.database)) {
            return false;
        }
        if (!MongoDBManagedConnectionFactory.checkEquals((Object)this.username, (Object)other.username)) {
            return false;
        }
        return MongoDBManagedConnectionFactory.checkEquals((Object)this.password, (Object)other.password);
    }
}

