/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.google.metadata;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.teiid.resource.adapter.google.common.Util;
import org.teiid.resource.adapter.google.metadata.Column;

public class Worksheet {
    private String name;
    private List<Column> columns = Collections.emptyList();

    public List<Column> getColumns() {
        return this.columns;
    }

    public void setColumns(List<Column> columns) {
        this.columns = columns;
    }

    public void setColumnCount(int columnCount) {
        if (columnCount == 0) {
            this.columns = Collections.emptyList();
        } else {
            this.columns = new ArrayList<Column>(columnCount);
            for (int i = 1; i <= columnCount; ++i) {
                Column newCol = new Column();
                newCol.setAlphaName(Util.convertColumnIDtoString(i));
                this.columns.add(newCol);
            }
        }
    }

    public Worksheet(String name) {
        this.name = name;
    }

    public String getName() {
        return this.name;
    }

    public int getColumnCount() {
        return this.columns.size();
    }
}

