/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.google.dataprotocol;

import java.io.IOException;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UnsupportedEncodingException;
import java.net.URLEncoder;
import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.impl.client.DefaultHttpClient;
import org.teiid.logging.LogManager;
import org.teiid.resource.adapter.google.auth.AuthHeaderFactory;
import org.teiid.resource.adapter.google.common.GDataAPI;
import org.teiid.resource.adapter.google.common.SheetRow;
import org.teiid.resource.adapter.google.common.SpreadsheetAuthException;
import org.teiid.resource.adapter.google.common.SpreadsheetOperationException;
import org.teiid.resource.adapter.google.dataprotocol.GoogleJSONParser;
import org.teiid.resource.adapter.google.metadata.Column;
import org.teiid.resource.adapter.google.metadata.SpreadsheetColumnType;
import org.teiid.resource.adapter.google.result.PartialResultExecutor;
import org.teiid.resource.adapter.google.result.RowsResult;

public class GoogleDataProtocolAPI {
    private GDataAPI spreadsheetBrowser = null;
    private AuthHeaderFactory headerFactory = null;
    public static String ENCODING = "UTF-8";
    private GoogleJSONParser parser = new GoogleJSONParser();

    public AuthHeaderFactory getHeaderFactory() {
        return this.headerFactory;
    }

    public void setHeaderFactory(AuthHeaderFactory headerFactory) {
        this.headerFactory = headerFactory;
    }

    public void setSpreadSheetBrowser(GDataAPI spreadsheetBrowser) {
        this.spreadsheetBrowser = spreadsheetBrowser;
    }

    public RowsResult executeQuery(String spreadsheetTitle, String worksheetTitle, String query, int batchSize, Integer offset, Integer limit) {
        String key = this.spreadsheetBrowser.getSpreadsheetKeyByTitle(spreadsheetTitle);
        RowsResult result = new RowsResult(new DataProtocolQueryStrategy(key, worksheetTitle, query), batchSize);
        if (offset != null) {
            result.setOffset(offset);
        }
        if (limit != null) {
            result.setLimit(limit);
        }
        return result;
    }

    public List<Column> getMetadata(String spreadsheetTitle, String worksheetTitle) {
        String key = this.spreadsheetBrowser.getSpreadsheetKeyByTitle(spreadsheetTitle);
        DataProtocolQueryStrategy dpqs = new DataProtocolQueryStrategy(key, worksheetTitle, "SELECT *");
        dpqs.setRetrieveMetadata(true);
        dpqs.getResultsBatch(0, 1);
        return dpqs.getMetadata();
    }

    public class DataProtocolQueryStrategy
    implements PartialResultExecutor {
        private String spreadsheetKey;
        private String worksheetName;
        private String urlEncodedQuery;
        private boolean retrieveMetadata;
        private List<Column> metadata;

        public DataProtocolQueryStrategy(String key, String worksheetKey, String query) {
            this.spreadsheetKey = key;
            this.worksheetName = worksheetKey;
            try {
                this.urlEncodedQuery = URLEncoder.encode(query, ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                throw new SpreadsheetOperationException(e);
            }
        }

        public void setRetrieveMetadata(boolean retrieveMetadata) {
            this.retrieveMetadata = retrieveMetadata;
        }

        public List<Column> getMetadata() {
            return this.metadata;
        }

        @Override
        public List<SheetRow> getResultsBatch(int startIndex, int amount) {
            String boundariedQuery = null;
            String worksheet = null;
            try {
                boundariedQuery = this.getQueryWithBoundaries(amount, Math.max(0, startIndex));
                worksheet = URLEncoder.encode(this.worksheetName, ENCODING);
            }
            catch (UnsupportedEncodingException e) {
                throw new SpreadsheetOperationException(e);
            }
            HttpGet get = new HttpGet("https://spreadsheets.google.com/tq?key=" + this.spreadsheetKey + "&sheet=" + worksheet + "&tqx=responseHandler:x;out:json&tq=" + boundariedQuery);
            get.setHeader("GData-Version", "3.0");
            get.setHeader("Authorization", GoogleDataProtocolAPI.this.headerFactory.getAuthHeader());
            try {
                DefaultHttpClient client = new DefaultHttpClient();
                try {
                    return this.executeAndParse((HttpClient)client, get);
                }
                catch (SpreadsheetAuthException e) {
                    GoogleDataProtocolAPI.this.headerFactory.login();
                    get.setHeader("Authorization", GoogleDataProtocolAPI.this.headerFactory.getAuthHeader());
                    return this.executeAndParse((HttpClient)client, get);
                }
            }
            catch (IOException e) {
                throw new SpreadsheetOperationException("Error retrieving batch from Gogole Visualization Data protocol", e);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private List<SheetRow> executeAndParse(HttpClient client, HttpGet get) throws IOException {
            HttpResponse response = client.execute((HttpUriRequest)get);
            if (response.getStatusLine().getStatusCode() == 200) {
                Reader reader = null;
                try {
                    reader = new InputStreamReader(response.getEntity().getContent(), Charset.forName(ENCODING));
                    Map jsonResponse = (Map)GoogleDataProtocolAPI.this.parser.parseObject(reader, true);
                    String status = (String)jsonResponse.get("status");
                    if ("error".equals(status)) {
                        List errors = (List)jsonResponse.get("errors");
                        ArrayList<String> reasons = new ArrayList<String>();
                        for (Map map : errors) {
                            String reason = (String)map.get("reason");
                            if ("user_not_authenticated".equals(reason)) {
                                throw new SpreadsheetAuthException("User not authenticated");
                            }
                            reasons.add(reason);
                        }
                        LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"Google request failed", errors});
                        throw new SpreadsheetOperationException(((Object)reasons).toString());
                    }
                    Map table = (Map)jsonResponse.get("table");
                    if (this.retrieveMetadata) {
                        List cols = (List)table.get("cols");
                        this.metadata = new ArrayList<Column>(cols.size());
                        for (Map col : cols) {
                            String type;
                            Column c = new Column();
                            c.setAlphaName((String)col.get("id"));
                            String label = (String)col.get("label");
                            if (label != null && !label.isEmpty()) {
                                c.setLabel(label);
                            }
                            if ((type = (String)col.get("type")) == null) continue;
                            c.setDataType(SpreadsheetColumnType.valueOf(type.toUpperCase()));
                        }
                    }
                    ArrayList<SheetRow> result = new ArrayList<SheetRow>();
                    List rows = (List)table.get("rows");
                    for (Map row : rows) {
                        SheetRow returnRow = new SheetRow();
                        List vals = (List)row.get("c");
                        for (Map val : vals) {
                            if (val == null) {
                                returnRow.addColumn(null);
                                continue;
                            }
                            Object object = val.get("v");
                            returnRow.addColumn(object);
                        }
                        result.add(returnRow);
                    }
                    ArrayList<SheetRow> arrayList = result;
                    return arrayList;
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
            if (response.getStatusLine().getStatusCode() == 500) {
                return new ArrayList<SheetRow>();
            }
            throw new SpreadsheetOperationException("Error when getting batch " + response.getStatusLine().getStatusCode() + ":" + response.getStatusLine().getReasonPhrase());
        }

        private String getQueryWithBoundaries(int amount, int offset) throws UnsupportedEncodingException {
            String[] keywordsToJump = new String[]{"label", "format", "options"};
            int indexToPut = this.urlEncodedQuery.length();
            for (String jumpIt : keywordsToJump) {
                int index = this.urlEncodedQuery.indexOf(jumpIt);
                if (index == -1) continue;
                indexToPut = index;
                break;
            }
            return this.urlEncodedQuery.substring(0, indexToPut).toString() + URLEncoder.encode(" limit " + amount + " offset " + offset + " ", ENCODING).toString() + this.urlEncodedQuery.substring(indexToPut).toString();
        }
    }
}

