/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.salesforce;

import com.sforce.async.AsyncApiException;
import com.sforce.async.BatchInfo;
import com.sforce.async.BatchInfoList;
import com.sforce.async.BatchRequest;
import com.sforce.async.BatchResult;
import com.sforce.async.BulkConnection;
import com.sforce.async.ContentType;
import com.sforce.async.JobInfo;
import com.sforce.async.OperationEnum;
import com.sforce.soap.partner.CallOptions;
import com.sforce.soap.partner.DeleteResult;
import com.sforce.soap.partner.DeletedRecord;
import com.sforce.soap.partner.DescribeGlobalResult;
import com.sforce.soap.partner.DescribeSObjectResult;
import com.sforce.soap.partner.Error;
import com.sforce.soap.partner.GetDeletedResult;
import com.sforce.soap.partner.GetUpdatedResult;
import com.sforce.soap.partner.InvalidFieldFault;
import com.sforce.soap.partner.InvalidIdFault;
import com.sforce.soap.partner.InvalidQueryLocatorFault;
import com.sforce.soap.partner.InvalidSObjectFault;
import com.sforce.soap.partner.LoginFault;
import com.sforce.soap.partner.LoginResult;
import com.sforce.soap.partner.MalformedQueryFault;
import com.sforce.soap.partner.MruHeader;
import com.sforce.soap.partner.ObjectFactory;
import com.sforce.soap.partner.PackageVersionHeader;
import com.sforce.soap.partner.QueryOptions;
import com.sforce.soap.partner.QueryResult;
import com.sforce.soap.partner.SaveResult;
import com.sforce.soap.partner.SessionHeader;
import com.sforce.soap.partner.SforceService;
import com.sforce.soap.partner.Soap;
import com.sforce.soap.partner.UnexpectedErrorFault;
import com.sforce.soap.partner.sobject.SObject;
import com.sforce.ws.ConnectorConfig;
import java.net.URL;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Calendar;
import java.util.List;
import java.util.Map;
import javax.resource.ResourceException;
import javax.xml.datatype.XMLGregorianCalendar;
import javax.xml.ws.BindingProvider;
import javax.xml.ws.handler.HandlerResolver;
import org.apache.cxf.Bus;
import org.apache.cxf.BusFactory;
import org.teiid.logging.LogManager;
import org.teiid.resource.adapter.salesforce.SalesForceManagedConnectionFactory;
import org.teiid.resource.adapter.salesforce.SalesforceHandlerResolver;
import org.teiid.resource.spi.BasicConnection;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.salesforce.SalesforceConnection;
import org.teiid.translator.salesforce.execution.DataPayload;
import org.teiid.translator.salesforce.execution.DeletedObject;
import org.teiid.translator.salesforce.execution.DeletedResult;
import org.teiid.translator.salesforce.execution.UpdatedResult;

public class SalesforceConnectionImpl
extends BasicConnection
implements SalesforceConnection {
    private static final String CONNECTION_TIMEOUT = "javax.xml.ws.client.connectionTimeout";
    private static final String RECEIVE_TIMEOUT = "javax.xml.ws.client.receiveTimeout";
    private Soap sfSoap;
    private BulkConnection bulkConnection;
    private ObjectFactory partnerFactory = new ObjectFactory();
    PackageVersionHeader pvHeader = this.partnerFactory.createPackageVersionHeader();

    public SalesforceConnectionImpl(String username, String password, URL url, SalesForceManagedConnectionFactory mcf) throws ResourceException {
        this.login(username, password, url, mcf);
    }

    protected SalesforceConnectionImpl(Soap soap) {
        this.sfSoap = soap;
    }

    String getUserName() throws ResourceException {
        try {
            return this.sfSoap.getUserInfo().getUserName();
        }
        catch (UnexpectedErrorFault e) {
            throw new ResourceException((Throwable)e);
        }
    }

    Soap getBinding() {
        return this.sfSoap;
    }

    private void login(String username, String password, URL url, SalesForceManagedConnectionFactory mcf) throws ResourceException {
        Map requestContext;
        LoginResult loginResult = null;
        SforceService sfService = null;
        SessionHeader sh = null;
        CallOptions co = new CallOptions();
        co.setClient("RedHat/MetaMatrix/");
        if (url == null) {
            throw new ResourceException("SalesForce URL is not specified, please provide a valid URL");
        }
        Bus bus = BusFactory.getThreadDefaultBus();
        BusFactory.setThreadDefaultBus((Bus)mcf.getBus());
        try {
            sfService = new SforceService();
            sh = new SessionHeader();
            sfService.setHandlerResolver((HandlerResolver)new SalesforceHandlerResolver(sh));
            this.sfSoap = sfService.getSoap();
            requestContext = ((BindingProvider)this.sfSoap).getRequestContext();
            if (mcf.getConnectTimeout() != null) {
                requestContext.put(CONNECTION_TIMEOUT, mcf.getConnectTimeout());
            }
            requestContext.put("javax.xml.ws.service.endpoint.address", url.toExternalForm());
            loginResult = this.sfSoap.login(username, password);
            sh.setSessionId(loginResult.getSessionId());
            this.bulkConnection = this.getBulkConnection(loginResult.getServerUrl(), loginResult.getSessionId());
        }
        catch (LoginFault e) {
            throw new ResourceException((Throwable)e);
        }
        catch (InvalidIdFault e) {
            throw new ResourceException((Throwable)e);
        }
        catch (UnexpectedErrorFault e) {
            throw new ResourceException((Throwable)e);
        }
        catch (AsyncApiException e) {
            throw new ResourceException((Throwable)e);
        }
        finally {
            BusFactory.setThreadDefaultBus((Bus)bus);
        }
        LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"Login was successful for username " + username});
        requestContext = ((BindingProvider)this.sfSoap).getRequestContext();
        requestContext.put("javax.xml.ws.service.endpoint.address", loginResult.getServerUrl());
        requestContext.put("javax.xml.ws.session.maintain", Boolean.TRUE);
        if (mcf.getRequestTimeout() != null) {
            requestContext.put(RECEIVE_TIMEOUT, mcf.getRequestTimeout());
        }
        try {
            this.sfSoap.getUserInfo();
        }
        catch (UnexpectedErrorFault e) {
            throw new ResourceException((Throwable)e);
        }
    }

    public boolean isValid() {
        boolean result = true;
        if (this.sfSoap == null) {
            result = false;
        } else {
            try {
                this.sfSoap.getServerTimestamp();
            }
            catch (Throwable t) {
                LogManager.logTrace((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"Caught Throwable in isAlive", t});
                result = false;
            }
        }
        return result;
    }

    public QueryResult query(String queryString, int batchSize, Boolean queryAll) throws ResourceException {
        if (batchSize > 2000) {
            batchSize = 2000;
            LogManager.logDetail((String)"org.teiid.CONNECTOR", (Object[])new Object[]{"reduced.batch.size"});
        }
        QueryResult qr = null;
        QueryOptions qo = this.partnerFactory.createQueryOptions();
        qo.setBatchSize(Integer.valueOf(batchSize));
        try {
            if (queryAll != null && queryAll.booleanValue()) {
                qr = this.sfSoap.queryAll(queryString);
            } else {
                MruHeader mruHeader = this.partnerFactory.createMruHeader();
                mruHeader.setUpdateMru(false);
                qr = this.sfSoap.query(queryString);
            }
        }
        catch (InvalidFieldFault e) {
            throw new ResourceException((Throwable)e);
        }
        catch (MalformedQueryFault e) {
            throw new ResourceException((Throwable)e);
        }
        catch (InvalidSObjectFault e) {
            throw new ResourceException((Throwable)e);
        }
        catch (InvalidIdFault e) {
            throw new ResourceException((Throwable)e);
        }
        catch (UnexpectedErrorFault e) {
            throw new ResourceException((Throwable)e);
        }
        catch (InvalidQueryLocatorFault e) {
            throw new ResourceException((Throwable)e);
        }
        return qr;
    }

    public QueryResult queryMore(String queryLocator, int batchSize) throws ResourceException {
        QueryOptions qo = this.partnerFactory.createQueryOptions();
        qo.setBatchSize(Integer.valueOf(batchSize));
        try {
            return this.sfSoap.queryMore(queryLocator);
        }
        catch (InvalidFieldFault e) {
            throw new ResourceException((Throwable)e);
        }
        catch (UnexpectedErrorFault e) {
            throw new ResourceException((Throwable)e);
        }
        catch (InvalidQueryLocatorFault e) {
            throw new ResourceException((Throwable)e);
        }
    }

    public int delete(String[] ids) throws ResourceException {
        List results = null;
        try {
            results = this.sfSoap.delete(Arrays.asList(ids));
        }
        catch (UnexpectedErrorFault e) {
            throw new ResourceException((Throwable)e);
        }
        boolean allGood = true;
        StringBuffer errorMessages = new StringBuffer();
        for (int i = 0; i < results.size(); ++i) {
            List errors;
            DeleteResult result = (DeleteResult)results.get(i);
            if (result.isSuccess()) continue;
            if (allGood) {
                errorMessages.append("Error(s) executing DELETE: ");
                allGood = false;
            }
            if (null == (errors = result.getErrors()) || errors.size() <= 0) continue;
            for (int x = 0; x < errors.size(); ++x) {
                Error error = (Error)errors.get(x);
                errorMessages.append(error.getMessage()).append(';');
            }
        }
        if (!allGood) {
            throw new ResourceException(errorMessages.toString());
        }
        return results.size();
    }

    public int create(DataPayload data) throws ResourceException {
        List result;
        SObject toCreate = new SObject();
        toCreate.setType(data.getType());
        toCreate.getAny().addAll(data.getMessageElements());
        ArrayList<SObject> objects = new ArrayList<SObject>();
        objects.add(toCreate);
        try {
            result = this.sfSoap.create(objects);
        }
        catch (InvalidFieldFault e) {
            throw new ResourceException((Throwable)e);
        }
        catch (InvalidSObjectFault e) {
            throw new ResourceException((Throwable)e);
        }
        catch (InvalidIdFault e) {
            throw new ResourceException((Throwable)e);
        }
        catch (UnexpectedErrorFault e) {
            throw new ResourceException((Throwable)e);
        }
        return this.analyzeResult(result);
    }

    public int update(List<DataPayload> updateDataList) throws ResourceException {
        List result;
        ArrayList<SObject> params = new ArrayList<SObject>(updateDataList.size());
        for (int i = 0; i < updateDataList.size(); ++i) {
            DataPayload data = updateDataList.get(i);
            SObject toCreate = new SObject();
            toCreate.setType(data.getType());
            toCreate.setId(data.getID());
            toCreate.getAny().addAll(data.getMessageElements());
            params.add(i, toCreate);
        }
        try {
            result = this.sfSoap.update(params);
        }
        catch (InvalidFieldFault e) {
            throw new ResourceException((Throwable)e);
        }
        catch (InvalidSObjectFault e) {
            throw new ResourceException((Throwable)e);
        }
        catch (InvalidIdFault e) {
            throw new ResourceException((Throwable)e);
        }
        catch (UnexpectedErrorFault e) {
            throw new ResourceException((Throwable)e);
        }
        return this.analyzeResult(result);
    }

    private int analyzeResult(List<SaveResult> results) throws ResourceException {
        for (SaveResult result : results) {
            if (result.isSuccess()) continue;
            throw new ResourceException(((Error)result.getErrors().get(0)).getMessage());
        }
        return results.size();
    }

    public UpdatedResult getUpdated(String objectType, XMLGregorianCalendar startDate, XMLGregorianCalendar endDate) throws ResourceException {
        GetUpdatedResult updated;
        try {
            updated = this.sfSoap.getUpdated(objectType, startDate, endDate);
        }
        catch (InvalidSObjectFault e) {
            throw new ResourceException((Throwable)e);
        }
        catch (UnexpectedErrorFault e) {
            throw new ResourceException((Throwable)e);
        }
        UpdatedResult result = new UpdatedResult();
        result.setLatestDateCovered((Calendar)updated.getLatestDateCovered().toGregorianCalendar());
        result.setIDs(updated.getIds());
        return result;
    }

    public DeletedResult getDeleted(String objectName, XMLGregorianCalendar startCalendar, XMLGregorianCalendar endCalendar) throws ResourceException {
        GetDeletedResult deleted;
        try {
            deleted = this.sfSoap.getDeleted(objectName, startCalendar, endCalendar);
        }
        catch (InvalidSObjectFault e) {
            throw new ResourceException((Throwable)e);
        }
        catch (UnexpectedErrorFault e) {
            throw new ResourceException((Throwable)e);
        }
        DeletedResult result = new DeletedResult();
        result.setLatestDateCovered((Calendar)deleted.getLatestDateCovered().toGregorianCalendar());
        result.setEarliestDateAvailable((Calendar)deleted.getEarliestDateAvailable().toGregorianCalendar());
        List records = deleted.getDeletedRecords();
        ArrayList<DeletedObject> resultRecords = new ArrayList<DeletedObject>();
        if (records != null) {
            for (DeletedRecord record : records) {
                DeletedObject object = new DeletedObject();
                object.setID(record.getId());
                object.setDeletedDate((Calendar)record.getDeletedDate().toGregorianCalendar());
                resultRecords.add(object);
            }
        }
        result.setResultRecords(resultRecords);
        return result;
    }

    public QueryResult retrieve(String fieldList, String sObjectType, List<String> ids) throws ResourceException {
        try {
            List objects = this.sfSoap.retrieve(fieldList, sObjectType, ids);
            QueryResult result = new QueryResult();
            for (SObject sObject : objects) {
                if (sObject == null) continue;
                result.getRecords().add(sObject);
            }
            result.setSize(result.getRecords().size());
            result.setDone(true);
            return result;
        }
        catch (InvalidFieldFault e) {
            throw new ResourceException((Throwable)e);
        }
        catch (MalformedQueryFault e) {
            throw new ResourceException((Throwable)e);
        }
        catch (InvalidSObjectFault e) {
            throw new ResourceException((Throwable)e);
        }
        catch (InvalidIdFault e) {
            throw new ResourceException((Throwable)e);
        }
        catch (UnexpectedErrorFault e) {
            throw new ResourceException((Throwable)e);
        }
    }

    public DescribeGlobalResult getObjects() throws ResourceException {
        try {
            return this.sfSoap.describeGlobal();
        }
        catch (UnexpectedErrorFault e) {
            throw new ResourceException((Throwable)e);
        }
    }

    public DescribeSObjectResult getObjectMetaData(String objectName) throws ResourceException {
        try {
            return this.sfSoap.describeSObject(objectName);
        }
        catch (InvalidSObjectFault e) {
            throw new ResourceException((Throwable)e);
        }
        catch (UnexpectedErrorFault e) {
            throw new ResourceException((Throwable)e);
        }
    }

    public void close() throws ResourceException {
    }

    public boolean isAlive() {
        return this.isValid();
    }

    private JobInfo createBulkJob(String objectName) throws ResourceException {
        try {
            JobInfo job = new JobInfo();
            job.setObject(objectName);
            job.setOperation(OperationEnum.insert);
            job.setContentType(ContentType.XML);
            return this.bulkConnection.createJob(job);
        }
        catch (AsyncApiException e) {
            throw new ResourceException((Throwable)e);
        }
    }

    public JobInfo executeBulkJob(String objectName, List<com.sforce.async.SObject> payload) throws ResourceException {
        try {
            JobInfo job = this.createBulkJob(objectName);
            BatchRequest request = this.bulkConnection.createBatch(job);
            request.addSObjects(payload.toArray(new com.sforce.async.SObject[payload.size()]));
            request.completeRequest();
            return this.bulkConnection.closeJob(job.getId());
        }
        catch (AsyncApiException e) {
            throw new ResourceException((Throwable)e);
        }
    }

    public BatchResult getBulkResults(JobInfo job) throws ResourceException {
        try {
            BatchInfoList batchInfo = this.bulkConnection.getBatchInfoList(job.getId());
            BatchInfo[] batches = batchInfo.getBatchInfo();
            if (batches.length > 0) {
                BatchResult batchResult = this.bulkConnection.getBatchResult(job.getId(), batches[0].getId());
                if (batchResult.isPartialResult()) {
                    throw new DataNotAvailableException(500L);
                }
                return batchResult;
            }
            throw new DataNotAvailableException(500L);
        }
        catch (AsyncApiException e) {
            throw new ResourceException((Throwable)e);
        }
    }

    private BulkConnection getBulkConnection(String endpoint, String sessionid) throws AsyncApiException {
        ConnectorConfig config = new ConnectorConfig();
        config.setSessionId(sessionid);
        int index = endpoint.indexOf("Soap/u/");
        int endIndex = endpoint.indexOf(47, index + 7);
        String apiVersion = endpoint.substring(index + 7, endIndex);
        String restEndpoint = endpoint.substring(0, endpoint.indexOf("Soap/")) + "async/" + apiVersion;
        config.setRestEndpoint(restEndpoint);
        config.setCompression(true);
        config.setTraceMessage(false);
        BulkConnection connection = new BulkConnection(config);
        return connection;
    }

    public void cancelBulkJob(JobInfo job) throws ResourceException {
        try {
            this.bulkConnection.abortJob(job.getId());
        }
        catch (AsyncApiException e) {
            throw new ResourceException((Throwable)e);
        }
    }
}

