/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.ws;

import java.io.IOException;
import java.security.MessageDigest;
import javax.security.auth.callback.Callback;
import javax.security.auth.callback.CallbackHandler;
import javax.security.auth.callback.UnsupportedCallbackException;
import org.apache.ws.security.WSPasswordCallback;
import org.apache.ws.security.util.Base64;
import org.teiid.logging.LogManager;
import org.teiid.resource.adapter.ws.WSManagedConnectionFactory;
import org.teiid.resource.adapter.ws.WSSecurityCredential;
import org.teiid.resource.adapter.ws.WSSecurityToken;

public class UsernameTokenProfile
extends WSSecurityToken
implements CallbackHandler {
    private boolean encryptedPassword;
    protected String passwd;
    protected String user;

    public UsernameTokenProfile(String user, String passwd, boolean encryptedPassword) {
        this.encryptedPassword = encryptedPassword;
        this.passwd = passwd;
        this.user = user;
        LogManager.logDetail((String)WSManagedConnectionFactory.UTIL.getString("using_username_profile"), (Object[])new Object[0]);
    }

    @Override
    public void addSecurity(WSSecurityCredential credential) {
        this.setAction(credential, "UsernameToken");
        credential.getRequestPropterties().put("user", this.user);
        if (this.encryptedPassword) {
            credential.getRequestPropterties().put("passwordType", "PasswordDigest");
        } else {
            credential.getRequestPropterties().put("passwordType", "PasswordText");
        }
        credential.getRequestPropterties().put("passwordCallbackRef", this);
    }

    @Override
    public void handle(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        for (int i = 0; i < callbacks.length; ++i) {
            if (callbacks[i] instanceof WSPasswordCallback) {
                WSPasswordCallback pc = (WSPasswordCallback)callbacks[i];
                if (this.encryptedPassword) {
                    pc.setPassword(this.encrypt(this.passwd));
                    continue;
                }
                pc.setPassword(this.passwd);
                continue;
            }
            throw new UnsupportedCallbackException(callbacks[i], "unrecognized_callback");
        }
    }

    String encrypt(String clearText) {
        String sha1Hash = null;
        try {
            MessageDigest md = MessageDigest.getInstance("SHA1");
            byte[] digest = md.digest(clearText.getBytes());
            sha1Hash = new String(Base64.encode((byte[])digest));
        }
        catch (Exception e) {
            e.printStackTrace();
        }
        return sha1Hash;
    }

    @Override
    void handleCallback(Callback[] callbacks) throws IOException, UnsupportedCallbackException {
        this.handle(callbacks);
    }
}

