/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.resource.adapter.ws;

import java.util.Properties;
import org.teiid.logging.LogManager;
import org.teiid.resource.adapter.ws.WSManagedConnectionFactory;
import org.teiid.resource.adapter.ws.WSSecurityCredential;
import org.teiid.resource.adapter.ws.WSSecurityToken;

public class EncryptProfile
extends WSSecurityToken {
    private String encryptionUser;
    private Properties encryptionProperties;
    private String encryptionKeyIdentifier;
    private String encryptionParts;
    private String encryptionSymAlgorithm;
    private String encryptionKeyTransportAlgorithm;

    public EncryptProfile(WSSecurityCredential credential, String encryptionUser, Properties encryptionProperties, String encryptionKeyIdentifier, String encryptionParts, String encryptionSymAlgorithm, String encryptionKeyTransportAlgorithm) {
        this.encryptionUser = encryptionUser;
        this.encryptionProperties = encryptionProperties;
        this.encryptionKeyIdentifier = encryptionKeyIdentifier;
        this.encryptionParts = encryptionParts;
        this.encryptionSymAlgorithm = encryptionSymAlgorithm;
        this.encryptionKeyTransportAlgorithm = encryptionKeyTransportAlgorithm;
        LogManager.logDetail((String)WSManagedConnectionFactory.UTIL.getString("using_encrypt_profile"), (Object[])new Object[0]);
    }

    @Override
    public void addSecurity(WSSecurityCredential credential) {
        this.setAction(credential, "Encrypt");
        if (this.encryptionUser != null) {
            credential.getRequestPropterties().put("encryptionUser", this.encryptionUser);
        }
        credential.getRequestPropterties().put("encryptionPropRefId", this.encryptionProperties);
        if (this.encryptionKeyIdentifier != null) {
            credential.getRequestPropterties().put("encryptionKeyIdentifier", this.encryptionKeyIdentifier);
        }
        if (this.encryptionParts != null) {
            credential.getRequestPropterties().put("encryptionParts", this.encryptionParts);
        }
        if (this.encryptionSymAlgorithm != null) {
            credential.getRequestPropterties().put("encryptionSymAlgorithm", this.encryptionSymAlgorithm);
        }
        if (this.encryptionKeyTransportAlgorithm != null) {
            credential.getRequestPropterties().put("encryptionKeyTransportAlgorithm", this.encryptionKeyTransportAlgorithm);
        }
    }
}

