/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.AbstractCollection;
import java.util.ArrayList;
import java.util.Collection;
import java.util.LinkedHashSet;
import org.teiid.core.util.EquivalenceUtil;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.lang.AbstractSetCriteria;
import org.teiid.query.sql.symbol.Expression;

public class SetCriteria
extends AbstractSetCriteria {
    private Collection values;
    private boolean allConstants;

    public SetCriteria() {
    }

    public SetCriteria(Expression expression, Collection values) {
        this.set(expression, values);
    }

    public int getNumberOfValues() {
        return this.values != null ? this.values.size() : 0;
    }

    public Collection getValues() {
        return this.values;
    }

    public void setValues(Collection values) {
        this.values = values;
    }

    public void set(Expression expression, Collection values) {
        this.setExpression(expression);
        this.setValues(values);
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public int hashCode() {
        int hc = 0;
        hc = HashCodeUtil.hashCode((int)hc, (Object[])new Object[]{this.getExpression()});
        hc = HashCodeUtil.expHashCode((int)hc, (Collection)this.getValues());
        return hc;
    }

    public boolean equals(Object obj) {
        if (obj == this) {
            return true;
        }
        if (!(obj instanceof SetCriteria)) {
            return false;
        }
        SetCriteria sc = (SetCriteria)obj;
        if (this.isNegated() ^ sc.isNegated()) {
            return false;
        }
        return this.getValues().size() == sc.getValues().size() && this.getValues().containsAll(sc.getValues()) && EquivalenceUtil.areEqual((Object)this.getExpression(), (Object)sc.getExpression());
    }

    @Override
    public Object clone() {
        Expression copy = null;
        if (this.getExpression() != null) {
            copy = (Expression)this.getExpression().clone();
        }
        AbstractCollection copyValues = null;
        copyValues = this.isAllConstants() ? new LinkedHashSet(this.values) : LanguageObject.Util.deepClone(new ArrayList(this.values), Expression.class);
        SetCriteria criteriaCopy = new SetCriteria(copy, copyValues);
        criteriaCopy.setNegated(this.isNegated());
        criteriaCopy.allConstants = this.allConstants;
        return criteriaCopy;
    }

    public boolean isAllConstants() {
        return this.allConstants;
    }

    public void setAllConstants(boolean allConstants) {
        this.allConstants = allConstants;
    }
}

