/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import org.teiid.core.util.ArgCheck;
import org.teiid.core.util.HashCodeUtil;
import org.teiid.query.sql.LanguageObject;
import org.teiid.query.sql.LanguageVisitor;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.symbol.Expression;
import org.teiid.query.sql.visitor.SQLStringVisitor;

public class SetClause
implements LanguageObject {
    private static final long serialVersionUID = 8174681510498719451L;
    private ElementSymbol symbol;
    private Expression value;

    public SetClause(ElementSymbol symbol, Expression value) {
        ArgCheck.isNotNull((Object)symbol);
        ArgCheck.isNotNull((Object)value);
        this.symbol = symbol;
        this.value = value;
    }

    public ElementSymbol getSymbol() {
        return this.symbol;
    }

    public void setSymbol(ElementSymbol symbol) {
        this.symbol = symbol;
    }

    public Expression getValue() {
        return this.value;
    }

    public void setValue(Expression value) {
        this.value = value;
    }

    @Override
    public void acceptVisitor(LanguageVisitor visitor) {
        visitor.visit(this);
    }

    public String toString() {
        return SQLStringVisitor.getSQLString(this);
    }

    @Override
    public Object clone() {
        return new SetClause(this.symbol.clone(), (Expression)this.value.clone());
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (!(obj instanceof SetClause)) {
            return false;
        }
        SetClause other = (SetClause)obj;
        return this.symbol.equals(other.symbol) && this.value.equals(other.value);
    }

    public int hashCode() {
        return HashCodeUtil.hashCode((int)this.symbol.hashCode(), (int)this.value.hashCode());
    }
}

