/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.sql.lang;

import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidRuntimeException;
import org.teiid.query.QueryPlugin;
import org.teiid.query.sql.symbol.GroupSymbol;

public class GroupContext
implements Cloneable {
    private Collection<GroupSymbol> groups;
    private GroupContext parent;

    public GroupContext() {
        this(null, null);
    }

    public GroupContext(GroupContext parent, Collection<GroupSymbol> groups) {
        this.parent = parent;
        this.groups = groups == null ? new LinkedList<GroupSymbol>() : groups;
    }

    public Collection<GroupSymbol> getGroups() {
        return this.groups;
    }

    public void addGroup(GroupSymbol symbol) {
        this.groups.add(symbol);
    }

    public GroupContext getParent() {
        return this.parent;
    }

    public List<GroupSymbol> getAllGroups() {
        LinkedList<GroupSymbol> result = new LinkedList<GroupSymbol>();
        for (GroupContext root = this; root != null; root = root.getParent()) {
            result.addAll(root.getGroups());
        }
        return result;
    }

    public Object clone() {
        try {
            return super.clone();
        }
        catch (CloneNotSupportedException err) {
            throw new TeiidRuntimeException((BundleUtil.Event)QueryPlugin.Event.TEIID30446, (Throwable)err);
        }
    }

    public String toString() {
        String result = this.groups.toString();
        if (this.parent != null) {
            result = result + "\n" + this.parent.toString();
        }
        return result;
    }
}

