/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.xml;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.teiid.core.BundleUtil;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.query.QueryPlugin;
import org.teiid.query.processor.xml.PlanExecutor;
import org.teiid.query.sql.symbol.ElementSymbol;
import org.teiid.query.sql.util.VariableContext;

class XMLContext {
    Map<String, PlanExecutor> resultsMap = new HashMap<String, PlanExecutor>();
    XMLContext parentContext;
    Map<String, PlanExecutor> executorMap = new HashMap<String, PlanExecutor>();
    VariableContext variableContext = new VariableContext();

    public XMLContext() {
    }

    public XMLContext(XMLContext parent) {
        this.parentContext = parent;
        this.variableContext.setParentContext(parent.variableContext);
    }

    public XMLContext getParentContext() {
        return this.parentContext;
    }

    public List<?> getCurrentRow(String aliasResultName) throws TeiidComponentException, TeiidProcessingException {
        PlanExecutor executor = this.getExecutor(aliasResultName);
        return executor.currentRow();
    }

    public List<?> getNextRow(String aliasResultName) throws TeiidComponentException, TeiidProcessingException {
        PlanExecutor executor = this.getExecutor(aliasResultName);
        return executor.nextRow();
    }

    public void setResultSet(String resultName, PlanExecutor executor) {
        this.resultsMap.put(resultName, executor);
    }

    public void removeResultSet(String resultName) throws TeiidComponentException {
        PlanExecutor executor = this.resultsMap.remove(resultName);
        if (executor != null) {
            executor.close();
        }
    }

    public List<?> getOutputElements(String resultName) throws TeiidComponentException {
        PlanExecutor executor = this.getExecutor(resultName);
        return executor.getOutputElements();
    }

    private PlanExecutor getExecutor(String resultName) throws TeiidComponentException {
        PlanExecutor executor = this.resultsMap.get(resultName);
        if (executor == null) {
            if (this.parentContext != null) {
                return this.parentContext.getExecutor(resultName);
            }
            throw new TeiidComponentException((BundleUtil.Event)QueryPlugin.Event.TEIID30216, QueryPlugin.Util.gs((BundleUtil.Event)QueryPlugin.Event.TEIID30216, new Object[]{resultName}));
        }
        return executor;
    }

    public Map getReferenceValues() {
        HashMap map = new HashMap();
        this.variableContext.getFlattenedContextMap(map);
        return map;
    }

    public PlanExecutor getResultExecutor(String resultName) {
        return this.executorMap.get(resultName);
    }

    public void setResultExecutor(String resultName, PlanExecutor executor) {
        this.executorMap.put(resultName, executor);
    }

    public void removeResultExecutor(String resultName) {
        this.executorMap.remove(resultName);
    }

    public VariableContext getVariableContext() {
        return this.variableContext;
    }

    void setVariableValues(String resultSetName, List<?> row) throws TeiidComponentException {
        List<?> elements = this.getOutputElements(resultSetName);
        for (int index = 0; index < elements.size(); ++index) {
            if (!(elements.get(index) instanceof ElementSymbol)) continue;
            ElementSymbol symbol = (ElementSymbol)elements.get(index);
            this.variableContext.setValue(new ElementSymbol(resultSetName + "." + symbol.getShortName()), row.get(index));
        }
    }
}

