/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.processor.relational;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.teiid.core.TeiidComponentException;
import org.teiid.core.TeiidProcessingException;
import org.teiid.core.util.Assertion;
import org.teiid.query.processor.relational.AccessNode;
import org.teiid.query.processor.relational.DependentCriteriaProcessor;
import org.teiid.query.processor.relational.DependentValueSource;
import org.teiid.query.processor.relational.JoinNode;
import org.teiid.query.processor.relational.MergeJoinStrategy;
import org.teiid.query.processor.relational.RelationalNode;
import org.teiid.query.processor.relational.RelationalNodeUtil;
import org.teiid.query.sql.lang.Command;
import org.teiid.query.sql.lang.Criteria;
import org.teiid.query.sql.lang.DependentSetCriteria;
import org.teiid.query.sql.lang.Query;
import org.teiid.query.sql.lang.QueryCommand;

public class DependentAccessNode
extends AccessNode {
    private int maxSetSize;
    private int maxPredicates;
    private boolean pushdown;
    private DependentCriteriaProcessor criteriaProcessor;
    private Criteria dependentCrit;
    private boolean sort = true;
    private Command rewrittenCommand;

    public DependentAccessNode(int nodeID) {
        super(nodeID);
    }

    @Override
    public void closeDirect() {
        super.closeDirect();
        if (this.criteriaProcessor != null) {
            this.criteriaProcessor.close();
        }
    }

    @Override
    public void reset() {
        super.reset();
        this.criteriaProcessor = null;
        this.dependentCrit = null;
        this.sort = true;
        this.rewrittenCommand = null;
    }

    @Override
    protected Command nextCommand() throws TeiidProcessingException, TeiidComponentException {
        if (this.rewrittenCommand == null) {
            Command atomicCommand = super.nextCommand();
            DependentAccessNode.rewriteAndEvaluate(atomicCommand, this.getEvaluator(Collections.emptyMap()), this.getContext(), this.getContext().getMetadata());
            this.rewrittenCommand = atomicCommand;
            this.nextCommand = null;
        }
        if (this.nextCommand == null && this.rewrittenCommand != null) {
            this.nextCommand = (Command)this.rewrittenCommand.clone();
        }
        return super.nextCommand();
    }

    @Override
    public Object clone() {
        DependentAccessNode clonedNode = new DependentAccessNode(super.getID());
        clonedNode.maxSetSize = this.maxSetSize;
        clonedNode.maxPredicates = this.maxPredicates;
        clonedNode.pushdown = this.pushdown;
        super.copyTo(clonedNode);
        return clonedNode;
    }

    public int getMaxSetSize() {
        return this.maxSetSize;
    }

    public int getMaxPredicates() {
        return this.maxPredicates;
    }

    public void setMaxPredicates(int maxPredicates) {
        this.maxPredicates = maxPredicates;
    }

    public void setMaxSetSize(int maxSize) {
        this.maxSetSize = maxSize;
    }

    @Override
    protected boolean prepareNextCommand(Command atomicCommand) throws TeiidComponentException, TeiidProcessingException {
        Assertion.assertTrue((boolean)(atomicCommand instanceof Query));
        Query query = (Query)atomicCommand;
        if (this.pushdown) {
            ArrayList<Criteria> newCriteria = new ArrayList<Criteria>();
            List<Criteria> queryCriteria = Criteria.separateCriteriaByAnd(query.getCriteria());
            for (Criteria criteria : queryCriteria) {
                if (!(criteria instanceof DependentSetCriteria)) {
                    newCriteria.add(criteria);
                    continue;
                }
                DependentSetCriteria dsc = (DependentSetCriteria)criteria;
                dsc = dsc.clone();
                DependentValueSource dvs = (DependentValueSource)this.getContext().getVariableContext().getGlobalValue(dsc.getContextSymbol());
                dsc.setDependentValueSource(dvs);
                newCriteria.add(dsc);
            }
            query.setCriteria(Criteria.combineCriteria(newCriteria));
            return RelationalNodeUtil.shouldExecute(atomicCommand, true);
        }
        if (this.criteriaProcessor == null) {
            this.criteriaProcessor = new DependentCriteriaProcessor(this.maxSetSize, this.maxPredicates, this, query.getCriteria());
        }
        if (this.dependentCrit == null) {
            this.dependentCrit = this.criteriaProcessor.prepareCriteria();
        }
        query.setCriteria(this.dependentCrit);
        if (this.sort && query.getOrderBy() != null && this.criteriaProcessor.hasNextCommand()) {
            JoinNode joinNode;
            RelationalNode parent;
            for (parent = this.getParent(); parent != null && !(parent instanceof JoinNode); parent = parent.getParent()) {
            }
            if (parent != null && (joinNode = (JoinNode)parent).getJoinStrategy() instanceof MergeJoinStrategy) {
                MergeJoinStrategy mjs = (MergeJoinStrategy)joinNode.getJoinStrategy();
                mjs.setProcessingSortRight(true);
            }
            this.sort = false;
        }
        if (!this.sort) {
            query.setOrderBy(null);
        }
        boolean result = RelationalNodeUtil.shouldExecute(atomicCommand, true);
        this.dependentCrit = null;
        this.criteriaProcessor.consumedCriteria();
        return result;
    }

    @Override
    protected boolean hasNextCommand() {
        if (this.pushdown) {
            return false;
        }
        return this.criteriaProcessor.hasNextCommand();
    }

    public void setPushdown(boolean pushdown) {
        this.pushdown = pushdown;
    }

    @Override
    public Boolean requiresTransaction(boolean transactionalReads) {
        if (transactionalReads || !(this.getCommand() instanceof QueryCommand)) {
            return true;
        }
        return null;
    }
}

