/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.query.optimizer.xml;

import java.util.Properties;
import org.teiid.query.mapping.xml.MappingDocument;
import org.teiid.query.mapping.xml.MappingElement;
import org.teiid.query.mapping.xml.MappingRecursiveElement;
import org.teiid.query.mapping.xml.MappingVisitor;
import org.teiid.query.mapping.xml.Namespace;
import org.teiid.query.mapping.xml.Navigator;

public class HandleNillableVisitor
extends MappingVisitor {
    @Override
    public void visit(MappingElement element) {
        this.visitNode(element);
    }

    @Override
    public void visit(MappingRecursiveElement element) {
        this.visitNode(element);
    }

    void visitNode(MappingElement element) {
        if (element.isNillable()) {
            MappingDocument doc = element.getDocument();
            MappingElement rootElement = doc.getTagRootElement();
            Properties namespaces = rootElement.getNamespacesAsProperties();
            if (namespaces == null || !namespaces.containsKey("xsi")) {
                rootElement.addNamespace(new Namespace("xsi", "http://www.w3.org/2001/XMLSchema-instance"));
            }
            this.setAbort(true);
        }
    }

    public static MappingDocument execute(MappingDocument doc) {
        HandleNillableVisitor visitor = new HandleNillableVisitor();
        doc.acceptVisitor(new Navigator(true, visitor));
        return doc;
    }
}

