/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer;

import java.util.AbstractList;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import java.util.RandomAccess;
import org.teiid.client.ResizingArrayList;

public class LightWeightCopyOnWriteList<T>
extends AbstractList<T>
implements RandomAccess {
    private List<T> list;
    private boolean modified;

    public LightWeightCopyOnWriteList(List<T> list) {
        this.list = list;
    }

    @Override
    public T get(int index) {
        return this.list.get(index);
    }

    public List<T> getList() {
        return this.list;
    }

    @Override
    public void add(int index, T element) {
        if (!this.modified) {
            ArrayList<T> next = new ArrayList<T>(this.list.size() + 1);
            next.addAll(this.list);
            this.list = next;
            this.modified = true;
        }
        this.list.add(index, element);
    }

    @Override
    public T set(int index, T element) {
        this.checkModified();
        return this.list.set(index, element);
    }

    private void checkModified() {
        if (!this.modified) {
            this.list = new ArrayList<T>(this.list);
            this.modified = true;
        }
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        return this.addAll(this.size(), c);
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        this.checkModified();
        return this.list.addAll(index, c);
    }

    @Override
    public T remove(int index) {
        this.checkModified();
        return this.list.remove(index);
    }

    @Override
    public Object[] toArray() {
        return this.list.toArray();
    }

    @Override
    public <U> U[] toArray(U[] a) {
        return this.list.toArray(a);
    }

    @Override
    public void clear() {
        if (!this.modified) {
            this.list = new ResizingArrayList();
            this.modified = true;
        } else {
            this.list.clear();
        }
    }

    @Override
    public int size() {
        return this.list.size();
    }
}

