/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.common.buffer;

import java.lang.ref.PhantomReference;
import java.lang.ref.ReferenceQueue;
import java.util.Collections;
import java.util.IdentityHashMap;
import java.util.Set;
import org.teiid.logging.LogManager;

public class AutoCleanupUtil {
    private static ReferenceQueue<Object> QUEUE = new ReferenceQueue();
    private static final Set<PhantomReference<Object>> REFERENCES = Collections.synchronizedSet(Collections.newSetFromMap(new IdentityHashMap()));

    public static PhantomReference<Object> setCleanupReference(Object o, Removable r) {
        PhantomCleanupReference ref = new PhantomCleanupReference(o, r);
        REFERENCES.add(ref);
        AutoCleanupUtil.doCleanup();
        return ref;
    }

    public static void removeCleanupReference(PhantomReference<Object> ref) {
        if (ref == null) {
            return;
        }
        REFERENCES.remove(ref);
        ref.clear();
    }

    public static void doCleanup() {
        PhantomCleanupReference ref;
        for (int i = 0; i < 10 && (ref = (PhantomCleanupReference)QUEUE.poll()) != null; ++i) {
            try {
                ref.cleanup();
            }
            catch (Throwable e) {
                LogManager.logWarning((String)"org.teiid.PROCESSOR", (Throwable)e, (Object)"Error cleaning up.");
            }
            REFERENCES.remove(ref);
        }
    }

    static final class PhantomCleanupReference
    extends PhantomReference<Object> {
        private Removable removable;

        public PhantomCleanupReference(Object referent, Removable removable) {
            super(referent, QUEUE);
            this.removable = removable;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void cleanup() {
            try {
                this.removable.remove();
            }
            finally {
                this.removable = null;
                this.clear();
            }
        }
    }

    public static interface Removable {
        public void remove();
    }
}

