/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.sasl.callback;

import java.security.PublicKey;
import javax.security.auth.callback.Callback;

public final class PublicKeyCallback
implements Callback {
    private final String prompt;
    private final String[] algorithmNames;
    private PublicKey publicKey;

    public PublicKeyCallback(String prompt, String[] algorithmNames) {
        this.prompt = prompt;
        this.algorithmNames = algorithmNames;
    }

    public PublicKeyCallback(String prompt, PublicKey publicKey, String[] algorithmNames) {
        this.prompt = prompt;
        this.publicKey = publicKey;
        this.algorithmNames = algorithmNames;
    }

    public String getPrompt() {
        return this.prompt;
    }

    public PublicKey getPublicKey() {
        return this.publicKey;
    }

    public void setPublicKey(PublicKey publicKey) {
        this.publicKey = publicKey;
    }

    public String[] getAlgorithmNames() {
        return (String[])this.algorithmNames.clone();
    }

    public boolean allows(String name) {
        for (String algorithmName : this.algorithmNames) {
            if (!algorithmName.equals(name)) continue;
            return true;
        }
        return false;
    }
}

