/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.odata;

import java.net.URI;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import javax.ws.rs.core.UriBuilder;
import org.teiid.core.BundleUtil;
import org.teiid.language.AggregateFunction;
import org.teiid.language.AndOr;
import org.teiid.language.ColumnReference;
import org.teiid.language.Comparison;
import org.teiid.language.Condition;
import org.teiid.language.DerivedColumn;
import org.teiid.language.Expression;
import org.teiid.language.Function;
import org.teiid.language.IsNull;
import org.teiid.language.Join;
import org.teiid.language.LanguageObject;
import org.teiid.language.LanguageUtil;
import org.teiid.language.Limit;
import org.teiid.language.Literal;
import org.teiid.language.NamedTable;
import org.teiid.language.Not;
import org.teiid.language.OrderBy;
import org.teiid.language.QueryExpression;
import org.teiid.language.Select;
import org.teiid.language.SortSpecification;
import org.teiid.language.visitor.HierarchyVisitor;
import org.teiid.metadata.Column;
import org.teiid.metadata.FunctionMethod;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.metadata.Table;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.odata.ODataExecutionFactory;
import org.teiid.translator.odata.ODataPlugin;

public class ODataSQLVisitor
extends HierarchyVisitor {
    private static Map<String, String> infixFunctions = new HashMap<String, String>();
    protected ArrayList<TranslatorException> exceptions = new ArrayList();
    protected QueryExpression command;
    protected ODataExecutionFactory executionFactory;
    protected RuntimeMetadata metadata;
    protected ArrayList<Column> selectColumns = new ArrayList();
    protected StringBuilder filter = new StringBuilder();
    private EntitiesInQuery entities = new EntitiesInQuery();
    private Integer skip;
    private Integer top;
    private StringBuilder orderBy = new StringBuilder();
    private boolean count = false;

    public Column[] getSelect() {
        return this.selectColumns.toArray(new Column[this.selectColumns.size()]);
    }

    public boolean isCount() {
        return this.count;
    }

    public boolean isKeyLookup() {
        return this.entities.isKeyLookup();
    }

    public Table getEnityTable() {
        return this.entities.getFinalEntity();
    }

    public String getEnitityURL() {
        StringBuilder url = new StringBuilder();
        this.entities.append(url);
        return url.toString();
    }

    public String buildURL() {
        StringBuilder url = new StringBuilder();
        this.entities.append(url);
        if (this.count) {
            url.append("/$count");
        }
        UriBuilder uriBuilder = UriBuilder.fromPath((String)url.toString());
        if (this.filter.length() > 0) {
            uriBuilder.queryParam("$filter", new Object[]{this.filter.toString()});
        }
        if (this.orderBy.length() > 0) {
            uriBuilder.queryParam("$orderby", new Object[]{this.orderBy.toString()});
        }
        if (!this.selectColumns.isEmpty()) {
            HashSet<String> select = new HashSet<String>();
            for (Column column : this.selectColumns) {
                select.add(this.getColumnName(column));
            }
            StringBuilder sb = new StringBuilder();
            Iterator it = select.iterator();
            while (it.hasNext()) {
                sb.append((String)it.next());
                if (!it.hasNext()) continue;
                sb.append(",");
            }
            uriBuilder.queryParam("$select", new Object[]{sb.toString()});
        }
        if (this.skip != null) {
            uriBuilder.queryParam("$skip", new Object[]{this.skip});
        }
        if (this.top != null) {
            uriBuilder.queryParam("$top", new Object[]{this.top});
        }
        URI uri = uriBuilder.build(new Object[0]);
        return uri.toString();
    }

    public ODataSQLVisitor(ODataExecutionFactory executionFactory, RuntimeMetadata metadata) {
        this.executionFactory = executionFactory;
        this.metadata = metadata;
    }

    public void visit(Comparison obj) {
        this.append((LanguageObject)obj.getLeftExpression());
        this.filter.append(" ");
        switch (obj.getOperator()) {
            case EQ: {
                this.filter.append("eq");
                break;
            }
            case NE: {
                this.filter.append("ne");
                break;
            }
            case LT: {
                this.filter.append("lt");
                break;
            }
            case LE: {
                this.filter.append("le");
                break;
            }
            case GT: {
                this.filter.append("gt");
                break;
            }
            case GE: {
                this.filter.append("ge");
            }
        }
        this.filter.append(" ");
        this.appendRightComparison(obj);
    }

    protected void appendRightComparison(Comparison obj) {
        this.append((LanguageObject)obj.getRightExpression());
    }

    public void visit(AndOr obj) {
        String opString = obj.getOperator().name().toLowerCase();
        this.appendNestedCondition(obj, obj.getLeftCondition());
        this.filter.append(" ").append(opString).append(" ");
        this.appendNestedCondition(obj, obj.getRightCondition());
    }

    protected void appendNestedCondition(AndOr parent, Condition condition) {
        AndOr nested;
        if (condition instanceof AndOr && (nested = (AndOr)condition).getOperator() != parent.getOperator()) {
            this.filter.append("(");
            this.append((LanguageObject)condition);
            this.filter.append(")");
            return;
        }
        this.append((LanguageObject)condition);
    }

    public void visit(ColumnReference obj) {
        this.filter.append(obj.getMetadataObject().getName());
    }

    protected boolean isInfixFunction(String function) {
        return infixFunctions.containsKey(function);
    }

    public void visit(Function obj) {
        if (this.executionFactory.getFunctionModifiers().containsKey(obj.getName())) {
            this.executionFactory.getFunctionModifiers().get(obj.getName()).translate(obj);
        }
        String name = obj.getName();
        List args = obj.getParameters();
        if (this.isInfixFunction(name)) {
            this.filter.append("(");
            if (args != null) {
                for (int i = 0; i < args.size(); ++i) {
                    this.append((LanguageObject)args.get(i));
                    if (i >= args.size() - 1) continue;
                    this.filter.append(" ");
                    this.filter.append(infixFunctions.get(name));
                    this.filter.append(" ");
                }
            }
            this.filter.append(")");
        } else {
            FunctionMethod method = obj.getMetadataObject();
            if (name.startsWith(method.getCategory())) {
                name = name.substring(method.getCategory().length() + 1);
            }
            this.filter.append(name).append("(");
            if (args != null && args.size() != 0) {
                for (int i = 0; i < args.size(); ++i) {
                    this.append((LanguageObject)args.get(i));
                    if (i >= args.size() - 1) continue;
                    this.filter.append(",");
                }
            }
            this.filter.append(")");
        }
    }

    public void visit(NamedTable obj) {
        this.entities.addEntity(obj.getMetadataObject());
    }

    public void visit(IsNull obj) {
        if (obj.isNegated()) {
            this.filter.append("NOT".toLowerCase()).append("(");
        }
        this.appendNested(obj.getExpression());
        this.filter.append(" ");
        this.filter.append("eq").append(" ");
        this.filter.append("NULL".toLowerCase());
        if (obj.isNegated()) {
            this.filter.append(")");
        }
    }

    private void appendNested(Expression ex) {
        boolean useParens = ex instanceof Condition;
        if (useParens) {
            this.filter.append("(");
        }
        this.append((LanguageObject)ex);
        if (useParens) {
            this.filter.append(")");
        }
    }

    public void visit(Join obj) {
        if (obj.getLeftItem() instanceof NamedTable && obj.getRightItem() instanceof NamedTable) {
            this.entities.addEntity(((NamedTable)obj.getLeftItem()).getMetadataObject());
            this.entities.addEntity(((NamedTable)obj.getRightItem()).getMetadataObject());
            obj.setCondition(this.buildEntityKey(obj.getCondition()));
            this.visitNode((LanguageObject)obj.getCondition());
        } else {
            this.visitNode((LanguageObject)obj.getLeftItem());
            this.visitNode((LanguageObject)obj.getRightItem());
            this.visitNode((LanguageObject)obj.getCondition());
        }
    }

    public void visit(Limit obj) {
        if (obj.getRowOffset() != 0) {
            this.skip = new Integer(obj.getRowOffset());
        }
        if (obj.getRowLimit() != 0) {
            this.top = new Integer(obj.getRowLimit());
        }
    }

    public void visit(Literal obj) {
        this.executionFactory.convertToODataInput(obj, this.filter);
    }

    public void visit(Not obj) {
        this.filter.append("NOT").append(" ").append("(");
        this.append((LanguageObject)obj.getCriteria());
        this.filter.append(")");
    }

    public void visit(OrderBy obj) {
        this.append(obj.getSortSpecifications());
    }

    public void visit(SortSpecification obj) {
        if (this.orderBy.length() > 0) {
            this.orderBy.append(",");
        }
        ColumnReference column = (ColumnReference)obj.getExpression();
        this.orderBy.append(column.getMetadataObject().getName());
        if (obj.getOrdering() == SortSpecification.Ordering.DESC) {
            this.orderBy.append(" ").append("DESC".toLowerCase());
        }
    }

    public void visit(Select obj) {
        this.visitNodes(obj.getFrom());
        obj.setWhere(this.buildEntityKey(obj.getWhere()));
        this.visitNode((LanguageObject)obj.getWhere());
        this.visitNode((LanguageObject)obj.getOrderBy());
        this.visitNode((LanguageObject)obj.getLimit());
        this.visitNodes(obj.getDerivedColumns());
    }

    protected Condition buildEntityKey(Condition obj) {
        List crits = LanguageUtil.separateCriteriaByAnd((Condition)obj);
        if (!crits.isEmpty()) {
            boolean modified = false;
            Iterator iter = crits.iterator();
            while (iter.hasNext()) {
                Comparison left;
                boolean leftAdded;
                Condition crit = (Condition)iter.next();
                if (!(crit instanceof Comparison) || !(leftAdded = this.entities.addEnityKey(left = (Comparison)crit))) continue;
                iter.remove();
                modified = true;
            }
            if (this.entities.valid() && modified) {
                return LanguageUtil.combineCriteria((List)crits);
            }
        }
        return obj;
    }

    public void visit(DerivedColumn obj) {
        if (obj.getExpression() instanceof ColumnReference) {
            Column column = ((ColumnReference)obj.getExpression()).getMetadataObject();
            String joinColumn = column.getProperty("{http://www.jboss.org/teiiddesigner/ext/odata/2012}JoinColumn", false);
            if (joinColumn != null && Boolean.valueOf(joinColumn).booleanValue()) {
                this.exceptions.add(new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17006, new Object[]{column.getName()})));
            }
            this.selectColumns.add(column);
        } else if (obj.getExpression() instanceof AggregateFunction) {
            AggregateFunction func = (AggregateFunction)obj.getExpression();
            if (func.getName().equalsIgnoreCase("COUNT")) {
                this.count = true;
            } else {
                this.exceptions.add(new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17007, new Object[]{func.getName()})));
            }
        } else {
            this.exceptions.add(new TranslatorException(ODataPlugin.Util.gs((BundleUtil.Event)ODataPlugin.Event.TEIID17008, new Object[0])));
        }
    }

    private String getColumnName(Column column) {
        String columnName = column.getName();
        String columnGroup = column.getProperty("{http://www.jboss.org/teiiddesigner/ext/odata/2012}ColumnGroup", false);
        if (columnGroup != null) {
            columnName = columnGroup;
        }
        return columnName;
    }

    public void append(LanguageObject obj) {
        this.visitNode(obj);
    }

    protected void append(List<? extends LanguageObject> items) {
        if (items != null && items.size() != 0) {
            for (int i = 0; i < items.size(); ++i) {
                this.append(items.get(i));
            }
        }
    }

    protected void append(LanguageObject[] items) {
        if (items != null && items.length != 0) {
            for (int i = 0; i < items.length; ++i) {
                this.append(items[i]);
            }
        }
    }

    static {
        infixFunctions.put("%", "mod");
        infixFunctions.put("+", "add");
        infixFunctions.put("-", "sub");
        infixFunctions.put("*", "mul");
        infixFunctions.put("/", "div");
    }

    class EntitiesInQuery {
        ArrayList<Entity> entities = new ArrayList();

        EntitiesInQuery() {
        }

        public void append(StringBuilder url) {
            if (this.entities.size() == 1) {
                this.addEntityToURL(url, this.entities.get(0));
            } else if (this.entities.size() > 1) {
                for (int i = 0; i < this.entities.size() - 1; ++i) {
                    this.addEntityToURL(url, this.entities.get(i));
                    url.append("/");
                }
                this.addEntityToURL(url, this.entities.get(this.entities.size() - 1));
            }
        }

        public boolean isKeyLookup() {
            return this.entities.get(this.entities.size() - 1).hasValidKey();
        }

        public Table getFinalEntity() {
            return this.entities.get((int)(this.entities.size() - 1)).table;
        }

        private void addEntityToURL(StringBuilder url, Entity entity) {
            url.append(entity.table.getName());
            if (entity.hasValidKey()) {
                boolean useNames = entity.pkValues.size() > 1;
                url.append("(");
                boolean firstKey = true;
                for (Column c : entity.pkValues.keySet()) {
                    if (firstKey) {
                        firstKey = false;
                    } else {
                        url.append(",");
                    }
                    if (useNames) {
                        url.append(c.getName()).append("=");
                    }
                    ODataSQLVisitor.this.executionFactory.convertToODataInput(entity.pkValues.get(c), url);
                }
                url.append(")");
            }
        }

        public void addEntity(Table table) {
            Entity entity = new Entity(table);
            this.entities.add(entity);
        }

        private Entity getEntity(Table table) {
            for (Entity e : this.entities) {
                if (!e.table.equals((Object)table)) continue;
                return e;
            }
            return null;
        }

        private boolean addEnityKey(Comparison obj) {
            if (obj.getOperator().equals((Object)Comparison.Operator.EQ)) {
                ColumnReference columnRef;
                Table parentTable;
                Entity entity;
                if (obj.getLeftExpression() instanceof ColumnReference && obj.getRightExpression() instanceof Literal && (entity = this.getEntity(parentTable = (columnRef = (ColumnReference)obj.getLeftExpression()).getTable().getMetadataObject())) != null) {
                    Column column = columnRef.getMetadataObject();
                    if (parentTable.getPrimaryKey().getColumnByName(column.getName()) != null) {
                        entity.addKeyValue(column, (Literal)obj.getRightExpression());
                        return true;
                    }
                }
                if (obj.getLeftExpression() instanceof ColumnReference && obj.getRightExpression() instanceof ColumnReference) {
                    Column left = ((ColumnReference)obj.getLeftExpression()).getMetadataObject();
                    Column right = ((ColumnReference)obj.getRightExpression()).getMetadataObject();
                    if (this.isJoinOrPkColumn(left) && this.isJoinOrPkColumn(right)) {
                        Entity leftEntity = this.getEntity((Table)left.getParent());
                        Entity rightEntity = this.getEntity((Table)right.getParent());
                        leftEntity.addRelation(left, right, rightEntity);
                        rightEntity.addRelation(right, left, leftEntity);
                        return true;
                    }
                }
            }
            return false;
        }

        private boolean isJoinOrPkColumn(Column column) {
            boolean joinColumn = Boolean.valueOf(column.getProperty("{http://www.jboss.org/teiiddesigner/ext/odata/2012}JoinColumn", false));
            if (!joinColumn) {
                Table table = (Table)column.getParent();
                return table.getPrimaryKey().getColumnByName(column.getName()) != null;
            }
            return false;
        }

        private boolean valid() {
            for (Entity e : this.entities) {
                if (!e.hasValidKey()) continue;
                return true;
            }
            return false;
        }
    }

    static class Entity {
        Table table;
        Map<Column, Literal> pkValues = new HashMap<Column, Literal>();
        boolean hasValidKey = false;
        List<Object[]> relations = new ArrayList<Object[]>();

        public Entity(Table t) {
            this.table = t;
        }

        public void addKeyValue(Column column, Literal value) {
            this.addKeyValue(column, value, true);
        }

        private void addKeyValue(Column column, Literal value, boolean walkRelations) {
            this.pkValues.put(column, value);
            if (walkRelations) {
                for (Object[] relation : this.relations) {
                    if (!column.equals(relation[0])) continue;
                    ((Entity)relation[2]).addKeyValue((Column)relation[1], value, false);
                }
            }
            for (Column col : this.table.getPrimaryKey().getColumns()) {
                if (this.pkValues.get(col) != null) continue;
                return;
            }
            this.hasValidKey = true;
        }

        public boolean hasValidKey() {
            return this.hasValidKey;
        }

        public void addRelation(Column self, Column other, Entity otherEntity) {
            this.relations.add(new Object[]{self, other, otherEntity});
        }
    }
}

