/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.ws;

import java.io.StringReader;
import java.io.StringWriter;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.Arrays;
import java.util.List;
import javax.xml.stream.XMLStreamException;
import javax.xml.transform.Source;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.stax.StAXSource;
import javax.xml.transform.stream.StreamResult;
import javax.xml.ws.Dispatch;
import javax.xml.ws.WebServiceException;
import org.teiid.core.types.XMLType;
import org.teiid.language.Argument;
import org.teiid.language.Call;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.WSConnection;
import org.teiid.translator.ws.WSExecutionFactory;
import org.teiid.util.StAXSQLXML;

public class WSProcedureExecution
implements ProcedureExecution {
    RuntimeMetadata metadata;
    ExecutionContext context;
    private Call procedure;
    private StAXSource returnValue;
    private WSConnection conn;
    private WSExecutionFactory executionFactory;

    public WSProcedureExecution(Call procedure, RuntimeMetadata metadata, ExecutionContext context, WSExecutionFactory executionFactory, WSConnection conn) {
        this.metadata = metadata;
        this.context = context;
        this.procedure = procedure;
        this.conn = conn;
        this.executionFactory = executionFactory;
    }

    public void execute() throws TranslatorException {
        List arguments = this.procedure.getArguments();
        String style = (String)((Argument)arguments.get(0)).getArgumentValue().getValue();
        String action = (String)((Argument)arguments.get(1)).getArgumentValue().getValue();
        XMLType docObject = (XMLType)((Argument)arguments.get(2)).getArgumentValue().getValue();
        StAXSource source = null;
        try {
            source = this.convertToSource((SQLXML)docObject);
            String endpoint = (String)((Argument)arguments.get(3)).getArgumentValue().getValue();
            if (style == null) {
                style = this.executionFactory.getDefaultBinding().getBindingId();
            } else {
                try {
                    WSExecutionFactory.Binding type = WSExecutionFactory.Binding.valueOf(style.toUpperCase());
                    style = type.getBindingId();
                }
                catch (IllegalArgumentException e) {
                    throw new TranslatorException(WSExecutionFactory.UTIL.getString("invalid_invocation", new Object[]{Arrays.toString((Object[])WSExecutionFactory.Binding.values())}));
                }
            }
            Dispatch dispatch = this.conn.createDispatch(style, endpoint, StAXSource.class, this.executionFactory.getDefaultServiceMode());
            if (WSExecutionFactory.Binding.HTTP.getBindingId().equals(style)) {
                if (action == null) {
                    action = "POST";
                }
                dispatch.getRequestContext().put("javax.xml.ws.http.request.method", action);
                if (source != null && !"POST".equalsIgnoreCase(action)) {
                    if (this.executionFactory.getXMLParamName() == null) {
                        throw new WebServiceException(WSExecutionFactory.UTIL.getString("http_usage_error"));
                    }
                    try {
                        Transformer t = TransformerFactory.newInstance().newTransformer();
                        StringWriter writer = new StringWriter();
                        t.transform(source, new StreamResult(writer));
                        String param = WSConnection.Util.httpURLEncode((String)this.executionFactory.getXMLParamName()) + "=" + WSConnection.Util.httpURLEncode((String)writer.toString());
                        endpoint = WSConnection.Util.appendQueryString((String)endpoint, (String)param);
                    }
                    catch (TransformerException e) {
                        throw new WebServiceException((Throwable)e);
                    }
                }
            } else if (action != null) {
                dispatch.getRequestContext().put("javax.xml.ws.soap.http.soapaction.use", Boolean.TRUE);
                dispatch.getRequestContext().put("javax.xml.ws.soap.http.soapaction.uri", action);
            }
            if (source == null) {
                source = new StAXSource(XMLType.getXmlInputFactory().createXMLEventReader(new StringReader("<none/>")));
            }
            this.returnValue = (StAXSource)dispatch.invoke((Object)source);
        }
        catch (SQLException e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (WebServiceException e) {
            throw new TranslatorException((Throwable)e);
        }
        catch (XMLStreamException e) {
            throw new TranslatorException((Throwable)e);
        }
        finally {
            WSConnection.Util.closeSource((Source)source);
        }
    }

    private StAXSource convertToSource(SQLXML xml) throws SQLException {
        if (xml == null) {
            return null;
        }
        return xml.getSource(StAXSource.class);
    }

    public List<?> next() throws TranslatorException, DataNotAvailableException {
        return null;
    }

    public List<?> getOutputParameterValues() throws TranslatorException {
        StAXSource result = this.returnValue;
        if (this.returnValue != null && this.procedure.getArguments().size() > 4 && Boolean.TRUE.equals(((Argument)this.procedure.getArguments().get(4)).getArgumentValue().getValue())) {
            StAXSQLXML sqlXml = new StAXSQLXML(this.returnValue);
            XMLType xml = new XMLType((SQLXML)sqlXml);
            xml.setType(XMLType.Type.DOCUMENT);
            result = xml;
        }
        return Arrays.asList(result);
    }

    public void close() {
    }

    public void cancel() throws TranslatorException {
    }
}

