/*
 * Decompiled with CFR 0.152.
 */
package org.teiid.translator.ws;

import java.io.IOException;
import java.io.InputStream;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.SQLException;
import java.sql.SQLXML;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.activation.DataSource;
import javax.xml.ws.Dispatch;
import javax.xml.ws.Service;
import javax.xml.ws.WebServiceException;
import org.teiid.core.BundleUtil;
import org.teiid.core.types.BlobImpl;
import org.teiid.core.types.BlobType;
import org.teiid.core.types.ClobImpl;
import org.teiid.core.types.InputStreamFactory;
import org.teiid.language.Argument;
import org.teiid.language.Call;
import org.teiid.metadata.RuntimeMetadata;
import org.teiid.translator.DataNotAvailableException;
import org.teiid.translator.ExecutionContext;
import org.teiid.translator.ProcedureExecution;
import org.teiid.translator.TranslatorException;
import org.teiid.translator.WSConnection;
import org.teiid.translator.ws.WSExecutionFactory;

public class BinaryWSProcedureExecution
implements ProcedureExecution {
    RuntimeMetadata metadata;
    ExecutionContext context;
    private Call procedure;
    private DataSource returnValue;
    private WSConnection conn;
    WSExecutionFactory executionFactory;
    Map<String, List<String>> customHeaders = new HashMap<String, List<String>>();
    Map<String, Object> responseContext = Collections.emptyMap();
    int responseCode = 200;
    private boolean useResponseContext;
    private boolean alwaysAllowPayloads;

    public BinaryWSProcedureExecution(Call procedure, RuntimeMetadata metadata, ExecutionContext context, WSExecutionFactory executionFactory, WSConnection conn) {
        this.metadata = metadata;
        this.context = context;
        this.procedure = procedure;
        this.conn = conn;
        this.executionFactory = executionFactory;
    }

    public void setUseResponseContext(boolean useResponseContext) {
        this.useResponseContext = useResponseContext;
    }

    public void setAlwaysAllowPayloads(boolean alwaysAllowPayloads) {
        this.alwaysAllowPayloads = alwaysAllowPayloads;
    }

    public void execute() throws TranslatorException {
        List arguments = this.procedure.getArguments();
        String method = (String)((Argument)arguments.get(0)).getArgumentValue().getValue();
        Object payload = ((Argument)arguments.get(1)).getArgumentValue().getValue();
        String endpoint = (String)((Argument)arguments.get(2)).getArgumentValue().getValue();
        try {
            Dispatch dispatch = this.conn.createDispatch("http://www.w3.org/2004/08/wsdl/http", endpoint, DataSource.class, Service.Mode.MESSAGE);
            if (method == null) {
                method = "POST";
            }
            dispatch.getRequestContext().put("javax.xml.ws.http.request.method", method);
            if (!this.alwaysAllowPayloads && payload != null && !"POST".equalsIgnoreCase(method)) {
                throw new WebServiceException(WSExecutionFactory.UTIL.getString("http_usage_error"));
            }
            Map httpHeaders = (Map)dispatch.getRequestContext().get("javax.xml.ws.http.request.headers");
            for (String key : this.customHeaders.keySet()) {
                httpHeaders.put(key, this.customHeaders.get(key));
            }
            dispatch.getRequestContext().put("javax.xml.ws.http.request.headers", httpHeaders);
            InputStreamFactory.ClobInputStreamFactory ds = null;
            if (payload instanceof String) {
                ds = new InputStreamFactory.ClobInputStreamFactory(ClobImpl.createClob((char[])((String)payload).toCharArray()));
            } else if (payload instanceof SQLXML) {
                ds = new InputStreamFactory.SQLXMLInputStreamFactory((SQLXML)payload);
            } else if (payload instanceof Clob) {
                ds = new InputStreamFactory.ClobInputStreamFactory((Clob)payload);
            } else if (payload instanceof Blob) {
                ds = new InputStreamFactory.BlobInputStreamFactory((Blob)payload);
            }
            this.returnValue = (DataSource)dispatch.invoke((Object)ds);
            Map rc = dispatch.getResponseContext();
            this.responseCode = (Integer)rc.get("status-code");
            if (this.useResponseContext) {
                this.responseContext = rc;
            } else if (this.responseCode >= 400) {
                String message = this.conn.getStatusMessage(this.responseCode);
                throw new TranslatorException((BundleUtil.Event)WSExecutionFactory.Event.TEIID15005, WSExecutionFactory.UTIL.gs((BundleUtil.Event)WSExecutionFactory.Event.TEIID15005, new Object[]{this.responseCode, message}));
            }
        }
        catch (WebServiceException e) {
            throw new TranslatorException((Throwable)e);
        }
    }

    public List<?> next() throws TranslatorException, DataNotAvailableException {
        return null;
    }

    public List<?> getOutputParameterValues() throws TranslatorException {
        DataSource result = this.returnValue;
        if (this.returnValue != null && this.procedure.getArguments().size() > 4 && Boolean.TRUE.equals(((Argument)this.procedure.getArguments().get(3)).getArgumentValue().getValue())) {
            try {
                result = new BlobType((Blob)((Object)new StreamingBlob(this.returnValue.getInputStream())));
            }
            catch (IOException e) {
                throw new TranslatorException((Throwable)e);
            }
        }
        return Arrays.asList(result, this.returnValue.getContentType());
    }

    public void close() {
    }

    public void cancel() throws TranslatorException {
    }

    public void addHeader(String name, List<String> value) {
        this.customHeaders.put(name, value);
    }

    public Object getResponseHeader(String name) {
        return this.responseContext.get(name);
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public static final class StreamingBlob
    extends BlobImpl {
        InputStream is;

        public StreamingBlob(InputStream is) {
            this.is = is;
        }

        public InputStream getBinaryStream() throws SQLException {
            if (this.is == null) {
                throw new SQLException("Already Freed.");
            }
            InputStream result = this.is;
            this.is = null;
            return result;
        }
    }
}

