/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.sandbox;

import java.io.File;
import javax.xml.stream.XMLInputFactory;
import nu.xom.Document;
import nu.xom.NodeFactory;
import nux.xom.io.StaxUtil;
import nux.xom.sandbox.IOTest;
import nux.xom.sandbox.IOTestUtil;

public class StaxBuilderTest
extends IOTest {
    public static void main(String[] args) throws Throwable {
        System.setProperty("nu.xom.Verifier.checkURI", "false");
        int bugs = 0;
        int k = 0;
        int i = 0;
        while (i < args.length) {
            File[] files = IOTestUtil.listXMLFiles(args[i]);
            int j = 0;
            while (j < files.length) {
                File file = files[j];
                if (StaxBuilderTest.bogus(file) || StaxBuilderTest.ignore(file) || file.isDirectory()) {
                    System.out.println("\n" + k + ": IGNORING " + file + " ...");
                } else {
                    System.out.println("\n" + k + ": now processing " + file + " ...");
                    try {
                        new StaxBuilderTest().run(file);
                    }
                    catch (Throwable e) {
                        ++bugs;
                        if (FAIL_FAST) {
                            throw e;
                        }
                        System.err.println("\nOopsla:" + k + ":" + bugs + ":" + file + ":");
                        e.printStackTrace();
                    }
                }
                ++j;
                ++k;
            }
            ++i;
        }
        System.out.println("\nNumber of bugs detected: " + bugs);
    }

    private void run(File file) throws Exception {
        Document expected = StaxBuilderTest.getBuilder().build(file);
        NodeFactory factory = new NodeFactory();
        XMLInputFactory staxFactory = StaxBuilderTest.createXMLInputFactory();
        Document actual = StaxUtil.createBuilder(staxFactory, factory).build(file);
        IOTestUtil.xomAssertEquals(expected, actual);
        IOTestUtil.canonicalAssertEquals(expected, actual);
    }

    private static boolean ignore(File xmlFile) {
        String file = xmlFile.getAbsolutePath();
        if (StaxBuilderTest.endsWith(file, "/data/xinclude/input/text/EBCDIC.xml")) {
            return true;
        }
        return StaxBuilderTest.endsWith(file, "XInclude-Test-Suite/Harold/test/text/EBCDIC.xml");
    }

    private static XMLInputFactory createXMLInputFactory() {
        String clazz = System.getProperty("javax.xml.stream.XMLInputFactory");
        if (clazz == null) {
            return null;
        }
        XMLInputFactory staxFactory = XMLInputFactory.newInstance();
        System.out.println("staxFactory=" + staxFactory.getClass().getName());
        return staxFactory;
    }
}

