/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.sandbox;

import nu.xom.Builder;
import nu.xom.Document;
import nu.xom.Element;
import nu.xom.Node;
import nux.xom.pool.DocumentMap;
import nux.xom.pool.PoolConfig;

public final class DocumentMapTest {
    public static void main(String[] args) throws Exception {
        System.setProperty("nux.xom.pool.Pool.debug", "true");
        final PoolConfig config = new PoolConfig();
        int k = -1;
        Document doc = null;
        if (args.length > ++k && !args[k].equals("-")) {
            doc = new Builder().build(args[k]);
        }
        int threads = 1;
        if (args.length > ++k) {
            threads = Math.max(1, Integer.parseInt(args[k]));
        }
        if (args.length > ++k) {
            config.setCompressionLevel(Integer.parseInt(args[k]));
        }
        if (args.length > ++k) {
            config.setMaxEntries(Integer.parseInt(args[k]));
        }
        if (args.length > ++k) {
            config.setFileMonitoring(new Boolean(args[k]));
        }
        if (args.length > ++k) {
            config.setCapacity(Long.parseLong(args[k]));
        }
        if (args.length > ++k) {
            config.setMaxIdleTime(Long.parseLong(args[k]));
        }
        if (args.length > ++k) {
            config.setMaxLifeTime(Long.parseLong(args[k]));
        }
        int printStep = 10;
        if (args.length > ++k) {
            printStep = Math.max(1, Integer.parseInt(args[k]));
        }
        final DocumentMap pool = new DocumentMap(config);
        int j = 0;
        while (j < threads) {
            final int t = j++;
            final Document xmlDoc = doc;
            final int step = printStep;
            Runnable runner = new Runnable(){

                public void run() {
                    try {
                        int i = 0;
                        while (true) {
                            Document doc;
                            if (i % step == 0) {
                                System.out.println("t=" + t + ", index=" + i);
                            }
                            if (xmlDoc == null) {
                                Element root = new Element("root");
                                Element child = new Element("child");
                                root.appendChild((Node)child);
                                int j = 0;
                                while (j < 10000) {
                                    child.appendChild("xxxxxxxxxxxxxxxxxx" + j);
                                    ++j;
                                }
                                doc = new Document(root);
                            } else {
                                doc = xmlDoc;
                                if (config.getCompressionLevel() == -1) {
                                    doc = new Document(doc);
                                }
                            }
                            Integer key = new Integer(i + t * 100);
                            pool.putDocument(key, doc);
                            pool.getDocument(new Integer(8));
                            ++i;
                        }
                    }
                    catch (Throwable t2) {
                        t2.printStackTrace();
                        System.exit(-1);
                        return;
                    }
                }
            };
            new Thread(runner).start();
        }
        Thread.sleep(Long.MAX_VALUE);
    }
}

