/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.pool;

import java.util.Map;
import nu.xom.Document;
import nux.xom.binary.BinaryParsingException;
import nux.xom.pool.Pool;
import nux.xom.pool.PoolConfig;
import nux.xom.pool.XOMUtil;

public class DocumentMap {
    private final Map entries;
    private final int compressionLevel;
    private final int maxEntries;

    public DocumentMap(PoolConfig config) {
        if (config == null) {
            throw new IllegalArgumentException("config must not be null");
        }
        this.compressionLevel = config.getCompressionLevel();
        int maxEntries = config.getMaxEntries();
        if (config.getCapacity() <= 0L || config.getMaxIdleTime() <= 0L || config.getMaxLifeTime() <= 0L) {
            maxEntries = 0;
        }
        this.maxEntries = maxEntries;
        this.entries = Pool.createPool(config);
    }

    public Document getDocument(Object key) {
        if (this.maxEntries == 0) {
            return null;
        }
        Object value = this.entries.get(key);
        if (value == null) {
            return null;
        }
        if (value instanceof Document) {
            return (Document)value;
        }
        try {
            return XOMUtil.getBinaryXMLCodec().deserialize((byte[])value);
        }
        catch (BinaryParsingException e) {
            throw new RuntimeException((Throwable)((Object)e));
        }
    }

    public void putDocument(Object key, Document doc) {
        if (this.maxEntries == 0) {
            return;
        }
        if (doc == null) {
            this.entries.remove(key);
        } else if (this.compressionLevel == -1) {
            this.entries.put(key, doc);
        } else {
            this.entries.put(key, XOMUtil.getBinaryXMLCodec().serialize(doc, this.compressionLevel));
        }
    }
}

