/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.binary;

final class LRUHashMap1 {
    private static final float LOAD_FACTOR = 0.75f;
    private static final int INITIAL_CAPACITY = 16;
    private Entry[] entries = new Entry[16];
    private int threshold = 12;
    private int size = 0;
    private final int maxSize;
    private final Entry header;

    LRUHashMap1(int maxSize) {
        this.maxSize = maxSize;
        this.header.before = this.header.after = (this.header = new Entry(null, -1, null, null));
    }

    public void clear() {
        this.size = 0;
        this.header.before = this.header.after = this.header;
        Entry[] src = this.entries;
        int i = src.length;
        while (--i >= 0) {
            src[i] = null;
        }
    }

    public Object get(String key) {
        int hash = LRUHashMap1.hash(key);
        int i = hash & this.entries.length - 1;
        Entry entry = LRUHashMap1.findEntry(key, this.entries[i], hash);
        if (entry == null) {
            return null;
        }
        entry.remove();
        entry.insert(this.header);
        return entry.value;
    }

    public void put(String key, Object value) {
        int hash = LRUHashMap1.hash(key);
        int i = hash & this.entries.length - 1;
        Entry entry = LRUHashMap1.findEntry(key, this.entries[i], hash);
        if (entry != null) {
            entry.value = value;
            entry.remove();
            entry.insert(this.header);
        } else {
            this.entries[i] = new Entry(key, hash, this.entries[i], value);
            this.entries[i].insert(this.header);
            ++this.size;
            if (this.size > this.maxSize) {
                this.removeEntry(this.header.after.key);
            }
            if (this.size >= this.threshold) {
                this.rehash();
            }
        }
    }

    public int size() {
        return this.size;
    }

    private static Entry findEntry(String key, Entry cursor, int hash) {
        while (cursor != null) {
            if (hash == cursor.hash && LRUHashMap1.eq(key, cursor.key)) {
                return cursor;
            }
            cursor = cursor.next;
        }
        return null;
    }

    private void removeEntry(String key) {
        int hash = LRUHashMap1.hash(key);
        int i = hash & this.entries.length - 1;
        Entry previous = null;
        Entry entry = this.entries[i];
        while (entry != null) {
            if (hash == entry.hash && LRUHashMap1.eq(key, entry.key)) {
                if (previous == null) {
                    this.entries[i] = entry.next;
                } else {
                    previous.next = entry.next;
                }
                --this.size;
                entry.remove();
                return;
            }
            previous = entry;
            entry = entry.next;
        }
    }

    private void rehash() {
        Entry[] src = this.entries;
        int capacity = 2 * src.length;
        Entry[] dst = new Entry[capacity];
        int i = src.length;
        while (--i >= 0) {
            Entry entry = src[i];
            while (entry != null) {
                int j = entry.hash & capacity - 1;
                Entry next = entry.next;
                entry.next = dst[j];
                dst[j] = entry;
                entry = next;
            }
        }
        this.entries = dst;
        this.threshold = (int)((float)capacity * 0.75f);
    }

    private static boolean eq(String x, String y) {
        return x == y || x.equals(y);
    }

    private static int hash(String key) {
        return LRUHashMap1.auxiliaryHash(key.hashCode());
    }

    private static int auxiliaryHash(int h) {
        h += ~(h << 9);
        h ^= h >>> 14;
        h += h << 4;
        h ^= h >>> 10;
        return h;
    }

    private static final class Entry {
        String key;
        Object value;
        final int hash;
        Entry next;
        Entry before;
        Entry after;

        Entry(String key, int hash, Entry next, Object value) {
            this.key = key;
            this.hash = hash;
            this.next = next;
            this.value = value;
        }

        void remove() {
            this.before.after = this.after;
            this.after.before = this.before;
        }

        void insert(Entry successor) {
            this.after = successor;
            this.before = successor.before;
            this.before.after = this;
            this.after.before = this;
        }
    }
}

