/*
 * Decompiled with CFR 0.152.
 */
package nux.xom.binary;

public final class ArrayIntList {
    private transient int[] elements;
    private int size;

    public ArrayIntList() {
        this(10);
    }

    public ArrayIntList(int initialCapacity) {
        this.elements = new int[initialCapacity];
        this.size = 0;
    }

    public void add(int elem) {
        if (this.size == this.elements.length) {
            this.ensureCapacity(this.size + 1);
        }
        this.elements[this.size++] = elem;
    }

    public void add(int[] elems, int offset, int length) {
        if (offset < 0 || length < 0 || offset + length > elems.length) {
            throw new IndexOutOfBoundsException("offset: " + offset + ", length: " + length + ", elems.length: " + elems.length);
        }
        this.ensureCapacity(this.size + length);
        System.arraycopy(elems, offset, this.elements, this.size, length);
        this.size += length;
    }

    public int[] asArray() {
        return this.elements;
    }

    public void clear() {
        this.size = 0;
    }

    public void ensureCapacity(int minCapacity) {
        if (minCapacity > this.elements.length) {
            int newCapacity = Math.max(minCapacity, 2 * this.elements.length + 1);
            this.elements = this.subArray(0, this.size, newCapacity);
        }
    }

    public int size() {
        return this.size;
    }

    private int[] subArray(int from, int length, int capacity) {
        int[] subArray = new int[capacity];
        System.arraycopy(this.elements, from, subArray, 0, length);
        return subArray;
    }

    public int[] toArray() {
        return this.subArray(0, this.size, this.size);
    }
}

