/*
 * Decompiled with CFR 0.152.
 */
package org.jboss.remoting3.remote;

import java.io.IOException;
import java.net.InetSocketAddress;
import java.nio.BufferOverflowException;
import java.nio.BufferUnderflowException;
import java.nio.ByteBuffer;
import java.security.AccessControlContext;
import java.security.AccessController;
import java.security.Principal;
import java.security.PrivilegedActionException;
import java.security.PrivilegedExceptionAction;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import java.util.Set;
import javax.net.ssl.SSLPeerUnverifiedException;
import javax.net.ssl.SSLSession;
import javax.security.auth.callback.CallbackHandler;
import javax.security.sasl.SaslClient;
import javax.security.sasl.SaslClientFactory;
import javax.security.sasl.SaslException;
import org.jboss.remoting3.RemotingOptions;
import org.jboss.remoting3.Version;
import org.jboss.remoting3.remote.Protocol;
import org.jboss.remoting3.remote.ProtocolUtils;
import org.jboss.remoting3.remote.RemoteConnection;
import org.jboss.remoting3.remote.RemoteConnectionHandler;
import org.jboss.remoting3.remote.RemoteLogger;
import org.jboss.remoting3.remote.RemoteReadListener;
import org.jboss.remoting3.security.InetAddressPrincipal;
import org.jboss.remoting3.security.SimpleUserInfo;
import org.jboss.remoting3.security.UserPrincipal;
import org.jboss.remoting3.spi.ConnectionHandler;
import org.jboss.remoting3.spi.ConnectionHandlerContext;
import org.jboss.remoting3.spi.ConnectionHandlerFactory;
import org.jboss.remoting3.spi.ConnectionProviderContext;
import org.xnio.Buffers;
import org.xnio.ChannelListener;
import org.xnio.Option;
import org.xnio.OptionMap;
import org.xnio.Options;
import org.xnio.Pooled;
import org.xnio.Sequence;
import org.xnio.channels.Channels;
import org.xnio.channels.Configurable;
import org.xnio.channels.ConnectedMessageChannel;
import org.xnio.channels.SslChannel;
import org.xnio.channels.WrappedChannel;
import org.xnio.sasl.SaslUtils;
import org.xnio.sasl.SaslWrapper;

final class ClientConnectionOpenListener
implements ChannelListener<ConnectedMessageChannel> {
    private final RemoteConnection connection;
    private final ConnectionProviderContext connectionProviderContext;
    private final CallbackHandler callbackHandler;
    private final AccessControlContext accessControlContext;
    private final OptionMap optionMap;
    private final Set<String> failedMechs = new HashSet<String>();
    private final Set<String> allowedMechs;
    private final Set<String> disallowedMechs;

    ClientConnectionOpenListener(RemoteConnection connection, ConnectionProviderContext connectionProviderContext, CallbackHandler callbackHandler, AccessControlContext accessControlContext, OptionMap optionMap) {
        this.connection = connection;
        this.connectionProviderContext = connectionProviderContext;
        this.callbackHandler = callbackHandler;
        this.accessControlContext = accessControlContext;
        this.optionMap = optionMap;
        Sequence allowedMechs = (Sequence)optionMap.get(Options.SASL_MECHANISMS);
        Sequence disallowedMechs = (Sequence)optionMap.get(Options.SASL_DISALLOWED_MECHANISMS);
        this.allowedMechs = allowedMechs == null ? null : new HashSet(allowedMechs);
        this.disallowedMechs = disallowedMechs == null ? Collections.emptySet() : new HashSet(disallowedMechs);
    }

    public void handleEvent(ConnectedMessageChannel channel) {
        this.connection.setReadListener(new Greeting(), true);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    void sendCapRequest(String remoteServerName) {
        RemoteLogger.client.trace("Client sending capabilities request");
        Pooled<ByteBuffer> pooledSendBuffer = this.connection.allocate();
        boolean ok = false;
        try {
            ByteBuffer sendBuffer = (ByteBuffer)pooledSendBuffer.getResource();
            sendBuffer.put((byte)1);
            ProtocolUtils.writeByte(sendBuffer, 0, 1);
            String localEndpointName = this.connectionProviderContext.getEndpoint().getName();
            if (localEndpointName != null) {
                ProtocolUtils.writeString(sendBuffer, (byte)3, localEndpointName);
            }
            ProtocolUtils.writeEmpty(sendBuffer, 4);
            ProtocolUtils.writeString(sendBuffer, (byte)5, Version.VERSION);
            ProtocolUtils.writeInt(sendBuffer, 6, this.optionMap.get(RemotingOptions.MAX_INBOUND_CHANNELS, 40));
            ProtocolUtils.writeInt(sendBuffer, 7, this.optionMap.get(RemotingOptions.MAX_OUTBOUND_CHANNELS, 40));
            sendBuffer.flip();
            this.connection.setReadListener(new Capabilities(remoteServerName), true);
            this.connection.send(pooledSendBuffer);
            ok = true;
            return;
        }
        finally {
            if (!ok) {
                pooledSendBuffer.free();
            }
        }
    }

    private void saslDispose(SaslClient saslClient) {
        if (saslClient != null) {
            try {
                saslClient.dispose();
            }
            catch (SaslException e) {
                RemoteLogger.client.trace("Failure disposing of SaslClient", e);
            }
        }
    }

    static /* synthetic */ Set access$200(ClientConnectionOpenListener x0) {
        return x0.disallowedMechs;
    }

    static /* synthetic */ Set access$300(ClientConnectionOpenListener x0) {
        return x0.allowedMechs;
    }

    static /* synthetic */ OptionMap access$400(ClientConnectionOpenListener x0) {
        return x0.optionMap;
    }

    static /* synthetic */ AccessControlContext access$700(ClientConnectionOpenListener x0) {
        return x0.accessControlContext;
    }

    final class Authentication
    implements ChannelListener<ConnectedMessageChannel> {
        private final SaslClient saslClient;
        private final String serverName;
        private final String authorizationID;
        private final String remoteEndpointName;
        private final int behavior;
        private final int maxInboundChannels;
        private final int maxOutboundChannels;

        Authentication(SaslClient saslClient, String serverName, String authorizationID, String remoteEndpointName, int behavior, int maxInboundChannels, int maxOutboundChannels) {
            this.saslClient = saslClient;
            this.serverName = serverName;
            this.authorizationID = authorizationID;
            this.remoteEndpointName = remoteEndpointName;
            this.behavior = behavior;
            this.maxInboundChannels = maxInboundChannels;
            this.maxOutboundChannels = maxOutboundChannels;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(final ConnectedMessageChannel channel) {
            Pooled<ByteBuffer> pooledBuffer = ClientConnectionOpenListener.this.connection.allocate();
            try {
                int res;
                final ByteBuffer buffer = (ByteBuffer)pooledBuffer.getResource();
                try {
                    res = channel.receive(buffer);
                }
                catch (IOException e) {
                    ClientConnectionOpenListener.this.connection.handleException(e);
                    ClientConnectionOpenListener.this.saslDispose(this.saslClient);
                    pooledBuffer.free();
                    return;
                }
                if (res == 0) {
                    return;
                }
                if (res == -1) {
                    ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.abruptClose(ClientConnectionOpenListener.this.connection));
                    ClientConnectionOpenListener.this.saslDispose(this.saslClient);
                    return;
                }
                buffer.flip();
                byte msgType = buffer.get();
                switch (msgType) {
                    case -16: {
                        RemoteLogger.client.trace("Client received connection alive");
                        ClientConnectionOpenListener.this.connection.sendAliveResponse();
                        return;
                    }
                    case -15: {
                        RemoteLogger.client.trace("Client received connection alive ack");
                        return;
                    }
                    case -1: {
                        RemoteLogger.client.trace("Client received connection close request");
                        ClientConnectionOpenListener.this.connection.handlePreAuthCloseRequest();
                        ClientConnectionOpenListener.this.saslDispose(this.saslClient);
                        return;
                    }
                    case 3: {
                        RemoteLogger.client.trace("Client received authentication challenge");
                        channel.suspendReads();
                        ClientConnectionOpenListener.this.connection.getExecutor().execute(new Runnable(){

                            @Override
                            public void run() {
                                byte[] response;
                                boolean clientComplete = Authentication.this.saslClient.isComplete();
                                if (clientComplete) {
                                    ClientConnectionOpenListener.this.connection.handleException(new SaslException("Received extra auth message after completion"));
                                    return;
                                }
                                byte[] challenge = Buffers.take((ByteBuffer)buffer, (int)buffer.remaining());
                                try {
                                    response = Authentication.this.saslClient.evaluateChallenge(challenge);
                                }
                                catch (Throwable e) {
                                    String mechanismName = Authentication.this.saslClient.getMechanismName();
                                    RemoteLogger.client.debugf("Client authentication failed for mechanism %s: %s", mechanismName, e);
                                    ClientConnectionOpenListener.this.failedMechs.add(mechanismName);
                                    ClientConnectionOpenListener.this.saslDispose(Authentication.this.saslClient);
                                    ClientConnectionOpenListener.this.sendCapRequest(Authentication.this.serverName);
                                    return;
                                }
                                RemoteLogger.client.trace("Client sending authentication response");
                                Pooled<ByteBuffer> pooled = ClientConnectionOpenListener.this.connection.allocate();
                                ByteBuffer sendBuffer = (ByteBuffer)pooled.getResource();
                                sendBuffer.put((byte)4);
                                sendBuffer.put(response);
                                sendBuffer.flip();
                                ClientConnectionOpenListener.this.connection.send(pooled);
                                channel.resumeReads();
                            }
                        });
                        return;
                    }
                    case 5: {
                        RemoteLogger.client.trace("Client received authentication complete");
                        channel.suspendReads();
                        ClientConnectionOpenListener.this.connection.getExecutor().execute(new Runnable(){

                            @Override
                            public void run() {
                                Object qop;
                                boolean clientComplete = Authentication.this.saslClient.isComplete();
                                byte[] challenge = Buffers.take((ByteBuffer)buffer, (int)buffer.remaining());
                                if (!clientComplete) {
                                    try {
                                        byte[] response = Authentication.this.saslClient.evaluateChallenge(challenge);
                                        if (response != null && response.length > 0) {
                                            ClientConnectionOpenListener.this.connection.handleException(new SaslException("Received extra auth message after completion"));
                                            ClientConnectionOpenListener.this.saslDispose(Authentication.this.saslClient);
                                            return;
                                        }
                                        if (!Authentication.this.saslClient.isComplete()) {
                                            ClientConnectionOpenListener.this.connection.handleException(new SaslException("Client not complete after processing auth complete message"));
                                            ClientConnectionOpenListener.this.saslDispose(Authentication.this.saslClient);
                                            return;
                                        }
                                    }
                                    catch (Throwable e) {
                                        String mechanismName = Authentication.this.saslClient.getMechanismName();
                                        RemoteLogger.client.debugf("Client authentication failed for mechanism %s: %s", mechanismName, e);
                                        ClientConnectionOpenListener.this.failedMechs.add(mechanismName);
                                        ClientConnectionOpenListener.this.saslDispose(Authentication.this.saslClient);
                                        ClientConnectionOpenListener.this.sendCapRequest(Authentication.this.serverName);
                                        return;
                                    }
                                }
                                if ("auth-int".equals(qop = Authentication.this.saslClient.getNegotiatedProperty("javax.security.sasl.qop")) || "auth-conf".equals(qop)) {
                                    ClientConnectionOpenListener.this.connection.setSaslWrapper(SaslWrapper.create((SaslClient)Authentication.this.saslClient));
                                }
                                ConnectionHandlerFactory connectionHandlerFactory = new ConnectionHandlerFactory(){

                                    @Override
                                    public ConnectionHandler createInstance(ConnectionHandlerContext connectionContext) {
                                        Collection principals = Authentication.this.definePrincipals();
                                        RemoteConnectionHandler connectionHandler = new RemoteConnectionHandler(connectionContext, ClientConnectionOpenListener.this.connection, principals, new SimpleUserInfo(principals), Authentication.this.maxInboundChannels, Authentication.this.maxOutboundChannels, Authentication.this.remoteEndpointName, Authentication.this.behavior);
                                        ClientConnectionOpenListener.this.connection.setReadListener(new RemoteReadListener(connectionHandler, ClientConnectionOpenListener.this.connection), false);
                                        ClientConnectionOpenListener.this.connection.getRemoteConnectionProvider().addConnectionHandler(connectionHandler);
                                        return connectionHandler;
                                    }
                                };
                                ClientConnectionOpenListener.this.connection.getResult().setResult((Object)connectionHandlerFactory);
                                channel.resumeReads();
                            }
                        });
                        return;
                    }
                    case 6: {
                        String mechanismName = this.saslClient.getMechanismName();
                        RemoteLogger.client.debugf("Client received authentication rejected for mechanism %s", mechanismName);
                        ClientConnectionOpenListener.this.failedMechs.add(mechanismName);
                        ClientConnectionOpenListener.this.saslDispose(this.saslClient);
                        ClientConnectionOpenListener.this.sendCapRequest(this.serverName);
                        return;
                    }
                }
                RemoteLogger.client.unknownProtocolId(msgType);
                ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.invalidMessage(ClientConnectionOpenListener.this.connection));
                ClientConnectionOpenListener.this.saslDispose(this.saslClient);
                return;
            }
            finally {
                pooledBuffer.free();
            }
        }

        private Collection<Principal> definePrincipals() {
            ConnectedMessageChannel channel;
            InetSocketAddress address;
            SSLSession session;
            LinkedHashSet<Principal> principals = new LinkedHashSet<Principal>();
            SslChannel sslChannel = ClientConnectionOpenListener.this.connection.getSslChannel();
            if (sslChannel != null && (session = sslChannel.getSslSession()) != null) {
                try {
                    principals.add(session.getPeerPrincipal());
                }
                catch (SSLPeerUnverifiedException ignored) {
                    // empty catch block
                }
            }
            if (this.authorizationID != null) {
                principals.add(new UserPrincipal(this.authorizationID));
            }
            if ((address = (InetSocketAddress)(channel = ClientConnectionOpenListener.this.connection.getChannel()).getPeerAddress(InetSocketAddress.class)) != null) {
                principals.add(new InetAddressPrincipal(address.getAddress()));
            }
            return principals;
        }
    }

    final class StartTls
    implements ChannelListener<ConnectedMessageChannel> {
        private final String remoteServerName;

        StartTls(String remoteServerName) {
            this.remoteServerName = remoteServerName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(ConnectedMessageChannel channel) {
            Pooled<ByteBuffer> pooledReceiveBuffer = ClientConnectionOpenListener.this.connection.allocate();
            try {
                int res;
                ByteBuffer receiveBuffer = (ByteBuffer)pooledReceiveBuffer.getResource();
                try {
                    res = channel.receive(receiveBuffer);
                }
                catch (IOException e) {
                    ClientConnectionOpenListener.this.connection.handleException(e);
                    pooledReceiveBuffer.free();
                    return;
                }
                if (res == -1) {
                    ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.abruptClose(ClientConnectionOpenListener.this.connection));
                    return;
                }
                if (res == 0) {
                    return;
                }
                RemoteLogger.client.tracef("Received %s", receiveBuffer);
                receiveBuffer.flip();
                byte msgType = receiveBuffer.get();
                switch (msgType) {
                    case -16: {
                        RemoteLogger.client.trace("Client received connection alive");
                        ClientConnectionOpenListener.this.connection.sendAliveResponse();
                        return;
                    }
                    case -15: {
                        RemoteLogger.client.trace("Client received connection alive ack");
                        return;
                    }
                    case -1: {
                        RemoteLogger.client.trace("Client received connection close request");
                        ClientConnectionOpenListener.this.connection.handlePreAuthCloseRequest();
                        return;
                    }
                    case 7: {
                        RemoteLogger.client.trace("Client received STARTTLS response");
                        Object c = channel;
                        while (true) {
                            if (c instanceof SslChannel) {
                                try {
                                    ((SslChannel)c).startHandshake();
                                }
                                catch (IOException e) {
                                    ClientConnectionOpenListener.this.connection.handleException(e, false);
                                    pooledReceiveBuffer.free();
                                    return;
                                }
                                ClientConnectionOpenListener.this.sendCapRequest(this.remoteServerName);
                                return;
                            }
                            if (!(c instanceof WrappedChannel)) break;
                            c = ((WrappedChannel)c).getChannel();
                        }
                        ClientConnectionOpenListener.this.connection.handleException(new IOException("Client starting STARTTLS but channel doesn't support SSL"));
                        return;
                    }
                }
                RemoteLogger.client.unknownProtocolId(msgType);
                ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.invalidMessage(ClientConnectionOpenListener.this.connection));
                return;
            }
            catch (BufferUnderflowException e) {
                ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.invalidMessage(ClientConnectionOpenListener.this.connection));
                return;
            }
            catch (BufferOverflowException e) {
                ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.invalidMessage(ClientConnectionOpenListener.this.connection));
                return;
            }
            finally {
                pooledReceiveBuffer.free();
            }
        }
    }

    final class Capabilities
    implements ChannelListener<ConnectedMessageChannel> {
        private final String remoteServerName;

        Capabilities(String remoteServerName) {
            this.remoteServerName = remoteServerName;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         * Unable to fully structure code
         */
        public void handleEvent(ConnectedMessageChannel channel) {
            pooledReceiveBuffer = ClientConnectionOpenListener.access$000(ClientConnectionOpenListener.this).allocate();
            try {
                receiveBuffer = (ByteBuffer)pooledReceiveBuffer.getResource();
                try {
                    res = channel.receive(receiveBuffer);
                }
                catch (IOException e) {
                    ClientConnectionOpenListener.access$000(ClientConnectionOpenListener.this).handleException(e);
                    pooledReceiveBuffer.free();
                    return;
                }
                if (res == -1) {
                    ClientConnectionOpenListener.access$000(ClientConnectionOpenListener.this).handleException(RemoteLogger.client.abruptClose(ClientConnectionOpenListener.access$000(ClientConnectionOpenListener.this)));
                    return;
                }
                if (res == 0) {
                    return;
                }
                receiveBuffer.flip();
                starttls = false;
                serverSaslMechs = new LinkedHashSet<String>();
                msgType = receiveBuffer.get();
                switch (msgType) {
                    case -16: {
                        RemoteLogger.client.trace("Client received connection alive");
                        ClientConnectionOpenListener.access$000(ClientConnectionOpenListener.this).sendAliveResponse();
                        return;
                    }
                    case -15: {
                        RemoteLogger.client.trace("Client received connection alive ack");
                        return;
                    }
                    case -1: {
                        RemoteLogger.client.trace("Client received connection close request");
                        ClientConnectionOpenListener.access$000(ClientConnectionOpenListener.this).handlePreAuthCloseRequest();
                        return;
                    }
                    case 1: {
                        RemoteLogger.client.trace("Client received capabilities response");
                        remoteEndpointName = null;
                        version = 1;
                        behavior = 2;
                        useDefaultChannels = true;
                        channelsIn = 40;
                        channelsOut = 40;
                        block38: while (receiveBuffer.hasRemaining()) {
                            type = receiveBuffer.get();
                            len = receiveBuffer.get() & 255;
                            data = Buffers.slice((ByteBuffer)receiveBuffer, (int)len);
                            switch (type) {
                                case 0: {
                                    version = data.get() & 255;
                                    RemoteLogger.client.tracef("Client received capability: version %d", version & 255);
                                    continue block38;
                                }
                                case 1: {
                                    mechName = Buffers.getModifiedUtf8((ByteBuffer)data);
                                    RemoteLogger.client.tracef("Client received capability: SASL mechanism %s", mechName);
                                    if (ClientConnectionOpenListener.access$100(ClientConnectionOpenListener.this).contains(mechName) || ClientConnectionOpenListener.access$200(ClientConnectionOpenListener.this).contains(mechName) || ClientConnectionOpenListener.access$300(ClientConnectionOpenListener.this) != null && !ClientConnectionOpenListener.access$300(ClientConnectionOpenListener.this).contains(mechName)) continue block38;
                                    RemoteLogger.client.tracef("SASL mechanism %s added to allowed set", mechName);
                                    serverSaslMechs.add(mechName);
                                    continue block38;
                                }
                                case 2: {
                                    RemoteLogger.client.trace("Client received capability: STARTTLS");
                                    starttls = true;
                                    continue block38;
                                }
                                case 3: {
                                    remoteEndpointName = Buffers.getModifiedUtf8((ByteBuffer)data);
                                    RemoteLogger.client.tracef("Client received capability: remote endpoint name \"%s\"", remoteEndpointName);
                                    continue block38;
                                }
                                case 4: {
                                    behavior |= 1;
                                    behavior &= -3;
                                    RemoteLogger.client.tracef("Client received capability: message close protocol supported", new Object[0]);
                                    continue block38;
                                }
                                case 5: {
                                    behavior &= -3;
                                    remoteVersionString = Buffers.getModifiedUtf8((ByteBuffer)data);
                                    RemoteLogger.client.tracef("Client received capability: remote version is \"%s\"", remoteVersionString);
                                    continue block38;
                                }
                                case 6: {
                                    useDefaultChannels = false;
                                    channelsOut = ProtocolUtils.readIntData(data, len);
                                    RemoteLogger.client.tracef("Client received capability: remote channels in is \"%d\"", channelsOut);
                                    continue block38;
                                }
                                case 7: {
                                    useDefaultChannels = false;
                                    channelsIn = ProtocolUtils.readIntData(data, len);
                                    RemoteLogger.client.tracef("Client received capability: remote channels out is \"%d\"", channelsIn);
                                    continue block38;
                                }
                            }
                            RemoteLogger.client.tracef("Client received unknown capability %02x", type & 255);
                        }
                        if (useDefaultChannels) {
                            channelsIn = 40;
                            channelsOut = 40;
                        }
                        if (starttls && ClientConnectionOpenListener.access$400(ClientConnectionOpenListener.this).get(Options.SSL_STARTTLS, true)) {
                            pooledSendBuffer = ClientConnectionOpenListener.access$000(ClientConnectionOpenListener.this).allocate();
                            sendBuffer = (ByteBuffer)pooledSendBuffer.getResource();
                            sendBuffer.put((byte)7);
                            sendBuffer.flip();
                            ClientConnectionOpenListener.access$000(ClientConnectionOpenListener.this).setReadListener(new StartTls(this.remoteServerName), true);
                            ClientConnectionOpenListener.access$000(ClientConnectionOpenListener.this).send(pooledSendBuffer);
                            return;
                        }
                        if (serverSaslMechs.isEmpty()) {
                            ClientConnectionOpenListener.access$000(ClientConnectionOpenListener.this).handleException(new SaslException("Authentication failed: all available authentication mechanisms failed"));
                            return;
                        }
                        saslMechs = new ArrayList<String>(serverSaslMechs.size());
                        if (ClientConnectionOpenListener.access$300(ClientConnectionOpenListener.this) != null) {
                            saslMechs.addAll(ClientConnectionOpenListener.access$300(ClientConnectionOpenListener.this));
                            saslMechs.retainAll(serverSaslMechs);
                        } else {
                            saslMechs.addAll(serverSaslMechs);
                        }
                        optionMap = ClientConnectionOpenListener.access$000(ClientConnectionOpenListener.this).getOptionMap();
                        userName = (String)optionMap.get(RemotingOptions.AUTHORIZE_ID);
                        propertyMap = SaslUtils.createPropertyMap((OptionMap)optionMap, (boolean)Channels.getOption((Configurable)channel, (Option)Options.SECURE, (boolean)false));
                        saslClient = null;
                        try {
                            iterator = SaslUtils.getSaslClientFactories((ClassLoader)this.getClass().getClassLoader(), (boolean)true);
                            factories = new LinkedHashMap<String, LinkedHashSet<SaslClientFactory>>();
                            while (iterator.hasNext()) {
                                factory = (SaslClientFactory)iterator.next();
                                for (String name : factory.getMechanismNames(propertyMap)) {
                                    if (!factories.containsKey(name)) {
                                        factories.put(name, new LinkedHashSet<SaslClientFactory>(Collections.singleton(factory)));
                                        continue;
                                    }
                                    ((Set)factories.get(name)).add(factory);
                                }
                            }
                            for (String mechanism : saslMechs) {
                                factorySet = (Set)factories.get(mechanism);
                                if (factorySet == null) continue;
                                strings = new String[]{mechanism};
                                for (final SaslClientFactory factory : factorySet) {
                                    saslClient = AccessController.doPrivileged(new PrivilegedExceptionAction<SaslClient>(){

                                        @Override
                                        public SaslClient run() throws SaslException {
                                            return factory.createSaslClient(strings, userName, "remote", Capabilities.this.remoteServerName, propertyMap, ClientConnectionOpenListener.this.callbackHandler);
                                        }
                                    }, ClientConnectionOpenListener.access$700(ClientConnectionOpenListener.this));
                                    if (saslClient == null) continue;
                                    ** GOTO lbl148
                                }
                                ClientConnectionOpenListener.access$100(ClientConnectionOpenListener.this).add(mechanism);
                            }
                        }
                        catch (PrivilegedActionException e) {
                            se = (SaslException)e.getCause();
                            ClientConnectionOpenListener.access$000(ClientConnectionOpenListener.this).handleException(se);
                            pooledReceiveBuffer.free();
                            return;
                        }
lbl148:
                        // 2 sources

                        if (saslClient == null) {
                            ClientConnectionOpenListener.access$000(ClientConnectionOpenListener.this).handleException(new SaslException("Authentication failed: all available authentication mechanisms failed"));
                            return;
                        }
                        mechanismName = saslClient.getMechanismName();
                        RemoteLogger.client.tracef("Client initiating authentication using mechanism %s", mechanismName);
                        theRemoteEndpointName = remoteEndpointName;
                        ClientConnectionOpenListener.access$000(ClientConnectionOpenListener.this).getChannel().suspendReads();
                        negotiatedVersion = version;
                        usedSaslClient = saslClient;
                        authentication = new Authentication(usedSaslClient, this.remoteServerName, userName, theRemoteEndpointName, behavior, channelsIn, channelsOut);
                        ClientConnectionOpenListener.access$000(ClientConnectionOpenListener.this).getExecutor().execute(new Runnable(){

                            @Override
                            public void run() {
                                byte[] response;
                                try {
                                    response = usedSaslClient.hasInitialResponse() && negotiatedVersion >= 1 ? usedSaslClient.evaluateChallenge(SaslUtils.EMPTY_BYTES) : null;
                                }
                                catch (Exception e) {
                                    RemoteLogger.client.tracef("Client authentication failed: %s", e);
                                    ClientConnectionOpenListener.this.saslDispose(usedSaslClient);
                                    ClientConnectionOpenListener.this.failedMechs.add(mechanismName);
                                    ClientConnectionOpenListener.this.sendCapRequest(Capabilities.this.remoteServerName);
                                    return;
                                }
                                Pooled<ByteBuffer> pooledSendBuffer = ClientConnectionOpenListener.this.connection.allocate();
                                ByteBuffer sendBuffer = (ByteBuffer)pooledSendBuffer.getResource();
                                sendBuffer.put((byte)2);
                                if (negotiatedVersion < 1) {
                                    sendBuffer.put(mechanismName.getBytes(Protocol.UTF_8));
                                } else {
                                    ProtocolUtils.writeString(sendBuffer, mechanismName);
                                    if (response != null) {
                                        sendBuffer.put(response);
                                    }
                                }
                                sendBuffer.flip();
                                ClientConnectionOpenListener.this.connection.send(pooledSendBuffer);
                                ClientConnectionOpenListener.this.connection.setReadListener(authentication, true);
                            }
                        });
                        return;
                    }
                }
                RemoteLogger.client.unknownProtocolId(msgType);
                ClientConnectionOpenListener.access$000(ClientConnectionOpenListener.this).handleException(RemoteLogger.client.invalidMessage(ClientConnectionOpenListener.access$000(ClientConnectionOpenListener.this)));
                return;
            }
            catch (BufferUnderflowException e) {
                ClientConnectionOpenListener.access$000(ClientConnectionOpenListener.this).handleException(RemoteLogger.client.invalidMessage(ClientConnectionOpenListener.access$000(ClientConnectionOpenListener.this)));
                return;
            }
            catch (BufferOverflowException e) {
                ClientConnectionOpenListener.access$000(ClientConnectionOpenListener.this).handleException(RemoteLogger.client.invalidMessage(ClientConnectionOpenListener.access$000(ClientConnectionOpenListener.this)));
                return;
            }
            finally {
                pooledReceiveBuffer.free();
            }
        }
    }

    final class Greeting
    implements ChannelListener<ConnectedMessageChannel> {
        Greeting() {
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void handleEvent(ConnectedMessageChannel channel) {
            Pooled<ByteBuffer> pooledReceiveBuffer = ClientConnectionOpenListener.this.connection.allocate();
            try {
                int res;
                ByteBuffer receiveBuffer = (ByteBuffer)pooledReceiveBuffer.getResource();
                try {
                    res = channel.receive(receiveBuffer);
                }
                catch (IOException e) {
                    ClientConnectionOpenListener.this.connection.handleException(e);
                    pooledReceiveBuffer.free();
                    return;
                }
                if (res == -1) {
                    ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.abruptClose(ClientConnectionOpenListener.this.connection));
                    return;
                }
                if (res == 0) {
                    return;
                }
                RemoteLogger.client.tracef("Received %s", receiveBuffer);
                receiveBuffer.flip();
                String remoteServerName = null;
                byte msgType = receiveBuffer.get();
                switch (msgType) {
                    case -16: {
                        RemoteLogger.client.trace("Client received connection alive");
                        ClientConnectionOpenListener.this.connection.sendAliveResponse();
                        return;
                    }
                    case -15: {
                        RemoteLogger.client.trace("Client received connection alive ack");
                        return;
                    }
                    case -1: {
                        RemoteLogger.client.trace("Client received connection close request");
                        ClientConnectionOpenListener.this.connection.handlePreAuthCloseRequest();
                        return;
                    }
                    case 0: {
                        RemoteLogger.client.trace("Client received greeting");
                        block25: while (receiveBuffer.hasRemaining()) {
                            byte type = receiveBuffer.get();
                            int len = receiveBuffer.get() & 0xFF;
                            ByteBuffer data = Buffers.slice((ByteBuffer)receiveBuffer, (int)len);
                            switch (type) {
                                case 0: {
                                    remoteServerName = Buffers.getModifiedUtf8((ByteBuffer)data);
                                    RemoteLogger.client.tracef("Client received server name: %s", remoteServerName);
                                    continue block25;
                                }
                            }
                            RemoteLogger.client.tracef("Client received unknown greeting message %02x", type & 0xFF);
                        }
                        if (remoteServerName == null) {
                            remoteServerName = ((InetSocketAddress)channel.getPeerAddress(InetSocketAddress.class)).getHostName();
                        }
                        ClientConnectionOpenListener.this.sendCapRequest(remoteServerName);
                        return;
                    }
                }
                RemoteLogger.client.unknownProtocolId(msgType);
                ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.invalidMessage(ClientConnectionOpenListener.this.connection));
                return;
            }
            catch (BufferUnderflowException e) {
                ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.invalidMessage(ClientConnectionOpenListener.this.connection));
                return;
            }
            catch (BufferOverflowException e) {
                ClientConnectionOpenListener.this.connection.handleException(RemoteLogger.client.invalidMessage(ClientConnectionOpenListener.this.connection));
                return;
            }
            finally {
                pooledReceiveBuffer.free();
            }
        }
    }
}

